/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.tax;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.itc.common.constants.TaxFileConstants;
import kd.sit.itc.formplugin.web.tax.AbstractTaxFileBasePlugin;
import kd.sit.sitbp.common.enums.EmpTypeEnum;
import kd.sit.sitbp.common.enums.TaxPayerTypeEnum;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class EmploymentEdit
extends AbstractTaxFileBasePlugin {
    public static final String OP_SAVE = "save";
    public static final String OP_SAVEAFTERAUDIT = "saveafteraudit";

    public void afterLoadData(EventObject evt) {
        super.afterLoadData(evt);
        Long taxFileId = (Long)BaseDataConverter.convert((Object)this.getView().getParentView().getFormShowParameter().getCustomParam("taxfileid"), Long.class);
        QFilter filter = new QFilter("exportstatus", "=", (Object)"1");
        filter.and(new QFilter("endstatus", "=", (Object)"0"));
        boolean validateExportStatus = TaxFileServiceHelper.validateTaxDataStatus((long)taxFileId, (QFilter)filter);
        if (validateExportStatus) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxpayertype"});
        }
    }

    @Override
    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        OperationStatus viewStatus = this.getView().getFormShowParameter().getStatus();
        if (viewStatus.equals((Object)OperationStatus.ADDNEW)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"empsituation"});
        }
        this.ctrlFieldEnable();
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs pca) {
        String fieldKey;
        super.propertyChanged(pca);
        switch (fieldKey = pca.getProperty().getName()) {
            case "emptype": 
            case "empdate": {
                this.ctrlFieldEnable();
                break;
            }
            case "taxpayertype": {
                this.taxPayerTypeChg();
                break;
            }
        }
    }

    private void taxPayerTypeChg() {
        OperationStatus viewStatus = this.getView().getFormShowParameter().getStatus();
        if (viewStatus.equals((Object)OperationStatus.ADDNEW) || viewStatus.equals((Object)OperationStatus.VIEW)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long taxPayerTypeId = dataEntity.getLong("taxpayertype.id");
        Date bsed = dataEntity.getDate("bsed");
        QFilter filter = new QFilter("id", "=", (Object)dataEntity.getLong("id"));
        DynamicObject[] dynamicObjects = TaxFileServiceHelper.getDynamicObject((HRBaseServiceHelper)new HRBaseServiceHelper("itc_employment"), (String)"id,bsed,taxpayertype.number", (QFilter[])new QFilter[]{filter});
        Long oldPayerTypeId = dynamicObjects[0].getLong("taxpayertype.id");
        Date oldBsed = dynamicObjects[0].getDate("bsed");
        if (taxPayerTypeId == TaxPayerTypeEnum.TAX_PAYER_TYPE_1010.getId() && oldPayerTypeId.longValue() == TaxPayerTypeEnum.TAX_PAYER_TYPE_1020.getId() && SITDateTimeUtils.getYear((Date)bsed) == SITDateTimeUtils.getYear((Date)oldBsed)) {
            List hintTips = (List)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSService", (String)"queryPromptForString", (Object[])new Object[]{"itc_employment", "advconap", dataEntity});
            if (CollectionUtils.isEmpty((Collection)hintTips) || StringUtils.isBlank((CharSequence)((CharSequence)hintTips.get(0)))) {
                return;
            }
            this.getView().showTipNotification((String)hintTips.get(0));
        }
    }

    private void ctrlFieldEnable() {
        IFormView view = this.getView();
        IDataModel dataModel = this.getModel();
        DynamicObject dataEntity = dataModel.getDataEntity();
        long empTypeId = dataEntity.getLong("emptype.id");
        Date empDate = dataEntity.getDate("empdate");
        if (empTypeId != 0L && null != empDate) {
            if (!(empTypeId != EmpTypeEnum.EMP_TYPE_1010.getId() && empTypeId != EmpTypeEnum.EMP_TYPE_1020.getId() && empTypeId != EmpTypeEnum.EMP_TYPE_1030.getId() || empDate.before(TaxFileConstants.START_EMPDATE))) {
                view.setEnable(Boolean.TRUE, new String[]{"empsituation"});
            } else {
                view.setEnable(Boolean.FALSE, new String[]{"empsituation"});
                dataModel.setValue("empsituation", null);
            }
        } else {
            dataModel.setValue("empsituation", null);
            view.setEnable(Boolean.FALSE, new String[]{"empsituation"});
        }
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        Date date = this.getModel().getDataEntity().getDate("bsed");
        if (null != date) {
            return;
        }
        HashMap map = (HashMap)SerializationUtils.fromJsonString((String)this.getView().getParentView().getPageCache().get("relateFileKeyInfo"), HashMap.class);
        this.getModel().setValue("bsed", map.get("bsed"));
        this.getView().updateView("bsed");
    }
}

