/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.tax;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.itc.common.constants.TaxFileConstants;
import kd.sit.itc.formplugin.web.tax.AbstractTaxFileBasePlugin;
import kd.sit.sitbp.common.enums.CredentialsTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class OverseasPersonEdit
extends AbstractTaxFileBasePlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit otherIdType = (BasedataEdit)this.getControl("otheridtype");
        BasedataEdit address = (BasedataEdit)this.getControl("address");
        BasedataEdit addressCity = (BasedataEdit)this.getControl("addresscity");
        BasedataEdit addressCounty = (BasedataEdit)this.getControl("addresscounty");
        otherIdType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        address.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        addressCity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        addressCounty.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterBindData(EventObject evt) {
        Long idTypeNumberValue;
        super.afterBindData(evt);
        long taxFileId = (Long)ObjectConverter.convert((Object)this.getView().getParentView().getFormShowParameter().getCustomParam("taxfileid"), Long.class, (boolean)true);
        Long credentialsTypeId = this.getCredentialsTypeId();
        if (!CredentialsTypeEnum.isId1010((long)credentialsTypeId)) {
            long empTypeId;
            BasedataEdit taxReason = (BasedataEdit)this.getControl("taxreason");
            BasedataEdit birthPlace = (BasedataEdit)this.getControl("birthplace");
            taxReason.setMustInput(true);
            birthPlace.setMustInput(true);
            DynamicObject employmentDyObj = TaxFileServiceHelper.queryRealteDynamicObject((String)"itc_employment", (long)taxFileId);
            if (null != employmentDyObj && (empTypeId = employmentDyObj.getLong("emptype.id")) == TaxFileConstants.EMPTYPE_1010) {
                DateEdit firstEntryDate = (DateEdit)this.getControl("firstentrydate");
                DateEdit departDate = (DateEdit)this.getControl("departdate");
                firstEntryDate.setMustInput(true);
                departDate.setMustInput(true);
            }
        }
        if (null != (idTypeNumberValue = CredentialsTypeEnum.getMapForeign((long)credentialsTypeId, (long)1000001L))) {
            BasedataEdit otherIdType = (BasedataEdit)this.getControl("otheridtype");
            TextEdit otherIdNumber = (TextEdit)this.getControl("otheridnumber");
            otherIdType.setMustInput(true);
            otherIdNumber.setMustInput(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        IDataModel dataModel = this.getModel();
        switch (fieldKey) {
            case "address": {
                dataModel.setValue("addresscity", null);
                dataModel.setValue("addresscounty", null);
                break;
            }
            case "addresscity": {
                dataModel.setValue("addresscounty", null);
                break;
            }
        }
        this.getView().updateView(fieldKey);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey;
        switch (fieldKey = beforeF7SelectEvent.getProperty().getName()) {
            case "otheridtype": {
                Long idTypeIdValue = CredentialsTypeEnum.getMapForeign((long)this.getCredentialsTypeId(), (long)1000001L);
                QFilter filter = new QFilter("enable", "=", (Object)YesOrNoEnum.YES.getCode());
                if (null != idTypeIdValue) {
                    filter.and("id", "=", (Object)idTypeIdValue);
                }
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                listShowParameter.getListFilterParameter().setFilter(filter);
                break;
            }
            case "address": 
            case "addresscity": 
            case "addresscounty": {
                if (TaxFileServiceHelper.validateAdmindivisionIsEmpty((String)fieldKey, (IFormView)this.getView())) {
                    this.clickAdminDivisionF7(beforeF7SelectEvent, fieldKey);
                    break;
                }
                beforeF7SelectEvent.setCancel(true);
                break;
            }
        }
    }

    private Long getCredentialsTypeId() {
        HashMap map = (HashMap)SerializationUtils.fromJsonString((String)this.getView().getParentView().getPageCache().get("relateFileKeyInfo"), HashMap.class);
        HashMap credentialsTypeMap = (HashMap)map.get("iit_person.credentialstype");
        return credentialsTypeMap == null ? Long.valueOf(0L) : (Long)BaseDataConverter.convert(credentialsTypeMap.get("id"), Long.class);
    }

    private void clickAdminDivisionF7(BeforeF7SelectEvent event, String fieldKey) {
        BasedataEdit address = (BasedataEdit)this.getControl("address");
        BasedataEdit addressCity = (BasedataEdit)this.getControl("addresscity");
        BasedataEdit addressCounty = (BasedataEdit)this.getControl("addresscounty");
        if (address.isF7Click() || addressCity.isF7Click() || addressCounty.isF7Click()) {
            event.setCancel(true);
            TaxFileServiceHelper.openAdmindivision((BeforeF7SelectEvent)event, (IFormView)this.getView(), (String)fieldKey);
        }
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        Date date = this.getModel().getDataEntity().getDate("bsed");
        if (null != date) {
            return;
        }
        HashMap map = (HashMap)SerializationUtils.fromJsonString((String)this.getView().getParentView().getPageCache().get("relateFileKeyInfo"), HashMap.class);
        this.getModel().setValue("bsed", map.get("bsed"));
        this.getView().updateView("bsed");
    }
}

