/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.tax;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class QuitTaxConfirmPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String QUIT_TAX_BSED = "bsed";
    private static final String CLICK_STATUS = "clickStatus";
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{BTN_OK});
        this.addClickListeners(new String[]{BTN_CANCEL});
    }

    public void beforeBindData(EventObject eventObject) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String content = (String)parameter.getCustomParam("content");
        String tipsContent = (String)parameter.getCustomParam("tipsContent");
        String tipsTitle = (String)parameter.getCustomParam("tipsTitle");
        String taxFileIds = (String)parameter.getCustomParam("taxFileIds");
        if (HRStringUtils.isNotEmpty((String)content)) {
            Html html = (Html)this.getView().getControl("fcontent");
            html.setConent(content);
        }
        if (HRStringUtils.isNotEmpty((String)tipsContent)) {
            Label label = (Label)this.getView().getControl("title");
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(tipsContent));
            if (HRStringUtils.isNotEmpty((String)tipsTitle)) {
                tips.setTitle(new LocaleString(tipsTitle));
            }
            label.addTips(tips);
        }
        if (HRStringUtils.isNotEmpty((String)taxFileIds)) {
            this.getView().getPageCache().put("taxFileIds", taxFileIds);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        IDataModel dataModel = this.getModel();
        Date bsed = (Date)BaseDataConverter.convert((Object)dataModel.getValue(QUIT_TAX_BSED), Date.class);
        switch (key) {
            case "btnok": {
                if (null == bsed) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u505c\u6b62\u7b97\u7a0e\u65e5\u671f\u3002", (String)"QuitTaxConfirmPlugin_5", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                returnData.put(CLICK_STATUS, "ok");
                this.setReturnData(returnData, bsed);
                this.getView().close();
                break;
            }
            case "btncancel": {
                returnData.put(CLICK_STATUS, "cancel");
                this.setReturnData(returnData, bsed);
                break;
            }
        }
    }

    private void setReturnData(Map<String, Object> returnData, Date bsed) {
        returnData.put(QUIT_TAX_BSED, bsed);
        this.getView().setReturnData(returnData);
    }

    public void beforeClosed(BeforeClosedEvent event) {
        this.getView().returnDataToParent(this.getView().getReturnData());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IFormView view = this.getView();
        if (BTN_OK.equals(key)) {
            String isClose = this.getView().getPageCache().get("isClose");
            if ("1".equals(isClose)) {
                view.close();
            }
            IListView listView = (IListView)view.getParentView();
            listView.refresh();
            view.sendFormAction(view.getParentView());
        }
    }
}

