/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.tax;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.itc.formplugin.web.tax.AbstractTaxFileBasePlugin;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class SpecialInfoEdit
extends AbstractTaxFileBasePlugin {
    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.getView().setEnable(Boolean.FALSE, new String[]{"disabilitynum", "martyrsfamilynum"});
        Date date = this.getModel().getDataEntity().getDate("bsed");
        if (null != date) {
            return;
        }
        HashMap map = (HashMap)SerializationUtils.fromJsonString((String)this.getView().getParentView().getPageCache().get("relateFileKeyInfo"), HashMap.class);
        this.getModel().setValue("bsed", map.get("bsed"));
        this.getView().updateView("bsed");
    }

    public void afterLoadData(EventObject eventObject) {
        Long taxFileId = (Long)BaseDataConverter.convert((Object)this.getView().getParentView().getFormShowParameter().getCustomParam("taxfileid"), Long.class);
        QFilter filter = new QFilter("exportstatus", "=", (Object)"1");
        filter.and(new QFilter("endstatus", "=", (Object)"0"));
        boolean validateExportStatus = TaxFileServiceHelper.validateTaxDataStatus((long)taxFileId, (QFilter)filter);
        if (validateExportStatus) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"disability", "martyrsfamily", "oldandloney"});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        switch (fieldKey = args.getProperty().getName()) {
            case "disability": 
            case "martyrsfamily": {
                String flag = HRStringUtils.equals((String)"disability", (String)fieldKey) ? "disabilitynum" : "martyrsfamilynum";
                this.ctrlFieldEnable(fieldKey, flag);
                break;
            }
            case "disabilitynum": 
            case "martyrsfamilynum": {
                String flag = HRStringUtils.equals((String)"disabilitynum", (String)fieldKey) ? "disability" : "martyrsfamily";
                this.ctrlFieldEnable(flag, fieldKey);
                break;
            }
        }
    }

    private void ctrlFieldEnable(String field, String clearField) {
        IDataModel dataModel = this.getModel();
        DynamicObject dataEntity = dataModel.getDataEntity();
        IFormView view = this.getView();
        boolean isTrue = dataEntity.getBoolean(field);
        if (isTrue) {
            view.setEnable(Boolean.TRUE, new String[]{clearField});
        } else {
            view.setEnable(Boolean.FALSE, new String[]{clearField});
            this.getModel().beginInit();
            this.getModel().setValue(clearField, null);
            this.getModel().endInit();
            this.getView().updateView(clearField);
        }
    }
}

