/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.tax;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.util.StringUtils;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.itc.formplugin.web.tax.AbstractTaxFileBasePlugin;
import kd.sit.sitbp.common.enums.CredentialsTypeEnum;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxContactEdit
extends AbstractTaxFileBasePlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit regPermRes = (BasedataEdit)this.getControl("regpermres");
        BasedataEdit regPermResCity = (BasedataEdit)this.getControl("regpermrescity");
        BasedataEdit regPermResCounty = (BasedataEdit)this.getControl("regpermrescounty");
        BasedataEdit habitRes = (BasedataEdit)this.getControl("habitres");
        BasedataEdit habitResCity = (BasedataEdit)this.getControl("habitrescity");
        BasedataEdit habitResCounty = (BasedataEdit)this.getControl("habitrescounty");
        regPermRes.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        regPermResCity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        regPermResCounty.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        habitRes.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        habitResCity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        habitResCounty.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        Long credentialsTypeId = this.getCredentialsTypeId();
        String taxPayerNum = this.getModel().getDataEntity().getString("taxpayernum");
        if (CredentialsTypeEnum.isId1010((long)credentialsTypeId) && StringUtils.isNotEmpty((String)taxPayerNum)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxpayernum"});
            this.getView().updateView("taxpayernum");
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        IDataModel dataModel = this.getModel();
        switch (fieldKey) {
            case "regpermres": {
                dataModel.setValue("regpermrescity", null);
                dataModel.setValue("regpermrescounty", null);
                break;
            }
            case "regpermrescity": {
                dataModel.setValue("regpermrescounty", null);
                break;
            }
            case "habitres": {
                dataModel.setValue("habitrescity", null);
                dataModel.setValue("habitrescounty", null);
                break;
            }
            case "habitrescity": {
                dataModel.setValue("habitrescounty", null);
                break;
            }
        }
        this.getView().updateView(fieldKey);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey;
        switch (fieldKey = beforeF7SelectEvent.getProperty().getName()) {
            case "regpermres": 
            case "regpermrescity": 
            case "regpermrescounty": 
            case "habitres": 
            case "habitrescity": 
            case "habitrescounty": {
                if (TaxFileServiceHelper.validateAdmindivisionIsEmpty((String)fieldKey, (IFormView)this.getView())) {
                    this.clickAdminDivisionF7(beforeF7SelectEvent, fieldKey);
                    break;
                }
                beforeF7SelectEvent.setCancel(true);
                break;
            }
        }
    }

    private void clickAdminDivisionF7(BeforeF7SelectEvent event, String fieldKey) {
        BasedataEdit regPermRes = (BasedataEdit)this.getControl("regpermres");
        BasedataEdit habitRes = (BasedataEdit)this.getControl("habitres");
        BasedataEdit regPermResCity = (BasedataEdit)this.getControl("regpermrescity");
        BasedataEdit regPermResCounty = (BasedataEdit)this.getControl("regpermrescounty");
        BasedataEdit habitResCity = (BasedataEdit)this.getControl("habitrescity");
        BasedataEdit habitResCounty = (BasedataEdit)this.getControl("habitrescounty");
        if (regPermRes.isF7Click() || habitRes.isF7Click() || regPermResCity.isF7Click() || regPermResCounty.isF7Click() || habitResCity.isF7Click() || habitResCounty.isF7Click()) {
            event.setCancel(true);
            TaxFileServiceHelper.openAdmindivision((BeforeF7SelectEvent)event, (IFormView)this.getView(), (String)fieldKey);
        }
    }

    private Long getCredentialsTypeId() {
        HashMap map = (HashMap)SerializationUtils.fromJsonString((String)this.getView().getParentView().getPageCache().get("relateFileKeyInfo"), HashMap.class);
        HashMap credentialsTypeMap = (HashMap)map.get("iit_person.credentialstype");
        return credentialsTypeMap == null ? Long.valueOf(0L) : (Long)BaseDataConverter.convert(credentialsTypeMap.get("id"), Long.class);
    }
}

