/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.tax;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sit.itc.business.taxtask.InitTaxDataBasicHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.business.taxtaskguide.task.SitLogServiceHelper;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.itc.formplugin.web.taskguide.task.TaxFileDeclareDownLoadTask;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.DataFilter;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.entity.TaxPeriodEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.ResultItem;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;
import kd.sit.sitbp.common.util.async.enums.MultiThreadCase;
import kd.sit.sitbp.common.util.datatype.StringConverter;
import org.apache.commons.lang.StringUtils;

public class TaxFileDeclarePlugin
extends HRDataBaseList {
    private static final Log logger = LogFactory.getLog(TaxFileDeclarePlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operKey = formOperate.getOperateKey()) {
            case "unmarkdeclarestatus": {
                this.unmarkDeclareStatus(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        switch (opKey) {
            case "exportdeclareandmark": {
                this.getPageCache().put("isMark", "1");
                this.markConfirm();
                break;
            }
            case "exportdeclare": 
            case "btn_exportdeclare": {
                this.getPageCache().put("isMark", "0");
                this.openTaxTemplateWindow();
                break;
            }
            case "exportdetails_declare": {
                this.openExportDetail();
                break;
            }
            case "unmarkdeclarestatus": {
                if (args.getOperationResult().isSuccess()) {
                    SitLogServiceHelper.addLog((IFormView)this.getView(), (String)formOperate.getOperateName().getLocaleValue(), (String)ResManager.loadKDString((String)"\u64a4\u9500\u6807\u8bb0\u62a5\u9001\u6210\u529f\u3002", (String)"TaxFileDeclarePlugin_0", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6807\u8bb0\u62a5\u9001\u6210\u529f\u3002", (String)"TaxFileDeclarePlugin_0", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                }
                ((IEntityOperate)formOperate).setCancelRefresh(false);
                break;
            }
            case "updatepersonfile": {
                InitTaxDataBasicHelper.confirmVersion((TaxTaskEntity)this.getTaxTask(), (IFormView)this.getView(), (boolean)true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (evt.getResult() == MessageBoxResult.Yes) {
            switch (callBackId) {
                case "event_unmark_declarestatus": {
                    TaxTaskEntity taxTask = this.getTaxTask();
                    TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView().getParentView(), (TaxTaskEntity)taxTask);
                    TaxPeriodEntity taxPeriod = taxTask.getTaxPeriodEntity();
                    OperateOption unmarkOperate = OperateOption.create();
                    unmarkOperate.setVariableValue("isUnmark", "1");
                    unmarkOperate.setVariableValue("taxstartdate", StringConverter.toString((Object)taxPeriod.getStartDate()));
                    unmarkOperate.setVariableValue("taxenddate", StringConverter.toString((Object)taxPeriod.getEndDate()));
                    unmarkOperate.setVariableValue("batchop_batchsize", "1000");
                    unmarkOperate.setVariableValue("taxtask", SerializationUtils.toJsonString((Object)taxTask));
                    unmarkOperate.setVariableValue("stepCaseInfo", SerializationUtils.toJsonString((Object)stepCaseInfo));
                    this.getView().invokeOperation("unmarkdeclarestatus", unmarkOperate);
                    break;
                }
                case "event_export_declare": {
                    this.openTaxTemplateWindow();
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (null != returnData) {
            switch (actionId) {
                case "confirmTaxPersonTemplate": {
                    this.exportPersonDeclare(returnData);
                    break;
                }
            }
        } else if (StringUtils.equals((String)actionId, (String)"afterExportDeclareDone")) {
            this.afterExportDone();
        } else if ("afterprocessclose".equals(actionId)) {
            this.afterUpdateDone();
        }
    }

    private void afterUpdateDone() {
        String exportPersonReport = this.getPageCache().get("exportPersonReport");
        if (!"exportPersonReport".equals(exportPersonReport)) {
            this.getView().invokeOperation("refresh");
            String totalNum = this.getView().getPageCache().get("totalNum");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u4e2a\u7a0e\u4eba\u5458\u64cd\u4f5c\u5b8c\u6210\uff0c\u6210\u529f{0}\u6761\u3002", (String)"TaxFileDeclarePlugin_9", (String)"sit-itc-formplugin", (Object[])new Object[]{totalNum}));
        } else {
            this.verifyCertAndExportPersonDeclareReport();
        }
    }

    private void afterExportDone() {
        String resultStr = this.getPageCache().get("export_result");
        if (StringUtils.isEmpty((String)resultStr)) {
            logger.info("error: declare export result is null");
            return;
        }
        String url = this.getPageCache().get("url");
        if (!StringUtils.isEmpty((String)url)) {
            this.getView().download(url);
        }
        BatchResult finalResult = (BatchResult)SerializationUtils.deSerializeFromBase64((String)resultStr);
        String option = StringUtils.equals((String)this.getPageCache().get("isMark"), (String)"1") ? ResManager.loadKDString((String)"\u5bfc\u51fa\u62a5\u9001\u8868\u5e76\u6807\u8bb0", (String)"TaxFileDeclarePlugin_1", (String)"sit-itc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ec5\u5bfc\u51fa\u62a5\u9001\u8868", (String)"TaxFileDeclarePlugin_8", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        this.showResultMsgAfterOp((BatchResult<Map<String, Object>>)finalResult, option);
        this.getView().invokeOperation("refresh");
    }

    private void unmarkDeclareStatus(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String isUnmark = formOperate.getOption().getVariableValue("isUnmark", "0");
        if (StringUtils.equals((String)"0", (String)isUnmark)) {
            args.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("event_unmark_declarestatus", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u64a4\u9500\u6807\u8bb0\u62a5\u9001\uff0c\u672c\u671f\u53d8\u52a8\u8bb0\u5f55\u7684\u62a5\u9001\u6708\u4efd\u5c06\u6e05\u7a7a\uff0c\u975e\u672c\u671f\u53d8\u52a8\u7684\u8bb0\u5f55\u4e0d\u5141\u8bb8\u5728\u672c\u671f\u64a4\u9500\u6807\u8bb0\u62a5\u9001\u3002\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"TaxFileDeclarePlugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
        }
    }

    private void openExportDetail() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("bos_exportlog");
        showParameter.setFormId("bos_list");
        showParameter.setCaption(ResManager.loadKDString((String)"\u4eba\u5458\u62a5\u9001\u8868\u5bfc\u51fa\u7ed3\u679c", (String)"TaxFileDeclarePlugin_3", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter filter = new QFilter("bizobject", "=", (Object)ResManager.loadKDString((String)"\u4eba\u5458\u62a5\u9001\u8868", (String)"TaxFileDeclarePlugin_4", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        ListFilterParameter filterParameter = new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{filter}), null);
        showParameter.setListFilterParameter(filterParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void exportPersonDeclare(Object returnData) {
        int total;
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List<Object> selectIds = Lists.newArrayListWithCapacity((int)selectedRows.size());
        boolean isExportAll = false;
        IPageCache pageCache = this.getPageCache();
        pageCache.remove("exportPersonReport");
        pageCache.put("exportPersonReport", "exportPersonReport");
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info("1---thread is [{}], updateAllPersonInfo begin, time is [{}]", (Object)Thread.currentThread().getName(), (Object)stopwatch.elapsed().toMillis());
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            isExportAll = true;
            total = this.updateAllPersonInfo(billList);
        } else {
            selectIds = selectedRows.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toList());
            selectIds = this.updateSomePersonInfo((List<Long>)selectIds);
            total = selectIds.size();
        }
        logger.info("2---thread is [{}], updateAllPersonInfo finish, time is [{}]", (Object)Thread.currentThread().getName(), (Object)stopwatch.elapsed().toMillis());
        stopwatch.stop();
        if (isExportAll && total == 0 || !isExportAll && CollectionUtils.isEmpty(selectIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6709\u66f4\u65b0\uff0c\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"TaxFileDeclarePlugin_5", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        pageCache.remove("isExportALL");
        pageCache.remove("exportTotal");
        pageCache.remove("selectIds");
        pageCache.remove("template");
        pageCache.put("isExportALL", String.valueOf(isExportAll));
        pageCache.put("exportTotal", String.valueOf(total));
        pageCache.put("selectIds", SerializationUtils.serializeToBase64(selectIds));
        pageCache.put("template", String.valueOf(returnData));
        if (!isExportAll && !CollectionUtils.isEmpty(selectIds)) {
            this.verifyCertAndExportPersonDeclareReport();
        }
    }

    private void verifyCertAndExportPersonDeclareReport() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        IPageCache pageCache = this.getPageCache();
        pageCache.remove("exportPersonReport");
        String isExportAllStr = pageCache.get("isExportALL");
        String selectIdsStr = pageCache.get("selectIds");
        if (Strings.isNullOrEmpty((String)isExportAllStr) || Strings.isNullOrEmpty((String)selectIdsStr)) {
            return;
        }
        logger.info("5---thread is [{}], TaxFileDeclareDownLoadTask begin, time is [{}]", (Object)Thread.currentThread().getName(), (Object)System.currentTimeMillis());
        TaxFileDeclareDownLoadTask task = new TaxFileDeclareDownLoadTask(this.getView(), this.getTaxTask());
        task.setHandleCase(MultiThreadCase.BY_PROVIDER);
        task.preparedataItem();
        MultiThreadTaskExecutor.execute((MultiThreadTask)task, (boolean)true, (ThreadPool)SITThreadPoolFactory.getExportPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getExportHanddataThreadPool());
    }

    private List<Long> updateSomePersonInfo(List<Long> selectIds) {
        List basicDys;
        PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxdatabasic");
        String props = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)info, (DataFilter)null);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        DynamicObject[] query = serviceHelper.query(props, new QFilter[]{new QFilter("id", "in", selectIds)});
        ArrayList needUpdateBasics = Lists.newArrayListWithCapacity((int)selectIds.size());
        ArrayList exportBasicIds = Lists.newArrayListWithCapacity((int)selectIds.size());
        for (DynamicObject basicDyn : query) {
            if (basicDyn.getInt("srcrefnum") > 0) {
                exportBasicIds.add(basicDyn.getLong("id"));
                continue;
            }
            needUpdateBasics.add(basicDyn);
        }
        if (!CollectionUtils.isEmpty((Collection)needUpdateBasics) && !CollectionUtils.isEmpty((Collection)(basicDys = InitTaxDataBasicHelper.updateAssignTaxDataBasicDys((IFormView)this.getView(), (TaxTaskEntity)this.getTaxTask(), Arrays.stream(query).collect(Collectors.toList()))))) {
            basicDys.forEach(obj -> {
                if (!StringUtils.equals((String)obj.getString("status"), (String)"E")) {
                    exportBasicIds.add(obj.getLong("id"));
                }
            });
        }
        return exportBasicIds;
    }

    private int updateAllPersonInfo(BillList billList) {
        InitTaxDataBasicHelper.confirmVersion((TaxTaskEntity)this.getTaxTask(), (IFormView)this.getView(), (boolean)true);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        List filters = billList.generalFilterParameter().getQFilters();
        return serviceHelper.count("itc_taxdatabasic", filters.toArray(new QFilter[0]));
    }

    private void markConfirm() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("event_export_declare", (IFormPlugin)this);
        String confirmTip = ResManager.loadKDString((String)"\u5bfc\u51fa\u4eba\u5458\u62a5\u9001\u8868\u7684\u540c\u65f6\uff0c\u4f1a\u5c06\u4eba\u5458\u62a5\u9001\u72b6\u6001\u6807\u8bb0\u4e3a\u201c\u5df2\u62a5\u9001\u201d\uff0c\u62a5\u9001\u6708\u4efd\u66f4\u65b0\u4e3a\u5f53\u524d\u4e2a\u7a0e\u4efb\u52a1\u6240\u5728\u6708\u4efd\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaxFileDeclarePlugin_6", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
    }

    private void openTaxTemplateWindow() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("sitbs_usetaxtemplate");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("scene", (Object)"1");
        formShowParameter.setCustomParam("msg", (Object)ResManager.loadKDString((String)"\u5c06\u6309\u6700\u65b0\u4e2a\u7a0e\u4eba\u5458\u6570\u636e\u5bfc\u51fa\u3002", (String)"TaxFileDeclarePlugin_11", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        CloseCallBack cb = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "confirmTaxPersonTemplate");
        formShowParameter.setCloseCallBack(cb);
        this.getView().showForm(formShowParameter);
    }

    private TaxTaskEntity getTaxTask() {
        return (TaxTaskEntity)TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView().getParentView()).getData();
    }

    protected void showResultMsgAfterOp(BatchResult<Map<String, Object>> result, String option) {
        int failSize;
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(result.getMessage());
            SITLogServiceHelper.addLog((IFormView)this.getView(), (String)option, (String)result.getMessage());
            return;
        }
        List failResult = result.getFailResultOriginal();
        List successResult = result.getSuccessResult();
        if (CollectionUtils.isEmpty((Collection)failResult)) {
            String msg = ResManager.loadKDString((String)"{0}\u64cd\u4f5c\u5b8c\u6210\uff0c\u6210\u529f{1}\u6761\u3002", (String)"TaxTaskGuideStep1Plugin_3", (String)"sit-itc-formplugin", (Object[])new Object[]{option, successResult.size()});
            this.getView().showSuccessNotification(msg);
            SITLogServiceHelper.addLog((IFormView)this.getView(), (String)option, (String)msg);
            return;
        }
        int successSize = successResult.size();
        int failSizeOld = failSize = failResult.size();
        int totalSize = failSize + successSize;
        Map status = result.failDataGroupByStatus();
        for (Map.Entry entry : status.entrySet()) {
            if ((Integer)entry.getKey() >= ResultStatusEnum.ERROR.getCode()) continue;
            int size = ((List)entry.getValue()).size();
            failSize -= size;
            successSize += size;
        }
        String title = ResManager.loadKDString((String)"{0}\u64cd\u4f5c\u5b8c\u6210\uff0c\u5171{1}\u6761\uff0c\u6210\u529f{2}\u6761\uff0c\u5931\u8d25{3}\u6761", (String)"TaxTaskGuideStep1Plugin_6", (String)"sit-itc-formplugin", (Object[])new Object[]{option, totalSize, successSize, failSize});
        ArrayList<String> allMsg = new ArrayList<String>(failSizeOld);
        for (int i = 0; i < failSizeOld; ++i) {
            String message = ((ResultItem)failResult.get(i)).getMessage();
            allMsg.add(message);
        }
        FormShowParameter parameter = SITShowFormServiceHelper.getOperationResultParameter((String)option, (String)title, allMsg);
        this.getView().showForm(parameter);
    }
}

