/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.tax;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.itc.formplugin.web.tax.AbstractTaxFileBasePlugin;
import kd.sit.itc.formplugin.web.tax.TaxFileList;
import kd.sit.sitbp.business.servicehelper.SITCertCommonHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.DataEditStatusEnum;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxFileEdit
extends AbstractTaxFileBasePlugin
implements BeforeF7SelectListener {
    public static final String OP_AUDIT = "audit";
    public static final String OP_SAVEAFTERAUDIT = "saveafteraudit";
    protected static final Log LOGGER = LogFactory.getLog(TaxFileEdit.class);
    private static final String CONFIRM_CALLBACK_REFER_LATEST = "confirm_callback_refer_latest";

    @Override
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit empGroup = (BasedataEdit)this.getControl("empgroup");
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        BasedataEdit taxUnit = (BasedataEdit)this.getView().getControl("taxunit");
        empGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxUnit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        OperationStatus viewStatus = this.getView().getFormShowParameter().getStatus();
        if (viewStatus.equals((Object)OperationStatus.ADDNEW)) {
            HashMap<String, Object> advConApCtrl = new HashMap<String, Object>(16);
            advConApCtrl.put("text", "");
            advConApCtrl.put("collapsible", Boolean.FALSE);
            HashMap<String, String> margin = new HashMap<String, String>(16);
            margin.put("t", "-30px");
            HashMap<String, HashMap<String, String>> styleMargin = new HashMap<String, HashMap<String, String>>(16);
            styleMargin.put("m", margin);
            advConApCtrl.put("s", styleMargin);
            this.getView().updateControlMetadata("advconap", advConApCtrl);
            HashMap fieldPanelApCtrl = new HashMap(16);
            HashMap<String, String> padding = new HashMap<String, String>(16);
            padding.put("l", "50px");
            HashMap<String, HashMap<String, String>> style = new HashMap<String, HashMap<String, String>>(16);
            style.put("p", padding);
            fieldPanelApCtrl.put("s", style);
            this.getView().updateControlMetadata("fieldsetpanelap", fieldPanelApCtrl);
            this.setTaxRegion(this.getView());
            this.getModel().setDataChanged(false);
            BasedataEdit control = (BasedataEdit)this.getControl("employee");
            control.setMustInput(true);
            BasedataEdit taxPayerTypeTmp = (BasedataEdit)this.getControl("taxpayertypetmp");
            taxPayerTypeTmp.setMustInput(true);
            BasedataEdit empTypeTmp = (BasedataEdit)this.getControl("emptypetmp");
            empTypeTmp.setMustInput(true);
        }
        List empGroupIds = SITPermissionServiceHelper.getEmpgroupByAppNumber((String)"itc");
        QFilter qFilter = new QFilter("id", "in", (Object)empGroupIds);
        BasedataEdit empGroupEdit = (BasedataEdit)this.getControl("empgroup");
        empGroupEdit.setQFilters(Collections.singletonList(qFilter));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        long id = this.getModel().getDataEntity().getLong("id");
        if (id != 0L) {
            String taxstatus;
            if (OP_AUDIT.equals(opKey)) {
                this.validateTaxFileApplyCert(Lists.newArrayList((Object[])new Long[]{id}), args);
            }
            if (OP_SAVEAFTERAUDIT.equals(opKey) && (taxstatus = this.getModel().getDataEntity().getString("taxstatus")).equals("1")) {
                this.validateTaxFileApplyCert(Lists.newArrayList((Object[])new Long[]{id}), args);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        switch (opKey = args.getOperateKey()) {
            case "save": {
                OperationResult result = args.getOperationResult();
                if (result != null && !result.isSuccess()) {
                    List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
                    if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo) && allErrorOrValidateInfo.size() == 1) {
                        result.setShowMessage(false);
                        this.getView().showTipNotification(((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage());
                    }
                    return;
                }
                Object editStatus = this.getView().getFormShowParameter().getCustomParam("editStatus");
                DynamicObject taxFile = this.getModel().getDataEntity();
                long taxFileId = taxFile.getLong("id");
                if (taxFileId == 0L || editStatus != null) {
                    return;
                }
                long personId = taxFile.getLong("person.id");
                DynamicObject latestOldFile = TaxFileServiceHelper.findLatestOldFileOfPerson((long)personId, (long)taxFileId);
                if (latestOldFile == null) {
                    TaxFileInfoServiceFactory.openTaxFile((DynamicObject)taxFile, (DataEditStatusEnum)DataEditStatusEnum.CAN_WRITE, (IFormView)this.getView().getParentView(), (long)0L);
                    this.getView().sendFormAction(this.getView().getParentView());
                    if (this.getView().getFormShowParameter().getOpenStyle().getShowType() == ShowType.Modal) {
                        this.getView().close();
                    }
                    return;
                }
                this.showConfirmOfReferOldInfo(latestOldFile, taxFile);
                if (this.getView().getFormShowParameter().getOpenStyle().getShowType() != ShowType.Modal) break;
                this.getView().close();
                break;
            }
        }
        if (OP_SAVEAFTERAUDIT.equals(opKey) && args.getOperationResult().isSuccess()) {
            Optional.ofNullable(this.getView()).map(IFormView::getParentView).map(view -> view.getPageCache().get("pageids")).filter(pageIdsStr -> !Strings.isNullOrEmpty((String)pageIdsStr)).map(pageIdsStr -> {
                HashMap map = (HashMap)SerializationUtils.fromJsonString((String)pageIdsStr, HashMap.class);
                return (String)map.get("itc_taxfile_preview");
            }).map(previewId -> this.getView().getView(previewId)).ifPresent(preview -> {
                preview.invokeOperation("refresh");
                this.getView().sendFormAction(preview);
            });
        }
    }

    private void showConfirmOfReferOldInfo(DynamicObject latestOldFile, DynamicObject currentFile) {
        this.getView().getParentView().getPageCache().put("referOldFileId", latestOldFile.getString("id"));
        this.getView().getParentView().getPageCache().put("currentFileId", currentFile.getString("id"));
        this.getView().getParentView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u8981\u5f15\u7528\u65e7\u6863\u6848{0}\u7684\u4fe1\u606f\uff1f", (String)"TaxFileList_14", (String)"sit-itc-formplugin", (Object[])new Object[]{latestOldFile.getString("number")}), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_CALLBACK_REFER_LATEST, TaxFileList.class.getName()));
        this.getView().sendFormAction(this.getView().getParentView());
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        String permEntity = "itc_taxfile";
        String permItemId = "47156aff000000ac";
        switch (fieldKey) {
            case "empgroup": {
                Set empGroupIds;
                if (SITPermissionServiceHelper.isSuperUser() || CollectionUtils.isEmpty((Collection)(empGroupIds = SITPermissionServiceHelper.getEmpgrpSetByPermItem((String)"itc", (String)"itc_taxfile", (String)"47156aff000000ac")))) break;
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter qFilter = new QFilter("id", "in", (Object)empGroupIds);
                listShowParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "org": {
                HasPermOrgResult permOrgResult = SITPermissionServiceHelper.getPermOrgs((String)"17/+CT1QBPNP", (String)permEntity, (String)permItemId);
                if (permOrgResult.hasAllOrgPerm()) break;
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("range", (Object)permOrgResult.getHasPermOrgs());
                break;
            }
            case "taxunit": {
                Set taxUnitIds;
                if (SITPermissionServiceHelper.isSuperUser() || !Objects.nonNull(taxUnitIds = SITPermissionServiceHelper.getTaxUnitSetByPermItem((Long)RequestContext.get().getCurrUserId(), (String)"17/+CT1QBPNP", (String)"itc_taxfile", (String)"47156aff000000ac"))) break;
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter idFilter = new QFilter("id", "in", (Object)taxUnitIds);
                listShowParameter.getListFilterParameter().setFilter(idFilter);
                LOGGER.info("taxfile taxUnitIds after F7 is {}", (Object)taxUnitIds.toString());
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        IFormView view = this.getView();
        IDataModel dataModel = this.getModel();
        DynamicObject dataEntity = dataModel.getDataEntity();
        switch (fieldKey) {
            case "starttaxdate": {
                Date startTaxDate = dataEntity.getDate("starttaxdate");
                if (null == startTaxDate) break;
                dataModel.setValue("bsed", (Object)startTaxDate);
                view.updateView("bsed");
                break;
            }
            case "employee": {
                if (!(newValue instanceof DynamicObject)) break;
                DynamicObject person = ((DynamicObject)newValue).getDynamicObject("person");
                if (person != null) {
                    long personId = person.getLong("id");
                    DynamicObject iitPerson = (DynamicObject)SITMServiceUtils.invokeSITService((String)"iit", (String)"IitPersonService", (String)"findById", (Object[])new Object[]{personId, null});
                    String failMsg = TaxFileServiceHelper.validatePersonMustInput((DynamicObject)iitPerson, (String)"0");
                    if (!Strings.isNullOrEmpty((String)failMsg)) {
                        view.showErrorNotification(failMsg);
                        dataModel.setValue("employee", changeData.getOldValue());
                        break;
                    }
                    dataModel.setValue("person", ((DynamicObject)newValue).get("person"));
                    dataModel.setValue("personversion", (Object)iitPerson.getLong("person.sourcevid"));
                    break;
                }
                view.showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u4fe1\u606f\u3002", (String)"TaxFileSavePersonInfoValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[0]));
                dataModel.setValue("employee", changeData.getOldValue());
                break;
            }
        }
    }

    private void validateTaxFileApplyCert(List<Long> taxFileIds, BeforeDoOperationEventArgs args) {
        Long countryId = 1000001L;
        List pIds = TaxFileServiceHelper.getApplyOrReleasePids(taxFileIds, (Long)countryId);
        if (!CollectionUtils.isEmpty((Collection)pIds)) {
            DynamicObject appInfo = SITCertCommonHelper.queryAppInfoByCountryId((Long)countryId);
            Map verifyMap = SITCertCommonHelper.verifyCertForApply((String)appInfo.getString("app.id"), (String)"itc_taxfile", (List)pIds);
            boolean result = (Boolean)BaseDataConverter.convert(verifyMap.get("result"), Boolean.class, (Object)Boolean.FALSE);
            HashMap resultMap = (HashMap)verifyMap.get("msg");
            String certHintMsg = (String)resultMap.get("message");
            String certDetailMessage = (String)resultMap.get("certDetailMessage");
            String infoType = (String)resultMap.get("infoType");
            String showMessage = (String)resultMap.get("showMessage");
            LOGGER.info("SITCertCommonHelper.verifyCertForApply result: {} - {}", (Object)certHintMsg, (Object)certDetailMessage);
            if (result) {
                if ((HRCertPromptInfoTypeEnum.EXCEED.getName().equals(infoType) || HRCertPromptInfoTypeEnum.WARNING.getName().equals(infoType)) && showMessage.equals("true")) {
                    if (this.getView().getParentView() != null) {
                        this.getView().getParentView().showTipNotification(certHintMsg);
                    } else {
                        this.getView().showTipNotification(certHintMsg);
                    }
                }
            } else {
                this.getView().showErrorNotification(certHintMsg);
                args.setCancel(true);
            }
        }
    }

    private void setTaxRegion(IFormView formView) {
        String countryId = (String)SITMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"getCountryIdByServiceAppId", (Object[])new Object[]{this.getView().getServiceAppId(this.getView().getPageId())});
        formView.getModel().setValue("taxregion", (Object)countryId);
        formView.setEnable(Boolean.FALSE, new String[]{"taxregion"});
    }
}

