/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.tax;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.itc.business.taxtaskguide.task.SitLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITCertCommonHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.common.enums.DataEditStatusEnum;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxFileList
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(TaxFileList.class);
    private static final String CONFIRM_CALLBACK_AUDIT = "confirm_callback_audit";
    private static final String AUDIT_AFTERCONFIRM = "audit_afterconfirm";
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";
    private static final String CONFIRM_CALLBACK_REFER_LATEST = "confirm_callback_refer_latest";
    private static final String QUIT_TAX = "quittax";
    private static final String QUIT_TAX_CONFIRM = "quit_tax_confirm";
    private static final String BTN_DELETE = "donothing_delete";
    private static final String PROGRESSBAR_COUNT = "500";
    private static final String SAVE_AFTER_AUDIT = "saveafteraudit";

    public void filterContainerInit(FilterContainerInitArgs args) {
        String isFirst = this.getPageCache().get("first");
        if (isFirst != null && HRStringUtils.equals((String)isFirst, (String)"false")) {
            return;
        }
        List columnList = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : columnList) {
            String fieldName = filterColumn.getFieldName();
            if (!HRStringUtils.equals((String)fieldName, (String)"org.name")) continue;
            filterColumn.setDefaultValue("");
            this.getPageCache().put("first", "false");
            return;
        }
    }

    public void setFilter(SetFilterEvent event) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long taxFileBoId = (Long)customParams.get("taxfileboid");
        if (null != taxFileBoId && 0L != taxFileBoId) {
            event.setOrderBy("hisversion desc");
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "position.company.name": 
            case "position.company.id": {
                List companyFilters = args.getQfilters();
                QFilter companyFilter = new QFilter("adminorgtype.adminorgtypest.id", "!=", (Object)1040L);
                companyFilters.add(companyFilter);
                break;
            }
            case "empgroup.id": 
            case "empgroup.name": {
                List empGroupFilters = args.getQfilters();
                this.addEmpGroupFilter(empGroupFilters);
                break;
            }
            case "org.id": 
            case "org.name": {
                List orgFilters = args.getQfilters();
                this.addOrgFilter(orgFilters);
                break;
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        if ("empgroup.name".equals(fieldName)) {
            List empGroupFilters = args.getQFilters();
            this.addEmpGroupFilter(empGroupFilters);
        }
        if ("org.name".equals(fieldName)) {
            List orgFilter = args.getQFilters();
            this.addOrgFilter(orgFilter);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        IListColumn logListColumn = args.getListColumn("viewlogap");
        IListColumn hisversionListColumn = args.getListColumn("hisversion");
        List columns = args.getListColumns();
        columns.remove(logListColumn);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long taxFileId = (Long)customParams.get("taxfileid");
        if (null == taxFileId || 0L == taxFileId) {
            columns.remove(hisversionListColumn);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (((ListShowParameter)this.getView().getFormShowParameter()).isLookUp()) {
            super.billListHyperLinkClick(args);
            return;
        }
        args.setCancel(true);
        ListView listView = (ListView)this.getView();
        HRBaseServiceHelper taxFileHelper = new HRBaseServiceHelper("itc_taxfile");
        QFilter qFilter = new QFilter("id", "=", listView.getFocusRowPkId());
        DynamicObject taxFileDyObj = taxFileHelper.loadDynamicObject(qFilter);
        Object editStatus = this.getView().getFormShowParameter().getCustomParam("editStatus");
        DataEditStatusEnum statusEnum = editStatus == null ? DataEditStatusEnum.CAN_WRITE : DataEditStatusEnum.fromCode((int)((Integer)BaseDataConverter.convert((Object)editStatus, Integer.class)));
        TaxFileInfoServiceFactory.openTaxFile((DynamicObject)taxFileDyObj, (DataEditStatusEnum)statusEnum, (IFormView)this.getView(), (long)0L);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        switch (opKey) {
            case "audit": {
                if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u64cd\u4f5c\u6570\u636e\u3002", (String)"TaxFileList_24", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ArrayList<Long> taxFileIds = new ArrayList<Long>(selectedRows.size());
                for (int i = 0; i < selectedRows.size(); ++i) {
                    taxFileIds.add((Long)selectedRows.get(i).getPrimaryKeyValue());
                }
                DynamicObject[] taxFileObjs = this.getSelectedTaxFile(taxFileIds);
                if (null != taxFileObjs && this.isHaveLoseEffectFile(taxFileObjs)) {
                    RefObject afterConfirm = new RefObject();
                    if (!formOperate.getOption().tryGetVariableValue(AUDIT_AFTERCONFIRM, afterConfirm)) {
                        args.setCancel(true);
                        ConfirmCallBackListener listener = new ConfirmCallBackListener(CONFIRM_CALLBACK_AUDIT, (IFormPlugin)this);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u6863\u6848\u5931\u6548\u65e5\u671f\u4e0d\u665a\u4e8e\u4eca\u65e5\u7684\uff0c\u6863\u6848\u72b6\u6001\u5c06\u66f4\u65b0\u4e3a\u5df2\u5931\u6548\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaxFileList_0", (String)"sit-itc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, listener);
                        return;
                    }
                }
                long startTime = System.currentTimeMillis();
                this.validateTaxFileApplyCert(taxFileIds, args);
                LOGGER.info("TaxFileList.validateTaxFileApplyCert use time {}:", (Object)(System.currentTimeMillis() - startTime));
                break;
            }
            case "quittax": {
                this.beforeQuitTax(args);
                break;
            }
            case "abandon": {
                this.selectOneAbandonedTaxFile(args);
                break;
            }
            case "donothing_delete": {
                this.getProgressBar(formOperate);
                break;
            }
            case "personcert": {
                if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5173\u8054\u7684\u6863\u6848\u6570\u636e", (String)"TaxFileList_23", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                HashMap<Long, Long> taxmap = new HashMap<Long, Long>(selectedRows.size());
                for (int i = 0; i < selectedRows.size(); ++i) {
                    taxmap.put((Long)selectedRows.get(i).getPrimaryKeyValue(), Long.valueOf(selectedRows.get(i).getRowKey()));
                }
                ArrayList taxfileIds = new ArrayList(taxmap.keySet());
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
                QFilter qFilter = new QFilter("id", "in", taxfileIds);
                DynamicObject[] taxdata = serviceHelper.query("id,person,person.id,person.personindexid", new QFilter[]{qFilter});
                List personIds = Arrays.stream(taxdata).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
                Map<Long, Long> map = Arrays.stream(taxdata).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("person.id"), (k1, k2) -> k1));
                HRBaseServiceHelper service = new HRBaseServiceHelper("hrpi_person");
                QFilter qFilter1 = new QFilter("id", "in", personIds);
                DynamicObject[] persondata = service.query("id,personindexid", new QFilter[]{qFilter1});
                List exitIds = Arrays.stream(persondata).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                StringBuilder sb = null;
                for (Long taxfileId : taxfileIds) {
                    if (exitIds.contains(map.get(taxfileId))) continue;
                    if (sb == null) {
                        sb = new StringBuilder(ResManager.loadKDString((String)"\u7b2c", (String)"TaxFileList_22", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                    }
                    sb.append((Long)taxmap.get(taxfileId) + 1L).append(',');
                }
                ArrayList pids = new ArrayList(persondata.length);
                Arrays.stream(persondata).forEach(dy -> {
                    Long obj = dy.getLong("personindexid");
                    if (obj == null || obj == 0L) {
                        dy.set("personindexid", (Object)dy.getLong("id"));
                    }
                    pids.add(dy.getLong("personindexid"));
                });
                service.update(persondata);
                Long conytryId = 1000001L;
                DynamicObject appInfo = SITCertCommonHelper.queryAppInfoByCountryId((Long)conytryId);
                SITCertCommonHelper.updateCert((String)appInfo.getString("app.id"), (String)"itc_taxfile", pids);
                if (sb != null) {
                    this.getView().showMessage(sb.append(ResManager.loadKDString((String)"\u884c\u6570\u636e\u5173\u8054\u5931\u8d25\uff01", (String)"TaxFileList_21", (String)"sit-itc-formplugin", (Object[])new Object[0])).toString());
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5173\u8054\u6210\u529f\uff01", (String)"TaxFileList_20", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                break;
            }
            case "delcertdetail": {
                HRBaseServiceHelper certHelper = new HRBaseServiceHelper("sitbs_certdetail");
                certHelper.deleteByFilter(new QFilter[]{new QFilter("id", "!=", (Object)0)});
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u8bb8\u53ef\u6210\u529f\uff01", (String)"TaxFileList_19", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        if ("audit".equals(formOperate.getOperateKey())) {
            formOperate.getOption().setVariableValue("batchop_batchsize", "5000");
        }
        if ("submit".equals(formOperate.getOperateKey())) {
            formOperate.getOption().setVariableValue("batchop_batchsize", String.valueOf(5000));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = args.getOperateKey()) {
            case "abandon": {
                if (args.getOperationResult().isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5e9f\u5f03\u6210\u529f\u3002", (String)"TaxFileList_9", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                    ((IEntityOperate)formOperate).setCancelRefresh(false);
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "donothing_delete": {
                if (args.getOperationResult().isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TaxFileList_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                    ((BillList)this.getView().getControl("billlistap")).refresh();
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "donothing_close": {
                IFormView taxTaskListView;
                IFormView parentView = this.getView().getParentView();
                if (ObjectUtils.isEmpty((Object)parentView) || ObjectUtils.isEmpty((Object)(taxTaskListView = parentView.getParentView()))) break;
                taxTaskListView.invokeOperation("refresh");
                this.getView().sendFormAction(taxTaskListView);
                break;
            }
            case "relatesalaryfile": {
                if (!args.getOperationResult().isSuccess() || !CollectionUtils.isEmpty((Collection)args.getOperationResult().getAllErrorInfo())) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u8054\u6210\u529f\u3002", (String)"TaxFileList_15", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                break;
            }
            case "saveafteraudit": {
                this.afterSaveShowResult(args);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (evt.getResult() == MessageBoxResult.Yes) {
            switch (callBackId) {
                case "confirm_callback_audit": {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue(AUDIT_AFTERCONFIRM, "true");
                    this.getView().invokeOperation("audit", operateOption);
                    break;
                }
                case "confirm_callback_refer_latest": {
                    Long currentNewFileId = (Long)BaseDataConverter.convert((Object)this.getPageCache().get("currentFileId"), Long.class);
                    Long referOldFileId = (Long)BaseDataConverter.convert((Object)this.getPageCache().get("referOldFileId"), Long.class);
                    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
                    DynamicObject taxFile = serviceHelper.queryOne("id,taxregion", (Object)currentNewFileId);
                    this.getPageCache().remove("currentFileId");
                    this.getPageCache().remove("referOldFileId");
                    TaxFileInfoServiceFactory.openTaxFile((DynamicObject)taxFile, (DataEditStatusEnum)DataEditStatusEnum.WRITE, (IFormView)this.getView(), (long)referOldFileId);
                    break;
                }
            }
        } else {
            switch (callBackId) {
                case "confirm_callback_refer_latest": {
                    Long currentNewFileId = (Long)BaseDataConverter.convert((Object)this.getPageCache().get("currentFileId"), Long.class);
                    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
                    DynamicObject taxFile = serviceHelper.queryOne("id,taxregion", (Object)currentNewFileId);
                    TaxFileInfoServiceFactory.openTaxFile((DynamicObject)taxFile, (DataEditStatusEnum)DataEditStatusEnum.CAN_WRITE, (IFormView)this.getView(), (long)0L);
                    this.getPageCache().remove("currentFileId");
                    this.getPageCache().remove("referOldFileId");
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection selectedRows;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (QUIT_TAX_CONFIRM.equals(actionId) && !CollectionUtils.isEmpty((Collection)(selectedRows = ((IListView)this.getView()).getSelectedRows()))) {
            Map returnData = (Map)evt.getReturnData();
            if (null == returnData) {
                return;
            }
            Date bsed = (Date)returnData.get("bsed");
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("bsed", HRDateTimeUtils.formatDate((Date)bsed));
            operateOption.setVariableValue("batchop_batchsize", "5000");
            this.getView().invokeOperation(SAVE_AFTER_AUDIT, operateOption);
        }
    }

    public void validateTaxFileApplyCert(List<Long> taxFileIds, BeforeDoOperationEventArgs args) {
        Long conytryId = 1000001L;
        List pids = TaxFileServiceHelper.getApplyOrReleasePids(taxFileIds, (Long)conytryId);
        if (pids != null && pids.size() > 0) {
            DynamicObject appInfo = SITCertCommonHelper.queryAppInfoByCountryId((Long)conytryId);
            Map verfyMap = SITCertCommonHelper.verifyCertForApply((String)appInfo.getString("app.id"), (String)"itc_taxfile", (List)pids);
            Boolean result = (Boolean)verfyMap.get("result");
            HashMap resultMap = (HashMap)verfyMap.get("msg");
            String certHintMsg = (String)resultMap.get("message");
            String showMessage = (String)resultMap.get("showMessage");
            String certDetailMessage = (String)resultMap.get("certDetailMessage");
            String infoType = (String)resultMap.get("infoType");
            LOGGER.info("SITCertCommonHelper.verifyCertForApply result: {} - {}", (Object)certHintMsg, (Object)certDetailMessage);
            if (result.booleanValue()) {
                if ((HRCertPromptInfoTypeEnum.EXCEED.getName().equals(infoType) || HRCertPromptInfoTypeEnum.WARNING.getName().equals(infoType)) && showMessage.equals("true")) {
                    this.getView().showTipNotification(certHintMsg);
                }
            } else {
                this.getView().showErrorNotification(certHintMsg);
                args.setCancel(true);
            }
        }
    }

    private void beforeQuitTax(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        RefObject confirm = new RefObject();
        if (!formOperate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, confirm)) {
            args.setCancel(true);
            ListSelectedRowCollection selectedData = formOperate.getListSelectedData();
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("itc_quittaxconfirm");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"TaxFileList_4", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            parameter.setCustomParam("taxFileIds", (Object)SerializationUtils.toJsonString((Object)selectedData.getPrimaryKeyValues()));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, QUIT_TAX_CONFIRM));
            this.getView().showForm(parameter);
            formOperate.getOption().setVariableValue(OPPARAM_AFTERCONFIRM, "true");
        }
    }

    private DynamicObject[] getSelectedTaxFile(List<Long> taxFileIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
        QFilter qFilter = new QFilter("id", "in", taxFileIds);
        return serviceHelper.query("id,status, bsled,depcytype.number,taxperson.phone,number", new QFilter[]{qFilter});
    }

    private DynamicObject[] getSelectedTaxFileDyobjs() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
            QFilter qFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
            return serviceHelper.query("status, bsled", new QFilter[]{qFilter});
        }
        return null;
    }

    private boolean isHaveLoseEffectFile(DynamicObject[] taxFileDyObjs) {
        for (DynamicObject taxFileDyobj : taxFileDyObjs) {
            Date brled = taxFileDyobj.getDate("bsled");
            if (!HRStringUtils.equals((String)taxFileDyobj.getString("status"), (String)"A") || null == brled || !brled.before(new Date())) continue;
            return true;
        }
        return false;
    }

    private void selectOneAbandonedTaxFile(BeforeDoOperationEventArgs args) {
        DynamicObject[] abandonDyobjs = this.getSelectedTaxFileDyobjs();
        if (null != abandonDyobjs && abandonDyobjs.length == 1 && HRStringUtils.equals((String)abandonDyobjs[0].getString("status"), (String)"E")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"{0}: \u6570\u636e\u5df2\u4e3a\u5e9f\u5f03\u72b6\u6001\uff01", (String)"TaxFileList_8", (String)"sit-itc-formplugin", (Object[])new Object[]{abandonDyobjs[0].getString("number")}));
            args.setCancel(true);
        } else {
            this.getProgressBar((FormOperate)args.getSource());
        }
    }

    private void getProgressBar(FormOperate formOperate) {
        OperateOption option = formOperate.getOption();
        option.setVariableValue("batchop_batchsize", PROGRESSBAR_COUNT);
    }

    private void addOrgFilter(List<QFilter> originalFilters) {
    }

    private void addEmpGroupFilter(List<QFilter> originalFilters) {
        Set empGrpIds;
        List empGroupIds = SITPermissionServiceHelper.getEmpgroupByAppNumber((String)"itc");
        QFilter qFilter = new QFilter("id", "in", (Object)empGroupIds);
        originalFilters.add(qFilter);
        if (!SITPermissionServiceHelper.isSuperUser() && (empGrpIds = SITPermissionServiceHelper.getEmpgrpSetByPermItem((String)"17/+CT1QBPNP", (String)"itc_taxfile", (String)"47150e89000000ac")) != null) {
            QFilter empGroupFilter = new QFilter("id", "in", (Object)empGrpIds);
            originalFilters.add(empGroupFilter);
        }
    }

    private void afterSaveShowResult(AfterDoOperationEventArgs args) {
        int enableNum;
        OperationResult operationResult = args.getOperationResult();
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        String msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaxFileList_17", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        if (operationResult == null || selectedRows.size() == 1) {
            if (operationResult != null && operationResult.isSuccess()) {
                List numberList = selectedRows.stream().map(row -> row.getNumber()).collect(Collectors.toList());
                SitLogServiceHelper.addLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u505c\u6b62\u7b97\u7a0e", (String)"TaxFileList_18", (String)"sit-itc-formplugin", (Object[])new Object[0]), (String)(Joiner.on((String)",").join(numberList) + msg));
                this.getView().showSuccessNotification(msg);
            }
            return;
        }
        int totalNum = operationResult.getBillCount();
        int unEnableNum = totalNum - (enableNum = operationResult.getSuccessPkIds().size());
        if (0 == unEnableNum) {
            SitLogServiceHelper.addLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u505c\u6b62\u7b97\u7a0e", (String)"TaxFileList_18", (String)"sit-itc-formplugin", (Object[])new Object[0]), (String)msg);
            this.getView().showSuccessNotification(msg);
            return;
        }
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        List failList = errorInfos.stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
        operationResult.setShowMessage(false);
        FormOperate source = (FormOperate)args.getSource();
        String title = ResManager.loadKDString((String)"\u505c\u6b62\u7b97\u7a0e\u64cd\u4f5c\u5b8c\u6210\uff0c\u5171{1}\u6761\uff0c\u6210\u529f{2}\u6761\uff0c\u5931\u8d25{3}\u6761", (String)"TaxFileList_16", (String)"sit-itc-formplugin", (Object[])new Object[]{source.getOperateName(), selectedRows.size(), enableNum, unEnableNum});
        FormShowParameter parameter = SITShowFormServiceHelper.getOperationResultParameter((String)source.getOperateName().toString(), (String)title, failList);
        SitLogServiceHelper.addLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u505c\u6b62\u7b97\u7a0e", (String)"TaxFileList_18", (String)"sit-itc-formplugin", (Object[])new Object[0]), (String)title);
        this.getView().showForm(parameter);
    }
}

