/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.tax;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITCertCommonHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.DataEditStatusEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxFilePlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(TaxFilePlugin.class);
    private static final String OP_SUBMIT = "donothing_submit";
    private static final String OP_UN_SUBMIT = "donothing_unsubmit";
    private static final String OP_VALIDATE = "donothing_validate";
    private static final String OP_REFRESH = "donothing_refresh";
    private static final String OP_CLOSE = "donothing_close";
    private static final String BTN_VALIDATE = "validatemap";
    private static final String BAR_SUBMIT = "bar_submit";
    private static final String BAR_UNSUBMIT = "bar_unsubmit";
    private static final String TOOL_BAR_AP = "toolbarap";
    private static final Map<String, String> BTN_TO_FID_MAP = Maps.newHashMapWithExpectedSize((int)3);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{TOOL_BAR_AP});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        long taxFileId = (Long)showParameter.getCustomParam("taxfileid");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(showParameter.getCustomParam("appId") + "_taxfile");
        DynamicObject taxFile = serviceHelper.loadSingle((Object)taxFileId);
        if (null != taxFile) {
            this.setBntVisibleOnFileStatus(taxFile);
            this.hideSider(taxFile);
        }
        this.checkEmpposorgrel(showParameter, taxFile);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String opKey;
        super.itemClick((ItemClickEvent)evt);
        switch (opKey = evt.getOperationKey()) {
            case "donothing_submit": {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u201d\u7684\u201c\u63d0\u4ea4\u201d\u6743\u9650,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxFilePlugin_21", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                this.checkPerm(evt, opKey, msg);
                break;
            }
            case "donothing_unsubmit": {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u201d\u7684\u201c\u64a4\u9500\u201d\u6743\u9650,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxFilePlugin_22", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                this.checkPerm(evt, opKey, msg);
                break;
            }
            case "donothing_validate": {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u201d\u7684\u201c\u5ba1\u6838\u201d\u6743\u9650,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxFilePlugin_23", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                this.checkPerm(evt, opKey, msg);
                break;
            }
        }
    }

    private void checkPerm(BeforeItemClickEvent evt, String opKey, String msg) {
        String permItemId = BTN_TO_FID_MAP.get(opKey);
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SITPermissionServiceHelper.hasPerm((long)userId, (String)"17/+CT1QBPNP", (String)"itc_taxfile", (String)permItemId);
        if (!hasPerm) {
            this.getView().showErrorNotification(msg);
            evt.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        Map childFormView = TaxFileServiceHelper.getChildFormView((IFormView)this.getView());
        List<String> unSavedPage = this.unSavedPage(childFormView);
        if (!CollectionUtils.isEmpty(unSavedPage)) {
            if ("1".equals(this.getView().getPageCache().get("confirm_continue_result"))) {
                this.getView().getPageCache().remove("confirm_continue_result");
            } else {
                args.setCancel(true);
                StringBuilder query = new StringBuilder();
                String split = ResManager.loadKDString((String)"\u3001", (String)"TaxFilePlugin_17", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                for (String page : unSavedPage) {
                    query.append(LocaleString.fromMap((Map)((Map)((IFormView)childFormView.get(page)).getFormShowParameter().getCustomParam("pageName")))).append(split);
                }
                query.delete(query.length() - split.length(), query.length());
                if (OP_VALIDATE.equals(operateKey) || OP_SUBMIT.equals(operateKey) || OP_UN_SUBMIT.equals(operateKey)) {
                    this.getView().showTipNotification(this.getTipNotification(operateKey, query));
                } else {
                    String operateStr = ((MetadataService)ServiceFactory.getService(MetadataService.class)).loadEntityOperationMeta("itc_taxbase", operateKey);
                    Map operateStrMap = (Map)SerializationUtils.fromJsonString((String)operateStr, Map.class);
                    Map operateNameMap = (Map)operateStrMap.get("name");
                    String opName = LocaleString.fromMap((Map)operateNameMap).toString();
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"TaxFilePlugin_13", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5{0}", (String)"TaxFilePlugin_14", (String)"sit-itc-formplugin", (Object[])new Object[]{opName}));
                    MessageBoxOptions options = MessageBoxOptions.OKCancel;
                    String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u4ee5\u4e0b\u9875\u9762\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5{0}\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"TaxFilePlugin_15", (String)"sit-itc-formplugin", (Object[])new Object[]{opName});
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirm_continue:" + operateKey, (IFormPlugin)this);
                    msg = msg.replace("\\\\r\\\\n", "\r\n");
                    this.getView().showConfirm(msg, query.toString(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
                }
            }
        } else if (OP_VALIDATE.equals(operateKey)) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            long taxFileId = (Long)showParameter.getCustomParam("taxfileid");
            ArrayList<Long> taxFileIds = new ArrayList<Long>();
            taxFileIds.add(taxFileId);
            this.validateTaxFileApplyCert(taxFileIds, args);
        }
    }

    public void validateTaxFileApplyCert(List<Long> taxFileIds, BeforeDoOperationEventArgs args) {
        Long conytryId = 1000001L;
        List pids = TaxFileServiceHelper.getApplyOrReleasePids(taxFileIds, (Long)conytryId);
        if (pids != null && pids.size() > 0) {
            DynamicObject appInfo = SITCertCommonHelper.queryAppInfoByCountryId((Long)conytryId);
            Map verfyMap = SITCertCommonHelper.verifyCertForApply((String)appInfo.getString("app.id"), (String)"itc_taxfile", (List)pids);
            Boolean result = (Boolean)verfyMap.get("result");
            HashMap resultMap = (HashMap)verfyMap.get("msg");
            String certHintMsg = (String)resultMap.get("message");
            String showMessage = (String)resultMap.get("showMessage");
            String certDetailMessage = (String)resultMap.get("certDetailMessage");
            String infoType = (String)resultMap.get("infoType");
            LOGGER.info("SITCertCommonHelper.verifyCertForApply result: {} - {}", (Object)certHintMsg, (Object)certDetailMessage);
            if (result.booleanValue()) {
                if ((HRCertPromptInfoTypeEnum.EXCEED.getName().equals(infoType) || HRCertPromptInfoTypeEnum.WARNING.getName().equals(infoType)) && showMessage.equals("true")) {
                    this.getView().showTipNotification(certHintMsg);
                }
            } else {
                this.getView().showErrorNotification(certHintMsg);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        long taxFileId = (Long)showParameter.getCustomParam("taxfileid");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(showParameter.getCustomParam("appId") + "_taxfile");
        DynamicObject taxFile = serviceHelper.loadSingle((Object)taxFileId);
        if (OP_REFRESH.equals(operateKey)) {
            int editStatus = (Integer)showParameter.getCustomParam("editStatus");
            Object editStatusOld = showParameter.getCustomParam("editStatusOld");
            if ("B".equals(taxFile.getString("status"))) {
                showParameter.setCustomParam("editStatusOld", editStatusOld == null ? Integer.valueOf(editStatus) : editStatusOld);
                editStatus = 0;
            } else if (editStatusOld != null) {
                editStatus = (Integer)BaseDataConverter.convert((Object)editStatusOld, Integer.class);
            }
            if (editStatus == 2) {
                editStatus = 1;
            }
            if (DataEditStatusEnum.READ_ONLY.getCode() == editStatus) {
                showParameter.setCustomParam("isOnlyView", (Object)"true");
            } else {
                showParameter.setCustomParam("isOnlyView", (Object)"false");
            }
            showParameter.setCustomParam("editStatus", (Object)editStatus);
            Map relateFileKeyInfo = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("relateFileKeyInfo"), Map.class);
            HashMap relateIds = Maps.newHashMapWithExpectedSize((int)16);
            Map map = TaxFileInfoServiceFactory.loadTaxFileKeyInfo((Map)relateIds, (DynamicObject)taxFile, (int)editStatus);
            relateFileKeyInfo.putAll(map);
            TaxFileInfoServiceFactory.decorateFormShowParameter((FormShowParameter)showParameter, (DynamicObject)taxFile, (Map)relateFileKeyInfo);
            this.getView().cacheFormShowParameter();
            this.getPageCache().put("relateFileKeyInfo", SerializationUtils.toJsonString((Object)relateFileKeyInfo));
            this.getView().updateView();
        } else if (OP_CLOSE.equals(operateKey)) {
            this.getView().invokeOperation("close");
            try {
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    parentView.invokeOperation("refresh");
                    this.getView().sendFormAction(parentView);
                }
            }
            catch (Exception e) {
                LOGGER.error("TaxFilePlugin getParentView occur error ", (Throwable)e);
            }
        } else if (OP_VALIDATE.equals(operateKey)) {
            this.proxyDoOperation(args, showParameter, "audit");
        } else if (OP_SUBMIT.equals(operateKey)) {
            this.proxyDoOperation(args, showParameter, "submit");
        } else if (OP_UN_SUBMIT.equals(operateKey)) {
            this.proxyDoOperation(args, showParameter, "unsubmit");
        }
        String status = taxFile.getString("status");
        if ("C".equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"rightpanelap"});
            this.getView().updateView();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.startsWith("confirm_continue:")) {
            String operateKey = callBackId.substring("confirm_continue:".length());
            this.getView().getPageCache().put("confirm_continue_result", "1");
            this.getView().invokeOperation(operateKey);
        }
    }

    private void proxyDoOperation(AfterDoOperationEventArgs args, FormShowParameter showParameter, String opKey) {
        OperateOption option = OperateOption.create();
        OperationResult result = OperationServiceHelper.executeOperate((String)opKey, (String)(showParameter.getCustomParam("appId") + "_taxfile"), (Object[])new Object[]{showParameter.getCustomParam("taxfileid")}, (OperateOption)option);
        OperationResult operationResult = args.getOperationResult();
        operationResult.setBillCount(0);
        operationResult.getSuccessPkIds().clear();
        operationResult.mergeOperateResult(result);
        operationResult.getAllErrorOrValidateInfo().clear();
        if (result.isSuccess()) {
            this.getView().invokeOperation(OP_REFRESH);
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            if (!parentPageId.startsWith("itc_")) {
                return;
            }
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.invokeOperation("refresh");
                this.getView().sendFormAction(parentView);
            }
        }
    }

    private List<String> unSavedPage(Map<String, IFormView> childViewMap) {
        ArrayList<String> unsavedPages = new ArrayList<String>(10);
        childViewMap.forEach((pageNumber, view) -> {
            OperationStatus viewStatus = view.getFormShowParameter().getStatus();
            if (viewStatus != OperationStatus.VIEW) {
                unsavedPages.add((String)pageNumber);
            }
        });
        return unsavedPages;
    }

    private void setBntVisibleOnFileStatus(DynamicObject taxFileObj) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if ("true".equals(parameter.getCustomParam("isOnlyView")) && ObjectUtils.nullSafeEquals((Object)parameter.getCustomParam("editStatusOld"), (Object)parameter.getCustomParam("editStatus"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SUBMIT, BAR_UNSUBMIT, BTN_VALIDATE});
        } else {
            switch (taxFileObj.getString("status")) {
                case "A": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SUBMIT});
                    this.getView().setVisible(Boolean.FALSE, new String[]{BAR_UNSUBMIT, BTN_VALIDATE});
                    break;
                }
                case "B": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{BAR_UNSUBMIT, BTN_VALIDATE});
                    this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SUBMIT});
                    break;
                }
                case "C": 
                case "E": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SUBMIT, BAR_UNSUBMIT, BTN_VALIDATE});
                    break;
                }
            }
        }
    }

    private void hideSider(DynamicObject taxFile) {
        Long taxfileid;
        Long boid;
        String status = taxFile.getString("status");
        if ("A".equals(status) || "B".equals(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"rightpanelap"});
        }
        if (!ObjectUtils.nullSafeEquals((Object)(boid = (Long)this.getView().getFormShowParameter().getCustomParam("taxfileboid")), (Object)(taxfileid = (Long)this.getView().getFormShowParameter().getCustomParam("taxfileid")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"rightpanelap"});
        }
    }

    private String getTipNotification(String operateKey, StringBuilder query) {
        String msg = null;
        switch (operateKey) {
            case "donothing_validate": {
                msg = ResManager.loadKDString((String)"\u9875\u9762{0}\u6ca1\u6709\u4fdd\u5b58\uff0c\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"TaxFilePlugin_3", (String)"sit-itc-formplugin", (Object[])new Object[]{query});
                break;
            }
            case "donothing_submit": {
                msg = ResManager.loadKDString((String)"{0}\u9875\u9762\u6ca1\u6709\u4fdd\u5b58\uff0c\u4e0d\u80fd\u8fdb\u884c\u63d0\u4ea4\u64cd\u4f5c\u3002", (String)"TaxFilePlugin_18", (String)"sit-itc-formplugin", (Object[])new Object[]{query});
                break;
            }
            case "donothing_unsubmit": {
                msg = ResManager.loadKDString((String)"{0}\u9875\u9762\u6ca1\u6709\u4fdd\u5b58\uff0c\u4e0d\u80fd\u8fdb\u884c\u64a4\u9500\u64cd\u4f5c\u3002", (String)"TaxFilePlugin_19", (String)"sit-itc-formplugin", (Object[])new Object[]{query});
                break;
            }
        }
        return msg;
    }

    private void checkEmpposorgrel(FormShowParameter showParameter, DynamicObject taxFile) {
        Object[] experiencesByPersonId;
        if (null != taxFile && null == showParameter.getCustomParams().get("taxDataBasicId") && YesOrNoEnum.YES.getCode().equals(taxFile.getString("taxstatus")) && ArrayUtils.isEmpty((Object[])(experiencesByPersonId = TaxFileServiceHelper.getExperiencesByPersonId((Long)taxFile.getLong("person.id"))))) {
            String msg = ResManager.loadKDString((String)"\u4eba\u5458\u65e0\u4e3b\u4efb\u804c\uff0c\u8bf7\u68c0\u67e5\u4eba\u5458\u4fe1\u606f\u3002", (String)"TaxFilePlugin_24", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        }
    }

    static {
        BTN_TO_FID_MAP.put(OP_SUBMIT, "804f6478000000ac");
        BTN_TO_FID_MAP.put(OP_UN_SUBMIT, "80513207000000ac");
        BTN_TO_FID_MAP.put(OP_VALIDATE, "47162f66000000ac");
    }
}

