/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.tax;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxFileSideNewPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TaxFileSideNewPlugin.class);
    private static final String TBL_NEW = "tblnew";
    private static final String TBL_MODIFYAFTERAUDIT = "tblmodifyafteraudit";
    private static final String TBL_DELETE = "tbldelete";
    private static final String DONOTHING_DELETE = "donothing_delete";
    private static final String DONOTHING_NEW = "donothing_new";
    private static final String DONOTHING_MODIFY = "donothing_modify";
    private static final String FLEX_LIST = "flexlist";
    private static final String FLEX_EMPTY = "flexempty";
    private static final String HSAS_SALARYFILEF7 = "hsas_salaryfilef7";
    private static final String HSAS_SALARYFILEEXTENDNEW = "hsas_salaryfileextendnew";
    private static final String HSAS_SALARYFILE = "hsas_salaryfile";
    private static final String HSAS_SALARYTAXFILEREL = "hsas_salarytaxfilerel";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.getModel().setValue("isshowstoppayroll", (Object)Boolean.TRUE);
        Boolean isShowStopPayroll = (Boolean)this.getModel().getValue("isshowstoppayroll");
        if (null != isShowStopPayroll) {
            this.showFormView(isShowStopPayroll);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        switch (fieldKey = args.getProperty().getName()) {
            case "isshowstoppayroll": {
                this.showFormView((Boolean)args.getChangeSet()[0].getNewValue());
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "donothing_new": {
                this.showSalaryFileF7Page(TBL_NEW);
                break;
            }
            case "donothing_modify": {
                this.showSalaryFileF7Page(TBL_MODIFYAFTERAUDIT);
                break;
            }
            case "donothing_delete": {
                this.operationDelete();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "tblnew": 
            case "tblmodifyafteraudit": {
                ListSelectedRowCollection returnDataCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                if (returnDataCollection == null) {
                    return;
                }
                DynamicObject taxFileData = this.getTaxFileData();
                String personId = taxFileData.getString("person.id");
                String taxFileId = taxFileData.getString("id");
                Object[] salaryFileObjects = this.querySalaryListData(taxFileId, personId, actionId);
                String salaryFileId = String.valueOf(returnDataCollection.getPrimaryKeyValues()[0]);
                if (!ObjectUtils.isEmpty((Object[])salaryFileObjects)) {
                    HRPageCache pageCache = new HRPageCache(this.getView());
                    pageCache.put("salaryfile", (Object)salaryFileId);
                    String message = ResManager.loadKDString((String)"\u540c\u4e00\u65f6\u95f4\u70b9\u4e0b\u5173\u8054\u7684\u85aa\u8d44\u6863\u6848\u5df2\u7ecf\u5b58\u5728\uff0c\u662f\u5426\u8981\u589e\u52a0\u65b0\u7684\u85aa\u8d44\u6863\u6848\uff1f", (String)"TaxFileSideNewPlugin_9", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                    this.validateTip(message, actionId);
                    break;
                }
                this.doAddSalaryTaxFileRel(personId, taxFileId, salaryFileId, actionId);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        DynamicObject taxFileData = this.getTaxFileData();
        String personId = taxFileData.getString("person.id");
        String taxFileId = taxFileData.getString("id");
        switch (callBackId) {
            case "tblnew": 
            case "tblmodifyafteraudit": {
                HRPageCache pageCache;
                String salaryFileId;
                if (MessageBoxResult.Yes != messageBoxClosedEvent.getResult() || !this.doAddSalaryTaxFileRel(personId, taxFileId, salaryFileId = (String)(pageCache = new HRPageCache(this.getView())).get("salaryfile", String.class), callBackId)) break;
                pageCache.remove("salaryfile");
                break;
            }
            case "tbldelete": {
                List<Object> salaryFileListSelectData;
                if (MessageBoxResult.Yes != messageBoxClosedEvent.getResult() || null == (salaryFileListSelectData = this.getSalaryFileListSelectData()) || salaryFileListSelectData.size() <= 0 || null == salaryFileListSelectData.get(0)) break;
                String salaryFileId = String.valueOf(salaryFileListSelectData.get(0));
                this.doDeleteSalaryTaxFileRel(personId, taxFileId, salaryFileId);
                break;
            }
        }
    }

    private void showEmptyPage() {
        IFormView view = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(FLEX_EMPTY);
        showParameter.setFormId("sitbp_abandonnullpage");
        Map customParams = view.getFormShowParameter().getCustomParams();
        if (customParams != null) {
            showParameter.setCustomParams(customParams);
        }
        view.showForm(showParameter);
    }

    private boolean isContainData(String personId, String taxFileId) {
        boolean isContainData = true;
        Object[] dynamicObjects = this.querySalaryListData(taxFileId, personId, TBL_NEW);
        if (ObjectUtils.isEmpty((Object[])dynamicObjects)) {
            isContainData = false;
        }
        return isContainData;
    }

    private DynamicObject[] querySalaryListData(String taxFileId, String personId, String operation) {
        List<Object> salaryFileListSelectData;
        Boolean isShowStopPayroll = (Boolean)this.getModel().getValue("isshowstoppayroll");
        List<Long> ids = this.getSalaryFileIdByRel(taxFileId, personId);
        if (!CollectionUtils.isEmpty(ids) && HRStringUtils.equals((String)TBL_MODIFYAFTERAUDIT, (String)operation) && !(salaryFileListSelectData = this.getSalaryFileListSelectData()).isEmpty() && salaryFileListSelectData.get(0) != null) {
            ids.remove(salaryFileListSelectData.get(0));
        }
        QFilter listQFilter = this.getListQFilter(HSAS_SALARYFILEEXTENDNEW, ids, isShowStopPayroll);
        DynamicObject[] salaryFileObjects = this.queryDynamicObjects(HSAS_SALARYFILE, new QFilter[]{listQFilter});
        return salaryFileObjects;
    }

    private List<Object> getSalaryFileListSelectData() {
        IListView view;
        HRPageCache pageCache = new HRPageCache(this.getView());
        String pageIds = (String)pageCache.get("pageids", String.class);
        if (null != pageIds && null != (view = (IListView)this.getView().getViewNoPlugin(pageIds)) && null != view.getSelectedRows()) {
            ListSelectedRowCollection selectedRows = view.getSelectedRows();
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            return Lists.newArrayList((Object[])primaryKeyValues);
        }
        return Lists.newArrayList();
    }

    private String querySalaryTaxFileRelId(String personId, String taxFileId, String salaryFileId) {
        QFilter taxFileFilter = new QFilter("taxfile", "=", (Object)Long.parseLong(taxFileId));
        QFilter salaryFileIdFilter = new QFilter("salaryfile.id", "=", (Object)Long.parseLong(salaryFileId));
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject[] dynamicObjects = this.queryDynamicObjects(HSAS_SALARYTAXFILEREL, new QFilter[]{taxFileFilter, salaryFileIdFilter, statusFilter});
        List salaryTaxFileRelIds = Arrays.asList(dynamicObjects).stream().map(salaryTaxFileRel -> salaryTaxFileRel.getString("id")).collect(Collectors.toList());
        return SerializationUtils.toJsonString(salaryTaxFileRelIds);
    }

    private void showFormView(boolean isShowStopPayroll) {
        DynamicObject taxFileData = this.getTaxFileData();
        String taxFileId = taxFileData.getString("id");
        String personId = taxFileData.getString("person.id");
        List<Long> salaryFileIds = this.getSalaryFileIdByRel(taxFileId, personId);
        this.showSalaryFileRelList(salaryFileIds, isShowStopPayroll);
        IFormView view = this.getView();
        String taxFileStatus = (String)view.getFormShowParameter().getCustomParam("status");
        if (HRStringUtils.equals((String)"E", (String)taxFileStatus)) {
            view.setEnable(Boolean.FALSE, new String[]{TBL_DELETE, TBL_NEW, TBL_MODIFYAFTERAUDIT});
        }
        if (this.isContainData(personId, taxFileId)) {
            view.setVisible(Boolean.FALSE, new String[]{FLEX_EMPTY});
            view.setVisible(Boolean.TRUE, new String[]{FLEX_LIST});
        } else {
            this.showEmptyPage();
            view.setVisible(Boolean.FALSE, new String[]{FLEX_LIST});
            view.setVisible(Boolean.TRUE, new String[]{FLEX_EMPTY});
        }
    }

    private void showSalaryFileRelList(List<Long> ids, boolean isShowStopPayroll) {
        IFormView view = this.getView();
        if (!HRStringUtils.isEmpty((String)HSAS_SALARYFILEEXTENDNEW) && null != ids && !ids.isEmpty()) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(FLEX_LIST);
            showParameter.setFormId("sitbp_nosearch_list");
            showParameter.setBillFormId(HSAS_SALARYFILEEXTENDNEW);
            showParameter.setMultiSelect(false);
            showParameter.setLookUp(false);
            showParameter.setCustomParam("nofilter", (Object)Boolean.TRUE);
            showParameter.setHasRight(true);
            QFilter qFilter = this.getListQFilter(HSAS_SALARYFILEEXTENDNEW, ids, isShowStopPayroll);
            if (null != qFilter) {
                ListFilterParameter filterParams = showParameter.getListFilterParameter();
                filterParams.setQFilters(Collections.singletonList(qFilter));
            }
            HRPageCache pageCache = new HRPageCache(view);
            pageCache.put("pageids", (Object)showParameter.getPageId());
            view.showForm((FormShowParameter)showParameter);
        }
    }

    private void showSalaryFileF7Page(String operation) {
        if (HRStringUtils.equals((String)TBL_MODIFYAFTERAUDIT, (String)operation) && !this.validateIsSelectRow()) {
            return;
        }
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)HSAS_SALARYFILEF7, (boolean)false);
        showListForm.setFormId("bos_listf7");
        showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operation));
        showListForm.setLookUp(true);
        showListForm.setMultiSelect(false);
        DynamicObject taxFileData = this.getTaxFileData();
        String personId = taxFileData.getString("person.id");
        if (StringUtils.isEmpty((CharSequence)personId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e2a\u4eba\u4eba\u5458\u5bf9\u5e94\u7684\u7b97\u85aa\u4eba\u5458\u4e0d\u5b58\u5728\u3002", (String)"TaxFileSideNewPlugin_5", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList filters = Lists.newArrayListWithCapacity((int)4);
        filters.add(new QFilter("person.id", "=", (Object)Long.parseLong(personId)));
        filters.add(new QFilter("payrollregion", "=", (Object)taxFileData.getLong("taxregion.id")));
        filters.add(new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.YES.getCode()));
        filters.add(new QFilter("enable", "=", (Object)YesOrNoEnum.YES.getCode()));
        filters.add(new QFilter("status", "not in", (Object)new String[]{"E"}));
        String taxFileId = taxFileData.getString("id");
        List<Long> salaryFileIdByRelIds = this.getSalaryFileIdByRel(taxFileId, personId);
        if (!CollectionUtils.isEmpty(salaryFileIdByRelIds)) {
            filters.add(new QFilter("id", "not in", salaryFileIdByRelIds));
        }
        showListForm.getListFilterParameter().setQFilters((List)filters);
        this.getView().showForm((FormShowParameter)showListForm);
    }

    private List<Long> getSalaryFileIdByRel(String taxFileId, String personId) {
        QFilter qFilter = new QFilter("taxfile", "=", BaseDataConverter.convert((Object)taxFileId, Long.class));
        QFilter statusFilter = new QFilter("status", "not in", (Object)new String[]{"E"});
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HSAS_SALARYTAXFILEREL);
        Object[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter, statusFilter});
        if (!ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            ArrayList<Long> ids = new ArrayList<Long>(dynamicObjects.length);
            for (Object dynamicObject : dynamicObjects) {
                ids.add(dynamicObject.getLong("salaryfile.id"));
            }
            return ids;
        }
        return Collections.emptyList();
    }

    private boolean validateIsSelectRow() {
        boolean flag = true;
        List<Object> salaryFileListSelectData = this.getSalaryFileListSelectData();
        if (null != salaryFileListSelectData) {
            if (salaryFileListSelectData.isEmpty()) {
                String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TaxFileSideNewPlugin_6", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                flag = false;
            }
        } else {
            String message = ResManager.loadKDString((String)"\u8be5\u4e2a\u7a0e\u6863\u6848\u6ca1\u6709\u5173\u8054\u85aa\u8d44\u6863\u6848\u6570\u636e\u3002", (String)"TaxFileSideNewPlugin_7", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            this.validateTip(message, null);
            flag = false;
        }
        return flag;
    }

    private QFilter getListQFilter(String pageNumber, List<Long> ids, boolean isShowStopPayroll) {
        QFilter qFilter = null;
        switch (pageNumber) {
            case "hsas_salaryfileextendnew": {
                qFilter = new QFilter("id", "in", ids);
                qFilter = qFilter.and("status", "!=", (Object)"E");
                if (isShowStopPayroll) break;
                QFilter filter = new QFilter("paystatus", "=", (Object)"1");
                qFilter = qFilter.and(filter);
                break;
            }
        }
        return qFilter;
    }

    private DynamicObject[] queryDynamicObjects(String pageNumber, QFilter[] qFilters) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(pageNumber);
        return serviceHelper.query("id,paystatus,bsed,bsled,firstbsed", qFilters);
    }

    private DynamicObject getTaxFileData() {
        IFormView view = this.getView();
        Long taxFileId = (Long)ObjectConverter.convert((Object)view.getFormShowParameter().getCustomParam("taxfileid"), Long.class, (boolean)true);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
        QFilter qFilter = new QFilter("id", "=", (Object)taxFileId);
        return serviceHelper.queryOne("id,person,taxregion", qFilter);
    }

    private void validateTip(String message, String callBackId) {
        IFormView view = this.getView();
        if (null != callBackId) {
            view.showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
        } else {
            view.showErrorNotification(message);
        }
    }

    private void operationDelete() {
        if (!this.validateIsSelectRow()) {
            return;
        }
        DynamicObject taxFileData = this.getTaxFileData();
        String personId = taxFileData.getString("person.id");
        String taxFileId = taxFileData.getString("id");
        DynamicObject[] dynamicObjects = this.querySalaryListData(taxFileId, personId, TBL_DELETE);
        int relCount = dynamicObjects.length;
        String message = 1 != relCount ? ResManager.loadKDString((String)"\u5220\u9664\u9009\u62e9\u76841\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"TaxFileSideNewPlugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5220\u9664\u8be5\u8bb0\u5f55\u540e\uff0c\u5f53\u524d\u4e2a\u7a0e\u6863\u6848\u5c06\u4e0d\u518d\u5173\u8054\u4efb\u4f55\u85aa\u8d44\u6863\u6848\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaxFileSideNewPlugin_3", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        this.validateTip(message, TBL_DELETE);
    }

    private boolean doAddSalaryTaxFileRel(String personId, String taxFileId, String salaryFileId, String operation) {
        String message;
        HashMap<String, String> params;
        boolean flag;
        block10: {
            flag = false;
            params = new HashMap<String, String>(16);
            params.put("salaryFile", salaryFileId);
            params.put("taxFile", taxFileId);
            if (HRStringUtils.equals((String)TBL_MODIFYAFTERAUDIT, (String)operation)) {
                List<Object> salaryFileListSelectData = this.getSalaryFileListSelectData();
                String salaryTaxFileRelId = null;
                if (null != salaryFileListSelectData && salaryFileListSelectData.size() > 0 && null != salaryFileListSelectData.get(0)) {
                    salaryTaxFileRelId = this.querySalaryTaxFileRelId(personId, taxFileId, String.valueOf(salaryFileListSelectData.get(0)));
                }
                try {
                    if (!HRStringUtils.isEmpty(salaryTaxFileRelId)) {
                        List idList = (List)HRJSONUtils.cast(salaryTaxFileRelId, ArrayList.class, (Class[])new Class[]{Long.class});
                        params.put("oldRelId", (String)idList.get(0));
                        break block10;
                    }
                    params.put("oldRelId", null);
                }
                catch (IOException e) {
                    LOGGER.error((Throwable)e);
                }
            } else {
                params.put("oldRelId", null);
            }
        }
        Map salaryTaxFileRelInfo = (Map)SITMServiceUtils.invokeSWCService((String)"hsas", (String)"IHSASService", (String)"saveOrUpdateSalaryTaxFileRel", (Object[])new Object[]{params});
        if (!Objects.isNull(salaryTaxFileRelInfo) && !salaryTaxFileRelInfo.isEmpty()) {
            boolean success = (Boolean)salaryTaxFileRelInfo.get("success");
            if (success) {
                flag = true;
                Boolean isShowStopPayroll = (Boolean)this.getModel().getValue("isshowstoppayroll");
                this.showFormView(isShowStopPayroll);
            } else {
                message = (String)salaryTaxFileRelInfo.get("message");
                this.validateTip(message, null);
            }
        } else {
            message = ResManager.loadKDString((String)"\u7f51\u7edc\u8d85\u65f6\uff0c\u8bf7\u95f4\u9694\u4e00\u6bb5\u65f6\u95f4\u91cd\u8bd5\u3002", (String)"TaxFileSideNewPlugin_4", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            this.validateTip(message, null);
        }
        return flag;
    }

    private boolean doDeleteSalaryTaxFileRel(String personId, String taxFileId, String salaryFileId) {
        boolean flag = false;
        String salaryTaxFileRelId = this.querySalaryTaxFileRelId(personId, taxFileId, salaryFileId);
        Map salaryTaxFileRelInfo = (Map)SITMServiceUtils.invokeSWCService((String)"hsas", (String)"IHSASService", (String)"deleteSalaryTaxFileRel", (Object[])new Object[]{salaryTaxFileRelId});
        if (!Objects.isNull(salaryTaxFileRelInfo) && !salaryTaxFileRelInfo.isEmpty()) {
            boolean success = (Boolean)salaryTaxFileRelInfo.get("success");
            if (success) {
                flag = true;
                this.clearPageCache();
                Boolean isShowStopPayroll = (Boolean)this.getModel().getValue("isshowstoppayroll");
                this.showFormView(isShowStopPayroll);
            } else {
                String message = (String)salaryTaxFileRelInfo.get("message");
                this.validateTip(message, null);
            }
        } else {
            String message = ResManager.loadKDString((String)"\u7f51\u7edc\u8d85\u65f6\uff0c\u8bf7\u95f4\u9694\u4e00\u6bb5\u65f6\u95f4\u91cd\u8bd5\u3002", (String)"TaxFileSideNewPlugin_4", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            this.validateTip(message, null);
        }
        return flag;
    }

    private void clearPageCache() {
        DynamicObject taxFileData = this.getTaxFileData();
        String personId = taxFileData.getString("person.id");
        String taxFileId = taxFileData.getString("id");
        DynamicObject[] dynamicObjects = this.querySalaryListData(taxFileId, personId, TBL_DELETE);
        if (null != dynamicObjects && dynamicObjects.length == 0) {
            HRPageCache pageCache = new HRPageCache(this.getView());
            pageCache.remove("pageids");
        }
    }
}

