/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.tax;

import com.google.common.base.Strings;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.util.StringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.model.MutexLockInfo;
import kd.sit.sitbp.common.util.BaseResult;

public class TaxFileSubInfoList
extends HRDataBaseList {
    private static final String TOOLBARAP1 = "toolbarap1";
    private static final String TBL_CLEAR = "tblclear";
    private static final String BILLLISTAP = "billlistap";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{TOOLBARAP1});
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.getView().setVisible(Boolean.TRUE, new String[]{TBL_CLEAR});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (TBL_CLEAR.equals(itemKey)) {
            boolean hasTable;
            BillList list = (BillList)this.getControl(BILLLISTAP);
            String entityName = list.getEntityType().getName();
            if (StringUtils.isEmpty((String)entityName)) {
                return;
            }
            long userId = RequestContext.get().getCurrUserId();
            boolean hasPerm = SITPermissionServiceHelper.hasPerm((long)userId, (String)"17/+CT1QBPNP", (String)entityName, (String)"4715a0df000000ac");
            if (!hasPerm) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201d{0}\u201c\u7684\u201d\u4fee\u6539\u201c\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"TaxFileSubInfoList_4", (String)"sit-itc-formplugin", (Object[])new Object[]{list.getEntityType().getDisplayName().getLocaleValue()}));
                return;
            }
            if (null == this.getView().getPageCache().get("hasdata") || !Boolean.parseBoolean(this.getView().getPageCache().get("hasdata"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6e05\u7a7a\u7684\u6570\u636e\u3002", (String)"TaxFileSubInfoList_3", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                return;
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long taxFileId = (Long)customParams.get("taxfileid");
            String tableName = list.getEntityType().getAlias();
            boolean bl = hasTable = !Strings.isNullOrEmpty((String)tableName);
            if (!hasTable) {
                return;
            }
            BaseResult lockInfo = TaxFileServiceHelper.muTextLock((Long)taxFileId, (String)entityName);
            if (lockInfo.isSuccess()) {
                TaxFileServiceHelper.showMutexNotification((IFormView)this.getView(), (MutexLockInfo)((MutexLockInfo)lockInfo.getData()));
                return;
            }
            String msg = ResManager.loadKDString((String)"\u5c06\u6e05\u7a7a\u201c{0}\u201d\u7684\u6570\u636e\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"TaxFileSubInfoList_2", (String)"sit-itc-formplugin", (Object[])new Object[]{list.getEntityType().getDisplayName()});
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("deleteConfirm", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (callBackId.equals("deleteConfirm") && evt.getResult() == MessageBoxResult.Yes) {
            this.deleteTaxFileSubin();
        }
    }

    private void deleteTaxFileSubin() {
        boolean hasTable;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long taxFileId = (Long)customParams.get("taxfileid");
        BillList list = (BillList)this.getControl(BILLLISTAP);
        String entityName = list.getEntityType().getName();
        String tableName = list.getEntityType().getAlias();
        boolean bl = hasTable = !Strings.isNullOrEmpty((String)tableName);
        if (!hasTable) {
            return;
        }
        String displayName = list.getEntityType().getDisplayName().getLocaleValue();
        BaseResult baseResult = TaxFileServiceHelper.deleteTaxFileSubInfo((Long)taxFileId, (String)entityName, (String)displayName);
        this.getView().getPageCache().put("hasdata", null);
        if (!baseResult.isSuccess()) {
            this.getView().showErrorNotification(baseResult.getMessage());
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TaxFileSubInfoList_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        }
        list.refreshData();
    }
}

