/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taxcalreport;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.control.Label;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.itc.business.calreport.CalReportDateUtil;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.enums.YesOrNoEnum;

public class TaxCalReportEdit
extends HRDataBaseEdit
implements SetFilterListener {
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_FAIL = "fail";
    private static final String CAL_DETAIL_LIST = "caldetaillist";
    private static final String OP_TYPE_LABEL = "optypelabel";
    private static final String CATEGORY_LABEL = "category";
    private static final String CATEGORY_LEFT_LABEL = "categoryleft";
    private static final String CATEGORY_RIGHT_LABEL = "categoryright";
    private static final String FAIL_TYPE_COUNT_LABEL = "failtypecount";
    private static final String FAIL_TYPE_LAP_LABEL = "failtypelap";
    private static final String CAL_TIME_LABEL = "caltime";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BillList billList = (BillList)this.getView().getControl(CAL_DETAIL_LIST);
        billList.addSetFilterListener((SetFilterListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        BillList billList = (BillList)this.getView().getControl(CAL_DETAIL_LIST);
        billList.getFilterParameter().getQFilters().add(this.getListFilter());
    }

    private QFilter getListFilter() {
        Long reportId = (Long)this.getModel().getValue("id");
        QFilter qFilter = new QFilter("taxcalreport", "=", (Object)reportId);
        return qFilter;
    }

    public void afterBindData(EventObject evt) {
        this.setOpType();
        this.setNewCategory();
        Map<String, Map<Integer, Integer>> countMap = this.queryCalDetail();
        this.setFailType(countMap);
        this.setCalTime();
    }

    private void setOpType() {
        DynamicObject report = this.getModel().getDataEntity();
        ComboProp opType = (ComboProp)this.getModel().getProperty("optype");
        Map<String, LocaleString> opTypeMap = opType.getComboItems().stream().collect(Collectors.toMap(ValueMapItem::getValue, ValueMapItem::getName));
        this.setLabelValue(OP_TYPE_LABEL, opTypeMap.get(report.getString("optype")).getLocaleValue());
    }

    private void setCalTime() {
        DynamicObject report = this.getModel().getDataEntity();
        String timeStr = CalReportDateUtil.getTimeStr((Date)report.getDate("createtime"), (Date)report.getDate("modifytime"));
        this.setLabelValue(CAL_TIME_LABEL, timeStr);
    }

    private void setNewCategory() {
        DynamicObject report = this.getModel().getDataEntity();
        if (report.getDynamicObjectCollection("newtaxcategory").size() != 0) {
            DynamicObjectCollection newTaxCategory = report.getDynamicObjectCollection("newtaxcategory");
            StringBuilder category = new StringBuilder();
            String split = "\u3001";
            for (DynamicObject dynamicObject : newTaxCategory) {
                String name = dynamicObject.getString("fbasedataid.name");
                category.append(name).append(split);
            }
            int length = category.length();
            category.delete(length - split.length(), length);
            this.setLabelValue(CATEGORY_LABEL, category.toString());
            return;
        }
        this.setLabelVisible(Boolean.FALSE, CATEGORY_LABEL, CATEGORY_LEFT_LABEL, CATEGORY_RIGHT_LABEL);
    }

    private void setFailType(Map<String, Map<Integer, Integer>> countMap) {
        if (!CollectionUtils.isEmpty(countMap)) {
            int warnCount = this.getModel().getDataEntity().getInt("warncount");
            DynamicProperty failType = EntityMetadataCache.getDataEntityType((String)"itc_taxcalrecord").getProperty("failtype");
            StringBuilder detailStr = new StringBuilder();
            String successStr = ResManager.loadKDString((String)"\u8ba1\u7b97\u6210\u529f\u4f46\u5b58\u5728\u95ee\u9898", (String)"TaxCalReportEdit_1", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            String unit = ResManager.loadKDString((String)"\u6761", (String)"TaxCalReportEdit_2", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            String comma = "\uff0c";
            String semicolon = "\uff1b";
            Map<Integer, Integer> successMap = countMap.get(KEY_SUCCESS);
            Map<Integer, Integer> failMap = countMap.get(KEY_FAIL);
            if (!CollectionUtils.isEmpty(successMap)) {
                detailStr.append(successStr).append("  ").append(warnCount).append(unit).append(semicolon);
            }
            if (!CollectionUtils.isEmpty(failMap)) {
                failMap.forEach((key, value) -> {
                    String itemName = ((ComboProp)failType).getItemByName(String.valueOf(key));
                    detailStr.append(itemName).append("  ").append(value).append(unit).append(comma);
                });
            }
            int length = detailStr.length();
            detailStr.delete(length - comma.length(), length);
            this.setLabelValue(FAIL_TYPE_COUNT_LABEL, detailStr.toString());
            return;
        }
        this.setLabelVisible(Boolean.FALSE, FAIL_TYPE_LAP_LABEL);
    }

    public Map<String, Map<Integer, Integer>> queryCalDetail() {
        long calReportId = this.getModel().getDataEntity().getLong("id");
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FFAILTYPE failtype, COUNT(FFAILTYPE) count, FISSUCCESS issuccess ");
        sql.append("FROM T_ITC_TAXCALRECORD ");
        sql.append("WHERE FTAXCALREPORTID = ? ");
        sql.append("GROUP BY FFAILTYPE, FISSUCCESS");
        return (Map)HRDBUtil.query((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)sql.toString(), (Object[])new Object[]{calReportId}, rs -> {
            HashMap result = Maps.newHashMapWithExpectedSize((int)2);
            while (rs.next()) {
                if (YesOrNoEnum.isYes((String)rs.getString("issuccess"))) {
                    result.computeIfAbsent(KEY_SUCCESS, v1 -> new HashMap()).put(Integer.valueOf(rs.getString("failtype")), rs.getInt("count"));
                    continue;
                }
                result.computeIfAbsent(KEY_FAIL, v1 -> new HashMap()).put(Integer.valueOf(rs.getString("failtype")), rs.getInt("count"));
            }
            return result;
        });
    }

    public void setFilter(SetFilterEvent args) {
        args.getQFilters().add(this.getListFilter());
    }

    private void setLabelValue(String labelName, String value) {
        Label label = (Label)this.getControl(labelName);
        label.setText(value);
    }

    private void setLabelVisible(Boolean flag, String ... labelName) {
        this.getView().setVisible(flag, labelName);
    }
}

