/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taxsrcdata;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.IListColumnConfig;
import kd.bos.list.ListColumn;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListGridView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.business.taxtaskguide.task.TaskGuideRawDataDownLoadTask;
import kd.sit.itc.formplugin.web.taskguide.model.TaxDataGuideBillList;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.CalTaxTypeEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.enums.TaxTaskTypeEnum;
import kd.sit.sitbp.common.model.SitEntityTypeBillList;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;
import kd.sit.sitbp.common.util.async.enums.MultiThreadCase;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxRawDataListPlugin
extends HRDataBaseList {
    public static final String BILL_LIST_AP = "billlistap";
    public static final String GRID_VIEW = "gridview";
    private SitEntityTypeBillList billList;
    private ListGridView gridView;
    private MainEntityType extTypeTaxData;

    public void beforeBindData(EventObject eventObject) {
        Long taxTaskId = (Long)BaseDataConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("taxTaskId"), Long.class);
        BaseResult result = TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskId);
        TaxTaskEntity data = (TaxTaskEntity)result.getData();
        if (result.isSuccess() && !data.isEnd() && data.isEnable() && !TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(data.getTaxTaskType())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_returndata"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_returndata"});
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        BillList customControl = null;
        if (BILL_LIST_AP.equals(key)) {
            customControl = this.createBillList(key);
        } else if (GRID_VIEW.equals(key)) {
            customControl = this.createListGridView(key);
        }
        if (customControl != null) {
            args.setControl((Control)customControl);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        super.getEntityType(args);
        args.setNewEntityType(this.extEntityType());
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        Map<String, IListColumn> collect = listColumns.stream().collect(Collectors.toMap(IListColumnConfig::getListFieldKey, e1 -> e1, (k1, k2) -> k1));
        Set<String> hiddenKeys = this.hiddenColumns();
        if (hiddenKeys != null && !hiddenKeys.isEmpty()) {
            for (String hiddenKey : hiddenKeys) {
                IListColumn column = collect.get(hiddenKey);
                if (column == null) continue;
                column.setVisible(0);
            }
        }
        List listGroupColumns = args.getListGroupColumns();
        ListColumnGroup salary2TaxGroup = null;
        ListColumnGroup tax2SalaryGroup = null;
        if (listGroupColumns != null) {
            for (ListColumnGroup groupColumn : listGroupColumns) {
                if ("salary2taxgroup".equals(groupColumn.getKey())) {
                    salary2TaxGroup = groupColumn;
                    continue;
                }
                if (!"tax2salarygroup".equals(groupColumn.getKey())) continue;
                tax2SalaryGroup = groupColumn;
            }
        }
        List<TaxItemEntity> taxItemEntities = this.taxItemEntities();
        for (TaxItemEntity taxItem : taxItemEntities) {
            ListColumn column;
            if (taxItem.isIncomeItem()) continue;
            Long itemId = taxItem.getId();
            String key = "it_" + itemId;
            if (collect.containsKey(key) || SITBaseConstants.INCOME_ITEM_1.equals(taxItem.getId()) || SITBaseConstants.INCOME_ITEM_2.equals(taxItem.getId())) continue;
            if (SitDataTypeEnum.isDecimal((long)taxItem.getDatatypeId())) {
                DecimalListColumn temp = new DecimalListColumn();
                temp.setDisplayFormatString(taxItem.formatString());
                temp.setZeroShow(true);
                column = temp;
            } else {
                column = new ListColumn();
            }
            column.setCaption(LocaleString.fromMap((Map)taxItem.getName()));
            column.setColumnOrder(false);
            column.setColumnFilter(false);
            column.setKey(key);
            column.setListFieldKey(key);
            if (tax2SalaryGroup != null && CalTaxTypeEnum.fromTaxById((long)taxItem.getCaltaxtypeId())) {
                tax2SalaryGroup.getItems().add(column);
            } else if (salary2TaxGroup != null) {
                salary2TaxGroup.getItems().add(column);
            }
            listColumns.add(column);
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        List qFilters = setFilterEvent.getQFilters();
        TaxTaskGuideOpEnum.convertFilters((List)qFilters);
        super.setFilter(setFilterEvent);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        switch (operate.getOperateKey()) {
            case "exportbylist": {
                this.exportByList();
                break;
            }
            case "showexportresult": {
                this.showExportResult();
                break;
            }
        }
    }

    private TaxTaskEntity getTask() {
        Long taxTaskId = (Long)BaseDataConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("taxTaskId"), Long.class);
        BaseResult result = TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskId);
        return (TaxTaskEntity)result.getData();
    }

    private void exportByList() {
        Long taxTaskId = (Long)BaseDataConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("taxTaskId"), Long.class);
        BaseResult taxTaskEntityRes = TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskId);
        if (!taxTaskEntityRes.isSuccess()) {
            this.getView().showTipNotification(taxTaskEntityRes.getMessage());
            return;
        }
        SitEntityTypeBillList billList = (SitEntityTypeBillList)this.getControl(BILL_LIST_AP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        int total = CollectionUtils.isEmpty((Collection)selectedRows) ? billList.queryBillDataCount() : selectedRows.size();
        if (total == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"TaxTaskGuidePlugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        TaskGuideRawDataDownLoadTask task = new TaskGuideRawDataDownLoadTask((TaxTaskEntity)taxTaskEntityRes.getData(), this.getView(), (BillList)billList);
        task.setHandleCase(MultiThreadCase.BY_ACTION);
        String dataKey = ResManager.loadKDString((String)"\u5217\u8868\u6570\u636e", (String)"TaxTaskGuidePlugin_9", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        task.addData(dataKey, total, 500, 1).ofKey(RequestContext.get().getTraceId());
        BatchResult execute = MultiThreadTaskExecutor.execute((MultiThreadTask)task, (boolean)true, (ThreadPool)SITThreadPoolFactory.getExportPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getExportHanddataThreadPool());
        if (!execute.isSuccess()) {
            this.getView().showErrorNotification(execute.getMessage());
        }
    }

    private void showExportResult() {
        Long taxTaskId = (Long)BaseDataConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("taxTaskId"), Long.class);
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId("bos_exportlog");
        param.setFormId("bos_list");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getListFilterParameter().setFilter(new QFilter("bizobject", "=", (Object)("itc_taxrawdata" + taxTaskId)));
        param.getListFilterParameter().setFilter(new QFilter("creator.id", "=", (Object)RequestContext.get().getCurrUserId()));
        this.getView().showForm((FormShowParameter)param);
    }

    public void destory() {
        super.destory();
        GlobalParam.remove();
    }

    public void pageRelease(EventObject eventObject) {
        super.pageRelease(eventObject);
        GlobalParam.remove();
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new TaxTaskGuideDataProviderImpl());
    }

    protected MainEntityType extEntityType() {
        try {
            if (this.extTypeTaxData == null) {
                this.extTypeTaxData = (MainEntityType)EntityMetadataCache.getDataEntityType((String)"itc_taxrawdata").clone();
            }
            List<TaxItemEntity> taxItemEntities = this.taxItemEntities();
            for (TaxItemEntity taxItemEntity : taxItemEntities) {
                String prop = "it_" + taxItemEntity.getId();
                if (this.extTypeTaxData.getProperties().containsKey((Object)prop)) continue;
                TextProp property = new TextProp();
                property.setName(prop);
                this.extTypeTaxData.addProperty((DynamicProperty)property);
            }
            this.extTypeTaxData.createPropIndexs();
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u9875\u9762\u5b9e\u4f53\u6269\u5c55\u5931\u8d25\u3002", (String)"TaxRawDataListPlugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        return this.extTypeTaxData;
    }

    protected List<TaxItemEntity> taxItemEntities() {
        Long taxTaskId = (Long)BaseDataConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("taxTaskId"), Long.class);
        BaseResult taxTaskRes = TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskId);
        if (!taxTaskRes.isSuccess()) {
            return new ArrayList<TaxItemEntity>(0);
        }
        TaxTaskEntity taxTask = (TaxTaskEntity)taxTaskRes.getData();
        return taxTask.getTaxItemOfCat((Long)this.getView().getFormShowParameter().getCustomParam("taxCategoryId"));
    }

    private BillList createBillList(String key) {
        if (this.billList == null) {
            this.billList = new TaxDataGuideBillList((EntityType)this.extEntityType());
        } else {
            this.extEntityType();
        }
        this.billList.setKey(key);
        this.billList.setEntityId("itc_taxrawdata");
        ListView listView = (ListView)this.getView();
        this.billList.setBillFormId(listView.getBillFormId());
        this.billList.setView((IFormView)listView);
        Container rootControl = (Container)this.getView().getRootControl();
        this.replaceBillList(rootControl.getItems(), (Control)this.billList);
        return this.billList;
    }

    private BillList createListGridView(String key) {
        if (this.gridView == null) {
            this.gridView = new ListGridView();
            this.gridView.setParent((BillList)this.billList);
        }
        this.gridView.setKey(key);
        Container rootControl = (Container)this.getView().getRootControl();
        this.replaceBillList(rootControl.getItems(), (Control)this.gridView);
        return this.billList;
    }

    private void replaceBillList(List<Control> items, Control billList) {
        for (int i = 0; i < items.size(); ++i) {
            Control control = items.get(i);
            if (control.getKey().equals(billList.getKey())) {
                items.set(i, billList);
                return;
            }
            if (!(control instanceof Container)) continue;
            this.replaceBillList(((Container)control).getItems(), billList);
        }
    }

    private void addItemProps(DynamicObjectType mainType, Set<String> listFields) {
        List<TaxItemEntity> taxItems = this.taxItemEntities();
        DataEntityPropertyCollection properties = mainType.getProperties();
        for (String listField : listFields) {
            if (properties.containsKey((Object)listField)) continue;
            TextProp property = new TextProp();
            property.setName(listField);
            mainType.addProperty((DynamicProperty)property);
        }
        for (TaxItemEntity taxItem : taxItems) {
            String number = "it_" + taxItem.getId();
            if (properties.containsKey((Object)number)) continue;
            TextProp property = new TextProp();
            property.setName(number);
            mainType.addProperty((DynamicProperty)property);
        }
    }

    protected String propNameOfTaxValue(TaxTaskEntity task) {
        if (TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(task.getTaxTaskType())) {
            return "calvalue";
        }
        return "itemvalue";
    }

    protected Set<String> hiddenColumns() {
        return null;
    }

    private class TaxTaskGuideDataProviderImpl
    extends ListDataProvider {
        private TaxTaskGuideDataProviderImpl() {
        }

        public String getOrderByExpr() {
            String order = super.getOrderByExpr();
            if (StringUtils.isEmpty((String)order) || "id".equals(order)) {
                return "taxfile.taxunit.id asc, taxfile.number asc";
            }
            return order;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            TaxTaskGuideViewHelper.cacheFilterAndOrderBy((ListDataProvider)this, (IPageCache)TaxRawDataListPlugin.this.getView().getPageCache());
            DynamicObjectCollection data = super.getData(start, limit);
            if (CollectionUtils.isEmpty((Collection)data)) {
                return data;
            }
            List listFields = this.getListFields();
            DynamicObjectType objectType = data.getDynamicObjectType();
            LinkedHashSet keySet = Sets.newLinkedHashSetWithExpectedSize((int)listFields.size());
            boolean formPrivate = true;
            for (ListField e12 : listFields) {
                String listFieldKey = e12.getListFieldKey();
                if (formPrivate && ("taxcategory".equals(listFieldKey) || listFieldKey.startsWith("taxcategory."))) {
                    formPrivate = false;
                }
                keySet.add(listFieldKey);
            }
            if (formPrivate) {
                return data;
            }
            String propNameOfTaxValue = TaxRawDataListPlugin.this.propNameOfTaxValue(TaxRawDataListPlugin.this.getTask());
            TaxRawDataListPlugin.this.addItemProps(objectType, keySet);
            Map<Long, DynamicObject> dataMap = data.stream().collect(Collectors.toMap(e1 -> e1.getLong("id"), e1 -> e1, (k1, k2) -> k1));
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxrawdata");
            DynamicObject[] query = serviceHelper.query("id,entryentity.taxitem,entryentity." + propNameOfTaxValue, new QFilter[]{new QFilter("id", "in", dataMap.keySet())});
            DataEntityPropertyCollection properties = data.getDynamicObjectType().getProperties();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"itc_taxrawdata");
            for (DynamicObject object : query) {
                DynamicObject object1 = dataMap.get(object.getLong("id"));
                TaxTaskGuideOpEnum.convertStatus((DynamicObject)object1);
                String description = object1.getString("taxdatabasic.description");
                JSONObject jsonObject = JSONObject.parseObject((String)description);
                if (!CollectionUtils.isEmpty((Map)jsonObject)) {
                    for (Map.Entry entry : jsonObject.entrySet()) {
                        String propName = ((String)entry.getKey()).toLowerCase();
                        IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)propName);
                        DynamicProperty property1 = mainEntityType.getProperty(propName);
                        if (property == null || property1 == null) continue;
                        object1.set(propName, BaseDataConverter.convert(entry.getValue(), (Class)property1.getPropertyType()));
                    }
                }
                DynamicObjectCollection entry = object.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : entry) {
                    String prop = "it_" + dynamicObject.getString("taxitem.id");
                    if (!objectType.getProperties().containsKey((Object)prop)) continue;
                    object1.set(prop, (Object)dynamicObject.getString(propNameOfTaxValue));
                }
            }
            return data;
        }
    }
}

