/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taxtask;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.threads.ThreadPool;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.itc.business.taxtask.InitTaxDataBasicHelper;
import kd.sit.itc.business.taxtask.TaxTaskCheckTypeHelper;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.itc.business.taxtaskguide.task.InitTaxDataBasicTask;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.TaxFrequencyEnum;
import kd.sit.sitbp.common.enums.TaxTaskCheckTypeEnum;
import kd.sit.sitbp.common.enums.TaxTaskStatusEnum;
import kd.sit.sitbp.common.enums.TaxTaskTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.SitDateUtil;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxTaskEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
RowClickEventListener,
EntryGridBindDataListener {
    private static final Log LOGGER = LogFactory.getLog(TaxTaskEdit.class);
    private static final String TAXUNIT_CALLBACK = "taxunit_cb";
    private static final String TAXCATEGORY_CALLBACK = "taxcategory_cb";
    private static final String[] NOT_ALLOWED_EDITED_FIELDS = new String[]{"number", "name", "adminorg", "taxtasktype", "isneeddeclare", "taxperiod", "exratedate", "declaredate", "isexistforeigncur", "exratetable", "foreigncurrency", "generalenname", "index", "tracker", "description"};
    private static final String MODIFY_BTN = "bar_modify";
    private static final String TAXPERIOD_BEFORE = "taxperiod_before";
    private static final String TAXUNIT_BEFORE = "taxunit_before";
    private TaxTaskCheckTypeEnum TASK_CHECK_TYPE;
    private AtomicBoolean entryGridDataBind = new AtomicBoolean();

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"taxunittoolbar"});
        this.addItemClickListeners(new String[]{"taxcategorytoolbar"});
        BasedataEdit taxPeriod = (BasedataEdit)this.getControl("taxperiod");
        BasedataEdit splitAlgo = (BasedataEdit)this.getControl("splitalgo");
        BasedataEdit foreignCur = (BasedataEdit)this.getControl("foreigncurrency");
        BasedataEdit calRuleBo = (BasedataEdit)this.getControl("calrulebo");
        EntryGrid taxItemEntry = (EntryGrid)this.getControl("taxtaskcatgentry");
        taxItemEntry.addRowClickListener((RowClickEventListener)this);
        taxItemEntry.addDataBindListener((EntryGridBindDataListener)this);
        taxPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        splitAlgo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        foreignCur.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        calRuleBo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            this.copyAtrributeCtrl();
        }
        long id = this.getModel().getDataEntity().getLong("id");
        this.getView().getPageCache().put("taskid", String.valueOf(id));
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject eventObject) {
        this.getPageCache().put(TAXPERIOD_BEFORE, SerializationUtils.serializeToBase64((Object)this.getModel().getDataEntity().getLong("taxperiod.id")));
        DynamicObjectCollection taxTaskUnitEntry = this.getModel().getEntryEntity("taxtaskunitentry");
        if (CollectionUtils.isEmpty((Collection)taxTaskUnitEntry)) {
            this.getPageCache().put(TAXUNIT_BEFORE, SerializationUtils.serializeToBase64((Object)ImmutableSet.of()));
        } else {
            Set taxUnitIdSet = taxTaskUnitEntry.stream().map(dy -> dy.getLong("taxunit.id")).collect(Collectors.toSet());
            this.getPageCache().put(TAXUNIT_BEFORE, SerializationUtils.serializeToBase64(taxUnitIdSet));
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.TASK_CHECK_TYPE = TaxTaskCheckTypeHelper.checkInfoOfTask((DynamicObject)this.getModel().getDataEntity());
        this.setCalRuleBo(this.getModel().getDataEntity().getString("taxtasktype"));
        this.declareDateCtrl();
        this.foreignCurCtrl();
        this.existForeignCurCtrl();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String hasLock = (String)formShowParameter.getCustomParam("hasLock");
        if (!Strings.isNullOrEmpty((String)hasLock)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MODIFY_BTN});
            String hasLockMessage = (String)formShowParameter.getCustomParam("hasLockMessage");
            if (!Strings.isNullOrEmpty((String)hasLockMessage)) {
                this.getView().showTipNotification(hasLockMessage);
            }
        }
        if (formShowParameter.getStatus().equals((Object)OperationStatus.EDIT)) {
            this.splitAlgoCtrl();
            this.unModifiableFieldCtrl();
            this.putForeignCurPageCache();
            this.getView().setVisible(Boolean.FALSE, new String[]{MODIFY_BTN});
        } else if (formShowParameter.getStatus().equals((Object)OperationStatus.VIEW)) {
            this.setTaxcategoryEntryButton(Boolean.FALSE);
        }
        JSONObject customParams = (JSONObject)formShowParameter.getCustomParams();
        JSONArray obj = (JSONArray)customParams.get((Object)"addTaxCategoryIds");
        if (null != obj) {
            Object[] taxCategoryIds = (Long[])obj.toArray((Object[])new Long[0]);
            if (formShowParameter.getStatus().equals((Object)OperationStatus.EDIT) && taxCategoryIds != null && taxCategoryIds.length > 0) {
                this.getView().getPageCache().put("isOnlyAddTaxCategory", YesOrNoEnum.YES.getCode());
                this.addTaxCategoryToEntry(taxCategoryIds);
            }
        }
    }

    private void setTaxcategoryEntryButton(Boolean show) {
        this.getView().setVisible(show, new String[]{"addnewtaxcategory"});
        this.getView().setVisible(show, new String[]{"deletetaxcategory"});
        this.getView().setVisible(show, new String[]{"movetaxcategoryup"});
        this.getView().setVisible(show, new String[]{"movetaxcategorydown"});
    }

    private void declareDateCtrl() {
        DynamicObject taxPeriod = this.getModel().getDataEntity().getDynamicObject("taxperiod");
        if (taxPeriod == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"declaredate"});
        }
    }

    private void foreignCurCtrl() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (model.getValue("exratedate") == null) {
            view.setEnable(Boolean.FALSE, new String[]{"foreigncurrency"});
        }
    }

    private void copyAtrributeCtrl() {
        this.getModel().setValue("taxperiod", null);
        this.getModel().setValue("taxstartdate", null);
        this.getModel().setValue("taxenddate", null);
        this.getModel().setValue("declarestartdate", null);
        this.getModel().setValue("declareenddate", null);
        this.getModel().setValue("exratetable", null);
        this.getModel().setValue("foreigncurrency", null);
        this.getModel().setValue("index", null);
        this.getModel().setValue("isexisttaxrecord", (Object)0);
        this.getModel().setValue("taxpersoncount", (Object)0);
        this.getModel().setValue("endstatus", (Object)0);
        this.getModel().setValue("taskstatus", (Object)0);
        this.getModel().setValue("taxunitcol", null);
        DynamicObjectCollection taxUnitEntries = this.getModel().getEntryEntity("taxtaskunitentry");
        Iterator taxUnitEntriesIt = taxUnitEntries.iterator();
        while (taxUnitEntriesIt.hasNext()) {
            DynamicObject taxUnitEntry = (DynamicObject)taxUnitEntriesIt.next();
            if (taxUnitEntry.getLong("taxunit.id") == 0L) {
                taxUnitEntriesIt.remove();
                continue;
            }
            taxUnitEntry.set("declarestatus", (Object)YesOrNoEnum.NO.getCode());
            taxUnitEntry.set("taxfilenum", (Object)0);
        }
        DynamicObjectCollection taxCateEntries = this.getModel().getEntryEntity("taxtaskcatgentry");
        Iterator taxCateEntriesIt = taxCateEntries.iterator();
        while (taxCateEntriesIt.hasNext()) {
            DynamicObject taxCateEntry = (DynamicObject)taxCateEntriesIt.next();
            if (taxCateEntry.getLong("taxcategory.id") == 0L) {
                taxCateEntriesIt.remove();
                continue;
            }
            taxCateEntry.set("taxdatanum", (Object)0);
        }
    }

    private void splitAlgoCtrl() {
        long id = this.getModel().getDataEntity().getLong("id");
        if (id != 0L) {
            DynamicObjectCollection oldEntryEntityDys = this.getModel().getEntryEntity("taxtaskcatgentry");
            Long firstTaxCategoryId = 0L;
            if (oldEntryEntityDys.size() > 0) {
                firstTaxCategoryId = ((DynamicObject)oldEntryEntityDys.get(0)).getLong("taxcategory.id");
            }
            this.setEnableForSplitalgo(id, firstTaxCategoryId);
        }
    }

    private void unModifiableFieldCtrl() {
        ArrayList taxTasks = Lists.newArrayList((Object[])new DynamicObject[]{this.getModel().getDataEntity(true)});
        Map checkResultMap = TaxTaskCheckTypeHelper.checkInfoOfTaskList((List)taxTasks);
        if (!CollectionUtils.isEmpty((Map)checkResultMap)) {
            List infoList = checkResultMap.values().stream().map(e1 -> e1.getI18nParam().getDescription()).collect(Collectors.toList());
            LOGGER.info("TaxTaskCheckTypeEnum is [{}]", infoList);
            this.getView().setVisible(Boolean.FALSE, new String[]{"deletetaxunit"});
            this.getView().setEnable(Boolean.FALSE, NOT_ALLOWED_EDITED_FIELDS);
        }
        this.setTaxcategoryEntryButton(Boolean.TRUE);
        if (this.TASK_CHECK_TYPE != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"deletetaxunit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxtasktype"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "addnewtaxunit": {
                this.addTaxUnit();
                break;
            }
            case "addnewtaxcategory": {
                this.addTaxCategory();
                break;
            }
            case "deletetaxcategory": {
                this.deleteTaxCategory();
                break;
            }
        }
    }

    private void deleteTaxCategory() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("taxtaskcatgentry");
        int[] selectRowsIndexes = entryGrid.getSelectRows();
        if (selectRowsIndexes.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u4e2a\u7a0e\u79cd\u7c7b\u3002", (String)"TaxTaskEdit_5", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        LinkedHashMap<Integer, DynamicObject> entryMap = new LinkedHashMap<Integer, DynamicObject>(selectRowsIndexes.length);
        for (int selectRowsIndex : selectRowsIndexes) {
            DynamicObject entry = this.getModel().getEntryRowEntity("taxtaskcatgentry", selectRowsIndex);
            entryMap.put(selectRowsIndex, entry);
        }
        List<Map<DynamicObject, TaxTaskCheckTypeEnum>> resultMap = this.checkTaxCategoryCanBeDeleted(entryMap);
        if (!CollectionUtils.isEmpty(entryMap)) {
            this.getModel().deleteEntryRows("taxtaskcatgentry", entryMap.keySet().stream().mapToInt(Integer::valueOf).toArray());
        }
        if (!CollectionUtils.isEmpty(resultMap)) {
            int notPassNum = resultMap.size();
            int totalNum = selectRowsIndexes.length;
            ArrayList errMsg = Lists.newArrayListWithCapacity((int)notPassNum);
            String tip = MessageFormat.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5171{0}\u6761\u8bb0\u5f55\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"TaxTaskEdit_12", (String)"sit-itc-formplugin", (Object[])new Object[0]), totalNum, totalNum - notPassNum, notPassNum);
            resultMap.stream().map(map -> map.entrySet().iterator().next()).forEach(map -> {
                String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\u4e2a\u7a0e\u79cd\u7c7b\u4e0b{1}\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"TaxTaskEdit_13", (String)"sit-itc-formplugin", (Object[])new Object[0]), ((DynamicObject)map.getKey()).getDynamicObject("taxcategory").getString("name"), ((TaxTaskCheckTypeEnum)map.getValue()).getI18nParam().getDescription());
                errMsg.add(msg);
            });
            FormShowParameter parameter = SITShowFormServiceHelper.getOperationResultParameter((String)ResManager.loadKDString((String)"\u5220\u9664", (String)"TaxTaskEdit_23", (String)"sit-itc-formplugin", (Object[])new Object[0]), (String)tip, (List)errMsg);
            this.getView().showForm(parameter);
        }
    }

    private List<Map<DynamicObject, TaxTaskCheckTypeEnum>> checkTaxCategoryCanBeDeleted(Map<Integer, DynamicObject> entryMap) {
        DynamicObject taxTask = this.getModel().getDataEntity();
        long taxTaskId = taxTask.getLong("id");
        if (0L == taxTaskId) {
            return ImmutableList.of();
        }
        ArrayList<DynamicObject> categoryEntryList = new ArrayList<DynamicObject>(entryMap.values());
        Map checkMap = TaxTaskCheckTypeHelper.checkInfoOfCategory((DynamicObject)taxTask, categoryEntryList);
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)checkMap.size());
        if (CollectionUtils.isEmpty((Map)checkMap)) {
            return resultList;
        }
        Iterator<Map.Entry<Integer, DynamicObject>> it = entryMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, DynamicObject> next = it.next();
            long catId = next.getValue().getLong("taxcategory.id");
            TaxTaskCheckTypeEnum typeEnum = (TaxTaskCheckTypeEnum)checkMap.get(catId);
            if (typeEnum == null) continue;
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)1);
            resultMap.put(next.getValue(), typeEnum);
            resultList.add(resultMap);
            it.remove();
        }
        return resultList;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "taxunit_cb": {
                this.afterCloseTaxUnitF7(closedCallBackEvent);
                break;
            }
            case "taxcategory_cb": {
                this.afterCloseTaxCategoryF7(closedCallBackEvent);
                break;
            }
            case "afterprocessclose": {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u4e2a\u7a0e\u4efb\u52a1\u6210\u529f\u3002", (String)"TaxTaskEdit_28", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void afterCloseTaxUnitF7(ClosedCallBackEvent closedCallBackEvent) {
        Object[] newTaxUnitIds;
        ListSelectedRowCollection returnDataCollection = null;
        if (!HRObjectUtils.isEmpty((Object)closedCallBackEvent)) {
            returnDataCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        }
        if (null == returnDataCollection || returnDataCollection.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection oldEntryEntityDys = model.getEntryEntity("taxtaskunitentry");
        if (oldEntryEntityDys.size() != 0) {
            Set oldTaxUnitId = oldEntryEntityDys.stream().map(oldDy -> oldDy.getDynamicObject("taxunit").getLong("id")).collect(Collectors.toSet());
            newTaxUnitIds = returnDataCollection.stream().filter(listSelectedRow -> !oldTaxUnitId.contains(listSelectedRow.getPrimaryKeyValue())).map(ListSelectedRow::getPrimaryKeyValue).toArray();
            if (newTaxUnitIds.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7eb3\u7a0e\u5355\u4f4d\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"TaxTaskEdit_6", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            }
        } else {
            newTaxUnitIds = returnDataCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        }
        if (newTaxUnitIds.length == 0) {
            return;
        }
        Map<Long, Set<Long>> resultMap = this.checkTaxUnitByTaxCategoryAndTaxPeriod(newTaxUnitIds);
        if (CollectionUtils.isEmpty(resultMap)) {
            this.addTaxUnitToEntry(newTaxUnitIds);
        } else {
            Object[] filterTaxUnitIds = TaxTaskServiceHelper.filterTaxUnitId((Object[])newTaxUnitIds, resultMap);
            this.addTaxUnitToEntry(filterTaxUnitIds);
            int total = newTaxUnitIds.length;
            int success = filterTaxUnitIds.length;
            TaxTaskServiceHelper.showTips(resultMap, (int)total, (int)success, (IFormView)this.getView(), (String)"addTaxUnit");
        }
    }

    private void addTaxUnitToEntry(Object[] newTaxUnitIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("taxunit", new Object[0]);
        for (Object newTaxUnitId : newTaxUnitIds) {
            vs.addRow(new Object[]{(Long)newTaxUnitId});
        }
        model.batchCreateNewEntryRow("taxtaskunitentry", vs);
        model.endInit();
        this.getView().updateView("taxtaskunitentry");
    }

    private Map<Long, Set<Long>> checkTaxUnitByTaxCategoryAndTaxPeriod(Object[] newTaxUnitIds) {
        return TaxTaskServiceHelper.checkTaxUnitByTaxCategoryAndTaxPeriod((Object[])newTaxUnitIds, (IDataModel)this.getModel());
    }

    private void addTaxUnit() {
        Set taxUnitIds;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject createOrg = model.getDataEntity().getDynamicObject("createorg");
        if (null == createOrg) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e2a\u7a0e\u7ba1\u7406\u7ec4\u7ec7\u540e\u518d\u6dfb\u52a0\u201c\u7eb3\u7a0e\u5355\u4f4d\u201d\u3002", (String)"TaxTaskEdit_0", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        long createOrgId = createOrg.getLong("id");
        Map<Long, DynamicObject> taxUnitMap = this.getUsedTaxUnitMap();
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"hbss_taxunit", (boolean)true);
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        if (taxUnitMap != null && !taxUnitMap.isEmpty()) {
            QFilter idFilter = new QFilter("id", "not in", taxUnitMap.keySet());
            qFilter.and(idFilter);
        }
        if (!SITPermissionServiceHelper.isSuperUser() && Objects.nonNull(taxUnitIds = SITPermissionServiceHelper.getTaxUnitSetByPermItem((Long)RequestContext.get().getCurrUserId(), (String)"17/+CT1QBPNP", (String)"itc_taxtask", (String)"47150e89000000ac"))) {
            QFilter idFilter = new QFilter("id", "in", (Object)taxUnitIds);
            qFilter.and(idFilter);
            LOGGER.info("taxtask taxUnitIds after F7 is {}", (Object)taxUnitIds.toString());
        }
        showListForm.getListFilterParameter().setFilter(qFilter);
        showListForm.setCaption(ResManager.loadKDString((String)"\u7eb3\u7a0e\u5355\u4f4d", (String)"TaxTaskEdit_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TAXUNIT_CALLBACK));
        view.showForm((FormShowParameter)showListForm);
    }

    public void entryGridBindData(EntryGridBindDataEvent event) {
        this.setCalRuleBo(this.getModel().getDataEntity().getString("taxtasktype"));
    }

    private Map<Long, DynamicObject> getUsedTaxUnitMap() {
        long taxTaskId = this.getModel().getDataEntity().getLong("id");
        long taxPeriodId = this.getModel().getDataEntity().getLong("taxperiod.id");
        Date startDate = this.getModel().getDataEntity().getDate("taxperiod.startdate");
        Date endDate = this.getModel().getDataEntity().getDate("taxperiod.enddate");
        if (taxPeriodId == 0L || startDate == null || endDate == null) {
            return null;
        }
        Set taxPeriodIds = TaxTaskServiceHelper.getSameOrTimeOverlapTaxPeriodIds((long)taxPeriodId, (Date)startDate, (Date)endDate);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxtask");
        QFilter qFilter = new QFilter("taxperiod.id", "in", (Object)taxPeriodIds);
        qFilter.and("id", "!=", (Object)taxTaskId);
        DynamicObject[] taxTaskDys = helper.query("id,taxtaskunitentry.taxunit", new QFilter[]{qFilter});
        if (taxTaskDys == null || taxTaskDys.length == 0) {
            return null;
        }
        HashMap<Long, DynamicObject> taxUnitMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject taxTaskDy : taxTaskDys) {
            taxTaskDy.getDynamicObjectCollection("taxtaskunitentry").forEach(dy -> taxUnitMap.put(dy.getLong("taxunit.id"), dy.getDynamicObject("taxunit")));
        }
        return taxUnitMap;
    }

    private void addTaxCategory() {
        IFormView view = this.getView();
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("country.id", "in", (Object)Long.valueOf("1000001")));
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"sitbs_taxcategory", (boolean)true);
        showListForm.getListFilterParameter().setFilter(qFilter);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qFilter);
        showListForm.getTreeFilterParameter().setQFilters(qFilters);
        showListForm.setCaption(ResManager.loadKDString((String)"\u4e2a\u7a0e\u79cd\u7c7b", (String)"TaxTaskEdit_2", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TAXCATEGORY_CALLBACK));
        view.showForm((FormShowParameter)showListForm);
    }

    private void afterCloseTaxCategoryF7(ClosedCallBackEvent closedCallBackEvent) {
        Object[] newTaxCategoryIds;
        ListSelectedRowCollection returnDataCollection = null;
        if (!HRObjectUtils.isEmpty((Object)closedCallBackEvent)) {
            returnDataCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        }
        if (null == returnDataCollection || returnDataCollection.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection oldEntryEntityDys = model.getEntryEntity("taxtaskcatgentry");
        if (oldEntryEntityDys.size() != 0) {
            Set oldTaxCategoryId = oldEntryEntityDys.stream().map(oldDy -> oldDy.getLong("taxcategory.id")).collect(Collectors.toSet());
            newTaxCategoryIds = returnDataCollection.stream().filter(listSelectedRow -> !oldTaxCategoryId.contains(listSelectedRow.getPrimaryKeyValue())).map(ListSelectedRow::getPrimaryKeyValue).toArray();
            if (newTaxCategoryIds.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e2a\u7a0e\u79cd\u7c7b\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"TaxTaskEdit_7", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            }
        } else {
            newTaxCategoryIds = returnDataCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        }
        Map<Long, Set<Long>> resultMap = this.checkTaxCategoryByTaxUnitAndTaxPeriod(newTaxCategoryIds);
        if (CollectionUtils.isEmpty(resultMap)) {
            this.addTaxCategoryToEntry(newTaxCategoryIds);
        } else {
            Object[] filterTaxCategoryIds = TaxTaskServiceHelper.filterTaxCategoryId((Object[])newTaxCategoryIds, resultMap);
            this.addTaxCategoryToEntry(filterTaxCategoryIds);
            int total = newTaxCategoryIds.length;
            int success = filterTaxCategoryIds.length;
            TaxTaskServiceHelper.showTips(resultMap, (int)total, (int)success, (IFormView)this.getView(), (String)"addTaxCategory");
        }
    }

    private void addTaxCategoryToEntry(Object[] newTaxCategoryIds) {
        Long createOrgId = this.getModel().getDataEntity().getLong("createorg.id");
        String taxTaskType = this.getModel().getDataEntity().getString("taxtasktype");
        Map taxCategoryToCalRuleMap = TaxTaskServiceHelper.getCalRuleMapByTaxCategoryIdsAndOrgId((Object[])newTaxCategoryIds, (Long)createOrgId);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("taxcategory", new Object[0]);
        vs.addField("calrulebo", new Object[0]);
        for (Object newTaxCategoryId : newTaxCategoryIds) {
            if (TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(taxTaskType) && !CollectionUtils.isEmpty((Map)taxCategoryToCalRuleMap)) {
                Set calRuleBoIds = (Set)taxCategoryToCalRuleMap.get((Long)newTaxCategoryId);
                if (calRuleBoIds != null && calRuleBoIds.size() == 1) {
                    vs.addRow(new Object[]{(Long)newTaxCategoryId, calRuleBoIds.iterator().next()});
                    continue;
                }
                vs.addRow(new Object[]{(Long)newTaxCategoryId});
                continue;
            }
            vs.addRow(new Object[]{(Long)newTaxCategoryId});
        }
        model.batchCreateNewEntryRow("taxtaskcatgentry", vs);
        model.endInit();
        this.getView().updateView("taxtaskcatgentry");
        Object[] taxItemDys = TaxTaskServiceHelper.getSrcProportionTaxItemsByTaxCategoryId((Object[])newTaxCategoryIds);
        HashMap taxCategoryToTaxItemMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!ArrayUtils.isEmpty((Object[])taxItemDys)) {
            for (Object taxItemDy : taxItemDys) {
                DynamicObjectCollection taxCategories = taxItemDy.getDynamicObjectCollection("taxcategories");
                for (DynamicObject taxCategory : taxCategories) {
                    Long taxCategoryId = taxCategory.getLong("fbasedataid_id");
                    List taxItemList = taxCategoryToTaxItemMap.computeIfAbsent(taxCategoryId, key -> Lists.newArrayListWithCapacity((int)8));
                    taxItemList.add(taxItemDy);
                }
            }
        }
        Set newTaxCategoryIdSet = Arrays.stream(newTaxCategoryIds).map(obj -> Long.valueOf(String.valueOf(obj))).collect(Collectors.toSet());
        DynamicObjectCollection newEntryEntityDys = this.getModel().getEntryEntity("taxtaskcatgentry");
        for (DynamicObject entryEntityDy : newEntryEntityDys) {
            long taxCategoryId = entryEntityDy.getLong("taxcategory.id");
            if (!newTaxCategoryIdSet.contains(taxCategoryId)) continue;
            DynamicObjectCollection dynamicObjectCollection = entryEntityDy.getDynamicObjectCollection("taxtaskitemdetail");
            List taxItemList = (List)taxCategoryToTaxItemMap.get(taxCategoryId);
            for (int i = 0; i < taxItemList.size(); ++i) {
                DynamicObject taxItemDy = (DynamicObject)taxItemList.get(i);
                DynamicObject emptyDynamicObject = dynamicObjectCollection.addNew();
                emptyDynamicObject.set("taxitem", (Object)taxItemDy);
                emptyDynamicObject.set("splitalgo", (Object)taxItemDy.getDynamicObject("splitalgo"));
                emptyDynamicObject.set("seq", (Object)(i + 1));
            }
        }
        this.updateModelCacheAndPage(newEntryEntityDys);
    }

    private Map<Long, Set<Long>> checkTaxCategoryByTaxUnitAndTaxPeriod(Object[] newTaxCategoryIds) {
        return TaxTaskServiceHelper.checkTaxCategoryByTaxUnitAndTaxPeriod((Object[])newTaxCategoryIds, (IDataModel)this.getModel());
    }

    private void updateModelCacheAndPage(DynamicObjectCollection entryEntityDys) {
        this.getModel().updateEntryCache(entryEntityDys);
        this.getView().updateView("taxtaskcatgentry");
        this.getView().updateView("taxtaskitemdetail");
        String taxTaskType = this.getModel().getDataEntity().getString("taxtasktype");
        this.setCalRuleBo(taxTaskType);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData[] changeData = args.getChangeSet();
        switch (fieldKey) {
            case "taxperiod": {
                this.setTaxAndDeclareDate(changeData);
                break;
            }
            case "taxstartdate": {
                Date taxStartDate = (Date)changeData[0].getNewValue();
                this.setExRateDate(taxStartDate);
                break;
            }
            case "exratetable": {
                this.setForeignCurByTable(changeData);
                break;
            }
            case "exratedate": {
                this.setForeignCurNull(changeData);
                break;
            }
            case "isexistforeigncur": {
                this.existForeignCurCtrl();
                break;
            }
            case "taxtasktype": {
                String newValue = (String)changeData[0].getNewValue();
                this.setCalRuleBo(newValue);
                break;
            }
            case "calrulebo": {
                this.changeCalRuleBo(args);
                break;
            }
        }
    }

    private void changeCalRuleBo(PropertyChangedArgs args) {
        ChangeData[] changeData = args.getChangeSet();
        int rowIndex = changeData[0].getRowIndex();
        this.getModel().setValue("calrule", null, rowIndex);
    }

    private void setCalRuleBo(String taxTaskType) {
        if (Strings.isNullOrEmpty((String)taxTaskType)) {
            return;
        }
        if (TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(taxTaskType)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taxtaskcatgentry");
            if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
                Long createOrgId = this.getModel().getDataEntity().getLong("createorg.id");
                Object[] taxCategoryIds = entryEntity.stream().map(dy -> dy.getLong("taxcategory.id")).toArray();
                Map taxCategoryToCalRuleMap = TaxTaskServiceHelper.getCalRuleMapByTaxCategoryIdsAndOrgId((Object[])taxCategoryIds, (Long)createOrgId);
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                    int taxDataNum = dynamicObject.getInt("taxdatanum");
                    if (taxDataNum > 0) {
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"calrulebo"});
                        continue;
                    }
                    if (!CollectionUtils.isEmpty((Map)taxCategoryToCalRuleMap)) {
                        long taxCategoryId = dynamicObject.getLong("taxcategory.id");
                        DynamicObject calRuleBoDy = dynamicObject.getDynamicObject("calrulebo");
                        Set calRuleBoIds = (Set)taxCategoryToCalRuleMap.get(taxCategoryId);
                        if (!CollectionUtils.isEmpty((Collection)calRuleBoIds) && calRuleBoIds.size() == 1 && calRuleBoDy == null) {
                            this.getModel().setValue("calrulebo", calRuleBoIds.iterator().next(), i);
                        }
                    }
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"calrulebo"});
                }
            }
        } else {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taxtaskcatgentry");
            if (this.entryGridDataBind.compareAndSet(false, true) && !CollectionUtils.isEmpty((Collection)entryEntity)) {
                this.getModel().beginInit();
                for (int i = 0; i < entryEntity.size(); ++i) {
                    this.getModel().setValue("calrulebo", null, i);
                    this.getModel().setValue("calrule", null, i);
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"calrulebo"});
                }
                this.getModel().endInit();
                this.getView().updateView("taxtaskcatgentry");
            }
        }
    }

    private void setTaxAndDeclareDate(ChangeData[] changeData) {
        DynamicObject dynamicObject = (DynamicObject)changeData[0].getNewValue();
        IDataModel model = this.getModel();
        model.setValue("taxstartdate", dynamicObject == null ? null : dynamicObject.getDate("startdate"));
        model.setValue("taxenddate", dynamicObject == null ? null : dynamicObject.getDate("enddate"));
        model.setValue("declarestartdate", dynamicObject == null ? null : dynamicObject.getDate("declarestartdate"));
        model.setValue("declareenddate", dynamicObject == null ? null : dynamicObject.getDate("declareenddate"));
        DynamicObject taxPeriod = model.getDataEntity().getDynamicObject("taxperiod");
        if (taxPeriod != null) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"declaredate"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"declaredate"});
        }
    }

    private void setExRateDate(Date taxStartDate) {
        IDataModel model = this.getModel();
        boolean isExistForeignCur = this.getModel().getDataEntity().getBoolean("isexistforeigncur");
        if (isExistForeignCur && taxStartDate != null) {
            Date exRateDate = HRDateTimeUtils.getBeforeDay((Date)taxStartDate);
            model.setValue("exratedate", (Object)exRateDate);
            this.getView().setEnable(Boolean.valueOf(model.getValue("exratetable") != null), new String[]{"foreigncurrency"});
        } else {
            model.setValue("exratedate", null);
        }
    }

    private void setForeignCurByTable(ChangeData[] changeData) {
        IDataModel model = this.getModel();
        model.setValue("foreigncurrency", null);
        if (model.getValue("exratedate") != null) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"foreigncurrency"});
        }
        IFormView view = this.getView();
        DynamicObject exRateTable = (DynamicObject)changeData[0].getNewValue();
        if (exRateTable == null) {
            view.setEnable(Boolean.FALSE, new String[]{"foreigncurrency"});
        }
    }

    private void setForeignCurNull(ChangeData[] changeData) {
        Date exRateDate = (Date)changeData[0].getNewValue();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.setValue("foreigncurrency", null);
        if (exRateDate == null) {
            view.setEnable(Boolean.FALSE, new String[]{"foreigncurrency"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey;
        switch (fieldKey = evt.getProperty().getName()) {
            case "taxperiod": {
                this.taxPeriodF7Select(evt);
                break;
            }
            case "splitalgo": {
                ListShowParameter splitAlgoParam = (ListShowParameter)evt.getFormShowParameter();
                splitAlgoParam.setMultiSelect(false);
                break;
            }
            case "foreigncurrency": {
                this.foreignCurF7Select(evt);
                break;
            }
            case "calrulebo": {
                this.calRuleF7Select(evt);
                break;
            }
        }
    }

    private void taxPeriodF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter taxPeriodParam = (ListShowParameter)evt.getFormShowParameter();
        QFilter filter = new QFilter("taxperiodprg.country.id", "in", (Object)Long.valueOf("1000001"));
        filter.and(new QFilter("taxperiodprg.enable", "=", (Object)"1"));
        filter.and(new QFilter("taxperiodprg.status", "=", (Object)"C"));
        taxPeriodParam.getListFilterParameter().setFilter(filter);
        taxPeriodParam.setCaption(ResManager.loadKDString((String)"\u4e2a\u7a0e\u671f\u95f4", (String)"TaxTaskEdit_14", (String)"sit-itc-formplugin", (Object[])new Object[0]));
    }

    private void calRuleF7Select(BeforeF7SelectEvent evt) {
        DynamicObject createOrgDy = this.getModel().getDataEntity().getDynamicObject("createorg");
        String taxTaskType = this.getModel().getDataEntity().getString("taxtasktype");
        if (null == createOrgDy) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e2a\u7a0e\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"TaxTaskEdit_29", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter calRuleListShowParameter = (ListShowParameter)evt.getFormShowParameter();
        long createOrgId = this.getModel().getDataEntity().getLong("createorg.id");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("taxtaskcatgentry", evt.getRow());
        long taxCategoryId = entryRowEntity.getLong("taxcategory.id");
        QFilter useOrgFilter = SITPermissionServiceHelper.getBaseDataFilter((String)"sitbs_calrule", (Long)createOrgId);
        calRuleListShowParameter.getListFilterParameter().setFilter(useOrgFilter);
        calRuleListShowParameter.getListFilterParameter().setFilter(new QFilter("taxcategory.id", "=", (Object)taxCategoryId));
        calRuleListShowParameter.getListFilterParameter().setFilter(new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.YES.getCode()));
        calRuleListShowParameter.setMultiSelect(false);
        calRuleListShowParameter.setCustomParam("isShowUsed", (Object)Boolean.TRUE);
    }

    private void foreignCurF7Select(BeforeF7SelectEvent evt) {
        Date exRateDate = this.getModel().getDataEntity().getDate("exratedate");
        long excTable = this.getModel().getDataEntity().getLong("exratetable.id");
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject[] exRates = TaxTaskServiceHelper.getSelectedExRate((long)excTable, (Date)exRateDate);
        Set<Long> currencySet = this.getSelectedCur(exRates);
        QFilter curFilter = new QFilter("id", "in", currencySet);
        curFilter.and("id", "!=", (Object)1L);
        param.getListFilterParameter().setFilter(curFilter);
        param.setCaption(ResManager.loadKDString((String)"\u53ef\u9009\u5e01\u79cd", (String)"TaxTaskEdit_15", (String)"sit-itc-formplugin", (Object[])new Object[0]));
    }

    private Set<Long> getSelectedCur(DynamicObject[] exRates) {
        HashSet<Long> currencySet = new HashSet<Long>(16);
        for (DynamicObject exRate : exRates) {
            Long orgCur = exRate.getDynamicObject("orgcur").getLong("id");
            Long cur = exRate.getDynamicObject("cur").getLong("id");
            if (cur.equals(1L)) {
                currencySet.add(orgCur);
                continue;
            }
            if (!orgCur.equals(1L)) continue;
            currencySet.add(cur);
        }
        return currencySet;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxtask");
            long id = this.getModel().getDataEntity().getLong("id");
            DynamicObject dynamicObject = serviceHelper.queryOne("id,taskstatus", new QFilter("id", "=", (Object)id));
            if (Objects.nonNull(dynamicObject) && TaxTaskStatusEnum.INITING.getCode().equals(dynamicObject.getString("taskstatus"))) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e2a\u7a0e\u4efb\u52a1\u6b63\u5728\u521d\u59cb\u5316\uff0c\u8bf7\u7a0d\u540e\u518d\u6253\u5f00\u3002", (String)"TaxTaskEdit_30", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                return;
            }
            this.checkAbnormalPeriod(args);
            this.checkDate(args);
            this.checkCurAndExRateDate(args);
            this.checkCurQuoted(args);
            this.checkTaxUnit(args);
            this.checkTaxCategory(args);
            this.checkSameTaxPeriodTaxUnit(args);
            this.putForeignCurPageCache();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        IFormView parentView;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String isOnlyAddTaxCategory = this.getView().getPageCache().get("isOnlyAddTaxCategory");
        if (YesOrNoEnum.isYes((String)isOnlyAddTaxCategory) && "save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().returnDataToParent((Object)"finish");
            this.getView().close();
            return;
        }
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            DynamicObject taxTaskDy = this.getModel().getDataEntity(true);
            String taskStatus = taxTaskDy.getString("taskstatus");
            LOGGER.info("task number is {}, and taskstatus is {}", (Object)taxTaskDy.getString("number"), (Object)taskStatus);
            if (TaxTaskStatusEnum.DEFAULT.getCode().equals(taskStatus)) {
                LOGGER.info("task run initTaxDataBasicData");
                this.initTaxDataBasicData(taxTaskDy);
            } else if (TaxTaskStatusEnum.INIT_FINISH.isLessEqThan(taskStatus) && TaxTaskStatusEnum.SAD_PREPARED.isGreaterThan(taskStatus)) {
                ImmutableSet oldTaxUnitIdSet;
                long newTaxPeriodId = this.getModel().getDataEntity().getLong("taxperiod.id");
                DynamicObjectCollection newTaxTaskUnitEntry = this.getModel().getEntryEntity("taxtaskunitentry");
                Set newTaxUnitIdSet = newTaxTaskUnitEntry.stream().map(dy -> dy.getLong("taxunit.id")).collect(Collectors.toSet());
                String oldTaxPeriodStr = this.getPageCache().get(TAXPERIOD_BEFORE);
                String oldTaxUnitIdSetStr = this.getPageCache().get(TAXUNIT_BEFORE);
                long oldTaxPeriodId = Strings.isNullOrEmpty((String)oldTaxPeriodStr) ? 0L : (Long)SerializationUtils.deSerializeFromBase64((String)oldTaxPeriodStr);
                Object object = oldTaxUnitIdSet = Strings.isNullOrEmpty((String)oldTaxUnitIdSetStr) ? ImmutableSet.of() : (Set)SerializationUtils.deSerializeFromBase64((String)oldTaxUnitIdSetStr);
                if (newTaxPeriodId != oldTaxPeriodId || !CollectionUtils.isEmpty((Collection)Sets.difference(newTaxUnitIdSet, (Set)oldTaxUnitIdSet)) || !CollectionUtils.isEmpty((Collection)Sets.difference((Set)oldTaxUnitIdSet, newTaxUnitIdSet))) {
                    args.getOperationResult().setShowMessage(false);
                    LOGGER.info("task run updateTaxDataBasicData");
                    this.updateTaxDataBasicData(taxTaskDy.getLong("id"));
                    this.getPageCache().put(TAXPERIOD_BEFORE, SerializationUtils.serializeToBase64((Object)newTaxPeriodId));
                    this.getPageCache().put(TAXUNIT_BEFORE, SerializationUtils.serializeToBase64(newTaxUnitIdSet));
                }
            }
        }
        if ("save".equals(operateKey) && (parentView = this.getView().getParentView()) != null) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    private void updateTaxDataBasicData(Long taxTaskId) {
        TaxTaskEntity taxTaskEntity = new TaxTaskEntity();
        DynamicObject taxTaskDy = new HRBaseServiceHelper("itc_taxtask").loadDynamicObject(new QFilter("id", "=", (Object)taxTaskId));
        taxTaskEntity.initBy(taxTaskDy);
        LOGGER.info("updateTaxDataBasicData, id of taxTaskDy is [{}]", (Object)taxTaskId);
        this.updateTaskStatus(taxTaskDy, TaxTaskStatusEnum.INITING.getCode());
        this.getPageCache().put("updateTaxDataBasicData", "1");
        InitTaxDataBasicHelper.confirmVersion((TaxTaskEntity)taxTaskEntity, (IFormView)this.getView(), (boolean)true);
    }

    private void initTaxDataBasicData(DynamicObject taxTaskDy) {
        TaxTaskEntity taxTaskEntity = new TaxTaskEntity();
        taxTaskEntity.lightWeightInitBy(taxTaskDy);
        Map initedTaxFileIdMap = InitTaxDataBasicHelper.getInitedTaxFileIdMap((TaxTaskEntity)taxTaskEntity);
        LOGGER.info("available taxfile count (not real count) is {}", (Object)initedTaxFileIdMap.size());
        if (!CollectionUtils.isEmpty((Map)initedTaxFileIdMap)) {
            int size = initedTaxFileIdMap.size();
            this.updateTaskStatus(taxTaskDy, TaxTaskStatusEnum.INITING.getCode());
            if (size <= 500) {
                LOGGER.info("start initTaxDataBasic in Syn with taxtaskid = {}", (Object)taxTaskEntity.getId());
                InitTaxDataBasicTask initTaxDataBasicTask = new InitTaxDataBasicTask(taxTaskEntity, null);
                initTaxDataBasicTask.addData(500, (List)Lists.newArrayList(initedTaxFileIdMap.values()));
                MultiThreadTaskExecutor.execute((MultiThreadTask)initTaxDataBasicTask, (boolean)false, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
                LOGGER.info("finish initTaxDataBasic in Syn with taxtaskid = {}", (Object)taxTaskEntity.getId());
            } else {
                LOGGER.info("start initTaxDataBasic in Asyn with taxtaskid = {}", (Object)taxTaskEntity.getId());
                InitTaxDataBasicTask initTaxDataBasicTask = new InitTaxDataBasicTask(taxTaskEntity, this.getView());
                initTaxDataBasicTask.addData(500, (List)Lists.newArrayList(initedTaxFileIdMap.values()));
                MultiThreadTaskExecutor.execute((MultiThreadTask)initTaxDataBasicTask, (boolean)true, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
                LOGGER.info("end initTaxDataBasic in Asyn with taxtaskid = {}", (Object)taxTaskEntity.getId());
            }
        } else {
            this.updateTaskStatus(taxTaskDy, TaxTaskStatusEnum.INIT_FINISH.getCode());
        }
    }

    private void updateTaskStatus(DynamicObject taxTaskDy, String status) {
        HRBaseServiceHelper taskHelper = new HRBaseServiceHelper("itc_taxtask");
        taxTaskDy.set("taskstatus", (Object)status);
        taxTaskDy.set("status", (Object)"C");
        taskHelper.updateOne(taxTaskDy);
    }

    private void checkAbnormalPeriod(BeforeDoOperationEventArgs args) {
        DynamicObject taxPeriod = this.getModel().getDataEntity().getDynamicObject("taxperiod");
        long periodPrgId = taxPeriod.getLong("taxperiodprg.id");
        DynamicObject periodPrg = new HRBaseServiceHelper("sitbs_taxperiodprg").loadSingle((Object)periodPrgId);
        String frequencyType = periodPrg.getString("calfrequency.type");
        TaxFrequencyEnum taxFrequencyEnum = TaxFrequencyEnum.valueOf((String)frequencyType);
        int startDate = SitDateUtil.toYearMonth((Date)taxPeriod.getDate("startdate"));
        int endDate = SitDateUtil.toYearMonth((Date)taxPeriod.getDate("enddate"));
        int periodDate = SitDateUtil.toYearMonth((Date)taxPeriod.getDate("perioddate"));
        if (taxFrequencyEnum.equals((Object)TaxFrequencyEnum.MONTH) && startDate != endDate) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e2a\u7a0e\u671f\u95f4\u7684\u671f\u95f4\u8d77\u6b62\u65e5\u671f\u4e0d\u5728\u540c\u4e00\u6708\u4efd\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"TaxTaskEdit_26", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (periodDate != endDate) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e2a\u7a0e\u671f\u95f4\u7684\u6240\u5c5e\u5e74\u6708\u4e0e\u671f\u95f4\u8d77\u6b62\u65e5\u671f\u6240\u5728\u5e74\u6708\u4e0d\u7b26\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"TaxTaskEdit_27", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkDate(BeforeDoOperationEventArgs args) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        Date taxStartDate = dynamicObject.getDate("taxstartdate");
        Date declareStartDate = dynamicObject.getDate("declarestartdate");
        if (null != taxStartDate && null != declareStartDate && taxStartDate.compareTo(declareStartDate) >= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u5f00\u59cb\u65e5\u671f\u987b\u665a\u4e8e\u4e2a\u7a0e\u5f00\u59cb\u65e5\u671f\u3002", (String)"TaxTaskEdit_3", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkCurAndExRateDate(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity.get("exratetable") != null) {
            long exRateTable = dataEntity.getLong("exratetable.id");
            Date exRateDate = dataEntity.getDate("exratedate");
            DynamicObjectCollection foreignCurCollection = dataEntity.getDynamicObjectCollection("foreigncurrency");
            Map<Long, String> curMap = this.getForeignCurMap(foreignCurCollection);
            Set<Long> curSet = curMap.keySet();
            TaxTaskServiceHelper.validateCurrency((long)exRateTable, (Date)exRateDate, curSet);
            String failMsg = this.getFailMsg(curMap);
            if (failMsg.length() != 0) {
                String Message = MessageFormat.format(ResManager.loadKDString((String)"{0}\u5728\u6c47\u7387\u65e5\u671f\u5185\u65e0\u6c47\u7387\u8868", (String)"TaxTaskEdit_18", (String)"sit-itc-formplugin", (Object[])new Object[0]), failMsg);
                this.getView().showTipNotification(Message);
                args.setCancel(true);
            }
        }
    }

    private void checkCurQuoted(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject dataEntity = model.getDataEntity();
        Long taxTaskId = dataEntity.getLong("id");
        DynamicObjectCollection foreignCurCollection = dataEntity.getDynamicObjectCollection("foreigncurrency");
        Map<Long, String> foreignCurMap = this.getForeignCurMap(foreignCurCollection);
        dataEntity.getDynamicObjectCollection("foreigncurrency");
        if (taxTaskId.equals(0L)) {
            return;
        }
        int yearMonth = SitDateUtil.toYearMonth((Date)dataEntity.getDate("taxperiod.perioddate"));
        Map failCurMap = TaxTaskServiceHelper.validateCurQuoted((Long)taxTaskId, foreignCurMap, (int)yearMonth);
        String failMsg = this.getFailMsg(failCurMap);
        PageCache pageCache = new PageCache(this.getView().getPageId());
        if (failMsg.length() != 0) {
            String messageBtnTrue = MessageFormat.format(ResManager.loadKDString((String)"{0}\u5df2\u7ecf\u6709\u4e2a\u7a0e\u8bb0\u5f55\u6e90\u6570\u636e\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664", (String)"TaxTaskEdit_19", (String)"sit-itc-formplugin", (Object[])new Object[0]), failMsg);
            String messageBtnFalse = MessageFormat.format(ResManager.loadKDString((String)"{0}\u5df2\u7ecf\u6709\u4e2a\u7a0e\u8bb0\u5f55\u6e90\u6570\u636e\u5b58\u5728\uff0c\u4e0d\u80fd\u5173\u95ed\"\u4e2a\u7a0e\u6e90\u6570\u636e\u6709\u5916\u5e01\"\u5f00\u5173", (String)"TaxTaskEdit_21", (String)"sit-itc-formplugin", (Object[])new Object[0]), failMsg);
            view.showTipNotification(Boolean.TRUE.equals(model.getValue("isexistforeigncur")) ? messageBtnTrue : messageBtnFalse);
            args.setCancel(true);
            Long exRateTableOld = this.getExRateTablePageCache(pageCache);
            Long[] foreignCurOldArray = this.getForeignCurPageCache(pageCache);
            if (Boolean.TRUE.equals(this.getModel().getValue("isexistforeigncur"))) {
                model.setValue("exratetable", (Object)exRateTableOld);
                model.setValue("foreigncurrency", (Object)foreignCurOldArray);
            }
        }
    }

    private void checkTaxUnit(BeforeDoOperationEventArgs args) {
        List taxUnitDys = this.getModel().getEntryEntity("taxtaskunitentry").stream().map(dy -> dy.getDynamicObject("taxunit")).collect(Collectors.toList());
        if (taxUnitDys.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u7eb3\u7a0e\u5355\u4f4d\u3002", (String)"TaxTaskEdit_4", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkTaxCategory(BeforeDoOperationEventArgs args) {
        List taxCategoryDys = this.getModel().getEntryEntity("taxtaskcatgentry").stream().map(dy -> dy.getDynamicObject("taxcategory")).collect(Collectors.toList());
        if (taxCategoryDys.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u4e2a\u7a0e\u79cd\u7c7b\u3002", (String)"TaxTaskEdit_5", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkSameTaxPeriodTaxUnit(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        List unPassTaxUnitDys = TaxTaskServiceHelper.checkSameTaxPeriodTaxUnit((IDataModel)model);
        this.showCheckTips(args, unPassTaxUnitDys);
    }

    private void showCheckTips(BeforeDoOperationEventArgs args, List<DynamicObject> unPassTaxUnitDys) {
        String tip = null;
        StringBuilder detail = new StringBuilder();
        if (!CollectionUtils.isEmpty(unPassTaxUnitDys)) {
            args.setCancel(true);
            tip = ResManager.loadKDString((String)"\u5b58\u5728\u7eb3\u7a0e\u5355\u4f4d\u5728\u76f8\u540c\u4e2a\u7a0e\u8d77\u6b62\u65e5\u671f\u5185\u8fd8\u6709\u4e2a\u7a0e\u4efb\u52a1\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"TaxTaskEdit_10", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            detail.append(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7eb3\u7a0e\u5355\u4f4d\u5728\u76f8\u540c\u4e2a\u7a0e\u8d77\u6b62\u65e5\u671f\u5185\u8fd8\u6709\u4e2a\u7a0e\u4efb\u52a1\uff1a\r\n", (String)"TaxTaskEdit_11", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            for (DynamicObject unpassTaxUnitDy : unPassTaxUnitDys) {
                detail.append(unpassTaxUnitDy.getString("name")).append("\r\n");
            }
        }
        if (!StringUtils.isEmpty(tip)) {
            this.getView().showConfirm(tip, detail.toString(), MessageBoxOptions.OK, null, null);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("taxtaskcatgentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length != 1) {
            return;
        }
        int rowIndex = evt.getRow();
        DynamicObject taxCategoryRowEntity = this.getModel().getEntryRowEntity("taxtaskcatgentry", rowIndex);
        if (taxCategoryRowEntity == null) {
            return;
        }
        long taxCategoryId = taxCategoryRowEntity.getLong("taxcategory.id");
        long id = this.getModel().getDataEntity().getLong("id");
        this.setEnableForSplitalgo(id, taxCategoryId);
    }

    private void setEnableForSplitalgo(Long taxTaskId, Long taxCategoryId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxrawdata");
        QFilter filter = new QFilter("taxtask.id", "=", (Object)taxTaskId);
        filter.and("feedbackoprecord.result", "=", (Object)YesOrNoEnum.YES.getCode());
        filter.and("taxcategory.id", "=", (Object)taxCategoryId);
        filter.and("status", "not in", Arrays.asList("D", "E"));
        if (helper.isExists(filter)) {
            BasedataEdit splitAlgo = (BasedataEdit)this.getView().getControl("splitalgo");
            DynamicObjectCollection taxItemEntryCollection = this.getModel().getEntryEntity("taxtaskitemdetail");
            for (int i = 0; i < taxItemEntryCollection.size(); ++i) {
                splitAlgo.setEnable("", false, i);
            }
        }
    }

    private void putForeignCurPageCache() {
        if (Boolean.TRUE.equals(this.getModel().getValue("isexistforeigncur"))) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Long exRateTableId = dataEntity.getLong("exratetable.id");
            DynamicObjectCollection foreignCurOldCollection = dataEntity.getDynamicObjectCollection("foreigncurrency");
            Set<Long> foreignCurOldSet = this.getForeignCurMap(foreignCurOldCollection).keySet();
            this.getView().getPageCache().put("foreignCurOld", SerializationUtils.toJsonString(foreignCurOldSet));
            this.getView().getPageCache().put("exRateTableOld", SerializationUtils.toJsonString((Object)exRateTableId));
        }
    }

    private Long[] getForeignCurPageCache(PageCache pageCache) {
        List oldList = JSONArray.parseArray((String)pageCache.get("foreignCurOld"), Long.class);
        if (CollectionUtils.isEmpty((Collection)oldList)) {
            return new Long[0];
        }
        return oldList.toArray(new Long[0]);
    }

    private Long getExRateTablePageCache(PageCache pageCache) {
        String exRateTableOld = pageCache.get("exRateTableOld");
        if (StringUtils.isEmpty((Object)exRateTableOld)) {
            return 0L;
        }
        return (Long)BaseDataConverter.convert((Object)exRateTableOld, Long.class);
    }

    private Map<Long, String> getForeignCurMap(DynamicObjectCollection foreignCurCollection) {
        HashMap<Long, String> curMap = new HashMap<Long, String>(16);
        for (DynamicObject dy : foreignCurCollection) {
            DynamicObject currency = dy.getDynamicObject("fbasedataid");
            Long curId = currency.getLong("id");
            String curName = currency.getString("name");
            curMap.put(curId, curName);
        }
        return curMap;
    }

    private String getFailMsg(Map<Long, String> curMap) {
        StringBuilder failMsg = new StringBuilder();
        if (CollectionUtils.isEmpty(curMap)) {
            return failMsg.toString();
        }
        String split = ResManager.loadKDString((String)"\u3001", (String)"TaxTaskEdit_20", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        for (Map.Entry<Long, String> entry : curMap.entrySet()) {
            failMsg.append(entry.getValue()).append(split);
        }
        int length = failMsg.length();
        failMsg.delete(length - split.length(), length);
        return failMsg.toString();
    }

    private void existForeignCurCtrl() {
        IDataModel model = this.getModel();
        Boolean switchBtn = (Boolean)model.getValue("isexistforeigncur");
        Date taxStartDate = (Date)model.getValue("taxstartdate");
        if (Boolean.TRUE.equals(switchBtn)) {
            this.resetControl("exratetable", Boolean.TRUE, true);
            this.resetControl("exratedate", Boolean.TRUE, true);
            this.setExRateDate(taxStartDate);
            this.resetControl("foreigncurrency", Boolean.TRUE, true);
        } else {
            this.resetControl("exratetable", Boolean.FALSE, false, null);
            this.resetControl("exratedate", Boolean.FALSE, false, null);
            this.resetControl("foreigncurrency", Boolean.FALSE, false, null);
        }
    }

    private void resetControl(String key, Boolean isVisible, boolean isMustInput) {
        this.getView().setVisible(isVisible, new String[]{key});
        ((FieldEdit)this.getControl(key)).setMustInput(isMustInput);
    }

    private void resetControl(String key, Boolean isVisible, boolean isMustInput, Object defaultValue) {
        this.resetControl(key, isVisible, isMustInput);
        this.getModel().beginInit();
        this.getModel().setValue(key, defaultValue);
        this.getModel().endInit();
        this.getView().updateView(key);
    }

    public void pageRelease(EventObject eventObject) {
        String hasLock = (String)this.getView().getFormShowParameter().getCustomParam("hasLock");
        String taskId = this.getView().getPageCache().get("taskid");
        String isOnlyAddTaxCategory = this.getView().getPageCache().get("isOnlyAddTaxCategory");
        if (Strings.isNullOrEmpty((String)hasLock) && !Strings.isNullOrEmpty((String)taskId) && Strings.isNullOrEmpty((String)isOnlyAddTaxCategory)) {
            MutexServiceHelper.release((String)"itc_taxtask", (String)taskId, (String)"calculateguide");
        }
    }
}

