/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taxtask;

import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.TaxTaskStatusEnum;
import kd.sit.sitbp.common.enums.TaxTaskTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import kd.sit.sitbp.formplugin.web.SITAdminOrgPermList;

public class TaxTaskList
extends SITAdminOrgPermList
implements BeforeFilterF7SelectListener {
    private static final Log logger = LogFactory.getLog(TaxTaskList.class);
    private static final String BTN_DONOTHING_CHECKPROGRESS = "donothing_checkprogress";
    private static final String BTN_DONOTHING_OPENTAXTASK = "donothing_opentaxtask";
    private static final String BTN_DONOTHING_FINISH = "donothing_finish";
    private static final String BTN_DONOTHING_WITHDRAWFINISH = "donothing_withdrawfinish";
    private static final String KEY_OPCOLUMN = "listoperationcolumnap";
    private static final String KEY_FILTERCONTAINERAP = "filtercontainerap";
    private static final String KEY_TAXPERIODPRG_NAME = "taxperiodprg.name";
    private static final String KEY_TAXPERIOD_NAME = "taxperiod.name";
    private static final String FINISH_AFTERCONFIRM = "notfirst";
    private Map<Long, Boolean> taxTaskEntryAllDeclaredStatusMap;
    private static final String END = "end";
    private static final String ROLLBACKEND = "rollbackend";

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        List qFilters = event.getQFilters();
        for (QFilter qFilter : qFilters) {
            if (qFilter == null || !qFilter.getProperty().contains("taxunitsearch")) continue;
            String property = qFilter.getProperty();
            String newProperty = property.replace("taxunitsearch", "taxtaskunitentry.taxunit");
            qFilter.__setProperty(newProperty);
            List nests = qFilter.getNests(true);
            if (CollectionUtils.isEmpty((Collection)nests)) continue;
            for (QFilter.QFilterNest nest : nests) {
                if (nest.getFilter() == null || !nest.getFilter().getProperty().contains("taxunitsearch")) continue;
                String nestProperty = nest.getFilter().getProperty();
                String newstNewProperty = nestProperty.replace("taxunitsearch", "taxtaskunitentry.taxunit");
                nest.getFilter().__setProperty(newstNewProperty);
            }
        }
        event.setOrderBy("index asc,taxstartdate desc,declarestartdate desc,createorg.name asc,number asc,taxunitcol.fbasedataid.name asc");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String isFirst = this.getPageCache().get("first");
        if (isFirst == null || !HRStringUtils.equals((String)isFirst, (String)"false")) {
            List columnList = args.getCommonFilterColumns();
            for (FilterColumn filterColumn : columnList) {
                String fieldName = filterColumn.getFieldName();
                if (!HRStringUtils.equals((String)fieldName, (String)"createorg.name")) continue;
                filterColumn.setDefaultValue("");
                this.getPageCache().put("first", "false");
            }
        }
        List list = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : list) {
            if (!filterColumn.getFieldName().equals("createorg.name")) continue;
            filterColumn.setDefaultValue("");
        }
        Set taxUnitIds = Sets.newHashSet();
        if (!SITPermissionServiceHelper.isSuperUser()) {
            taxUnitIds = SITPermissionServiceHelper.getTaxUnitSetByPermItem((Long)RequestContext.get().getCurrUserId(), (String)"17/+CT1QBPNP", (String)"itc_taxtask", (String)"47150e89000000ac");
        }
        if (!CollectionUtils.isEmpty((Collection)taxUnitIds)) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_taxunit");
            ArrayList<ComboItem> taxUnitSearchNameComboItems = new ArrayList<ComboItem>(16);
            ArrayList<ComboItem> taxUnitAdminDivisionComboItems = new ArrayList<ComboItem>(16);
            LinkedHashMap<Long, Object> taxUnitMap = new LinkedHashMap<Long, Object>(16);
            LinkedHashMap<Long, DynamicObject> adminDivisionMap = new LinkedHashMap<Long, DynamicObject>(16);
            Object[] taxUnitDys = helper.query("id,number,name,admindivision,admindivision.name", new QFilter[]{new QFilter("id", "in", (Object)taxUnitIds)}, "number asc");
            if (!ArrayUtils.isEmpty((Object[])taxUnitDys)) {
                for (Object taxUnitDy : taxUnitDys) {
                    long adminDivisionId;
                    long taxUnitID = taxUnitDy.getLong("id");
                    taxUnitMap.put(taxUnitID, taxUnitDy);
                    DynamicObject adminDivision = taxUnitDy.getDynamicObject("admindivision");
                    if (!Objects.nonNull(adminDivision) || adminDivisionMap.containsKey(adminDivisionId = adminDivision.getLong("id"))) continue;
                    adminDivisionMap.put(adminDivisionId, adminDivision);
                }
                for (Map.Entry entry : taxUnitMap.entrySet()) {
                    ComboItem taxUnit = new ComboItem();
                    taxUnit.setCaption(LocaleString.fromMap((Map)((Map)((DynamicObject)entry.getValue()).get("name"))));
                    taxUnit.setValue(((DynamicObject)entry.getValue()).getString("id"));
                    taxUnitSearchNameComboItems.add(taxUnit);
                }
                for (Map.Entry entry : adminDivisionMap.entrySet()) {
                    ComboItem adminDivision = new ComboItem();
                    adminDivision.setCaption(LocaleString.fromMap((Map)((Map)((DynamicObject)entry.getValue()).get("name"))));
                    adminDivision.setValue(((DynamicObject)entry.getValue()).getString("id"));
                    taxUnitAdminDivisionComboItems.add(adminDivision);
                }
                this.setTaxUnitSearchNameValue(args, taxUnitSearchNameComboItems);
                this.setAdminDivisionValue(args, taxUnitAdminDivisionComboItems);
            }
        }
    }

    private void setAdminDivisionValue(FilterContainerInitArgs args, List<ComboItem> taxUnitAdminDivisionComboItems) {
        FilterColumn adminDivisionNameFilterColumn = args.getFilterColumn("taxunitsearch.admindivision.name");
        CommonFilterColumn adminDivisionNameCommonFilterColumn = (CommonFilterColumn)adminDivisionNameFilterColumn;
        adminDivisionNameCommonFilterColumn.setComboItems(taxUnitAdminDivisionComboItems);
    }

    private void setTaxUnitSearchNameValue(FilterContainerInitArgs args, List<ComboItem> taxUnitSearchNameComboItems) {
        FilterColumn taxUnitSearchNameFilterColumn = args.getFilterColumn("taxunitsearch.name");
        CommonFilterColumn taxUnitSearchNameCommonFilterColumn = (CommonFilterColumn)taxUnitSearchNameFilterColumn;
        taxUnitSearchNameCommonFilterColumn.setComboItems(taxUnitSearchNameComboItems);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        Set taxUnitIds;
        if ("hbss_taxunit".equals(args.getRefEntityId()) && !SITPermissionServiceHelper.isSuperUser() && Objects.nonNull(taxUnitIds = SITPermissionServiceHelper.getTaxUnitSetByPermItem((Long)RequestContext.get().getCurrUserId(), (String)"17/+CT1QBPNP", (String)"itc_taxtask", (String)"47150e89000000ac"))) {
            QFilter qFilter = new QFilter("id", "in", (Object)taxUnitIds);
            List qfilters = args.getQfilters();
            qfilters.add(qFilter);
            args.setQfilters(qfilters);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection collection = super.getData(arg0, arg1);
                List pkIds = collection.stream().map(dy -> String.valueOf(dy.getPkValue())).collect(Collectors.toList());
                if (!pkIds.isEmpty()) {
                    TaxTaskList.this.getTaxTaskEntryAllDeclaredStatusMap(pkIds);
                }
                return collection;
            }
        });
    }

    private void getTaxTaskEntryAllDeclaredStatusMap(List<String> pkIds) {
        DynamicObject[] dys;
        this.taxTaskEntryAllDeclaredStatusMap = new HashMap<Long, Boolean>(16);
        List ids = pkIds.stream().map(Long::parseLong).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", ids);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxtask");
        for (DynamicObject dy : dys = helper.query("id,taxtaskunitentry,taxtaskunitentry.declarestatus,taxtaskunitentry.taxfilenum", new QFilter[]{filter})) {
            Boolean isAllDeclared = Boolean.TRUE;
            DynamicObjectCollection entryDys = dy.getDynamicObjectCollection("taxtaskunitentry");
            for (DynamicObject entryDy : entryDys) {
                String declareStatus = entryDy.getString("declarestatus");
                int taxFileNum = entryDy.getInt("taxfilenum");
                if (taxFileNum == 0 || YesOrNoEnum.isYes((String)declareStatus)) continue;
                isAllDeclared = Boolean.FALSE;
                break;
            }
            this.taxTaskEntryAllDeclaredStatusMap.put(dy.getLong("id"), isAllDeclared);
        }
    }

    public void packageData(PackageDataEvent event) {
        block6: {
            AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
            String fieldKey = columnDesc.getFieldKey();
            if (!KEY_OPCOLUMN.equals(fieldKey)) break block6;
            DynamicObject taxTaskDy = event.getRowData();
            String taxTaskEndStatus = taxTaskDy.getString("endstatus");
            if (YesOrNoEnum.isYes((String)taxTaskEndStatus)) {
                ArrayList list = (ArrayList)event.getFormatValue();
                for (OperationColItem item : list) {
                    if (BTN_DONOTHING_FINISH.equals(item.getOperationKey())) {
                        item.setVisible(false);
                    }
                    if (!BTN_DONOTHING_WITHDRAWFINISH.equals(item.getOperationKey())) continue;
                    item.setVisible(true);
                }
            } else {
                long id = taxTaskDy.getLong("id");
                Boolean isAllDeclared = this.taxTaskEntryAllDeclaredStatusMap.get(id);
                ArrayList list = (ArrayList)event.getFormatValue();
                for (OperationColItem item : list) {
                    if (BTN_DONOTHING_FINISH.equals(item.getOperationKey())) {
                        item.setVisible(true);
                        item.setLocked(isAllDeclared == false);
                    }
                    if (!BTN_DONOTHING_WITHDRAWFINISH.equals(item.getOperationKey())) continue;
                    item.setVisible(false);
                }
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Long pkId = (Long)((BillList)args.getHyperLinkClickEvent().getSource()).getFocusRowPkId();
        if (pkId != 0L && !TaxTaskServiceHelper.taskIsExist((long)pkId)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e2a\u7a0e\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"TaxTaskList_16", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxtask");
        DynamicObject dynamicObject = serviceHelper.queryOne("id,taxperiod.perioddate,taxtasktype,taskstatus", (Object)pkId);
        if (TaxTaskStatusEnum.INIT_FINISH.isGreaterThan(dynamicObject.getString("taskstatus"))) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e2a\u7a0e\u4efb\u52a1\u6b63\u5728\u521d\u59cb\u5316\uff0c\u8bf7\u7a0d\u540e\u518d\u6253\u5f00\u3002", (String)"TaxTaskList_18", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        Date date = dynamicObject.getDate("taxperiod.perioddate");
        LocalDate periodDate = LocalDateTime.ofInstant(date.toInstant(), KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate();
        String yyyyMM = periodDate.format(DateTimeFormatter.ofPattern("yyyyMM"));
        FormShowParameter formShowParameter = new FormShowParameter();
        String taxTaskType = dynamicObject.getString("taxtasktype");
        if (TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(taxTaskType)) {
            formShowParameter.setFormId("itc_taxtaskguide_localcal");
        } else {
            formShowParameter.setFormId("itc_taxtaskguide");
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("taxTaskId", (Object)pkId);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1 - {0}", (String)"TaxTaskList_9", (String)"sit-itc-formplugin", (Object[])new Object[]{yyyyMM}));
        IFormView parentView = this.getView().getParentView();
        String pageId = null;
        if (null != parentView) {
            String parentViewPageId = parentView.getPageId();
            pageId = parentViewPageId + pkId;
        } else {
            pageId = RequestContext.getOrCreate().getGlobalSessionId() + pkId;
        }
        formShowParameter.setPageId(pageId);
        this.getView().showForm(formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        long id;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        Object focusRowPkId = this.getFocusRowPkId();
        long l = id = focusRowPkId == null ? 0L : (Long)BaseDataConverter.convert((Object)focusRowPkId, Long.class);
        if (id != 0L && !TaxTaskServiceHelper.taskIsExist((long)id)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e2a\u7a0e\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"TaxTaskList_16", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (opKey) {
            case "donothing_checkprogress": {
                this.openProgressView(this.getView(), this.getFocusRowPkId());
                break;
            }
            case "donothing_opentaxtask": {
                this.openTaxTask(this.getFocusRowPkId(), args);
                break;
            }
            case "modify": {
                this.validateBeforeModify(this.getSelectedRows(), args);
                break;
            }
            case "donothing_finish": {
                RefObject finishAfterConfirm = new RefObject();
                if (formOperate.getOption().tryGetVariableValue(FINISH_AFTERCONFIRM, finishAfterConfirm)) break;
                TaxTaskServiceHelper.openCountDownF7((IFormPlugin)this, (IFormView)this.getView());
                args.setCancel(true);
                break;
            }
            case "donothing_withdrawfinish": {
                args.setCancel(true);
                TaxTaskServiceHelper.rollbackEndTip((IFormView)this.getView(), (IFormPlugin)this);
                break;
            }
            case "delete": {
                formOperate.getOption().setVariableValue("ignorerefentityids", "itc_taxtaskunitentry,itc_taxtasksnapshot,itc_taxtaskrecord,itc_taxcalreport,itc_taxdata,itc_taxdatabasic,itc_taxrawdata,itc_taxrawdatabasic,itc_taxpreparedata,itc_accdetail,itc_taxdeduct");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Long taxTaskId = (Long)ObjectConverter.convert((Object)this.getFocusRowPkId(), Long.class, (boolean)true);
        BaseResult taxTaskEntityRes = TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskId);
        TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
        TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView().getParentView(), (TaxTaskEntity)taxTaskEntity);
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "sitbp_countdown": {
                BatchResult result;
                if (!(returnData instanceof Boolean) || null != (result = TaxTaskGuideServiceHelper.validateEnd((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (IFormView)this.getView(), (IFormPlugin)this)) || !(result = TaxTaskGuideServiceHelper.endData((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo)).isSuccess() || !CollectionUtils.isEmpty((Collection)result.getFailResult())) break;
                String msg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u5df2\u7ed3\u675f\u3002", (String)"TaxTaskList_10", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                String opName = TaxTaskGuideOpEnum.END.loadKDString();
                SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opName, (String)msg);
                this.getView().showSuccessNotification(msg);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "itc_taxdata": 
            case "itc_taxrawdata": {
                if (!(returnData instanceof Boolean) || ((Boolean)returnData).booleanValue()) break;
                TaxTaskServiceHelper.viewMore((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (String)actionId, (IFormView)this.getView());
                break;
            }
        }
    }

    private void validateBeforeModify(ListSelectedRowCollection selectedRows, BeforeDoOperationEventArgs args) {
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u4e2a\u7a0e\u4efb\u52a1\u3002", (String)"TaxTaskList_8", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxtask");
        QFilter qFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
        DynamicObject taxTaskDy = helper.queryOne("id,endstatus,isexisttaxrecord,taxpersoncount", new QFilter[]{qFilter});
        String isFinished = taxTaskDy.getString("endstatus");
        if (YesOrNoEnum.YES.getCode().equals(isFinished)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u5df2\u7ecf\u7ed3\u675f\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"TaxTaskList_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        String pkId = String.valueOf(selectedRows.getPrimaryKeyValues()[0]);
        this.openWithMutexLockCheck(pkId, args, "edit");
    }

    private void openWithMutexLockCheck(String pkId, BeforeDoOperationEventArgs args, String statusIfNotLock) {
        BaseResult lockRes = MutexServiceHelper.require((String)"itc_taxtask", (String)pkId, (String)"calculateguide");
        if (!lockRes.isSuccess()) {
            args.setCancel(true);
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setFormId("itc_taxtask");
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShowParameter.setPkId((Object)pkId);
            baseShowParameter.setCustomParam("hasLock", (Object)"1");
            baseShowParameter.setCustomParam("hasLockMessage", (Object)lockRes.getMessage());
            baseShowParameter.setStatus(OperationStatus.VIEW);
            baseShowParameter.setBillStatus(BillOperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)baseShowParameter);
        } else {
            args.setCancel(true);
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setFormId("itc_taxtask");
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShowParameter.setPkId((Object)pkId);
            if ("edit".equals(statusIfNotLock)) {
                baseShowParameter.setStatus(OperationStatus.EDIT);
                baseShowParameter.setBillStatus(BillOperationStatus.EDIT);
            } else {
                baseShowParameter.setStatus(OperationStatus.VIEW);
                baseShowParameter.setBillStatus(BillOperationStatus.VIEW);
            }
            this.getView().showForm((FormShowParameter)baseShowParameter);
        }
    }

    private void openTaxTask(Object focusRowPkId, BeforeDoOperationEventArgs args) {
        String pkId = String.valueOf(focusRowPkId);
        this.openWithMutexLockCheck(pkId, args, "view");
    }

    private void openProgressView(IFormView view, Object taxTaskPkId) {
        TaxTaskServiceHelper.openProgressView((IFormView)view, (Object)taxTaskPkId);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        Long taxTaskId = (Long)ObjectConverter.convert((Object)this.getFocusRowPkId(), Long.class, (boolean)true);
        GlobalParam.remove();
        BaseResult taxTaskEntityRes = TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskId);
        TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
        TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView().getParentView(), (TaxTaskEntity)taxTaskEntity);
        MessageBoxResult confirmResult = event.getResult();
        switch (event.getCallBackId()) {
            case "end": {
                BatchResult result;
                if (MessageBoxResult.Yes == confirmResult && (result = TaxTaskGuideServiceHelper.rollbackEndData((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo)).isSuccess()) {
                    String opName = TaxTaskGuideOpEnum.ROLLBACK_END.loadKDString();
                    String msg = ResManager.loadKDString((String)"\u64a4\u9500\u7ed3\u675f\u4e2a\u7a0e\u8bb0\u5f55\u6210\u529f\u3002", (String)"TaxTaskList_11", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                    SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opName, (String)msg);
                    this.getView().showSuccessNotification(msg);
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "rollbackend": {
                if (MessageBoxResult.Yes != confirmResult) break;
                String opName = TaxTaskGuideOpEnum.ROLLBACK_END.loadKDString();
                if (taxTaskEntity.isEndStatus()) {
                    try {
                        TaxTaskGuideServiceHelper.operateTaxTask((TaxTaskEntity)taxTaskEntity, (String)YesOrNoEnum.NO.getCode());
                        String message = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u64a4\u9500\u7ed3\u675f\u6210\u529f\u3002\u662f\u5426\u5bf9\u4e2a\u7a0e\u4efb\u52a1\u4e2d\u7684\u6240\u6709\u4e2a\u7a0e\u8bb0\u5f55\uff0c\u7ed3\u675f\u72b6\u6001\u6807\u8bb0\u4e3a\u672a\u7ed3\u675f\uff1f", (String)"TaxTaskList_12", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                        String msg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u64a4\u9500\u7ed3\u675f\u6210\u529f\u3002", (String)"TaxTaskList_17", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opName, (String)msg);
                        this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(TaxTaskGuideOpEnum.END.getCode(), (IFormPlugin)this));
                    }
                    catch (Exception exception) {
                        String msg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u64a4\u9500\u7ed3\u675f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"TaxTaskList_13", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opName, (String)msg);
                        this.getView().showErrorNotification(msg);
                        logger.warn("update taxEndStatus  fail");
                    }
                    break;
                }
                String msg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u672a\u7ed3\u675f\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u7ed3\u675f\u3002", (String)"TaxTaskList_14", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opName, (String)msg);
                this.getView().showErrorNotification(msg);
                break;
            }
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        FilterContainer filterContainerAp = (FilterContainer)this.getControl(KEY_FILTERCONTAINERAP);
        filterContainerAp.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        String fieldName = event.getFieldName();
        if (KEY_TAXPERIODPRG_NAME.equals(fieldName) || KEY_TAXPERIOD_NAME.equals(fieldName)) {
            new PageCache(this.getView().getPageId()).put("changeF7caption", "changeF7caption");
        }
    }
}

