/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.mservice.update;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.UpgradeResult;
import kd.sit.itc.common.update.BankcardDO;
import kd.sit.itc.common.update.SubCardUpdateServiceHelper;
import kd.sit.itc.mservice.update.UpgradeDataFilter1128Service;
import kd.sit.sitbp.common.constants.SITConstants;
import kd.sit.sitbp.common.util.SITDbUtil;
import org.apache.commons.lang3.StringUtils;

public class BankcardUpdateService
extends UpgradeDataFilter1128Service {
    private static final Log LOGGER = LogFactory.getLog(BankcardUpdateService.class);
    private String allColumns = "t1.fid,t1.fnumber,t1.fcreatorid,t1.fcreatetime,t1.fmodifierid,t1.fmodifytime,t1.fenable,t1.findex,t1.fstatus,t1.fdisablerid,t1.fbankcardstatus,t1.fdisabledate,t1.fissyspreset,t1.fmasterid,t1.fbsed,t1.fbsled,t1.fname,t1.fsimplename,t1.fdescription,t1.fbebankid,t1.fprovinceid,t1.ftaxfileid,t1.fboid,t1.fiscurrentversion,t1.fdatastatus,t1.fsourcevid,t1.fhisversion,t1.fchangedescription,t1.fperbankcardid,t1.fperbankcardboid,t1.fismodify";
    private String columns = "fnumber,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fenable,findex,fdisablerid,fdisabledate,fissyspreset,fbsed,fbsled,fname,fsimplename,fdescription,fbebankid,fprovinceid,fbankcardstatus,ftaxfileid,fperbankcardid,fperbankcardboid";

    @Override
    public UpgradeResult doAfterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        this.updataBankcardInfo();
        return result;
    }

    private void updataBankcardInfo() {
        block19: {
            this.upDateBankCardField();
            StringBuilder selectSql = new StringBuilder();
            selectSql.append(" select distinct ").append(this.allColumns);
            selectSql.append(" from t_itc_bankcard t1 where t1.fboid is null or t1.fboid = 0 ");
            try (DataSet dataSet = this.queryData(SITConstants.SIT_ROUTE, selectSql.toString(), null);){
                if (dataSet == null) break block19;
                ArrayList updateParams = new ArrayList(100);
                ArrayList insertparams = new ArrayList(100);
                SubCardUpdateServiceHelper.geneInsertParams((DataSet)dataSet, updateParams, insertparams, (String)"t_itc_bankcard", (String)this.columns);
                try (TXHandle tx = TX.requiresNew();){
                    if (!CollectionUtils.isEmpty(updateParams)) {
                        LOGGER.info("BankcardUpdateService update t_itc_bankcard old not histime size {}", (Object)updateParams.size());
                        StringBuilder updateSql = new StringBuilder();
                        updateSql.append("UPDATE t_itc_bankcard ");
                        updateSql.append(" SET fboid = ? ,fiscurrentversion = ?, fdatastatus = ?,fsourcevid = ?,fhisversion = ?,fismodify = ?,fchangedescription = ?,fstatus = ? ");
                        updateSql.append(" WHERE fid = ? ");
                        SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)updateSql.toString(), updateParams);
                    }
                    if (!CollectionUtils.isEmpty(insertparams)) {
                        LOGGER.info("BankcardUpdateService insert t_itc_bankcard new not histime  size {}", (Object)insertparams.size());
                        StringBuilder insertSql = new StringBuilder();
                        insertSql.append(" insert into t_itc_bankcard ");
                        insertSql.append(" ( ").append(this.columns);
                        insertSql.append("  ,fid,fstatus,fmasterid,fboid,fiscurrentversion,fdatastatus,fsourcevid,fchangedescription,fhisversion,fismodify ) ");
                        insertSql.append(" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
                        SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)insertSql.toString(), insertparams);
                    }
                }
            }
        }
    }

    private void upDateBankCardField() {
        block37: {
            try (TXHandle tx = TX.requiresNew();){
                BankcardDO bean;
                StringBuilder selectSql = new StringBuilder();
                selectSql.append("  select distinct t2.fpersonid,t3.fname,t1.fid,t1.fnumber,t1.fbebankid ");
                selectSql.append("     from t_itc_bankcard t1,t_itc_taxfile t2,t_itc_bankcard_l t3");
                selectSql.append("  where t1.ftaxfileid = t2.fid and t1.fid = t3.fid and t3.flocaleid = 'zh_CN'   ");
                selectSql.append("     and (t1.fperbankcardboid is null or t1.fperbankcardboid = 0 ) and (t1.fperbankcardid is null or t1.fperbankcardid = 0) ");
                selectSql.append("     and t1.fbebankid is not null and t1.fbebankid <> 0 ");
                ArrayList<BankcardDO> itcList = null;
                try (DataSet itcDataSet = SITDbUtil.queryDataSet((String)"ItcBankcard", (DBRoute)SITConstants.SIT_ROUTE, (String)selectSql.toString(), null);){
                    while (itcDataSet.hasNext()) {
                        Row row = itcDataSet.next();
                        long fpersonid = row.getLong("fpersonid");
                        String fnumber = row.getString("fnumber");
                        long fbebankid = row.getLong("fbebankid");
                        if (fpersonid == 0L || fbebankid == 0L || !StringUtils.isNotBlank((CharSequence)fnumber)) continue;
                        bean = new BankcardDO();
                        bean.setFid(row.getLong("fid"));
                        bean.setFname(row.getString("fname"));
                        bean.setFpersonid(Long.valueOf(fpersonid));
                        bean.setFnumber(fnumber.trim());
                        bean.setFbebankid(Long.valueOf(fbebankid));
                        if (itcList == null) {
                            itcList = new ArrayList<BankcardDO>(32);
                        }
                        itcList.add(bean);
                    }
                }
                if (itcList == null) break block37;
                ArrayList fnumbers = new ArrayList(itcList.size());
                ArrayList fpersonids = new ArrayList(itcList.size());
                ArrayList fbebankid = new ArrayList(itcList.size());
                itcList.stream().forEach(obj -> {
                    fnumbers.add(obj.getFnumber());
                    fpersonids.add(obj.getFpersonid());
                    fbebankid.add(obj.getFbebankid());
                });
                StringBuilder hrpiSql = new StringBuilder();
                hrpiSql.append(" select distinct fboid,fid,fsourcevid,fpersonid,fbankdepositid,fbankcardnum ");
                hrpiSql.append("   from t_hrpi_perbankcard ");
                hrpiSql.append(" where fpersonid in( ");
                hrpiSql.append(Joiner.on((String)",").join(fpersonids)).append(')');
                hrpiSql.append("   and fbankdepositid in( ");
                hrpiSql.append(Joiner.on((String)",").join(fbebankid)).append(')');
                hrpiSql.append("   and fbankcardnum in( '");
                hrpiSql.append(Joiner.on((String)"','").join(fnumbers)).append("')");
                hrpiSql.append("   and fiscurrentversion = '1' ");
                ArrayList<BankcardDO> hrpiList = null;
                try (DataSet hrpiDataSet = SITDbUtil.queryDataSet((String)"ItcBankcard", (DBRoute)new DBRoute("hr"), (String)hrpiSql.toString(), null);){
                    while (hrpiDataSet.hasNext()) {
                        Row row = hrpiDataSet.next();
                        bean = new BankcardDO();
                        bean.setFid(row.getLong("fid"));
                        bean.setFsourcevid(row.getLong("fsourcevid"));
                        bean.setFpersonid(row.getLong("fpersonid"));
                        bean.setFbankdepositid(row.getLong("fbankdepositid"));
                        bean.setFbankcardnum(row.getString("fbankcardnum"));
                        if (hrpiList == null) {
                            hrpiList = new ArrayList<BankcardDO>(32);
                        }
                        hrpiList.add(bean);
                    }
                }
                if (hrpiList != null) {
                    ArrayList<Object[]> updateParams = new ArrayList<Object[]>(hrpiList.size());
                    this.getUpdataParams(itcList, (List<BankcardDO>)hrpiList, updateParams);
                    if (!CollectionUtils.isEmpty(updateParams)) {
                        StringBuilder updateSql = new StringBuilder();
                        updateSql.append("UPDATE t_itc_bankcard ");
                        updateSql.append(" SET fperbankcardid = ? ,fperbankcardboid = ? ");
                        updateSql.append(" WHERE fid = ? ");
                        SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)updateSql.toString(), updateParams);
                    }
                } else {
                    this.geneHrpiDataAndUpdateBank(itcList);
                }
            }
        }
    }

    private void getUpdataParams(List<BankcardDO> itcList, List<BankcardDO> hrpiList, List<Object[]> updateParams) {
        ArrayList<BankcardDO> needGeneList = null;
        for (BankcardDO upObj : itcList) {
            long ufpersonid = upObj.getFpersonid();
            long fbebankid = upObj.getFbebankid();
            String fnumber = upObj.getFnumber();
            Boolean idMatch = Boolean.FALSE;
            for (BankcardDO hrpiObj : hrpiList) {
                long fpersonid = hrpiObj.getFpersonid();
                long fbankdepositid = hrpiObj.getFbankdepositid();
                String fbankcardnum = hrpiObj.getFbankcardnum();
                if (fpersonid != ufpersonid || fbankdepositid != fbebankid || !StringUtils.isNotBlank((CharSequence)fnumber) || !StringUtils.isNotBlank((CharSequence)fbankcardnum) || !fnumber.equals(fbankcardnum)) continue;
                Object[] param = new Object[]{hrpiObj.getFid(), hrpiObj.getFsourcevid(), upObj.getFid()};
                updateParams.add(param);
                idMatch = Boolean.TRUE;
            }
            if (idMatch.booleanValue()) continue;
            if (needGeneList == null) {
                needGeneList = new ArrayList<BankcardDO>(8);
            }
            needGeneList.add(upObj);
        }
        if (needGeneList != null) {
            this.geneHrpiDataAndUpdateBank(needGeneList);
        }
    }

    private void geneHrpiDataAndUpdateBank(List<BankcardDO> selList) {
        HashMap groupMap = Maps.newHashMapWithExpectedSize((int)selList.size());
        ArrayList personids = new ArrayList(selList.size());
        selList.stream().forEach(obj -> {
            StringBuilder sb = new StringBuilder();
            sb.append(obj.getFpersonid()).append('$').append(obj.getFbebankid()).append('$').append(obj.getFnumber());
            String key = sb.toString();
            if (groupMap.get(key) != null) {
                List list = (List)groupMap.get(key);
                list.add(obj);
            } else {
                ArrayList<BankcardDO> list = new ArrayList<BankcardDO>(8);
                list.add((BankcardDO)obj);
                groupMap.put(key, list);
            }
            personids.add(obj.getFpersonid());
        });
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct fid,fpersonid ");
        sql.append("   from t_hrpi_employee ");
        sql.append(" where fpersonid in( ");
        sql.append(Joiner.on((String)",").join(personids)).append(')');
        HashMap perMap = Maps.newHashMapWithExpectedSize((int)8);
        try (DataSet empDataSet = SITDbUtil.queryDataSet((String)"ItcBankcard", (DBRoute)new DBRoute("hr"), (String)sql.toString(), null);){
            while (empDataSet.hasNext()) {
                Row row = empDataSet.next();
                perMap.put(row.getLong("fpersonid"), row.getLong("fid"));
            }
        }
        if (perMap.isEmpty()) {
            return;
        }
        long userid = RequestContext.get().getCurrUserId();
        Date timeDate = new Date();
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(selList.size());
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(groupMap.size() * 2);
        long[] ids = DB.genLongIds((String)"t_hrpi_perbankcard", (int)(groupMap.size() * 2));
        int index = 0;
        for (Map.Entry entry : groupMap.entrySet()) {
            String[] keys = ((String)entry.getKey()).split("[$]");
            List upList = (List)entry.getValue();
            Long fpersonid = Long.parseLong(keys[0]);
            Long femployeeid = (Long)perMap.get(fpersonid);
            LOGGER.info("femployeeid is {}", (Object)femployeeid);
            if (Objects.isNull(femployeeid) || femployeeid == 0L) continue;
            Long fbebankid = Long.parseLong(keys[1]);
            String fnumber = keys[2];
            String fname = StringUtils.isBlank((CharSequence)((BankcardDO)upList.get(0)).getFname()) ? " " : ((BankcardDO)upList.get(0)).getFname();
            Object[] insertParam = new Object[]{femployeeid, "1128-" + ids[index], ids[index], "1", "1", ids[index + 1], " ", ids[index], ids[index], " ", userid, timeDate, userid, timeDate, fpersonid, fbebankid, fnumber, fname, " ", "1", "C", 0, 0, "0", 1010, "0", " ", "0"};
            Object[] insertParam1 = new Object[]{femployeeid, "1128-" + ids[index], ids[index], "0", "1", 0, "V0001", ids[index + 1], ids[index + 1], " ", userid, timeDate, userid, timeDate, fpersonid, fbebankid, fnumber, fname, " ", "1", "C", 0, 0, "0", 1010, "0", " ", "0"};
            for (BankcardDO obj2 : upList) {
                Object[] upParam = new Object[]{ids[index], ids[index + 1], obj2.getFid()};
                updateParams.add(upParam);
            }
            insertParams.add(insertParam);
            insertParams.add(insertParam1);
            index += 2;
        }
        try (TXHandle txhrpi = null;){
            txhrpi = TX.requiresNew();
            if (!CollectionUtils.isEmpty(insertParams)) {
                StringBuilder insertSql = new StringBuilder();
                insertSql.append(" insert into t_hrpi_perbankcard ");
                insertSql.append(" ( femployeeid, fnumber,fboid, fiscurrentversion, fdatastatus, fsourcevid,  fhisversion,");
                insertSql.append("   fid, fmasterid, fname, fcreatorid, fcreatetime, fmodifierid, fmodifytime, fpersonid, fbankdepositid, fbankcardnum, fusername, ");
                insertSql.append("   fdescription, fenable, fstatus, fdisablerid, findex, fissyspreset, faccountrelationid, fisdelete, fchangedescription,fismodify )");
                insertSql.append(" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
                SITDbUtil.executeBatch((DBRoute)new DBRoute("hr"), (String)insertSql.toString(), insertParams);
                LOGGER.info("BankcardUpdateService insert into t_hrpi_perbankcard size {}", (Object)insertParams.size());
            }
        }
        try (TXHandle txitc = null;){
            txitc = TX.requiresNew();
            if (!CollectionUtils.isEmpty(updateParams)) {
                StringBuilder updateSql = new StringBuilder();
                updateSql.append("UPDATE t_itc_bankcard ");
                updateSql.append(" SET fperbankcardid = ? ,fperbankcardboid = ? ");
                updateSql.append(" WHERE fid = ? ");
                SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)updateSql.toString(), updateParams);
                LOGGER.info("BankcardUpdateService update t_itc_bankcard fperbankcardboid,fperbankcardid size {}", (Object)updateParams.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet queryData(DBRoute dbRoute, String querySql, Object[] params) {
        try (DataSet copySet = null;){
            DataSet dataSet = SITDbUtil.queryDataSet((String)"ItcBankcard", (DBRoute)dbRoute, (String)querySql, (Object[])params);
            copySet = dataSet.copy();
            int count = copySet.count("fid", true);
            LOGGER.info("BankcardUpdateService select data {}", (Object)count);
            if (count > 0) {
                DataSet dataSet2 = dataSet;
                return dataSet2;
            }
            DataSet dataSet3 = null;
            return dataSet3;
        }
    }
}

