/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.mservice.update;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.UpgradeResult;
import kd.sit.itc.common.update.SubCardUpdateServiceHelper;
import kd.sit.itc.mservice.update.UpgradeDataFilter1128Service;
import kd.sit.sitbp.common.constants.SITConstants;
import kd.sit.sitbp.common.util.SITDbUtil;

public class ContactUpdateService
extends UpgradeDataFilter1128Service {
    private static final Log LOGGER = LogFactory.getLog(ContactUpdateService.class);
    private String allColumns = "t1.fid,t1.fnumber,t1.fname,t1.fstatus,t1.fcreatorid,t1.fmodifierid,t1.fenable,t1.fcreatetime,t1.fmodifytime,t1.fmasterid,t1.fsimplename,t1.fdescription,t1.findex,t1.fissyspreset,t1.fdisablerid,t1.fdisabledate,t1.fboid,t1.fiscurrentversion,t1.fdatastatus,t1.fsourcevid,t1.fchangedescription,t1.fhisversion,t1.fismodify,t1.ftaxpayernum,t1.fphone,t1.femail,t1.fregpermresid,t1.fregpermrescityid,t1.fregpermrescountyid,t1.fregpermresinfo,t1.fhabitresid,t1.fhabitrescityid,t1.fhabitrescountyid,t1.fhabitresinfo,t1.ftaxfileid";
    private String columns = "fnumber,fname,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fsimplename,fregpermrescityid,fdescription,findex,fissyspreset,fdisablerid,fdisabledate,ftaxpayernum,fphone,femail,fregpermresid,fregpermrescountyid,fregpermresinfo,fhabitresid,fhabitrescityid,fhabitrescountyid,fhabitresinfo,ftaxfileid";

    @Override
    public UpgradeResult doAfterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        this.updateTaxContactInfo();
        return result;
    }

    private void updateTaxContactInfo() {
        long startTime = System.currentTimeMillis();
        try (TXHandle txCopy = TX.requiresNew();){
            String copySQL = this.copyTaxPersonToContract();
            DB.execute((DBRoute)SITConstants.SIT_ROUTE, (String)copySQL);
        }
        LOGGER.info("ContactUpdateService execute copyTaxPersonToContract use time {}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        TXHandle tx = null;
        DataSet dataSet = null;
        try {
            tx = TX.requiresNew();
            dataSet = this.queryTaxContactInfo();
            if (dataSet != null) {
                ArrayList updateParams = new ArrayList(100);
                ArrayList insertparams = new ArrayList(100);
                SubCardUpdateServiceHelper.geneInsertParams((DataSet)dataSet, updateParams, insertparams, (String)"t_itc_taxcontact", (String)this.columns);
                if (!CollectionUtils.isEmpty(updateParams)) {
                    StringBuilder updateSql = new StringBuilder();
                    updateSql.append("UPDATE t_itc_taxcontact ");
                    updateSql.append(" SET fboid = ? ,fiscurrentversion = ?, fdatastatus = ?,fsourcevid = ?,fhisversion = ?,fismodify = ?,fchangedescription = ?,fstatus = ? ");
                    updateSql.append(" WHERE fid = ? ");
                    SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)updateSql.toString(), updateParams);
                    LOGGER.info("ContactUpdateService update data size {}", (Object)updateParams.size());
                }
                if (!CollectionUtils.isEmpty(insertparams)) {
                    StringBuilder insertSql = new StringBuilder();
                    insertSql.append(" insert into t_itc_taxcontact ");
                    insertSql.append(" ( ").append(this.columns);
                    insertSql.append("  ,fid,fstatus,fmasterid,fboid,fiscurrentversion,fdatastatus,fsourcevid,fchangedescription,fhisversion,fismodify ) ");
                    insertSql.append(" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
                    SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)insertSql.toString(), insertparams);
                    LOGGER.info("ContactUpdateService insert data size {}", (Object)insertparams.size());
                }
                LOGGER.info("ContactUpdateService execute updateTaxContact use time {}", (Object)(System.currentTimeMillis() - startTime));
            }
        }
        catch (Exception ex) {
            if (tx != null) {
                tx.markRollback();
            }
            throw ex;
        }
        finally {
            if (tx != null) {
                tx.close();
            }
            if (dataSet != null) {
                dataSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet queryTaxContactInfo() {
        StringBuilder querySql = new StringBuilder();
        querySql.append(" select distinct ").append(this.allColumns);
        querySql.append(" from t_itc_taxcontact t1,t_itc_taxperson t2");
        querySql.append(" where  t1.fid = t2.fid and t1.fboid is null or t1.fboid = 0 ");
        DataSet dataSet = SITDbUtil.queryDataSet((String)"ItcTaxContact", (DBRoute)SITConstants.SIT_ROUTE, (String)querySql.toString(), null);
        try (DataSet copySet = null;){
            copySet = dataSet.copy();
            if (copySet.count("fid", true) > 0) {
                DataSet dataSet2 = dataSet;
                return dataSet2;
            }
            DataSet dataSet3 = null;
            return dataSet3;
        }
    }

    private String copyTaxPersonToContract() {
        StringBuilder sb = new StringBuilder();
        sb.append(" INSERT into t_itc_taxcontact (fid,fnumber,fname,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,ftaxfileid, ");
        sb.append("        fsimplename,fdescription,findex,fissyspreset,fdisablerid,fdisabledate,ftaxpayernum,fphone,fhabitresinfo,");
        sb.append("        femail,fregpermresid,fregpermrescityid,fregpermrescountyid,fregpermresinfo,fhabitresid,fhabitrescityid,fhabitrescountyid) ");
        sb.append(" select fid,fnumber,fname,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,ftaxfileid, ");
        sb.append("        fsimplename,fdescription,findex,fissyspreset,fdisablerid,fdisabledate,ftaxpayernum,fphone,fhabitresinfo, ");
        sb.append("        femail,fregpermresid,fregpermrescityid,fregpermrescountyid,fregpermresinfo,fhabitresid,fhabitrescityid,fhabitrescountyid ");
        sb.append(" from t_itc_taxperson  ");
        sb.append(" where fid not in (select fid from t_itc_taxcontact) ");
        return sb.toString();
    }
}

