/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.mservice.update;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.UpgradeResult;
import kd.sit.itc.common.update.SubCardUpdateServiceHelper;
import kd.sit.itc.mservice.update.UpgradeDataFilter1128Service;
import kd.sit.sitbp.common.constants.SITConstants;
import kd.sit.sitbp.common.util.SITDbUtil;

public class InvestorUpdateService
extends UpgradeDataFilter1128Service {
    private static final Log LOGGER = LogFactory.getLog(InvestorUpdateService.class);
    private String allColumns = "fid,fnumber,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fenable,findex,fstatus,fdisablerid,fdisabledate,fissyspreset,fmasterid,fbsed,fbsled,fname,fsimplename,fdescription,finvesttotal,fdutyid,finvestratio,ftaxfileid,fboid,fiscurrentversion,fdatastatus,fsourcevid,fhisversion,fismodify,fchangedescription";
    private String columns = "fnumber,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fenable,findex,fdisablerid,fdisabledate,fissyspreset,fbsed,fbsled,fname,fsimplename,fdescription,finvesttotal,fdutyid,finvestratio,ftaxfileid";

    @Override
    public UpgradeResult doAfterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew();){
            this.updataInvestorInfo();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updataInvestorInfo() {
        try (DataSet dataSet = null;){
            dataSet = this.queryData();
            if (dataSet != null) {
                ArrayList updateParams = new ArrayList(100);
                ArrayList insertparams = new ArrayList(100);
                SubCardUpdateServiceHelper.geneInsertParams((DataSet)dataSet, updateParams, insertparams, (String)"t_itc_investor", (String)this.columns);
                if (!CollectionUtils.isEmpty(updateParams)) {
                    StringBuilder updateSql = new StringBuilder();
                    updateSql.append("UPDATE t_itc_investor ");
                    updateSql.append(" SET fboid = ? ,fiscurrentversion = ?, fdatastatus = ?,fsourcevid = ?,fhisversion = ?,fismodify = ?,fchangedescription = ?,fstatus = ? ");
                    updateSql.append(" WHERE fid = ? ");
                    SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)updateSql.toString(), updateParams);
                    LOGGER.info("InvestorUpdateService update data size {}", (Object)updateParams.size());
                }
                if (!CollectionUtils.isEmpty(insertparams)) {
                    StringBuilder insertSql = new StringBuilder();
                    insertSql.append(" insert into t_itc_investor ");
                    insertSql.append(" ( ").append(this.columns);
                    insertSql.append("  ,fid,fstatus,fmasterid,fboid,fiscurrentversion,fdatastatus,fsourcevid,fchangedescription,fhisversion,fismodify ) ");
                    insertSql.append(" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
                    SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)insertSql.toString(), insertparams);
                    LOGGER.info("InvestorUpdateService insert data size {}", (Object)insertparams.size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet queryData() {
        StringBuilder querySql = new StringBuilder();
        querySql.append(" select distinct ").append(this.allColumns);
        querySql.append(" from t_itc_investor where fboid is null or fboid = 0 ");
        DataSet dataSet = SITDbUtil.queryDataSet((String)"ItcInvestor", (DBRoute)SITConstants.SIT_ROUTE, (String)querySql.toString(), null);
        try (DataSet copySet = null;){
            copySet = dataSet.copy();
            int count = copySet.count("fid", true);
            LOGGER.info("InvestorUpdateService select data {}", (Object)count);
            if (count > 0) {
                DataSet dataSet2 = dataSet;
                return dataSet2;
            }
            DataSet dataSet3 = null;
            return dataSet3;
        }
    }
}

