/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.mservice.update;

import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.UpgradeResult;
import kd.sit.itc.mservice.update.UpgradeDataFilter1128Service;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.constants.SITConstants;
import kd.sit.sitbp.common.enums.DataStatusEnum;
import kd.sit.sitbp.common.history.model.SITHisBaseConstants;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITDbUtil;
import kd.sit.sitbp.common.util.SitDateUtil;

public class SpecialInfotUpdateService
extends UpgradeDataFilter1128Service {
    private static final Log LOGGER = LogFactory.getLog(SpecialInfotUpdateService.class);
    private static final String tableName = "t_itc_specialinfo";
    private static final String querySql = "SELECT TOP 10000 FID,FNUMBER,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FENABLE,FINDEX,FSTATUS,FDISABLERID,FDISABLEDATE,FISSYSPRESET,FMASTERID,FBSED,FBSLED,FNAME,FSIMPLENAME,FDESCRIPTION,FDISABILITY,FMARTYRSFAMILY,FOLDANDLONEY,FDISABILITYNUM,FMARTYRSFAMILYNUM,FTAXFILEID FROM t_itc_specialinfo WHERE FBOID = 0 OR FBOID IS NULL";
    private static final String[] queryField = new String[]{"FID", "FNUMBER", "FCREATORID", "FCREATETIME", "FMODIFIERID", "FMODIFYTIME", "FENABLE", "FINDEX", "FSTATUS", "FDISABLERID", "FDISABLEDATE", "FISSYSPRESET", "FMASTERID", "FBSED", "FBSLED", "FNAME", "FSIMPLENAME", "FDESCRIPTION", "FDISABILITY", "FMARTYRSFAMILY", "FOLDANDLONEY", "FDISABILITYNUM", "FMARTYRSFAMILYNUM", "FTAXFILEID"};
    private static final String insertSql = "INSERT INTO T_ITC_SPECIALINFO (FID,FNUMBER,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FENABLE,FINDEX,FSTATUS,FDISABLERID,FDISABLEDATE,FISSYSPRESET,FMASTERID,FBSED,FBSLED,FNAME,FSIMPLENAME,FDESCRIPTION,FDISABILITY,FMARTYRSFAMILY,FOLDANDLONEY,FDISABILITYNUM,FMARTYRSFAMILYNUM,FTAXFILEID,FBOID,FISCURRENTVERSION,FDATASTATUS,FSOURCEVID,FFIRSTBSED,FHISVERSION,FISMODIFY) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String updateSql = "UPDATE T_ITC_SPECIALINFO  SET FSTATUS = ?,FBSED = ?,FBSLED = ?,FBOID = ?,FISCURRENTVERSION = ?,FDATASTATUS = ?,FSOURCEVID = ?,FFIRSTBSED = ?,FHISVERSION = ?,FISMODIFY = ? WHERE FID = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradeResult doAfterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (DataSet dateSet = null;){
            dateSet = SITDbUtil.queryDataSet((String)"employmentUpdateService", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)querySql, (Object[])new Object[0]);
            while (dateSet.hasNext()) {
                HashMap empBaseMap = Maps.newHashMapWithExpectedSize((int)16);
                this.getEmploymentBaseData(empBaseMap, dateSet);
                if (CollectionUtils.isEmpty((Map)empBaseMap)) {
                    UpgradeResult upgradeResult = result;
                    return upgradeResult;
                }
                ArrayList<Object[]> updateList = new ArrayList<Object[]>(empBaseMap.size());
                ArrayList<Object[]> insertList = new ArrayList<Object[]>(empBaseMap.size());
                this.createTimSqeEmploymentInfo(empBaseMap, updateList, insertList);
                try (TXHandle txHandle = TX.requiresNew();){
                    if (!CollectionUtils.isEmpty(updateList)) {
                        SITDbUtil.executeBatch((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)updateSql, updateList);
                    }
                    if (!CollectionUtils.isEmpty(insertList)) {
                        SITDbUtil.executeBatch((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)insertSql, insertList);
                    }
                    LOGGER.info("SpecialInfotUpdateService end");
                }
                dateSet = SITDbUtil.queryDataSet((String)"queryTaxFileSQL", (DBRoute)SITConstants.SIT_ROUTE, (String)querySql, (Object[])new Object[0]);
            }
        }
        return result;
    }

    private void getEmploymentBaseData(Map<Long, Map<String, Object>> empBaseMap, DataSet dateSet) {
        while (dateSet.hasNext()) {
            Row row = dateSet.next();
            HashMap<String, Object> tempMap = new HashMap<String, Object>(16);
            tempMap.put("FID", row.getLong("FID"));
            tempMap.put("FNUMBER", row.getString("FNUMBER"));
            tempMap.put("FCREATORID", row.getLong("FCREATORID"));
            tempMap.put("FCREATETIME", row.getDate("FCREATETIME"));
            tempMap.put("FMODIFIERID", row.getLong("FMODIFIERID"));
            tempMap.put("FMODIFYTIME", row.getDate("FMODIFYTIME"));
            tempMap.put("FENABLE", row.getString("FENABLE"));
            tempMap.put("FINDEX", row.getInteger("FINDEX"));
            tempMap.put("FSTATUS", row.getString("FSTATUS"));
            tempMap.put("FDISABLERID", row.getLong("FDISABLERID"));
            tempMap.put("FDISABLEDATE", row.getDate("FDISABLEDATE"));
            tempMap.put("FISSYSPRESET", row.getString("FISSYSPRESET"));
            tempMap.put("FMASTERID", row.getLong("FMASTERID"));
            tempMap.put("FBSED", row.getDate("FBSED"));
            tempMap.put("FBSLED", row.getDate("FBSLED"));
            tempMap.put("FNAME", row.getString("FNAME"));
            tempMap.put("FSIMPLENAME", row.getString("FSIMPLENAME"));
            tempMap.put("FDESCRIPTION", row.getString("FDESCRIPTION"));
            tempMap.put("FDISABILITY", row.getString("FDISABILITY"));
            tempMap.put("FMARTYRSFAMILY", row.getString("FMARTYRSFAMILY"));
            tempMap.put("FOLDANDLONEY", row.getString("FOLDANDLONEY"));
            tempMap.put("FDISABILITYNUM", row.getString("FDISABILITYNUM"));
            tempMap.put("FMARTYRSFAMILYNUM", row.getString("FMARTYRSFAMILYNUM"));
            tempMap.put("FTAXFILEID", row.getLong("FTAXFILEID"));
            empBaseMap.put(row.getLong("FID"), tempMap);
        }
    }

    private void createTimSqeEmploymentInfo(Map<Long, Map<String, Object>> empBaseMap, List<Object[]> updateList, List<Object[]> insertList) {
        for (Map.Entry<Long, Map<String, Object>> entry : empBaseMap.entrySet()) {
            Map<String, Object> value = entry.getValue();
            if ("A".equals(value.get("FSTATUS"))) {
                this.getUpdateObject(value, updateList);
                continue;
            }
            this.getInsertAndUpdateObject(value, updateList, insertList);
        }
    }

    private void getUpdateObject(Map<String, Object> value, List<Object[]> updateList) {
        ArrayList<Object> updateTempList = new ArrayList<Object>(queryField.length);
        updateTempList.add(value.get("FSTATUS"));
        updateTempList.add(value.get("FBSED"));
        if (null == value.get("FBSLED")) {
            updateTempList.add(this.getNewTimestamp(SITHisBaseConstants.NEW_BSLED));
        } else {
            updateTempList.add(value.get("FBSLED"));
        }
        updateTempList.add(value.get("FID"));
        updateTempList.add("1");
        updateTempList.add(DataStatusEnum.DRAFT.getCode());
        updateTempList.add(0L);
        updateTempList.add(null);
        updateTempList.add(" ");
        updateTempList.add("0");
        updateTempList.add(value.get("FID"));
        updateList.add(updateTempList.toArray());
    }

    private void getInsertAndUpdateObject(Map<String, Object> value, List<Object[]> updateList, List<Object[]> insertList) {
        Object fbsled = value.get("FBSLED");
        if (null == fbsled || SITDateTimeUtils.dayEquals((Date)SITHisBaseConstants.OLD_BSLED, (Date)((Date)fbsled)) || SITDateTimeUtils.dayEquals((Date)SITHisBaseConstants.NEW_BSLED, (Date)((Date)fbsled))) {
            ArrayList<Object> updateTempList = new ArrayList<Object>(value.size());
            ArrayList<Object> insertTempList = new ArrayList<Object>(value.size());
            ArrayList<Object> insertTempList2 = new ArrayList<Object>(value.size());
            long fid = DB.genLongId((String)tableName);
            for (String field : queryField) {
                if ("FID".equals(field)) {
                    insertTempList.add(fid);
                    continue;
                }
                if ("FSTATUS".equals(field)) {
                    if ("D".equals(value.get("FSTATUS"))) {
                        insertTempList.add("C");
                        updateTempList.add("C");
                        continue;
                    }
                    insertTempList.add(value.get(field));
                    updateTempList.add(value.get(field));
                    continue;
                }
                if ("FBSLED".equals(field)) {
                    updateTempList.add(this.getNewTimestamp(SITHisBaseConstants.NEW_BSLED));
                    insertTempList.add(this.getNewTimestamp(SITHisBaseConstants.NEW_BSLED));
                    continue;
                }
                if ("FBSED".equals(field)) {
                    insertTempList.add(value.get(field));
                    updateTempList.add(value.get(field));
                    continue;
                }
                insertTempList.add(value.get(field));
            }
            this.setUpdateTempListTimeSqeInfo(value, updateTempList, fid);
            this.setInsertTempListTimeSqeInfo(value, insertTempList, insertTempList2);
            updateList.add(updateTempList.toArray());
            insertList.add(insertTempList.toArray());
        } else {
            ArrayList<Object> updateTempList = new ArrayList<Object>(value.size());
            ArrayList<Object> insertTempList1 = new ArrayList<Object>(value.size());
            ArrayList<Object> insertTempList2 = new ArrayList<Object>(value.size());
            long[] ids = DB.genLongIds((String)tableName, (int)2);
            long fsourceVid = 0L;
            long insertTemp1Fid = 0L;
            long insertTemp2Fid = 0L;
            for (String field : queryField) {
                if ("FID".equals(field)) {
                    insertTempList1.add(ids[0]);
                    insertTemp1Fid = ids[0];
                    insertTempList2.add(ids[1]);
                    insertTemp2Fid = ids[1];
                    continue;
                }
                if ("FSTATUS".equals(field)) {
                    if ("D".equals(value.get("FSTATUS"))) {
                        insertTempList1.add("C");
                        insertTempList2.add("C");
                        updateTempList.add("C");
                        continue;
                    }
                    insertTempList1.add(value.get(field));
                    insertTempList2.add(value.get(field));
                    updateTempList.add(value.get(field));
                    continue;
                }
                if ("FBSED".equals(field)) {
                    insertTempList1.add(value.get(field));
                    Date date = SITDateTimeUtils.addDay((Date)((Date)fbsled), (long)1L);
                    insertTempList2.add(this.getNewTimestamp(date));
                    if (SITDateTimeUtils.dayBefore((Date)((Date)fbsled), (Date)SitDateUtil.ceil((Object)new Date()))) {
                        updateTempList.add(this.getNewTimestamp(SITDateTimeUtils.addDay((Date)((Date)fbsled), (long)1L)));
                        continue;
                    }
                    updateTempList.add(value.get(field));
                    continue;
                }
                if ("FBSLED".equals(field)) {
                    insertTempList1.add(value.get(field));
                    insertTempList2.add(this.getNewTimestamp(SITHisBaseConstants.NEW_BSLED));
                    if (SITDateTimeUtils.dayBefore((Date)((Date)fbsled), (Date)SitDateUtil.ceil((Object)new Date()))) {
                        fsourceVid = insertTemp2Fid;
                        updateTempList.add(this.getNewTimestamp(SITHisBaseConstants.NEW_BSLED));
                        continue;
                    }
                    fsourceVid = insertTemp1Fid;
                    updateTempList.add(value.get(field));
                    continue;
                }
                insertTempList1.add(value.get(field));
                insertTempList2.add(value.get(field));
            }
            this.setInsertTempListTimeSqeInfo(value, insertTempList1, insertTempList2);
            this.setUpdateTempListTimeSqeInfo(value, updateTempList, fsourceVid);
            updateList.add(updateTempList.toArray());
            insertList.add(insertTempList1.toArray());
            insertList.add(insertTempList2.toArray());
        }
    }

    private void setUpdateTempListTimeSqeInfo(Map<String, Object> value, List<Object> updateTempList, Long sourceVid) {
        updateTempList.add(value.get("FID"));
        updateTempList.add("1");
        if (null != value.get("FBSLED") && SITDateTimeUtils.dayBefore((Date)((Date)value.get("FBSLED")), (Date)SitDateUtil.ceil((Object)new Date()))) {
            updateTempList.add(DataStatusEnum.EFFECTING.getCode());
        } else if (SITDateTimeUtils.dayBefore((Date)((Date)value.get("FBSED")), (Date)SitDateUtil.ceil((Object)new Date()))) {
            updateTempList.add(DataStatusEnum.EFFECTING.getCode());
        } else {
            updateTempList.add(DataStatusEnum.TO_EFFECT.getCode());
        }
        updateTempList.add(sourceVid);
        updateTempList.add(value.get("FBSED"));
        updateTempList.add(" ");
        updateTempList.add("0");
        updateTempList.add(value.get("FID"));
    }

    private void setInsertTempListTimeSqeInfo(Map<String, Object> value, List<Object> insertTempList1, List<Object> insertTempList2) {
        insertTempList1.add(value.get("FID"));
        insertTempList1.add("0");
        if (null != value.get("FBSLED") && SITDateTimeUtils.dayBefore((Date)((Date)value.get("FBSLED")), (Date)SitDateUtil.ceil((Object)new Date())) && !CollectionUtils.isEmpty(insertTempList2)) {
            insertTempList1.add(DataStatusEnum.EXPIRED.getCode());
        } else if (SITDateTimeUtils.dayBefore((Date)((Date)value.get("FBSED")), (Date)SitDateUtil.ceil((Object)new Date()))) {
            insertTempList1.add(DataStatusEnum.EFFECTING.getCode());
        } else {
            insertTempList1.add(DataStatusEnum.TO_EFFECT.getCode());
        }
        insertTempList1.add(0L);
        insertTempList1.add(value.get("FBSED"));
        insertTempList1.add("V0001");
        insertTempList1.add("0");
        if (CollectionUtils.isEmpty(insertTempList2)) {
            return;
        }
        insertTempList2.add(value.get("FID"));
        insertTempList2.add("0");
        if (SITDateTimeUtils.dayBefore((Date)((Date)value.get("FBSLED")), (Date)SitDateUtil.ceil((Object)new Date())) && !CollectionUtils.isEmpty(insertTempList2)) {
            insertTempList2.add(DataStatusEnum.EFFECTING.getCode());
        } else {
            insertTempList2.add(DataStatusEnum.TO_EFFECT.getCode());
        }
        insertTempList2.add(insertTempList1.get(0));
        insertTempList2.add(value.get("FBSED"));
        insertTempList2.add("V0002");
        insertTempList2.add("0");
    }

    private Timestamp getNewTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }
}

