/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.mservice.update;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.sit.itc.mservice.update.UpgradeDataFilter1128Service;
import kd.sit.sitbp.common.constants.SITBaseConstants;

public class TaxDataBasicOther2UpdateService
extends UpgradeDataFilter1128Service {
    private static final Log LOG = LogFactory.getLog(TaxDataBasicOther2UpdateService.class);
    private static final String querySql = "select fid from t_itc_taxdatabasic t2 join ( select t3.ftaxfileboid, min(t3.fyearmonth) fyearmonth from t_itc_taxdatabasic t3  where exists (select 1 from t_itc_dataupgrade du where du.fbatchkey = '20221128' and du.ftablename = 't_itc_taxdatabasic' and du.fdataid = t3.fid)  and t3.fstatus != 'E' group by ftaxfileboid) tit  on t2.ftaxfileboid = tit.ftaxfileboid and t2.fyearmonth = tit.fyearmonth";
    private static final String updateSql = "update t_itc_taxdatabasic t2 set fchangetype = '1', fpersonstatus = '1', fdeclarestatus = ( select fdeclarestatus from t_itc_taxfile tit where t2.ftaxfileid = tit.fid ) where (fchangetype = '0' or fchangetype = '3' or fchangetype = ' ' or fchangetype is null) and exists (select 1 from t_itc_taxfile tit where tit.ftaxstatus = '1' and t2.ftaxfileid = tit.fid) and fid in (0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = super.beforeExecuteSqlWithResult(ver, iteration, dbKey, sqlFileName);
        try (TXHandle txHandle = TX.requiresNew();){
            if (!result.isSuccess()) {
                UpgradeResult upgradeResult = result;
                return upgradeResult;
            }
            int batchSize = 1000;
            try (DataSet rows = HRDBUtil.queryDataSet((String)"TaxDataBasicOther2UpdateService.beforeExecuteSqlWithResult", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)querySql, (Object[])new Object[0]);){
                ArrayList ids = Lists.newArrayListWithExpectedSize((int)batchSize);
                while (rows.hasNext()) {
                    ids.add(rows.next().getLong("fid"));
                    if (ids.size() < batchSize) continue;
                    this.update(ids);
                }
                this.update(ids);
            }
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    public void update(List<Long> ids) {
        try (TXHandle txHandle = TX.requiresNew();){
            LOG.info("TaxDataBasicOther2UpdateService {}", ids);
            if (CollectionUtils.isEmpty(ids)) {
                return;
            }
            StringBuilder query = new StringBuilder(updateSql);
            for (Long ignored : ids) {
                query.append(",?");
            }
            query.append(')');
            HRDBUtil.execute((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)query.toString(), (Object[])ids.toArray(new Long[0]));
            ids.clear();
        }
    }
}

