/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.mservice.update;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.UpgradeResult;
import kd.sit.itc.mservice.update.UpgradeDataFilter1128Service;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.util.SITDbUtil;
import kd.sit.sitbp.common.util.SitDateUtil;

public class TaxDataBasicUpdateService
extends UpgradeDataFilter1128Service {
    private static final String querySql = "select TOP 10000 tit.fid as ftaxfileid, tit.fboid as ftaxfileboid,tit.fpersonid, tit2.fid as ftaxtaskid, tst.fperioddate, tit.ftaxunitid, tit.fdeclarestatus ,tit.forgid from t_itc_taxfile tit join t_sitbs_taxperiod tst on tit.fbsled >= tst.fstartdate and tit.fbsed <= tst.fenddate join t_sitbs_taxperiodprg tst2 on tst.fid = tst2.fid and tst2.fcountryid = 1000001 join t_itc_taxtask tit2 on tst.fentryid = tit2.ftaxperiodid join t_itc_taxtaskunitentry tit3 on tit2.fid = tit3.fid and tit.ftaxunitid = tit3.ftaxunitid left join t_itc_taxdatabasic titd on tit.fid = titd.ftaxfileid and tit2.fid = titd.ftaxtaskid where tit.ftaxstatus = '1' and tit.fiscurrentversion = '0' and tit.fstatus != 'E' and tst.fstatus != 'E' and tit2.fstatus != 'E' and titd.fid is null     and exists (select 1 from t_itc_dataupgrade du where du.fbatchkey = '20221128' and du.ftablename = 't_itc_taxfile' and du.fdataid = tit.fboid)     and exists (select 1 from t_itc_dataupgrade du where du.fbatchkey = '20221128' and du.ftablename = 't_itc_taxtask' and du.fdataid = tit2.fid)    and not exists (select 1 from t_itc_taxdatabasic tdb2 where tdb2.ftaxfileboid = tit.fboid and tdb2.ftaxtaskid = tit2.fid)";
    private static final String insertSql = "insert into t_itc_taxdatabasic ( fid, fcreatorid, fmodifierid, fcreatetime, fmodifytime, fyearmonth, ftaxfileid, fstatus, ftaxtaskid, ftaxunitid, fbizstatus, ftaxpersonid, fdeclarestatus, fchangetype, fpreparestatus, ftaxfileboid, fpersonstatus, frefoprecordid ,forgid ) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String insertRangeSql = "insert into t_itc_dataupgrade (fid, fbatchkey, ftablename, fdataid) values (?, '20221128', 't_itc_taxdatabasic', ?)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradeResult doAfterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DataSet dateSet = SITDbUtil.queryDataSet((String)"TaxDataBasicUpdateService", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)querySql, (Object[])new Object[0]);
        DataSet countSet = dateSet.copy();
        int count = countSet.count("ftaxfileid", false);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        for (int max = 100; count > 0 && max > 0; --max) {
            long[] ids = this.generateIds(count);
            int index = 0;
            ArrayList insertList = Lists.newArrayListWithCapacity((int)ids.length);
            ArrayList insertRangeList = Lists.newArrayListWithCapacity((int)ids.length);
            try {
                while (dateSet.hasNext()) {
                    Row next = dateSet.next();
                    Date periodDate = next.getDate("fperioddate");
                    Object[] data = new Object[19];
                    insertList.add(data);
                    data[0] = ids[index];
                    data[1] = 1L;
                    data[2] = 1L;
                    data[3] = now;
                    data[4] = now;
                    data[5] = SitDateUtil.toYearMonth((Date)periodDate);
                    data[6] = next.getLong("ftaxfileid");
                    data[7] = "C";
                    data[8] = next.getLong("ftaxtaskid");
                    data[9] = next.getLong("ftaxunitid");
                    data[10] = "0";
                    data[11] = next.getLong("fpersonid");
                    data[12] = next.getString("fdeclarestatus");
                    data[13] = " ";
                    data[14] = " ";
                    data[15] = next.getLong("ftaxfileboid");
                    data[16] = "1";
                    data[17] = 1012L;
                    data[18] = next.getLong("forgid");
                    Object[] insertRange = new Object[2];
                    insertRangeList.add(insertRange);
                    insertRange[0] = ids[index] - 1100000000000000000L;
                    insertRange[1] = ids[index];
                    ++index;
                }
                SITDbUtil.executeBatch((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)insertSql, (List)insertList);
                SITDbUtil.executeBatch((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)insertRangeSql, (List)insertRangeList);
            }
            finally {
                dateSet.close();
                countSet.close();
            }
            dateSet = SITDbUtil.queryDataSet((String)"TaxDataBasicUpdateService", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)querySql, (Object[])new Object[0]);
            countSet = dateSet.copy();
            count = countSet.count("ftaxfileid", false);
        }
        dateSet.close();
        countSet.close();
        return result;
    }

    private long[] generateIds(int count) {
        return DB.genLongIds((String)"t_itc_taxdatabasic", (int)count);
    }
}

