/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.mservice.update;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.sit.sitbp.common.util.SITDbUtil;

public class TaxFileImportTplUpgrade1230Service
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(TaxFileImportTplUpgrade1230Service.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (DataSet dataSet = null;){
            String sql = " select fid, fentryid, fparententryid, fseq, ffieldkey, fimportprop, fexportprop, fisimport from t_bas_importtemplateentry where fid  in (select fid from t_bas_importtemplate where fbizobject = 'itc_taxfilebill')  and ffieldkey = 'person' ";
            dataSet = DB.queryDataSet((String)"TaxFileImportTplUpgrade1230Service", (DBRoute)new DBRoute("sys"), (String)sql, (Object[])new Object[0]);
            ArrayList insertParams = Lists.newArrayListWithExpectedSize((int)10);
            ArrayList updateParams = Lists.newArrayListWithExpectedSize((int)10);
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            while (dataSet.hasNext()) {
                this.getInsertAndUpdateList(dataSet.next(), insertParams, updateParams, map);
            }
            if (CollectionUtils.isEmpty((Map)map)) {
                UpgradeResult upgradeResult = new UpgradeResult();
                return upgradeResult;
            }
            ArrayList update1Params = Lists.newArrayListWithExpectedSize((int)100);
            this.getUpdateEntityE(map, update1Params);
            try (TXHandle txHandle = TX.requiresNew();){
                StringBuilder updateSql;
                LOGGER.info("afterExecuteSqlWithResult {}", (Object)map.keySet().toString());
                if (!CollectionUtils.isEmpty((Collection)insertParams)) {
                    DB.executeBatch((DBRoute)new DBRoute("sys"), (String)"insert into t_bas_importtemplateentry (fid, fentryid, fparententryid, fseq, ffieldkey,fisimport,fisfield,fimportprop,fexportprop,fmustinput) values (?,?,?,?,?,?,?,?,?,?)", (List)insertParams);
                }
                if (!CollectionUtils.isEmpty((Collection)updateParams)) {
                    updateSql = new StringBuilder();
                    updateSql.append("update t_bas_importtemplateentry ");
                    updateSql.append(" set ffieldkey = ? , fimportprop = ?, fexportprop = ? ");
                    updateSql.append(" where fentryid = ? ");
                    SITDbUtil.executeBatch((DBRoute)new DBRoute("sys"), (String)updateSql.toString(), (List)updateParams);
                }
                if (!CollectionUtils.isEmpty((Collection)update1Params)) {
                    updateSql = new StringBuilder();
                    updateSql.append("update t_bas_importtemplateentry ");
                    updateSql.append(" set fseq = ? ");
                    updateSql.append(" where fentryid = ? ");
                    SITDbUtil.executeBatch((DBRoute)new DBRoute("sys"), (String)updateSql.toString(), (List)update1Params);
                }
            }
        }
        return new UpgradeResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getUpdateEntityE(HashMap<Long, Integer> map, List<Object[]> update1Params) {
        StringBuilder querySqlBuilder = new StringBuilder();
        querySqlBuilder.append(" select fid, fentryid, fseq from t_bas_importtemplateentry where ");
        querySqlBuilder.append(" fid in (?");
        for (int i = 1; i < map.keySet().size(); ++i) {
            querySqlBuilder.append(", ?");
        }
        querySqlBuilder.append(" ) ");
        Set<Long> set = map.keySet();
        try (DataSet dataSet1 = null;){
            dataSet1 = DB.queryDataSet((String)"TaxFileImportTplUpgrade1230Service", (DBRoute)new DBRoute("sys"), (String)querySqlBuilder.toString(), (Object[])set.toArray(new Long[0]));
            while (dataSet1.hasNext()) {
                Row row = dataSet1.next();
                Integer seq = row.getInteger("fseq");
                Long fid = row.getLong("fid");
                if (map.get(fid) >= seq) continue;
                Object[] updateParam = new Object[]{seq + 1, row.getLong("fentryid")};
                update1Params.add(updateParam);
            }
        }
    }

    private void getInsertAndUpdateList(Row row, List<Object[]> insertParams, List<Object[]> updateParams, HashMap<Long, Integer> map) {
        Integer seq = row.getInteger("fseq");
        Long entryId = row.getLong("fentryid");
        Long fid = row.getLong("fid");
        Long parentId = row.getLong("fparententryid");
        String isImport = row.getString("fisimport");
        map.put(fid, seq);
        Object[] updateParam = new Object[]{"personnumber", " ", " ", entryId};
        updateParams.add(updateParam);
        Object[] insertParam = new Object[]{fid, DB.genGlobalLongId(), parentId, seq + 1, "personname", isImport, "1", " ", " ", "0"};
        insertParams.add(insertParam);
    }
}

