/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.mservice.update;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class TaxPrivacyUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TaxPrivacyUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        TaxPrivacyUpgradeService.upgradeData();
        return new UpgradeResult();
    }

    public static void upgradeData() {
        String[] tables;
        HashMap encryptMap = Maps.newHashMapWithExpectedSize((int)2);
        for (String table : tables = new String[]{"t_itc_taxperson", "t_itc_bankcard"}) {
            encryptMap.computeIfAbsent(table, k1 -> new HashSet()).addAll(PrivacyCenterUtils.getEncryptFields((String)table));
        }
        ArrayList params = Lists.newArrayListWithExpectedSize((int)encryptMap.size());
        for (Map.Entry entry : encryptMap.entrySet()) {
            String table;
            table = (String)entry.getKey();
            Set fieldsSet = (Set)entry.getValue();
            StringBuilder sb = new StringBuilder();
            for (String str : fieldsSet) {
                sb.append('\'').append(str.trim()).append('\'').append(',');
            }
            params.add(new Object[]{table, StringUtils.isEmpty((CharSequence)sb) ? "" : sb.substring(0, sb.length() - 1)});
        }
        try (TXHandle txHandle = TX.requiresNew();){
            DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)"delete from t_privacy_scheme_desen where fdense_table_name = ? and fdense_field_name not in (?)", (List)params);
            DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)"delete from t_privacy_scheme_encrypt where fencrypt_table_name = ? and fencrypt_field_name not in (?)", (List)params);
            DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)"delete from t_privacy_data_tag_fields where ftable_name = ? and ffield_name not in (?)", (List)params);
            logger.info("TaxPrivacyUpgradeService end");
        }
    }
}

