/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.mservice.update;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.sit.sitbp.common.constants.SITConstants;
import kd.sit.sitbp.common.util.SITDbUtil;
import kd.sit.sitbp.common.util.SitDateUtil;

public class TaxTaskUpgradeForPeriodService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(TaxTaskUpgradeForPeriodService.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String periodSql = "select a.fentryid from t_sitbs_taxperiod a join t_sitbs_taxperiodprg b on a.fid = b.fid where b.fcountryid = 1000001 and b.fid != 1463640374944791552";
        StringBuilder taskQuerySql = new StringBuilder("select a.fid, a.ftaxenddate, a.fdeclareenddate from t_itc_taxtask a where ftaxperiodid in (0");
        String taskUpdateSql = "update t_itc_taxtask set ftaxenddate = ?, fdeclareenddate = ? where fid = ?";
        try (DataSet dateSet = SITDbUtil.queryDataSet((String)"TaxTaskUpgradeForPeriodService1", (DBRoute)SITConstants.SIT_ROUTE, (String)periodSql, (Object[])new Object[0]);){
            ArrayList periodIds = Lists.newArrayListWithExpectedSize((int)100);
            while (dateSet.hasNext()) {
                periodIds.add(dateSet.next().getLong("fentryid"));
            }
            if (CollectionUtils.isEmpty((Collection)periodIds)) {
                UpgradeResult upgradeResult = new UpgradeResult();
                return upgradeResult;
            }
            for (Long periodId : periodIds) {
                taskQuerySql.append(", ").append(periodId);
            }
            taskQuerySql.append(")");
            try (DataSet taskDateSet = SITDbUtil.queryDataSet((String)"TaxTaskUpgradeForPeriodService2", (DBRoute)SITConstants.SIT_ROUTE, (String)taskQuerySql.toString(), (Object[])new Object[0]);){
                ArrayList params = Lists.newArrayListWithExpectedSize((int)100);
                while (taskDateSet.hasNext()) {
                    Object[] item = new Object[3];
                    params.add(item);
                    Row next = taskDateSet.next();
                    item[0] = SitDateUtil.toLastSecond((Date)next.getDate("ftaxenddate"));
                    item[1] = SitDateUtil.toLastSecond((Date)next.getDate("fdeclareenddate"));
                    item[2] = next.getLong("fid");
                }
                if (CollectionUtils.isEmpty((Collection)params)) return new UpgradeResult();
                SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)taskUpdateSql, (List)params);
                return new UpgradeResult();
            }
        }
        catch (Exception e) {
            LOGGER.error("TaxTaskUpgradeForPeriodService error", (Throwable)e);
        }
        return new UpgradeResult();
    }
}

