/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.formplugin.web;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class BaseDataSummaryEdit
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(BaseDataSummaryEdit.class);

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.changeAboutSummary();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "save": 
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": 
            case "disable": 
            case "enable": 
            case "confirmchange": {
                if (!args.getOperationResult().isSuccess()) break;
                this.changeAboutSummary();
                break;
            }
        }
    }

    protected void changeAboutSummary() {
        boolean hisAndNoChangeAndAddNew;
        if (StringUtils.isEmpty((CharSequence)this.getModel().getDataEntity().getString("number"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"summaryap"});
            return;
        }
        BillOperationStatus billStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
        logger.info("BaseDataSummaryEdit.changeAboutSummary:billStatus=", (Object)billStatus);
        boolean isHistoryPage = this.isHisPage(this.getView());
        boolean hisAndNotVersion = !this.isShowIfRevisionHistory() && isHistoryPage;
        boolean bl = hisAndNoChangeAndAddNew = isHistoryPage && !this.isShowIfPageToChange() && BillOperationStatus.ADDNEW.equals((Object)billStatus);
        if (hisAndNotVersion || hisAndNoChangeAndAddNew) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"summaryap"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"summaryap"});
        String summaryPageId = this.getSummaryPageId();
        if (StringUtils.isNotEmpty((CharSequence)summaryPageId)) {
            this.updateSummary(summaryPageId);
        } else {
            this.loadSummary();
        }
    }

    private String getSummaryPageId() {
        IPageCache pageCache = this.getPageCache();
        String summaryPageId = pageCache.get("summaryPageId");
        if (StringUtils.isEmpty((CharSequence)summaryPageId)) {
            return null;
        }
        return summaryPageId;
    }

    protected void updateSummary(String summaryPageId) {
        IFormView formView = this.getView();
        if (StringUtils.isNotEmpty((CharSequence)summaryPageId)) {
            IFormView summaryView = formView.getView(summaryPageId);
            if (summaryView == null) {
                return;
            }
            FormShowParameter formShowParameter = summaryView.getFormShowParameter();
            formShowParameter.setCustomParam("summaryDataMap", this.getSummaryDatas());
            summaryView.updateView();
            formView.sendFormAction(summaryView);
        }
    }

    protected void loadSummary() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("summaryap");
        formShowParameter.setFormId("sitbp_summary");
        Map<String, String> summaryDataMap = this.getSummaryDatas();
        formShowParameter.setCustomParam("summaryDataMap", summaryDataMap);
        this.getView().showForm(formShowParameter);
        this.getView().updateView("summaryap");
    }

    protected Map<String, String> getSummaryDatas() {
        List<String> summaryFieldList = this.getSummaryFieldCodeList();
        HashMap<String, String> summaryDataMap = new HashMap<String, String>(summaryFieldList.size());
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectType objectType = dataEntity.getDynamicObjectType();
        for (String fieldCode : summaryFieldList) {
            SimpleDateFormat format;
            Date dateValue;
            DynamicProperty property = objectType.getProperty(fieldCode);
            if (null == property) continue;
            String summaryKey = fieldCode;
            String summaryValue = "";
            if (property instanceof TextProp) {
                summaryValue = dataEntity.getString(fieldCode);
            } else if (property instanceof ComboProp) {
                summaryValue = dataEntity.getString(fieldCode);
                if (StringUtils.isNotEmpty((CharSequence)summaryValue)) {
                    summaryValue = ((ComboProp)property).getItemByName(summaryValue);
                }
            } else if (property instanceof TimeProp) {
                dateValue = dataEntity.getDate(fieldCode);
                if (dateValue != null) {
                    format = new SimpleDateFormat("yyyy-MM-dd");
                    summaryValue = format.format(dateValue);
                }
            } else if (property instanceof DateTimeProp) {
                dateValue = dataEntity.getDate(fieldCode);
                if (dateValue != null) {
                    format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    summaryValue = format.format(dateValue);
                }
            } else {
                summaryValue = property instanceof BooleanProp ? dataEntity.getString(fieldCode) : (property instanceof BasedataProp ? dataEntity.getString(fieldCode + ".name") : dataEntity.getString(fieldCode));
            }
            this.putSummaryData(dataEntity, fieldCode, summaryKey, summaryValue, summaryDataMap);
        }
        return summaryDataMap;
    }

    public boolean isHisPage(IFormView view) {
        Map params = view.getFormShowParameter().getCustomParams();
        Object fromPage = params.get("fromPage");
        return fromPage != null && "fromHisAction".equals(fromPage);
    }

    protected void putSummaryData(DynamicObject dataEntity, String fieldCode, String summaryKey, String summaryValue, Map<String, String> summaryDataMap) {
        block4 : switch (fieldCode) {
            case "status": {
                switch (dataEntity.getString(fieldCode)) {
                    case "A": {
                        summaryKey = "save";
                        break block4;
                    }
                    case "B": {
                        summaryKey = "submit";
                        break block4;
                    }
                    case "C": {
                        summaryKey = "audit";
                        break block4;
                    }
                }
                break;
            }
            case "enable": {
                switch (dataEntity.getString(fieldCode)) {
                    case "0": {
                        summaryKey = "disable";
                        break block4;
                    }
                    case "1": {
                        summaryKey = "enable";
                        break block4;
                    }
                    case "10": {
                        summaryKey = "unusing";
                        break block4;
                    }
                }
                break;
            }
        }
        if (!StringUtils.isEmpty((CharSequence)summaryValue)) {
            summaryDataMap.put(summaryKey, summaryValue);
        }
    }

    protected List<String> getSummaryFieldCodeList() {
        ArrayList<String> summaryFieldList = new ArrayList<String>(4);
        summaryFieldList.add("name");
        summaryFieldList.add("number");
        summaryFieldList.add("status");
        summaryFieldList.add("enable");
        return summaryFieldList;
    }

    protected boolean isShowIfRevisionHistory() {
        return true;
    }

    protected boolean isShowIfPageToChange() {
        return false;
    }
}

