/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.formplugin.web;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.sit.sitbp.common.api.ExpressionSupport;
import kd.sit.sitbp.common.cal.api.OperatorName;
import kd.sit.sitbp.common.cal.factory.CalResolverFactory;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class ExpressionPlugin
extends HRDynamicFormBasePlugin {
    public static final String EXPRESSION = "expression";
    public static final String BTN_PREFIX_IP = "op_";
    public static final String BTN_PREFIX_NUM = "num_";
    private static final int TAB_STYLE_MINI = 3;
    private static final Map<String, String> OPERATOR = new HashMap<String, String>(32);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        FormShowParameter source = (FormShowParameter)args.getSource();
        List extraElements = (List)source.getCustomParam("extraElements");
        if (!CollectionUtils.isEmpty((Collection)extraElements)) {
            TabAp tab = new TabAp();
            tab.setKey("supportedtabs");
            tab.setTabStyle(3);
            for (String element : extraElements) {
                ExpressionSupport byName = ExpressionSupport.findByName((String)element);
                if (byName == null) continue;
                TabPageAp tabPageAp = byName.tabPage(tab, source);
                tabPageAp.setKey(element);
                tab.getItems().add(tabPageAp);
            }
            args.getItems().add(tab.createControl());
        }
    }

    public void registerListener(EventObject event) {
        String[] keys = OPERATOR.keySet().toArray(new String[0]);
        this.addClickListeners(keys);
        this.addClickListeners(new String[]{"btn_comfirm", "btn_cancel", "func_clear", "func_del"});
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button) {
            String expression;
            String key = ((Button)source).getKey();
            if (key.startsWith(BTN_PREFIX_IP) || key.startsWith(BTN_PREFIX_NUM)) {
                String expression2 = this.getModel().getDataEntity().getString(EXPRESSION);
                if (ObjectUtils.isEmpty((Object)expression2)) {
                    this.setExpressionValue(OPERATOR.get(key));
                } else {
                    this.setExpressionValue(expression2 + OPERATOR.get(key));
                }
            } else if ("btn_comfirm".equals(key)) {
                String expression3 = this.getModel().getDataEntity().getString(EXPRESSION);
                this.getView().returnDataToParent((Object)expression3);
                this.getView().close();
            } else if ("btn_cancel".equals(key)) {
                this.getView().close();
            } else if ("func_clear".equals(key)) {
                this.setExpressionValue(null);
            } else if ("func_del".equals(key) && !StringUtils.isEmpty((CharSequence)(expression = this.getModel().getDataEntity().getString(EXPRESSION)))) {
                this.setExpressionValue(expression.substring(0, expression.trim().lastIndexOf(32) + 1));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        IDataEntityProperty property = args.getProperty();
        String name = property.getName();
        String expression = this.getModel().getDataEntity().getString(EXPRESSION);
        ChangeData[] changeSet = args.getChangeSet();
        String newValue = BaseDataConverter.toString((Object)changeSet[0].getNewValue());
        switch (name) {
            case "appendvalue": {
                if (ObjectUtils.isEmpty((Object)newValue)) {
                    return;
                }
                expression = ObjectUtils.isEmpty((Object)expression) ? newValue : expression + newValue;
                this.setExpressionValue(expression.trim() + " ");
                break;
            }
            case "expression_tag": 
            case "expression": {
                this.setExpressionValue(expression);
                break;
            }
        }
    }

    public void beforeBindData(EventObject event) {
        FormShowParameter source = this.getView().getFormShowParameter();
        List extraElements = (List)source.getCustomParam("extraElements");
        boolean hasExtra = false;
        this.getModel().setValue(EXPRESSION, source.getCustomParam(EXPRESSION));
        this.getModel().setValue("expression_tag", source.getCustomParam(EXPRESSION));
        if (!CollectionUtils.isEmpty((Collection)extraElements)) {
            for (String element : extraElements) {
                ExpressionSupport byName = ExpressionSupport.findByName((String)element);
                if (byName == null) continue;
                hasExtra = true;
                FormShowParameter showParameter = byName.embedTo(this.getView());
                showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                showParameter.getOpenStyle().setTargetKey(element);
                this.getView().showForm(showParameter);
            }
        }
        if (!hasExtra) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabapflexpanel"});
        }
    }

    private void setExpressionValue(String expression) {
        this.getModel().beginInit();
        this.getModel().setValue(EXPRESSION, (Object)expression);
        this.getModel().setValue("expression_tag", (Object)expression);
        this.getModel().setValue("appendvalue", null);
        this.getModel().endInit();
        this.getView().updateView(EXPRESSION);
    }

    static {
        List operatorNames = CalResolverFactory.supportOps();
        for (OperatorName op : operatorNames) {
            if (StringUtils.isEmpty((CharSequence)op.viewFlag()) || StringUtils.isEmpty((CharSequence)op.expression())) continue;
            OPERATOR.put(op.viewFlag(), op.expression());
        }
        OPERATOR.put("op_unitclose", ") ");
        OPERATOR.put("op_comma", ", ");
        OPERATOR.put("op_blank", " ");
        OPERATOR.put("num_1", "1");
        OPERATOR.put("num_2", "2");
        OPERATOR.put("num_3", "3");
        OPERATOR.put("num_4", "4");
        OPERATOR.put("num_5", "5");
        OPERATOR.put("num_6", "6");
        OPERATOR.put("num_7", "7");
        OPERATOR.put("num_8", "8");
        OPERATOR.put("num_9", "9");
        OPERATOR.put("num_0", "0");
    }
}

