/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.formplugin.web;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;

public class OperationConfirmPlugin
extends AbstractFormPlugin {
    private static final String BTN_MORE = "btnmore";
    private static final String BTN_OK = "btnok";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_MORE, BTN_OK});
    }

    public void afterCreateNewData(EventObject event) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Label label = (Label)this.getControl("ftitle");
        label.setText((String)parameter.getCustomParam("title"));
        Html content = (Html)this.getControl("fcontent");
        content.setConent((String)parameter.getCustomParam("errorMsg"));
        if (Boolean.TRUE != parameter.getCustomParam("hasMore")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_MORE});
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnmore": {
                this.showMore();
                break;
            }
            case "btnok": {
                this.returnTureToParent();
                break;
            }
        }
    }

    private void returnTureToParent() {
        IFormView view = this.getView();
        view.returnDataToParent((Object)Boolean.TRUE);
        view.close();
    }

    private void showMore() {
        FormShowParameter param = this.getView().getFormShowParameter();
        IFormView view = this.getView();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_showoperationresult");
        parameter.setCustomParam("pkNumbers", param.getCustomParam("pkNumbers"));
        parameter.setCustomParam("operateName", param.getCustomParam("operateName"));
        this.setFailMessageToCache();
        view.showForm(parameter);
    }

    private void setFailMessageToCache() {
        FormShowParameter param = this.getView().getFormShowParameter();
        Object operateName = param.getCustomParam("operateName");
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        OperationResult operationResult = new OperationResult();
        List allErrorInfo = operationResult.getAllErrorInfo();
        Object failListObj = param.getCustomParam("failList");
        if (failListObj != null) {
            List faiList = (List)failListObj;
            for (String message : faiList) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setMessage(message);
                if (operateName != null) {
                    errorInfo.setTitle(operateName.toString());
                }
                errorInfo.setErrorLevel(String.valueOf(ErrorLevel.Error));
                allErrorInfo.add(errorInfo);
            }
        }
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
    }
}

