/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.formplugin.web;

import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.OpBatchExecuter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.common.enums.SInsuranceInfoEnum;

public class SITOpBatchExecutePlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(SITOpBatchExecutePlugin.class);
    private static final String FORMID_OPBATCHEXECUTE = "bos_opbatchexecute";
    private static final String CUSTPARAM_ENTITYNUMBER = "entitynumber";
    private static final String CUSTPARAM_OPKEY = "opkey";
    private static final String CUSTPARAM_PKIDS = "pkids";
    private static final String CUSTPARAM_LISTSELECTEDROWS = "listselectedrows";
    private static final String CUSTPARAM_OPERATEOPTION = "operateoption";
    private static final String CUSTPARAM_BATCHSIZE = "batchsize";
    private static final String CUSTPARAM_PERMISSIONENTITYID = "permissionentityid";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_LBLPROGRESS = "lblprogress";
    private static final String CACHEKEY_TASKID = "taskid";
    public static final String NEED_RELEASE_MUTEX = "NeedReleaseMutex";
    public static final String MUTEX_ENTITY_NUMBER = "MutexEntityNumber";
    public static final String MUTEX_ENTITY_PKIDS = "MutexEntityPKIds";
    public static final String OP_BATCH_EXECUTE_META = "OpBatchExecuteMeta";
    private static final ThreadPool PREPARE_POOL = ThreadPools.newFixedThreadPool((String)"SITBP_OpBatch_MultiThreadTaskExecutor", (int)4);

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        String parentPageId = args.getFormShowParameter().getParentPageId();
        if (HRStringUtils.isEmpty((String)parentPageId)) {
            args.setCancel(true);
        }
    }

    public static void invokeBatchOp(BeforeDoOperationEventArgs args) {
        boolean needSplitBatch;
        FormOperate formOperate = (FormOperate)args.getSource();
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        if (listSelectedData == null) {
            listSelectedData = new ListSelectedRowCollection();
        }
        formOperate.setListSelectedData(listSelectedData);
        boolean batchFinish = SITOpBatchExecutePlugin.isBatchFinish(formOperate);
        int batchCount = SITOpBatchExecutePlugin.getBatchSize(formOperate);
        boolean bl = needSplitBatch = batchCount > 0 && batchCount < formOperate.getListSelectedData().size();
        if (!batchFinish && needSplitBatch) {
            SITOpBatchExecutePlugin.showOpBatchForm(formOperate, batchCount);
            args.setCancel(true);
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.start();
    }

    public void onProgress(ProgressEvent arg0) {
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            taskId = DBServiceHelper.genStringId();
            OpBatchExecuter executer = new OpBatchExecuter(taskId, this.getEntityNumber(), this.getOpKey(), this.getPKIds(), this.getOption(), this.getBatchSize());
            executer.setListSelectedRows(this.getListSelectedRows());
            PREPARE_POOL.execute((Runnable)executer);
            this.setTaskId(taskId);
            return;
        }
        boolean completed = OpBatchExecuter.isCompleted((String)taskId);
        boolean finished = OpBatchExecuter.isFinished((String)taskId);
        boolean isInteraction = OpBatchExecuter.isInteraction((String)taskId);
        boolean isError = OpBatchExecuter.isError((String)taskId);
        ProgressBar bar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        if (completed) {
            this.complete();
            bar.stop();
        } else if (isError) {
            this.getView().getParentView().showErrMessage(OpBatchExecuter.getErrorMessage((String)taskId), "");
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
            bar.stop();
        } else if (isInteraction) {
            OpBatchExecuter.setFinished((String)taskId, (boolean)false);
            OpBatchExecuter.setInteraction((String)taskId, (boolean)false);
            this.interaction();
        } else if (finished) {
            this.getView().close();
            bar.stop();
        } else {
            int progress = OpBatchExecuter.getProgress((String)taskId);
            String tip = OpBatchExecuter.getProgressTip((String)taskId);
            if (progress >= 100) {
                progress = 99;
            }
            arg0.setProgress(progress);
            if (StringUtils.isNotBlank((CharSequence)tip)) {
                this.setProgressTip(tip);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        if (!this.isTaskFinished()) {
            event.setCancel(true);
        }
    }

    public void pageRelease(EventObject event) {
        String taskId = this.getTaskId();
        if (this.isTaskFinished()) {
            OpBatchExecuter.clearCache((String)taskId);
        } else {
            OpBatchExecuter.setCancel((String)taskId, (boolean)true);
        }
        this.releaseMutex();
        if (this.getView().getParentView() != null) {
            this.getView().getParentView().invokeOperation("refresh");
        }
    }

    private void start() {
        String entityNumber = this.getEntityNumber();
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
        this.setProgressTip(SInsuranceInfoEnum.COMMON_BATCH_OP_TIPS.getErrInfo());
    }

    private void interaction() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        this.continueExecute("sponsor", MessageBoxResult.Yes.toString());
    }

    private void continueExecute(String sponsor, String interactionResult) {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        String taskId = this.getTaskId();
        OpBatchExecuter executer = new OpBatchExecuter(taskId, this.getEntityNumber(), this.getOpKey(), this.getPKIds(), this.getOption(), this.getBatchSize());
        executer.setListSelectedRows(this.getListSelectedRows());
        OperateOption option = this.getOption().copy();
        option.setVariableValue(sponsor, interactionResult);
        executer.setInteractionOption(option);
        PREPARE_POOL.execute((Runnable)executer);
    }

    private void complete() {
        String taskId = this.getTaskId();
        String result = OpBatchExecuter.getOperationResult((String)taskId);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            OperateOption option = this.getOption();
            option.setVariableValue("batchop_result", result);
            option.setVariableValue("batchop_completed", String.valueOf(true));
            this.getView().getParentView().invokeOperation(this.getOpKey(), option);
            this.getView().sendFormAction(this.getView().getParentView());
        }
        this.getView().close();
    }

    private String getTaskId() {
        return this.getPageCache().get(CACHEKEY_TASKID);
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put(CACHEKEY_TASKID, taskId);
    }

    private String getEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_ENTITYNUMBER);
    }

    protected String getOpKey() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_OPKEY);
    }

    private Set<Object> getPKIds() {
        List ids = (List)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_PKIDS);
        LinkedHashSet<Object> set = new LinkedHashSet<Object>(16);
        for (Object id : ids) {
            if (id instanceof Integer) {
                set.add(((Integer)id).longValue());
                continue;
            }
            set.add(id);
        }
        return set;
    }

    private ListSelectedRowCollection getListSelectedRows() {
        String str = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_LISTSELECTEDROWS);
        if (StringUtils.isBlank((CharSequence)str)) {
            return new ListSelectedRowCollection();
        }
        return (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)str, ListSelectedRowCollection.class);
    }

    protected OperateOption getOption() {
        OperateOption option = OperateOption.create();
        Map vars = (Map)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_OPERATEOPTION);
        if (vars != null) {
            for (Map.Entry entry : vars.entrySet()) {
                option.setVariableValue((String)entry.getKey(), (String)entry.getValue());
            }
        }
        option.setVariableValue(CUSTPARAM_PERMISSIONENTITYID, (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_PERMISSIONENTITYID));
        return option;
    }

    private int getBatchSize() {
        return (Integer)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_BATCHSIZE);
    }

    private void setProgressTip(String tip) {
        Label lblTip = (Label)this.getControl(KEY_LBLPROGRESS);
        lblTip.setText(tip);
    }

    protected boolean isTaskFinished() {
        String taskId = this.getTaskId();
        return StringUtils.isNotBlank((CharSequence)taskId) && OpBatchExecuter.isFinished((String)taskId);
    }

    private void releaseMutex() {
        Map variables = this.getOption().getVariables();
        try {
            if (variables != null && Boolean.TRUE.toString().equals(variables.get(NEED_RELEASE_MUTEX))) {
                Collection mutexEntityPKIdArr;
                String mutexEntityNumber = (String)variables.get(MUTEX_ENTITY_NUMBER);
                String mutexEntityPKIds = (String)variables.get(MUTEX_ENTITY_PKIDS);
                if (StringUtils.isNotBlank((CharSequence)mutexEntityNumber) && StringUtils.isNotBlank((CharSequence)mutexEntityPKIds) && (mutexEntityPKIdArr = (Collection)SerializationUtils.deSerializeFromBase64((String)mutexEntityPKIds)) != null) {
                    for (Object mutexEntityPKId : mutexEntityPKIdArr) {
                        MutexServiceHelper.release((String)mutexEntityNumber, (String)String.valueOf(mutexEntityPKId), (String)this.getOpKey());
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error("SITOpBatchExecutePlugin#releaseMutex, error info is: ", (Throwable)ex);
        }
    }

    public static boolean isBatchFinish(FormOperate formOperate) {
        return Boolean.parseBoolean(formOperate.getOption().getVariableValue("batchop_completed", String.valueOf(false)));
    }

    public static int getBatchSize(FormOperate formOperate) {
        String variableValue = formOperate.getOption().getVariableValue("batchop_batchsize", (String)null);
        if (StringUtils.isNotBlank((CharSequence)variableValue)) {
            return Integer.parseInt(variableValue);
        }
        DynamicObject billParamObj = ParameterReader.getBillParameter((String)formOperate.getEntityId());
        return billParamObj != null && billParamObj.getDataEntityType().getProperties().containsKey((Object)"opbatchcount") && billParamObj.get("opbatchcount") != null ? (Integer)billParamObj.get("opbatchcount") : 100;
    }

    public static FormShowParameter showOpBatchForm(FormOperate formOperate, int batchCount) {
        FormShowParameter showParameter = new FormShowParameter();
        String formId = formOperate.getOption().getVariableValue(OP_BATCH_EXECUTE_META, "sitbp_defaultbatchexecute");
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put(CUSTPARAM_ENTITYNUMBER, formOperate.getEntityId());
        showParameter.getCustomParams().put(CUSTPARAM_OPKEY, formOperate.getOperateKey());
        ListSelectedRowCollection listSelectedData = formOperate.getListSelectedData();
        if (listSelectedData == null) {
            listSelectedData = new ListSelectedRowCollection();
        }
        Set pkIds = listSelectedData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toCollection(LinkedHashSet::new));
        showParameter.getCustomParams().put(CUSTPARAM_PKIDS, pkIds.toArray());
        showParameter.getCustomParams().put(CUSTPARAM_LISTSELECTEDROWS, SerializationUtils.toJsonString((Object)formOperate.getListSelectedData()));
        showParameter.getCustomParams().put(CUSTPARAM_OPERATEOPTION, formOperate.getOption().getVariables());
        showParameter.getCustomParams().put(CUSTPARAM_BATCHSIZE, batchCount);
        showParameter.getCustomParams().put(CUSTPARAM_PERMISSIONENTITYID, formOperate.getPermissionEntityId());
        showParameter.getCustomParams().put("beginOpBatch", Boolean.TRUE);
        IFormView formView = formOperate.getView();
        if (formView != null) {
            String appId = formView.getFormShowParameter().getServiceAppId();
            showParameter.setAppId(appId);
            formView.showForm(showParameter);
        }
        return showParameter;
    }
}

