/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.formplugin.web;

import com.google.common.base.Strings;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.enums.YesOrNoEnum;

public class TaxFileSidePlugin
extends AbstractListPlugin
implements SetFilterListener {
    private static final String FLEX_EMPTY = "flexempty";
    private static final String BILLLISTAP = "billlistap";
    private static final String TBL_REFRESH = "tblrefresh";
    private static final String TOOLBARAP1 = "toolbarap1";
    private static final String CHX_IS_SHOW_LOGICDELETE = "isshowlogicdelete";
    private static final String TAXFILE = "taxfile";
    private static final String TBL_CLEAR = "tblclear";

    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getControl(BILLLISTAP);
        if (list != null) {
            list.addSetFilterListener((SetFilterListener)this);
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addItemClickListeners(new String[]{TOOLBARAP1});
    }

    public void afterBindData(EventObject event) {
        boolean hasNoTableAndNoData;
        boolean hasTable;
        super.afterBindData(event);
        BillList list = (BillList)this.getControl(BILLLISTAP);
        IListDataProvider provider = list.getListModel().getProvider();
        String entityName = provider.getEntityType().getName();
        String tableName = provider.getEntityType().getAlias();
        QFilter[] qFilters = (QFilter[])provider.getQFilters().stream().filter(qFilter -> !"datastatus".equals(qFilter.getProperty())).toArray(QFilter[]::new);
        boolean hasData = false;
        boolean bl = hasTable = !Strings.isNullOrEmpty((String)tableName);
        if (hasTable) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
            hasData = serviceHelper.isExists(qFilters);
        }
        if (null == this.getView().getPageCache().get("hasdata")) {
            this.getView().getPageCache().put("hasdata", String.valueOf(hasData));
        }
        boolean hasTableAndData = hasTable && !Boolean.parseBoolean(this.getView().getPageCache().get("hasdata"));
        boolean bl2 = hasNoTableAndNoData = !hasTable && list.getListModel().getDataCount() == 0;
        if (hasTableAndData || hasNoTableAndNoData) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(FLEX_EMPTY);
            showParameter.setFormId("sitbp_abandonnullpage");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (customParams != null) {
                showParameter.setCustomParams(customParams);
            }
            this.getView().showForm(showParameter);
            this.getView().setVisible(Boolean.FALSE, new String[]{BILLLISTAP});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_EMPTY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BILLLISTAP});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_EMPTY});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        switch (args.getProperty().getName()) {
            case "isshowlogicdelete": {
                BillList list = (BillList)this.getControl(BILLLISTAP);
                list.refreshData();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "tblrefresh": {
                BillList list = (BillList)this.getControl(BILLLISTAP);
                list.refreshData();
                list.clearSelection();
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent event) {
        boolean isShowLogicDelete = (Boolean)this.getModel().getValue(CHX_IS_SHOW_LOGICDELETE);
        BillList list = (BillList)this.getControl(BILLLISTAP);
        DataEntityPropertyCollection properties = list.getListModel().getDataEntityType().getProperties();
        if (properties.containsKey((Object)TAXFILE)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long taxFileId = (Long)customParams.get("taxfileid");
            String status = (String)customParams.get("status");
            event.addCustomQFilter(new QFilter("taxfile.boid", "=", (Object)taxFileId));
            if (properties.containsKey((Object)"status") && "C".equals(status)) {
                event.addCustomQFilter(new QFilter("status", "!=", (Object)"E"));
            }
            if (properties.containsKey((Object)"iscurrentversion")) {
                event.addCustomQFilter(new QFilter("iscurrentversion", "!=", (Object)YesOrNoEnum.YES.getCode()));
            }
        }
        if (properties.containsKey((Object)"hisversion")) {
            event.setOrderBy("hisversion desc");
        }
        if (!isShowLogicDelete && properties.containsKey((Object)"datastatus")) {
            event.addCustomQFilter(new QFilter("datastatus", "!=", (Object)"-2"));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.getView().setVisible(Boolean.FALSE, new String[]{TBL_CLEAR});
    }
}

