/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.formplugin.web.multiview;

import com.google.common.base.Strings;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.multiview.CombinePageCfgCacheService;
import kd.sit.sitbp.business.multiview.PageFrameLoadMetaHelper;
import kd.sit.sitbp.business.multiview.PageFrameShowFormUtils;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;

public class PageFrameHomePlugin
extends AbstractFormPlugin {
    private static final String PANEL_DYNPANELAP = "dynpanelap";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter showParameter = (FormShowParameter)args.getSource();
        Map customParams = showParameter.getCustomParams();
        Long cfgId = HRJSONUtils.getLongValOfCustomParam(customParams.get("cfgid"));
        FlexPanelAp dynamicPanelAp = PageFrameLoadMetaHelper.getInstance().createDynamicPanelAp(cfgId);
        HashMap<String, String> dynamicPanelMap = new HashMap<String, String>(16);
        dynamicPanelMap.put("id", PANEL_DYNPANELAP);
        dynamicPanelMap.put("items", (String)dynamicPanelAp.createControl().get("items"));
        args.getItems().add(dynamicPanelMap);
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        FormView formView = (FormView)args.getSource();
        Map<String, List<Map<String, Object>>> pageConfig = this.getPageCfg(this.getView());
        List<Map<String, Object>> siderEntryList = pageConfig.get("siderentry");
        if (null == siderEntryList || siderEntryList.size() == 0) {
            return;
        }
        for (Map<String, Object> siderPageInfo : siderEntryList) {
            String pageKey = String.valueOf(siderPageInfo.get("number"));
            if (!HRStringUtils.equals((String)pageKey, (String)args.getKey())) continue;
            Label siderLabel = new Label();
            siderLabel.setKey(pageKey);
            siderLabel.setView((IFormView)formView);
            siderLabel.addClickListener((ClickListener)this);
            args.setControl((Control)siderLabel);
            return;
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Label) {
            Label curClickLabel = (Label)evt.getSource();
            String labelName = curClickLabel.getKey();
            this.showRelatedPage(labelName);
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        FormView formView = (FormView)event.getSource();
        Map<String, List<Map<String, Object>>> pageConfig = this.getPageCfg(this.getView());
        if (null != pageConfig && pageConfig.size() > 0) {
            FlexPanelAp headPanelAp = PageFrameLoadMetaHelper.getInstance().createSiderPageInfoPanelAp(pageConfig);
            Container relatePanel = (Container)formView.getControl(PANEL_DYNPANELAP);
            relatePanel.getItems().addAll(((Container)headPanelAp.buildRuntimeControl()).getItems());
            formView.createControlIndex(relatePanel.getItems());
        }
    }

    public void afterBindData(EventObject event) {
        HRBaseServiceHelper helper;
        DynamicObject obj;
        super.afterBindData(event);
        Object mainDataId = this.getView().getFormShowParameter().getCustomParam("mainDataId");
        Object mainEntityNumber = this.getView().getFormShowParameter().getCustomParam("mainEntityNumber");
        if (mainEntityNumber != null && mainDataId != null && (obj = (helper = new HRBaseServiceHelper(String.valueOf(mainEntityNumber))).queryOriginalOne("status", (Object)Long.valueOf(String.valueOf(mainDataId)))) != null) {
            this.getView().getFormShowParameter().setCustomParam("mainStatus", (Object)obj.getString("status"));
        }
        this.showPageInContainer();
    }

    private void showPageInContainer() {
        Map<String, List<Map<String, Object>>> pageConfig = this.getPageCfg(this.getView());
        if (null != pageConfig && pageConfig.size() > 0) {
            HRPageCache pageCache = new HRPageCache(this.getView());
            HashMap<String, String> pageIds = new HashMap<String, String>(16);
            HashMap<String, String> targetKeys = new HashMap<String, String>(16);
            List<Map<String, Object>> topPageList = pageConfig.get("toppage");
            this.insertTopPagePanel(topPageList, pageIds, targetKeys);
            List<Map<String, Object>> mainPageList = pageConfig.get("mainentry");
            this.insertMainPagePanel(mainPageList, pageIds, targetKeys);
            List<Map<String, Object>> tabPageList = pageConfig.get("tabentry");
            List<Map<String, Object>> siderPageList = pageConfig.get("siderentry");
            this.insertTabPagePanel(tabPageList, pageIds, targetKeys);
            pageCache.put("pageids", pageIds);
            pageCache.put("targetKeys", targetKeys);
        }
    }

    private void insertTabPagePanel(List<Map<String, Object>> tabPageList, Map<String, String> pageIds, Map<String, String> targetKeys) {
        if (null == tabPageList || tabPageList.size() == 0) {
            return;
        }
        for (Map<String, Object> entityInfo : tabPageList) {
            if (1 == (Integer)entityInfo.get("seq")) continue;
            this.insertPanel(entityInfo, pageIds, targetKeys);
        }
    }

    private void insertMainPagePanel(List<Map<String, Object>> mainPageList, Map<String, String> pageIds, Map<String, String> targetKeys) {
        if (null == mainPageList || mainPageList.size() == 0) {
            return;
        }
        String firstEntity = String.valueOf(mainPageList.get(0).get("page"));
        for (Map<String, Object> entityInfo : mainPageList) {
            boolean hasPerm = this.checkPermission("47150e89000000ac", firstEntity);
            if (hasPerm) {
                this.insertPanel(entityInfo, pageIds, targetKeys);
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{String.valueOf(entityInfo.get("number"))});
        }
    }

    private boolean checkPermission(String permItemId, String entityName) {
        if (Strings.isNullOrEmpty((String)entityName)) {
            return false;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String serviceAppId = this.getView().getFormShowParameter().getCheckRightAppId();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_devportal_bizapp");
        DynamicObject appDy = helper.queryOne("id", new QFilter[]{new QFilter("number", "=", (Object)serviceAppId)});
        if (null == appDy) {
            return false;
        }
        return SITPermissionServiceHelper.hasPerm((long)userId, (String)appDy.getString("id"), (String)entityName, (String)permItemId);
    }

    private void insertTopPagePanel(List<Map<String, Object>> topPageList, Map<String, String> pageIds, Map<String, String> targetKeys) {
        if (null == topPageList || topPageList.size() == 0) {
            return;
        }
        Map<String, Object> entityInfo = topPageList.get(0);
        this.insertPanel(entityInfo, pageIds, targetKeys);
    }

    private void insertPanel(Map<String, Object> entityInfo, Map<String, String> pageIds, Map<String, String> targetKeys) {
        boolean hasPerm;
        String entityName = (String)entityInfo.get("page");
        if (HRStringUtils.equals((String)entityName, (String)"hcsi_sinsurfilestd") && !(hasPerm = this.checkPermission("47150e89000000ac", entityName))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{String.valueOf(entityInfo.get("number"))});
            return;
        }
        IFormView view = this.getView();
        String pageType = String.valueOf(entityInfo.get("pagetype"));
        String pageKey = String.valueOf(entityInfo.get("number"));
        String pageNumber = String.valueOf(entityInfo.get("page"));
        Map name = (Map)entityInfo.get("name");
        targetKeys.put(pageNumber, pageKey);
        switch (pageType) {
            case "1": {
                PageFrameShowFormUtils.showBaseForm((Map)name, (String)pageKey, (String)pageNumber, (IFormView)view, pageIds);
                break;
            }
            case "2": {
                PageFrameShowFormUtils.showList((Map)name, (String)pageKey, (String)pageNumber, (IFormView)view, pageIds);
                break;
            }
            case "3": {
                PageFrameShowFormUtils.showForm((Map)name, (String)pageKey, (String)pageNumber, (IFormView)view, pageIds);
                break;
            }
        }
    }

    private Map<String, List<Map<String, Object>>> getPageCfg(IFormView view) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        Long cfgId = HRJSONUtils.getLongValOfCustomParam(customParams.get("cfgid"));
        Map dynFileAllCnf = CombinePageCfgCacheService.getInstance().getCfg(cfgId);
        String pageJson = (String)dynFileAllCnf.get("PageJson");
        Map pageConfig = (Map)SerializationUtils.fromJsonString((String)pageJson, Map.class);
        return pageConfig;
    }

    private void showRelatedPage(String currentNumber) {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map<String, List<Map<String, Object>>> pageConfig = this.getPageCfg(view);
        List<Map<String, Object>> topPageList = pageConfig.get("toppage");
        List<Map<String, Object>> siderPageList = pageConfig.get("siderentry");
        List<Map<String, Object>> mainPageList = pageConfig.get("mainentry");
        String firstPermissionEntity = CollectionUtils.isEmpty(mainPageList) ? "" : String.valueOf(mainPageList.get(0).get("page"));
        Map<String, Object> currentSider = null;
        for (Map<String, Object> siderMap : siderPageList) {
            String number = String.valueOf(siderMap.get("number"));
            if (!currentNumber.equals(number)) continue;
            if (this.checkPermission("47150e89000000ac", firstPermissionEntity)) {
                currentSider = siderMap;
                continue;
            }
            return;
        }
        if (null == currentSider) {
            return;
        }
        FormShowParameter pageFormShowParameter = new FormShowParameter();
        pageFormShowParameter.setCustomParams(formShowParameter.getCustomParams());
        pageFormShowParameter.setCustomParam("currentRelatePage", (Object)String.valueOf(currentSider.get("number")));
        pageFormShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        pageFormShowParameter.setCustomParam("toppage", (Object)SerializationUtils.toJsonString(topPageList));
        pageFormShowParameter.setCustomParam("parentpageid", (Object)this.getView().getPageId());
        pageFormShowParameter.setCustomParam("siderentry", (Object)SerializationUtils.toJsonString(siderPageList));
        pageFormShowParameter.setFormId("sitbs_siderrelatepage");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String name = (String)customParams.get("name");
        String caption = ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u5173\u8054\u4fe1\u606f", (String)"PageFrameHomePlugin_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)name)) {
            pageFormShowParameter.setCaption(caption);
        } else {
            pageFormShowParameter.setCaption(caption + " - " + name);
        }
        view.showForm(pageFormShowParameter);
    }
}

