/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.formplugin.web.multiview;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.JSONUtils;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.multiview.PageFrameLoadMetaHelper;
import kd.sit.sitbp.business.multiview.PageFrameShowFormUtils;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.YesOrNoEnum;

public class TaxFileRelatePagePlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(TaxFileRelatePagePlugin.class);
    private static final String MAINPAGE_PANEL = "mainpagepanel";
    private static final String BASEINFO_PANEL = "baseinfopanel";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter showParameter = (FormShowParameter)args.getSource();
        FlexPanelAp relatePagePanelAp = PageFrameLoadMetaHelper.getInstance().createRelatePagePanelAp(showParameter);
        HashMap<String, String> relatePanelMap = new HashMap<String, String>(16);
        relatePanelMap.put("id", "flexpanelrelateinfo");
        relatePanelMap.put("items", (String)relatePagePanelAp.createControl().get("items"));
        args.getItems().add(relatePanelMap);
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        FormView formView = (FormView)event.getSource();
        FlexPanelAp relatePagePanelAp = PageFrameLoadMetaHelper.getInstance().createRelatePagePanelAp(formView.getFormShowParameter());
        Container relatePanel = (Container)this.getView().getControl("flexpanelrelateinfo");
        relatePanel.getItems().addAll(((Container)relatePagePanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(relatePanel.getItems());
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        IFormView view = this.getView();
        String number = (String)view.getFormShowParameter().getCustomParam("currentRelatePage");
        this.showRelatePageInContainer(number);
        PageFrameLoadMetaHelper.getInstance().setSelectStyle(number, view);
        this.setPreviewPanel();
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        List<Map<String, Object>> siderPageList = this.getSiderPageList();
        for (Map<String, Object> siderMap : siderPageList) {
            String regNumber = String.valueOf(siderMap.get("number"));
            if (!HRStringUtils.equals((String)regNumber, (String)args.getKey())) continue;
            Label relateLabel = new Label();
            relateLabel.setKey(regNumber);
            relateLabel.setView(this.getView());
            relateLabel.addClickListener((ClickListener)this);
            args.setControl((Control)relateLabel);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Label) {
            Label curClickLabel = (Label)evt.getSource();
            String labelName = curClickLabel.getKey();
            PageFrameLoadMetaHelper.getInstance().setSelectStyle(labelName, this.getView());
            this.showRelatePageInContainer(labelName);
        }
    }

    private void setPreviewPanel() {
        IFormView view = this.getView();
        String topPageInfo = (String)view.getFormShowParameter().getCustomParam("toppage");
        if (StringUtils.isBlank((CharSequence)topPageInfo)) {
            return;
        }
        List topPageList = (List)SerializationUtils.fromJsonString((String)topPageInfo, List.class);
        Map headInfo = (Map)topPageList.get(0);
        String pageNumber = String.valueOf(headInfo.get("page"));
        HashMap pageIds = new HashMap(16);
        Map name = (Map)headInfo.get("name");
        PageFrameShowFormUtils.showForm((Map)name, (String)BASEINFO_PANEL, (String)pageNumber, (IFormView)view, pageIds);
        HRPageCache pageCache = new HRPageCache(this.getView());
        pageCache.put("pageids", pageIds);
    }

    private List<Map<String, Object>> getSiderPageList() {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String siderInfo = (String)formShowParameter.getCustomParam("siderentry");
        return (List)SerializationUtils.fromJsonString((String)siderInfo, List.class);
    }

    private void showRelatePageInContainer(String regNumber) {
        List<Map<String, Object>> siderPageList = this.getSiderPageList();
        Map<String, Object> currentSider = null;
        for (Map<String, Object> siderMap : siderPageList) {
            String number = String.valueOf(siderMap.get("number"));
            if (!regNumber.equals(number)) continue;
            currentSider = siderMap;
        }
        if (currentSider == null) {
            return;
        }
        String pageType = String.valueOf(currentSider.get("pagetype"));
        String page = String.valueOf(currentSider.get("page"));
        Long userId = RequestContext.get().getCurrUserId();
        String appId = this.getAppId();
        boolean hasPerm = SITPermissionServiceHelper.hasPerm((long)userId, (String)appId, (String)page, (String)"2A5WA/Z4YAET");
        if (!hasPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u67e5\u8be2\u5386\u53f2\u7248\u672c\u4fe1\u606f\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxFileRelatePagePlugin_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        Map name = (Map)currentSider.get("name");
        switch (pageType) {
            case "1": {
                this.showBaseDataForm(name, page);
                break;
            }
            case "2": {
                this.showList(name, page);
                break;
            }
            case "3": {
                this.showDYForm(name, page);
                break;
            }
        }
    }

    private String getAppId() {
        String appNumber;
        switch (appNumber = this.getView().getFormShowParameter().getCheckRightAppId()) {
            case "hcsi": {
                return "2AXKDRPJUQ77";
            }
            case "itc": {
                return "17/+CT1QBPNP";
            }
        }
        return null;
    }

    private void showDYForm(Map<String, String> name, String page) {
        FormShowParameter dyFormShowParameter = new FormShowParameter();
        dyFormShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        dyFormShowParameter.getOpenStyle().setTargetKey(MAINPAGE_PANEL);
        dyFormShowParameter.setFormId(page);
        dyFormShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        dyFormShowParameter.setCustomParam("pageName", name);
        this.getView().showForm(dyFormShowParameter);
    }

    private void showList(Map<String, String> name, String page) {
        QFilter qFilter1;
        Object parentRelateIds;
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey(MAINPAGE_PANEL);
        listShowParameter.setBillFormId(page);
        listShowParameter.setLookUp(false);
        listShowParameter.setCustomParam("type", (Object)"list");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        listShowParameter.setCustomParams(customParams);
        listShowParameter.setCustomParam("pageName", name);
        listShowParameter.setCustomParam("option", (Object)"showhisversion");
        listShowParameter.setCustomParam("hisinfolist", (Object)"hisinfolist");
        listShowParameter.setCustomParam("removeHrDatastatusFilter", (Object)Boolean.TRUE);
        IFormView parentView = this.getView().getParentView();
        JSONObject relateFileIds = parentView != null && (parentRelateIds = parentView.getFormShowParameter().getCustomParam("relateFileIds")) instanceof JSONObject ? (JSONObject)parentRelateIds : (JSONObject)customParams.get("relateFileIds");
        customParams.put("relateFileIds", relateFileIds);
        if (relateFileIds == null) {
            return;
        }
        try {
            LOG.info("TaxFileRelatePagePlugin.showList.relateFileIds:{}", (Object)JSONUtils.toString((Object)relateFileIds));
        }
        catch (IOException e) {
            LOG.error("JSONUtils", (Throwable)e);
        }
        boolean isByFile = false;
        try {
            Long taxFileId;
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)page);
            if (entityType.getProperties().containsKey((Object)"taxfile") && (taxFileId = (Long)customParams.get("taxfileid")) != null && taxFileId != 0L) {
                qFilter1 = new QFilter("taxfile.boid", "=", (Object)taxFileId);
                listShowParameter.getListFilterParameter().getQFilters().add(qFilter1);
                isByFile = true;
            }
        }
        catch (Exception ex) {
            LOG.error("Error occurs when showList", (Throwable)ex);
        }
        Object pageDataId = relateFileIds.get((Object)page.replace("sideview", ""));
        if (!isByFile && pageDataId != null) {
            Long boId = Long.parseLong(String.valueOf(pageDataId));
            listShowParameter.setCustomParam("boid", (Object)boId);
            qFilter1 = new QFilter("boid", "=", (Object)boId);
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter1);
        }
        QFilter qFilter2 = new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.NO.getCode());
        listShowParameter.getListFilterParameter().getQFilters().add(qFilter2);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showBaseDataForm(Map<String, String> name, String page) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(page);
        baseShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        baseShowParameter.setCustomParam("pageName", name);
        baseShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        baseShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        baseShowParameter.setStatus(OperationStatus.ADDNEW);
        baseShowParameter.getOpenStyle().setTargetKey(MAINPAGE_PANEL);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }
}

