/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.algo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.business.algo.TaxDataBaseAlgoHandler;
import kd.sit.sitbp.common.api.algo.AlgoHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.AlgoHandlerEnum;
import kd.sit.sitbp.common.model.algo.TaxDataDynObjWrapper;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;

public class TaxDataAlgoServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(TaxDataAlgoServiceHelper.class);

    public static BaseResult<DynamicObject> dealTaxDataAndSrc(TaxTaskEntity taxTaskEntity, DynamicObject taxData, List<DynamicObject> srcDataList, AlgoHandlerEnum algoHandlerEnum) {
        LOGGER.info("Trace by Quinn: dealTaxDataAndSrc", taxData.get("id"), (Object)algoHandlerEnum.getAlgoCode());
        BaseResult algoHandlerResult = AlgoHandler.genAlgoHandler((String)algoHandlerEnum.getAlgoCode());
        if (!algoHandlerResult.isSuccess()) {
            return BaseResult.fail((String)algoHandlerResult.getMessage());
        }
        ArrayList srcDataWrappers = new ArrayList(srcDataList.size());
        srcDataList.forEach(obj -> srcDataWrappers.add(new TaxDataDynObjWrapper(obj)));
        HashMap<String, TaxTaskEntity> param = new HashMap<String, TaxTaskEntity>(2);
        param.put(TaxDataBaseAlgoHandler.PARA_TAXTASK, taxTaskEntity);
        LOGGER.info("Trace by Quinn: dealTaxDataAndSrc handleData", taxData.get("id"), (Object)algoHandlerEnum.getAlgoCode());
        return ((AlgoHandler)algoHandlerResult.getData()).handleData((Object)new TaxDataDynObjWrapper(taxData), srcDataWrappers, param);
    }

    public static BatchResult<DynamicObject> batchDealTaxDataAndSrc(TaxTaskEntity taxTaskEntity, List<DynamicObject> taxDataList, Map<Long, List<DynamicObject>> srcDataMap, AlgoHandlerEnum algoHandlerEnum) {
        BatchResult batchResult = new BatchResult(true, new ArrayList<DynamicObject>(taxDataList));
        if (CollectionUtils.isEmpty(taxDataList) || CollectionUtils.isEmpty(srcDataMap)) {
            return batchResult;
        }
        for (DynamicObject taxData : taxDataList) {
            BaseResult<DynamicObject> baseResult = TaxDataAlgoServiceHelper.dealTaxDataAndSrc(taxTaskEntity, taxData, srcDataMap.get(taxData.getLong("id")), algoHandlerEnum);
            if (baseResult == null || baseResult.isSuccess()) continue;
            batchResult.successItemToFail((Object)taxData, baseResult.getMessage());
        }
        return batchResult;
    }
}

