/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.algo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.api.algo.AlgoHandler;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.AlgoHandleResultEnum;
import kd.sit.sitbp.common.enums.CalTaxTypeEnum;
import kd.sit.sitbp.common.model.algo.TaxDataDynObjWrapper;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;

public abstract class TaxDataBaseAlgoHandler
implements AlgoHandler<Long, TaxDataDynObjWrapper> {
    private static final Log LOGGER = LogFactory.getLog(TaxDataBaseAlgoHandler.class);
    public static String PARA_TAXTASK = "para_taxTask";

    public BatchResult<DynamicObject> handleData(List<TaxDataDynObjWrapper> taxDatas, Map<Long, List<TaxDataDynObjWrapper>> srcDataMap, Map<String, Object> param) {
        if (CollectionUtils.isEmpty(taxDatas) || CollectionUtils.isEmpty(srcDataMap)) {
            return null;
        }
        BatchResult batchResult = new BatchResult(true, new ArrayList(taxDatas.size()));
        for (TaxDataDynObjWrapper taxDataWrapper : taxDatas) {
            List<TaxDataDynObjWrapper> srcDataWrapperList;
            BaseResult<DynamicObject> baseResult = this.handleData(taxDataWrapper, srcDataWrapperList = srcDataMap.get(taxDataWrapper.getData().getLong("id")), param);
            if (baseResult != null && !baseResult.isSuccess()) {
                batchResult.addFailItem((Object)taxDataWrapper.getData(), baseResult.getMessage());
                continue;
            }
            batchResult.addSuccessResult((Object)taxDataWrapper.getData());
        }
        return batchResult;
    }

    public BaseResult<DynamicObject> handleData(TaxDataDynObjWrapper taxDataWrapper, List<TaxDataDynObjWrapper> srcDataWrapperList, Map<String, Object> param) {
        LOGGER.info("Trace by Quinn: handleData start");
        if (taxDataWrapper == null || CollectionUtils.isEmpty(srcDataWrapperList)) {
            return BaseResult.success(null);
        }
        LOGGER.info("Trace by Quinn: handleData not Null");
        try {
            TaxTaskEntity taxTaskEntity = (TaxTaskEntity)param.get(PARA_TAXTASK);
            Map<Long, String> netTaxAlgoMap = this.getNetTaxAlgoMap(param, taxTaskEntity);
            Map<Long, TaxItemEntity> taxItemMap = this.getTaxItemMap(param, taxTaskEntity);
            Map splitAlgoMap = taxTaskEntity.getTaxItemSplitEntityMapMap();
            LOGGER.info("Trace by Quinn: handleData getTaxItemSplitEntityMapMap");
            DynamicObject taxData = taxDataWrapper.getData();
            Map taxDataEntryMap = taxDataWrapper.getEntryMap();
            if (CollectionUtils.isEmpty((Map)taxDataEntryMap)) {
                return BaseResult.success((Object)taxData);
            }
            LOGGER.info("Trace by Quinn: handleData taxDataEntryMap");
            long taxCategoryId = taxData.getLong("taxcategory.id") == 0L ? taxData.getLong("taxcategory") : taxData.getLong("taxcategory.id");
            Map splitEntityMap = (Map)splitAlgoMap.get(taxCategoryId);
            ArrayList<TaxDataDynObjWrapper> validSrcDataWrappers = new ArrayList<TaxDataDynObjWrapper>(srcDataWrapperList.size());
            ArrayList<TaxDataDynObjWrapper> invalidSrcDataWrappers = new ArrayList<TaxDataDynObjWrapper>(srcDataWrapperList.size());
            for (TaxDataDynObjWrapper taxDataDynObjWrapper : srcDataWrapperList) {
                if (this.isValidSrcData(taxDataDynObjWrapper)) {
                    validSrcDataWrappers.add(taxDataDynObjWrapper);
                    continue;
                }
                invalidSrcDataWrappers.add(taxDataDynObjWrapper);
            }
            LOGGER.info("Trace by Quinn: handleData isValidSrcData");
            this.beforeLoopTaxDataItem(taxDataWrapper, validSrcDataWrappers, invalidSrcDataWrappers);
            LOGGER.info("Trace by Quinn: handleData beforeLoopTaxDataItem");
            for (Map.Entry entry : taxDataEntryMap.entrySet()) {
                Long taxItemId = (Long)entry.getKey();
                DynamicObject taxDataItem = (DynamicObject)entry.getValue();
                TaxItemEntity taxItem = taxItemMap.get(taxItemId);
                if (taxItem == null) {
                    BaseResult.fail((String)AlgoHandleResultEnum.TAXITEM_CONFIG_FAIL.loadKDString(new Object[]{taxData.get("taxfile.number"), taxData.get("taxfile.person.name"), taxDataItem.getString("taxitem.name")}));
                    continue;
                }
                if (!this.isValidDataItem(taxDataItem, taxItem)) continue;
                String splitAlgo = this.getSplitAlgo(splitEntityMap, taxItemId, taxItem);
                if (StringUtils.isEmpty((CharSequence)splitAlgo)) {
                    BaseResult.fail((String)AlgoHandleResultEnum.SPLIT_CONFIG_FAIL.loadKDString(new Object[]{taxData.get("taxfile.number"), taxData.get("taxfile.person.name"), taxDataItem.getString("taxitem.name")}));
                    continue;
                }
                ArrayList<DynamicObject> validSrcDataItems = new ArrayList<DynamicObject>(validSrcDataWrappers.size());
                for (TaxDataDynObjWrapper validSrcDataWrapper : validSrcDataWrappers) {
                    DynamicObject srcDataItem = validSrcDataWrapper.getEntry(taxItemId);
                    if (srcDataItem == null) {
                        srcDataItem = validSrcDataWrapper.addNewEntry("taxitem", taxItemId);
                        srcDataItem.set("entryyearmonth", taxDataItem.get("entryyearmonth"));
                        srcDataItem.set("datadirect", (Object)CalTaxTypeEnum.NOFEEDBACK.getCode());
                    }
                    validSrcDataItems.add(srcDataItem);
                }
                if (CollectionUtils.isEmpty(validSrcDataItems)) continue;
                if (this.isValueNull(taxDataItem)) {
                    this.afterValueIsNull(taxDataItem, validSrcDataItems, taxItem);
                    continue;
                }
                taxDataWrapper.setNetTaxAlgo(netTaxAlgoMap.get(taxCategoryId));
                BaseResult<DynamicObject> itemResult = this.doAlgo(taxDataItem, validSrcDataItems, taxDataWrapper, validSrcDataWrappers, invalidSrcDataWrappers, taxItem, splitAlgo);
                if (itemResult.isSuccess()) continue;
                return BaseResult.fail((String)itemResult.getMessage());
            }
            return BaseResult.success((Object)taxData);
        }
        catch (Exception e) {
            LOGGER.error("Trace By Quinn", (Throwable)e);
            return BaseResult.fail((String)ResManager.loadKDString((String)"\u62c6\u5206\u7b97\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"TaxDataBaseAlgoHandler_0", (String)"sit-sitbp-business", (Object[])new Object[0]));
        }
    }

    protected boolean isValueNull(DynamicObject taxDataItem) {
        return StringUtils.isEmpty((CharSequence)taxDataItem.getString("itemvalue"));
    }

    protected void afterValueIsNull(DynamicObject taxDataItem, List<DynamicObject> validSrcDataItems, TaxItemEntity taxItem) {
    }

    protected Map<Long, String> getNetTaxAlgoMap(Map<String, Object> param, TaxTaskEntity taxTaskEntity) {
        return taxTaskEntity.getNetTaxAlgoMap();
    }

    protected Map<Long, TaxItemEntity> getTaxItemMap(Map<String, Object> param, TaxTaskEntity taxTaskEntity) {
        return taxTaskEntity.getTaxItemMap();
    }

    protected void beforeLoopTaxDataItem(TaxDataDynObjWrapper taxDataWrapper, List<TaxDataDynObjWrapper> validSrcDataWrappers, List<TaxDataDynObjWrapper> invalidSrcDataWrappers) {
    }

    protected abstract boolean isValidSrcData(TaxDataDynObjWrapper var1);

    protected abstract boolean isValidDataItem(DynamicObject var1, TaxItemEntity var2);

    protected abstract BaseResult<DynamicObject> doAlgo(DynamicObject var1, List<DynamicObject> var2, TaxDataDynObjWrapper var3, List<TaxDataDynObjWrapper> var4, List<TaxDataDynObjWrapper> var5, TaxItemEntity var6, String var7);

    private String getSplitAlgo(Map<Long, String> splitEntityMap, Long taxItemId, TaxItemEntity taxItem) {
        String splitAlgo = "";
        if (splitEntityMap != null) {
            splitAlgo = splitEntityMap.get(taxItemId);
        }
        if (StringUtils.isEmpty((CharSequence)splitAlgo)) {
            splitAlgo = taxItem.getSplitAlgo();
        }
        return splitAlgo;
    }
}

