/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.algo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.business.algo.TaxDataBaseAlgoHandler;
import kd.sit.sitbp.common.api.MergeAlgorithm;
import kd.sit.sitbp.common.api.MergeAlgorithmParamInitializer;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.enums.CalTaxTypeEnum;
import kd.sit.sitbp.common.enums.SplitAlgoEnum;
import kd.sit.sitbp.common.model.algo.TaxDataDynObjWrapper;
import kd.sit.sitbp.common.util.BaseResult;

public abstract class TaxDataMergerAlgoHandler
extends TaxDataBaseAlgoHandler {
    private static Map<String, String> algoCodeMap = new HashMap<String, String>(2);

    @Override
    protected BaseResult<DynamicObject> doAlgo(DynamicObject taxDataItem, List<DynamicObject> validSrcDataItems, TaxDataDynObjWrapper taxDataWrapper, List<TaxDataDynObjWrapper> validSrcDataWrappers, List<TaxDataDynObjWrapper> invalidSrcDataWrappers, TaxItemEntity taxItem, String splitAlgoCode) {
        this.dealValidData(taxDataItem, validSrcDataItems, taxItem);
        return this.mergeInvalidData(taxDataItem, invalidSrcDataWrappers, splitAlgoCode);
    }

    protected void dealValidData(DynamicObject taxDataItem, List<DynamicObject> validSrcDataItems, TaxItemEntity taxItem) {
        taxDataItem.set("itemvalue", null);
        if (CalTaxTypeEnum.fromTaxById((long)taxItem.getCaltaxtypeId())) {
            validSrcDataItems.forEach(obj -> obj.set("itemvalue", null));
        }
    }

    protected BaseResult<DynamicObject> mergeInvalidData(DynamicObject taxDataItem, List<TaxDataDynObjWrapper> invalidSrcDataWrappers, String splitAlgoCode) {
        long taxItemId = taxDataItem.getLong("taxitem.id");
        ArrayList<DynamicObject> invalidSrcDataItems = new ArrayList<DynamicObject>(invalidSrcDataWrappers.size());
        for (TaxDataDynObjWrapper obj : invalidSrcDataWrappers) {
            DynamicObject entry = obj.getEntry(Long.valueOf(taxItemId));
            if (entry == null) continue;
            invalidSrcDataItems.add(entry);
        }
        if (CollectionUtils.isEmpty(invalidSrcDataItems)) {
            return BaseResult.success((Object)taxDataItem);
        }
        BaseResult mergeAlgorithmResult = MergeAlgorithm.genAlgorithm((String)algoCodeMap.get(splitAlgoCode));
        if (!mergeAlgorithmResult.isSuccess()) {
            return BaseResult.fail((String)mergeAlgorithmResult.getMessage());
        }
        MergeAlgorithm mergeAlgorithm = (MergeAlgorithm)mergeAlgorithmResult.getData();
        HashMap params = new HashMap(4);
        for (int i = 0; i < invalidSrcDataItems.size(); ++i) {
            DynamicObject srcItem = (DynamicObject)invalidSrcDataItems.get(i);
            if (srcItem == null) continue;
            mergeAlgorithm.genParams((Object)taxDataItem, (Object)srcItem, params, this.getAlgoParamInitializer());
            BaseResult mergeResult = mergeAlgorithm.merge((Object)taxDataItem, (Object)srcItem, params);
            if (mergeResult.isSuccess()) continue;
            return mergeResult;
        }
        return BaseResult.success((Object)taxDataItem);
    }

    protected abstract MergeAlgorithmParamInitializer getAlgoParamInitializer();

    static {
        algoCodeMap.put(SplitAlgoEnum.BY_SRC_PROPORTION.getAlgoCode(), "sumMerge");
        algoCodeMap.put(SplitAlgoEnum.NONE_SPLIT.getAlgoCode(), "latestMerge");
    }
}

