/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.algo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.sit.sitbp.business.algo.TaxDataBaseAlgoHandler;
import kd.sit.sitbp.common.api.algo.SplitAlgo;
import kd.sit.sitbp.common.api.algo.SplitAlgoParamInitializer;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.enums.SplitAlgoEnum;
import kd.sit.sitbp.common.model.algo.SplitInfo;
import kd.sit.sitbp.common.model.algo.TaxDataDynObjWrapper;
import kd.sit.sitbp.common.util.BaseResult;

public abstract class TaxDataSplitAlgoHandler
extends TaxDataBaseAlgoHandler {
    @Override
    protected BaseResult<DynamicObject> doAlgo(DynamicObject taxDataItem, List<DynamicObject> validSrcDataItems, TaxDataDynObjWrapper taxDataWrapper, List<TaxDataDynObjWrapper> validSrcDataWrappers, List<TaxDataDynObjWrapper> invalidSrcDataWrappers, TaxItemEntity taxItem, String splitAlgoCode) {
        BaseResult splitAlgoResult = SplitAlgo.genSplitAlgo((String)splitAlgoCode);
        if (!splitAlgoResult.isSuccess()) {
            return BaseResult.fail((String)splitAlgoResult.getMessage());
        }
        Map<String, Object> param = this.prepareParams(splitAlgoCode, taxItem, taxDataWrapper, validSrcDataWrappers, invalidSrcDataWrappers);
        SplitAlgo splitAlgo = (SplitAlgo)splitAlgoResult.getData();
        splitAlgo.genParams((Object)taxDataItem, validSrcDataItems, param, this.getAlgoParamInitializer());
        return splitAlgo.split((Object)taxDataItem, validSrcDataItems, param);
    }

    protected Map<String, Object> prepareParams(String splitAlgoCode, TaxItemEntity taxItem, TaxDataDynObjWrapper taxDataWrapper, List<TaxDataDynObjWrapper> validSrcDataWrappers, List<TaxDataDynObjWrapper> invalidSrcDataWrappers) {
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        if (StringUtils.equals((CharSequence)splitAlgoCode, (CharSequence)SplitAlgoEnum.BY_SRC_PROPORTION.getAlgoCode())) {
            SplitInfo splitInfo = this.buildSplitInfo(taxItem, taxDataWrapper, validSrcDataWrappers, invalidSrcDataWrappers);
            param.put("para_splitInfo", splitInfo);
        }
        return param;
    }

    protected abstract SplitInfo buildSplitInfo(TaxItemEntity var1, TaxDataDynObjWrapper var2, List<TaxDataDynObjWrapper> var3, List<TaxDataDynObjWrapper> var4);

    protected abstract SplitAlgoParamInitializer getAlgoParamInitializer();
}

