/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.algo.split;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.sitbp.business.algo.split.AbstractSplitAlgo;
import kd.sit.sitbp.common.api.algo.SplitValueHandler;
import kd.sit.sitbp.common.model.algo.SplitInfo;
import kd.sit.sitbp.common.util.BaseResult;

public class ByProportionAlgo<T>
extends AbstractSplitAlgo<T> {
    private static final Log LOGGER = LogFactory.getLog(ByProportionAlgo.class);
    public static final String PARA_SPLITINFO = "para_splitInfo";

    public BaseResult<T> split(T targetData, List<T> srcDates, Map<String, Object> param) {
        SplitValueHandler valueHandler = (SplitValueHandler)param.get("SPLIT_VALUE_HANDLER");
        SplitInfo splitInfo = (SplitInfo)param.get(PARA_SPLITINFO);
        if (splitInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62c6\u5206\u6bd4\u4f8b\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"ByProportionAlgo_0", (String)"", (Object[])new Object[0]));
        }
        BigDecimal ratioDenominator = splitInfo.getRatioDenominator();
        BigDecimal totalValue = splitInfo.getTotalValue();
        int scale = splitInfo.getScale();
        int dataRound = splitInfo.getDataRound();
        boolean isZero = false;
        if (totalValue.compareTo(BigDecimal.ZERO) == 0) {
            isZero = true;
        }
        BigDecimal allocatedValue = BigDecimal.ZERO;
        for (int i = 0; i < srcDates.size(); ++i) {
            BigDecimal value;
            T srcData = srcDates.get(i);
            if (isZero) {
                valueHandler.setValue(srcData, (Object)totalValue);
                continue;
            }
            if (i == srcDates.size() - 1) {
                value = totalValue.subtract(allocatedValue);
            } else if (ratioDenominator.compareTo(BigDecimal.ZERO) == 0) {
                value = BigDecimal.ZERO;
            } else {
                BigDecimal ratioNumerator = splitInfo.getRatioNumerator(valueHandler.getKey(srcData));
                if (ratioNumerator == null) {
                    ratioNumerator = BigDecimal.ZERO;
                }
                value = totalValue.multiply(ratioNumerator).divide(ratioDenominator, scale, dataRound);
                allocatedValue = allocatedValue.add(value);
            }
            valueHandler.setValue(srcData, (Object)value);
        }
        return BaseResult.success(targetData);
    }
}

