/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.basecal;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.hr.hbp.business.service.formula.cal.vo.FormulaVO;
import kd.hr.hbp.business.service.formula.cal.vo.FunctionVO;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sit.hcsi.common.entity.basecal.BaseCalFormulaEntity;
import kd.sdk.sit.hcsi.common.entity.basecal.BaseCalParam;
import kd.sdk.sit.sitbp.entity.Pair;
import kd.sdk.sit.sitbp.service.spi.SInsurCalItemUniCodeResolver;
import kd.sit.sitbp.business.coderule.CodeRuleHelper;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.common.util.SITStringUtils;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class BaseCalHelper {
    private static final Log log = LogFactory.getLog(BaseCalHelper.class);

    public static Map<Long, Long> getWelfarepayerRulevRelByBsed(Collection<Long> welFarepayerIds, Date bsed) {
        HRBaseServiceHelper welfarepayerHelper = new HRBaseServiceHelper("sitbs_welfarepayer");
        DynamicObjectCollection welfarepayerColl = welfarepayerHelper.queryOriginalCollection("id,basecalrule.id", new QFilter("id", "in", welFarepayerIds).toArray());
        Map<Long, Long> welfarepayerRuleMap = welfarepayerColl.stream().filter(o -> o.getLong("basecalrule.id") != 0L).collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getLong("basecalrule.id"), (v1, v2) -> v1));
        HRBaseServiceHelper basecalruleHelper = new HRBaseServiceHelper("sitbs_basecalrule");
        QFilter qFilter = new QFilter("boid", "in", welfarepayerRuleMap.values());
        BaseDataHisHelper.addHisVerFilter(qFilter);
        qFilter.and("bsed", "<=", (Object)bsed);
        qFilter.and("bsled", ">=", (Object)bsed);
        qFilter.and("datastatus", "in", Arrays.asList("1", "2", "0"));
        DynamicObjectCollection calrulevs = basecalruleHelper.queryOriginalCollection("id,boid,bsed,bsled", qFilter.toArray());
        Map<Long, Long> ruleVersionMap = calrulevs.stream().collect(Collectors.toMap(o -> o.getLong("boid"), o -> o.getLong("id"), (v1, v2) -> v1));
        HashMap<Long, Long> welfarepayerRulevMap = new HashMap<Long, Long>(welfarepayerRuleMap.size());
        for (Map.Entry<Long, Long> entry : welfarepayerRuleMap.entrySet()) {
            Long welfarepayerId = entry.getKey();
            Long ruleId = entry.getValue();
            Long rulevid = ruleVersionMap.get(ruleId);
            if (rulevid == null) continue;
            welfarepayerRulevMap.put(welfarepayerId, rulevid);
        }
        return welfarepayerRulevMap;
    }

    public static long createBaseCalRecord(Map<Long, List<Long>> welfarepayerFileMap, Date bsed, String caltype) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_basecalrecord");
        DynamicObject record = helper.generateEmptyDynamicObject();
        int total = 1;
        if (welfarepayerFileMap != null) {
            total = welfarepayerFileMap.values().stream().mapToInt(List::size).sum();
        }
        String number = null;
        try {
            number = CodeRuleHelper.getNumber(record, String.valueOf(RequestContext.get().getOrgId()));
        }
        catch (Exception exception) {
            log.error("createBaseCalRecord", (Throwable)exception);
        }
        record.set("number", (Object)number);
        record.set("total", (Object)total);
        record.set("caltype", (Object)caltype);
        record.set("bsed", (Object)bsed);
        record.set("starttime", (Object)new Date());
        helper.saveOne(record);
        return record.getLong("id");
    }

    public static DynamicObject queryRecord(Long recordId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_basecalrecord");
        DynamicObject record = helper.queryOne((Object)recordId);
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCalRecord(Long recordId, int success, int fail) {
        String lockKey = "_updateBaseCalRecordCount_" + recordId;
        DLock lock = DLock.create((String)lockKey);
        try {
            if (lock.tryLock(120000L)) {
                HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_basecalrecord");
                DynamicObject record = helper.queryOne((Object)recordId);
                int dbSuccess = record.getInt("success");
                int dbFail = record.getInt("fail");
                int total = record.getInt("total");
                int newSuccess = dbSuccess + success;
                int newFail = fail + dbFail;
                record.set("success", (Object)newSuccess);
                record.set("fail", (Object)newFail);
                if (newSuccess + newFail >= total) {
                    Date enddate = new Date();
                    Date starttime = record.getDate("starttime");
                    record.set("endtime", (Object)enddate);
                    record.set("time", (Object)BaseCalHelper.getTimeStr(starttime, enddate));
                }
                helper.saveOne(record);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void addCalLog() {
        AppLogInfo log = new AppLogInfo();
        log.setBizAppID("2AXKDRPJUQ77");
        log.setBizObjID("hcsi_sinsurfile");
        log.setOpName(ResManager.loadKDString((String)"\u6309\u89c4\u5219\u8ba1\u7b97\u57fa\u6570", (String)"BaseCalHelper_4", (String)"sit-sitbp-business", (Object[])new Object[0]));
        log.setOpDescription(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b8c\u6210", (String)"BaseCalHelper_5", (String)"sit-sitbp-business", (Object[])new Object[0]));
        LogServiceHelper.addLog((AppLogInfo)log);
    }

    public static void assembleCalFormulaVO(DynamicObject formulaDynamicObj, BaseCalFormulaEntity formulaEntity, BaseCalParam param) {
        Map dependMap = formulaEntity.computeDependentMapIfAbsent(8);
        BaseCalHelper.addDependencyItem(dependMap, formulaDynamicObj, "dependentcalitem", "dependentcalitemforfunc", "resultitemuniquecode", "dependentcalitemfordg");
        HashMap<String, CalItemVO> uniqueCodeCalItemMap = new HashMap<String, CalItemVO>();
        formulaEntity.setUniqueCodeCalItemMap(uniqueCodeCalItemMap);
        for (Map.Entry entry : dependMap.entrySet()) {
            SInsurCalItemUniCodeResolver resolver = SInsurCalItemUniCodeResolver.getResolverBy((String)((String)entry.getKey()));
            if (resolver == null) continue;
            resolver.genCalItemVO(formulaDynamicObj, (Set)entry.getValue(), uniqueCodeCalItemMap, param);
        }
        CalItemVO resultItem = new CalItemVO();
        resultItem.setName(formulaDynamicObj.getString("resultitem.name"));
        resultItem.setUniqueCode(formulaDynamicObj.getString("resultitemuniquecode"));
        resultItem.setRoundingMode(RoundingMode.HALF_UP);
        int dataLength = formulaDynamicObj.getInt("resultitemdatalength");
        resultItem.setDataLength(Integer.valueOf(dataLength == 0 ? 24 : dataLength));
        resultItem.setDataType(DataTypeEnum.getDataType((String)formulaDynamicObj.getString("resultitemdatatype")));
        resultItem.setScale(Integer.valueOf(formulaDynamicObj.getInt("resultitemscale")));
        uniqueCodeCalItemMap.put(formulaDynamicObj.getString("resultitemuniquecode"), resultItem);
        String executeExp = formulaDynamicObj.getString("executeexp");
        formulaEntity.setExecuteExp(executeExp);
        if (HRStringUtils.isNotEmpty((String)executeExp)) {
            String formulaName = formulaDynamicObj.getString("name");
            FormulaVO formulaVO = new FormulaVO();
            formulaVO.setName(formulaName);
            formulaVO.setExecuteCode(executeExp);
            formulaEntity.setCalFormula(formulaVO);
        }
        String dependentFunc = formulaDynamicObj.getString("dependentfunc");
        ArrayList<FunctionVO> functionVOList = new ArrayList<FunctionVO>(10);
        BaseCalHelper.getFunctionVos(dependentFunc, functionVOList);
        formulaEntity.setFunctionVOList(functionVOList);
    }

    private static void addDependencyItem(Map<String, Set<String>> dependMap, DynamicObject formulaDynamicObj, String ... propNames) {
        for (String propName : propNames) {
            String[] calItemList;
            String dependencyValue = formulaDynamicObj.getString(propName);
            if (StringUtils.isEmpty((CharSequence)dependencyValue)) continue;
            for (String uniCode : calItemList = HRStringUtils.split((String)dependencyValue, (String)",")) {
                if (!SITStringUtils.isNotEmpty((String)uniCode)) continue;
                Pair bizCode = SInsurCalItemUniCodeResolver.bizCode((String)uniCode);
                Set codeSet = dependMap.computeIfAbsent((String)bizCode.getKey(), key -> new HashSet(16));
                codeSet.add(bizCode.getValue());
            }
        }
    }

    private static void getFunctionVos(String dependentFunc, List<FunctionVO> functionVOList) {
        HashSet<String> functionUniqueCodes = new HashSet<String>(16);
        if (HRStringUtils.isNotEmpty((String)dependentFunc)) {
            functionUniqueCodes.addAll(Arrays.asList(dependentFunc.split(",")));
        }
        if (!CollectionUtils.isEmpty(functionUniqueCodes)) {
            DynamicObject[] fucArray;
            HRBaseServiceHelper fucHelper = new HRBaseServiceHelper("hrcs_function");
            QFilter uniqueCodeFilter = new QFilter("id", "in", functionUniqueCodes.stream().map(e -> (Long)BaseDataConverter.convert((Object)e, Long.class)).toArray(Long[]::new));
            for (DynamicObject fuc : fucArray = fucHelper.query("id,name,funcexp,importentry.importcode", new QFilter[]{uniqueCodeFilter})) {
                functionVOList.add(FunctionVO.getFunctionVO((DynamicObject)fuc));
            }
        }
    }

    public static Map<Long, Long> getSinsurFileAndRefStd(Collection<Long> fileBoIds, Date bsed) {
        QFilter refFilter = new QFilter("sinsurfile", "in", fileBoIds);
        refFilter.and("bsed", "<=", (Object)bsed);
        refFilter.and("bsled", ">=", (Object)bsed);
        refFilter.and("iscurrentversion", "=", (Object)Boolean.FALSE);
        refFilter.and("datastatus", "in", Arrays.asList("1", "2", "0"));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsurfilestd");
        DynamicObjectCollection fileAndRefStdDys = helper.queryOriginalCollection("sinsurfile.id,sinsurstd.id", new QFilter[]{refFilter});
        HashMap<Long, Long> fileAndRefStdMap = new HashMap<Long, Long>(fileAndRefStdDys.size());
        for (DynamicObject fileAndRefStdDy : fileAndRefStdDys) {
            fileAndRefStdMap.put(fileAndRefStdDy.getLong("sinsurfile.id"), fileAndRefStdDy.getLong("sinsurstd.id"));
        }
        return fileAndRefStdMap;
    }

    public static Map<Long, Set<Long>> getInsuranceStandardInsuranceType(Collection<Long> stdIds, Date bsed) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sinsurstd");
        QFilter qFilter = new QFilter("boid", "in", stdIds);
        qFilter.and("bsed", "<=", (Object)bsed);
        qFilter.and("bsled", ">=", (Object)bsed);
        qFilter.and("iscurrentversion", "=", (Object)Boolean.FALSE);
        qFilter.and("datastatus", "in", Arrays.asList("1", "2", "0"));
        DynamicObject[] insuranceStandardVDys = helper.query("id,boid,insurtype.id,insuritem.id,insuritem.name,roundtype", qFilter.toArray());
        HashMap<Long, Set<Long>> stdInsurtypeMap = new HashMap<Long, Set<Long>>();
        for (DynamicObject sinsurStd : insuranceStandardVDys) {
            Set insurtypes = stdInsurtypeMap.computeIfAbsent(sinsurStd.getLong("boid"), o -> new HashSet(16));
            for (DynamicObject stdEntity : sinsurStd.getDynamicObjectCollection("stdentryentity")) {
                insurtypes.add(stdEntity.getLong("insurtype.id"));
            }
        }
        return stdInsurtypeMap;
    }

    public static String getTimeStr(Date calStartTime, Date calEndTime) {
        if (calStartTime == null || calEndTime == null) {
            return "";
        }
        long diff = calEndTime.getTime() - calStartTime.getTime();
        if (diff < 0L) {
            return "";
        }
        long day = diff / 86400000L;
        long hour = diff / 3600000L - day * 24L;
        long min = diff / 60000L - day * 24L * 60L - hour * 60L;
        String sd = new BigDecimal(diff - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L).divide(BigDecimal.valueOf(1000L), 1, RoundingMode.UP).toPlainString();
        StringBuilder sb = new StringBuilder();
        if (day != 0L) {
            sb.append(day).append(ResManager.loadKDString((String)"\u5929", (String)"BaseCalHelper_0", (String)"sit-sitbp-business", (Object[])new Object[0]));
        }
        if (hour > 0L) {
            sb.append(hour).append(ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"BaseCalHelper_1", (String)"sit-sitbp-business", (Object[])new Object[0]));
        }
        if (min > 0L) {
            sb.append(min).append(ResManager.loadKDString((String)"\u5206\u949f", (String)"BaseCalHelper_2", (String)"sit-sitbp-business", (Object[])new Object[0]));
        }
        sb.append(sd).append(ResManager.loadKDString((String)"\u79d2", (String)"BaseCalHelper_3", (String)"sit-sitbp-business", (Object[])new Object[0]));
        return sb.toString();
    }
}

