/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.basecal;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.util.SITDateTimeUtils;

public class BaseCalMutexUtils {
    private static final Log LOGGER = LogFactory.getLog(BaseCalMutexUtils.class);

    public static void checkPersonHrIsCaling(Map<Long, DynamicObject> personIndexMap, Map<Long, String> errorMap) {
        if (personIndexMap.size() == 0) {
            return;
        }
        DynamicObjectCollection calMutexDataList = BaseCalMutexUtils.getSalaryCalMutexData(personIndexMap.keySet());
        DynamicObject file = null;
        for (DynamicObject obj : calMutexDataList) {
            file = personIndexMap.remove(obj.getLong("personindexid"));
            if (file == null) continue;
            errorMap.put(file.getLong("id"), BaseCalMutexUtils.getMsgByType(obj.getString("type")));
        }
    }

    private static String getMsgByType(String calType) {
        String msg = "";
        switch (calType) {
            case "cal": {
                msg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u6709\u793e\u4fdd\u6863\u6848\u6b63\u5728\u57fa\u6570\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BaseCalMutexUtils_0", (String)"sit-sitbp-business", (Object[])new Object[0]);
                break;
            }
            case "import": {
                msg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u6709\u793e\u4fdd\u6863\u6848\u6b63\u5728\u5bfc\u5165\u57fa\u6570\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BaseCalMutexUtils_1", (String)"sit-sitbp-business", (Object[])new Object[0]);
                break;
            }
            case "edit": {
                msg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u6709\u793e\u4fdd\u6863\u6848\u6b63\u5728\u4fee\u6539\u57fa\u6570\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BaseCalMutexUtils_2", (String)"sit-sitbp-business", (Object[])new Object[0]);
                break;
            }
        }
        return msg;
    }

    public static Collection<Long> addCalMutexData(List<DynamicObject> files, Map<Long, String> errorMap, String type, long recordId) {
        HashMap<Long, DynamicObject> personIndexMap = new HashMap<Long, DynamicObject>(files.size());
        for (DynamicObject file : files) {
            long personindexid = file.getLong("personindexid");
            DynamicObject existFile = (DynamicObject)personIndexMap.get(personindexid);
            if (existFile == null) {
                personIndexMap.put(personindexid, file);
                continue;
            }
            errorMap.put(file.getLong("id"), BaseCalMutexUtils.getMsgByType(type));
        }
        String lockKey = "sit_hcsi_basecal";
        try (DLock lock = DLock.create((String)"sit_hcsi_basecal");){
            LOGGER.info("start try lock...");
            if (lock.tryLock(30000L)) {
                LOGGER.info(" get locked...");
                BaseCalMutexUtils.checkPersonHrIsCaling(personIndexMap, errorMap);
                if (personIndexMap.size() > 0) {
                    BaseCalMutexUtils.saveCalMutexData(personIndexMap, recordId, type);
                }
            } else {
                LOGGER.error("addCalmutex_tryLock fail");
            }
        }
        catch (Exception ex) {
            LOGGER.error("addCalMutex error.", (Throwable)ex);
        }
        return personIndexMap.keySet();
    }

    private static DynamicObjectCollection getSalaryCalMutexData(Set<Long> personIndexIdSet) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_basecalmutex");
        QFilter filter = new QFilter("personindexid", "in", personIndexIdSet);
        Date expireTime = SITDateTimeUtils.addHour((Date)new Date(), (long)-8L);
        QFilter expireFilter = filter.and("createtime", ">=", (Object)expireTime);
        return helper.queryOriginalCollection("personindexid,type,sinsurfile.id", new QFilter[]{filter, expireFilter});
    }

    private static void saveCalMutexData(Map<Long, DynamicObject> personIndexMap, long recordId, String type) {
        LOGGER.info("saveCalMutexData start");
        DynamicObjectCollection calMutexCollection = new DynamicObjectCollection();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"hcsi_basecalmutex");
        DynamicObject calMutex = null;
        for (Map.Entry<Long, DynamicObject> entry : personIndexMap.entrySet()) {
            calMutex = (DynamicObject)entityType.createInstance();
            calMutex.set("record", (Object)recordId);
            calMutex.set("personindexid", (Object)entry.getKey());
            calMutex.set("sinsurfile", (Object)entry.getValue().getLong("id"));
            calMutex.set("createtime", (Object)new Date());
            calMutex.set("modifytime", (Object)new Date());
            calMutex.set("type", (Object)type);
            calMutex.set("creator", (Object)RequestContext.get().getCurrUserId());
            calMutex.set("modifier", (Object)RequestContext.get().getCurrUserId());
            calMutexCollection.add((Object)calMutex);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_basecalmutex");
        helper.save(calMutexCollection);
        LOGGER.info("saveCalMutexData end");
    }

    public static void deleteCalMutexData(Collection<Long> personIndexIdList) {
        if (personIndexIdList == null || personIndexIdList.isEmpty()) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_basecalmutex");
        QFilter filter = new QFilter("personindexid", "in", personIndexIdList);
        helper.deleteByFilter(new QFilter[]{filter});
    }

    public static boolean addBaseCalViewLock(IFormView view) {
        Long fileId;
        HRBaseServiceHelper helper;
        DynamicObject file;
        if ("hcsi_sinsurfilestd".equals(view.getEntityId()) && (file = (helper = new HRBaseServiceHelper("hcsi_sinsurfile")).queryOne("id,number,person.id,employee.id,welfarepayer.id,welfarepayer.placeofwelfare.id,status,personindexid", new QFilter("id", "=", (Object)(fileId = (Long)view.getFormShowParameter().getCustomParam("sinsur_file_id"))))) != null) {
            HashMap<Long, String> errMap = new HashMap<Long, String>(16);
            BaseCalMutexUtils.addCalMutexData(Collections.singletonList(file), errMap, "edit", 0L);
            String errMsg = (String)errMap.get(file.getLong("id"));
            if (errMsg != null) {
                view.showTipNotification(errMsg);
                return false;
            }
        }
        return true;
    }

    public static void removeBaseCalViewLock(IFormView view) {
        Long fileId;
        HRBaseServiceHelper helper;
        DynamicObject file;
        if ("hcsi_sinsurfilestd".equals(view.getEntityId()) && (file = (helper = new HRBaseServiceHelper("hcsi_sinsurfile")).queryOne("id,number,person.id,employee.id,welfarepayer.id,welfarepayer.placeofwelfare.id,status,personindexid", new QFilter("id", "=", (Object)(fileId = (Long)view.getFormShowParameter().getCustomParam("sinsur_file_id"))))) != null) {
            BaseCalMutexUtils.deleteCalMutexData(Collections.singletonList(file.getLong("personindexid")));
        }
    }
}

