/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.cloudcolla;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.sit.sitbp.business.servicehelper.SITBaseDataHelper;
import kd.sit.sitbp.common.util.SITStringUtils;
import kd.sit.sitbp.common.vo.AbstractCloudCollaExecutePlugin;
import kd.sit.sitbp.common.vo.CollaActContext;
import kd.sit.sitbp.common.vo.CollaRuleExecuteContext;
import kd.sit.sitbp.common.vo.CollaTriggerEntity;
import org.apache.commons.collections4.MapUtils;

public class CommonBizAppCloudCollaRuleConstructHelper {
    private static final Log log = LogFactory.getLog(CommonBizAppCloudCollaRuleConstructHelper.class);

    private CommonBizAppCloudCollaRuleConstructHelper() {
    }

    public static CommonBizAppCloudCollaRuleConstructHelper getInstance() {
        return load.INSTANCE;
    }

    public CollaRuleExecuteContext constructCollaRuleExecuteContext(Map<String, Object> paramMap) {
        Long taskCenterId = (Long)paramMap.get("taskCenterId");
        Long centerEntId = (Long)paramMap.get("centerEntId");
        String taskExecManner = (String)paramMap.get("taskExecManner");
        String taskCenterClass = MapUtils.getString(paramMap, (Object)"taskCenterClass");
        Set executeAppSet = (Set)MapUtils.getObject(paramMap, (Object)"executeAppSet", Collections.emptySet());
        log.info("[colla]:HSASCloudCollaExecuteHelper.constructHSASCloudCollaExecuteInfo begin. taskCenterId={} centerEntId={}", (Object)taskCenterId, (Object)centerEntId);
        try {
            Long payRollActGrpId = MapUtils.getLong(paramMap, (Object)"payRollActGrpId");
            String payRollActGrpClass = MapUtils.getString(paramMap, (Object)"payRollActGrpClass");
            Map apiDataCombos = (Map)paramMap.get("apiResult");
            Map convertedApiDatas = (Map)paramMap.get("convertedApiResult");
            String orgNumber = (String)paramMap.get("orgNumber");
            Long orgId = Long.valueOf(String.valueOf(paramMap.get("orgId")));
            Boolean isInbound = (Boolean)paramMap.get("isInbound");
            String flowType = (String)paramMap.get("flowType");
            Date effectTime = (Date)paramMap.get("effectTime");
            Map apiIdNumberMap = (Map)paramMap.get("apiIdNumberMap");
            DynamicObject payRollActGrpDyObj = this.getPayRollActGrpDyobj(payRollActGrpClass, payRollActGrpId);
            if (payRollActGrpDyObj == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u534f\u4f5c\u89c4\u5219\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u85aa\u8d44\u6838\u7b97\u7684\u534f\u4f5c\u89c4\u5219\u6570\u636e\u3002", (String)"CommonBizAppCloudCollaRuleConstructHelper_6", (String)"sit-sitbp-business", (Object[])new Object[0]));
            }
            if (!"C".equals(payRollActGrpDyObj.getString("status"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u534f\u4f5c\u89c4\u5219\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u8bf7\u68c0\u67e5\u85aa\u8d44\u6838\u7b97\u7684\u534f\u4f5c\u89c4\u5219\u6570\u636e\u3002", (String)"CommonBizAppCloudCollaRuleConstructHelper_7", (String)"sit-sitbp-business", (Object[])new Object[0]));
            }
            if (!"1".equals(payRollActGrpDyObj.getString("enable"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u534f\u4f5c\u89c4\u5219\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u85aa\u8d44\u6838\u7b97\u7684\u534f\u4f5c\u89c4\u5219\u6570\u636e\u3002", (String)"CommonBizAppCloudCollaRuleConstructHelper_8", (String)"sit-sitbp-business", (Object[])new Object[0]));
            }
            long sceneId = payRollActGrpDyObj.getLong("scene.id");
            String sceneNumber = payRollActGrpDyObj.getString("scene.number");
            long policyId = payRollActGrpDyObj.getLong("policy.id");
            String sceneBizAppNumber = payRollActGrpDyObj.getString("scene.bizappid.number");
            CollaRuleExecuteContext collaRuleExecuteInfo = new CollaRuleExecuteContext();
            collaRuleExecuteInfo.setPayRollActGrpId(payRollActGrpId);
            collaRuleExecuteInfo.setOrgNumber(orgNumber);
            collaRuleExecuteInfo.setOrgId(orgId);
            collaRuleExecuteInfo.setInBound(isInbound);
            collaRuleExecuteInfo.setFlowType(flowType);
            collaRuleExecuteInfo.setEffectTime(effectTime);
            collaRuleExecuteInfo.setTaskCenterEntryId((Long)paramMap.get("centerEntId"));
            collaRuleExecuteInfo.setTaskCenterId((Long)paramMap.get("taskCenterId"));
            collaRuleExecuteInfo.setTaskCenterClass(taskCenterClass);
            collaRuleExecuteInfo.setTaskExecManner((String)paramMap.get("taskExecManner"));
            collaRuleExecuteInfo.setPreExeResult((List)paramMap.get("preExeResult"));
            collaRuleExecuteInfo.setMsgEntity((Map)paramMap.get("msgEntity"));
            collaRuleExecuteInfo.setConvertedApiDatas(convertedApiDatas);
            collaRuleExecuteInfo.setOriginalApiDatas(apiDataCombos);
            collaRuleExecuteInfo.setApiIdNumberMap(apiIdNumberMap);
            collaRuleExecuteInfo.setRuleDataSource(((Integer)paramMap.get("ruleDataSource")).intValue());
            collaRuleExecuteInfo.setVerifyBillData((Map)paramMap.get("verifyBillData"));
            collaRuleExecuteInfo.setBatchTaskCenterData((Map)MapUtils.getObject(paramMap, (Object)"batchTaskCenterData", Collections.emptyMap()));
            collaRuleExecuteInfo.setRecordDetails(MapUtils.getMap(paramMap, (Object)"recordDetails", Collections.emptyMap()));
            log.info("[colla] collaRuleExecuteInfo.setRecordDetails = {}", JSON.toJSON((Object)collaRuleExecuteInfo.getRecordDetails()));
            Map<Long, DynamicObject> collActDataMap = this.getPayActDyObjMap(payRollActGrpDyObj);
            Map<String, DynamicObject> fieldRuleDataMap = this.getFieldRuleMap(payRollActGrpDyObj);
            Map<String, DynamicObject> payRollActFieldMapRel = this.getPayRollActFieldMapRel(payRollActGrpDyObj);
            collaRuleExecuteInfo.setPayRollActFieldMapRel(payRollActFieldMapRel);
            Map<Long, DynamicObject> allTriggerObjectMap = this.getAllTriggerObjectMap(payRollActGrpDyObj);
            DynamicObjectCollection payRollActGrpEntryEntity = payRollActGrpDyObj.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)payRollActGrpEntryEntity)) {
                return collaRuleExecuteInfo;
            }
            for (int i = 0; i < payRollActGrpEntryEntity.size(); ++i) {
                DynamicObject payRollActGrpEntry = (DynamicObject)payRollActGrpEntryEntity.get(i);
                CollaActContext collaActContext = new CollaActContext();
                collaActContext.setParentCollaRuleExecuteContext(collaRuleExecuteInfo);
                collaRuleExecuteInfo.getCollaActContext().add(collaActContext);
                collaActContext.setPayRollActGrpEntry(payRollActGrpEntry);
                collaActContext.setIndex(Integer.valueOf(i));
                collaActContext.setRuleId(Long.valueOf(payRollActGrpEntry.getLong("ruledesign.id")));
                collaActContext.setSceneId(Long.valueOf(sceneId));
                collaActContext.setPolicyId(Long.valueOf(policyId));
                collaActContext.setSceneNumber(sceneNumber);
                collaActContext.setSceneAppNumber(sceneBizAppNumber);
                collaActContext.setPayRollActId(Long.valueOf(payRollActGrpEntry.getLong("payrollact.id")));
                collaActContext.setPayRollActName(String.valueOf(payRollActGrpEntry.getLocaleString("payrollact.name")));
                collaActContext.setPolicyIds(this.assemblyFieldRulePolicysData(payRollActGrpEntry.getDynamicObjectCollection("fieldrulesubentryentity")));
                collaActContext.getTriggers().addAll(this.assemblyTriggerData(fieldRuleDataMap, allTriggerObjectMap, payRollActGrpEntry.getDynamicObject("payrollact"), executeAppSet));
            }
            return collaRuleExecuteInfo;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.publishSyncMsg(taskCenterClass, taskCenterId, centerEntId, e.getMessage(), taskExecManner);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private List<Long> assemblyFieldRulePolicysData(DynamicObjectCollection fieldRuleEntry) {
        ArrayList<Long> policyIds = new ArrayList<Long>(10);
        if (CollectionUtils.isEmpty((Collection)fieldRuleEntry)) {
            return policyIds;
        }
        return fieldRuleEntry.stream().map(data -> data.getLong("frfieldrule.policy.id")).collect(Collectors.toList());
    }

    private boolean validateFieldMap(String entityNumber, DynamicObject fieldMapDyobj) {
        String name;
        boolean isQualified = true;
        DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        IDataEntityType dataEntityType = entity.getDataEntityType();
        LocaleString displayName = dataEntityType.getDisplayName();
        String string = name = displayName == null ? dataEntityType.getAlias() : displayName.getLocaleValue();
        if (null == fieldMapDyobj) {
            isQualified = false;
            throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u5b9e\u4f53 ''{0}''\uff0c\u5b57\u6bb5\u6620\u5c04\u65b9\u6848\u5df2\u88ab\u5220\u9664", (String)"CommonBizAppCloudCollaRuleConstructHelper_1", (String)"sit-sitbp-business", (Object[])new Object[]{name})), new Object[0]);
        }
        if (!SITStringUtils.equals((String)fieldMapDyobj.getString("status"), (String)"C")) {
            isQualified = false;
            throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u5b9e\u4f53 ''{0}''\uff0c\u5b57\u6bb5\u6620\u5c04\u65b9\u6848\uff08{1}\uff09\u6570\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6838", (String)"CommonBizAppCloudCollaRuleConstructHelper_2", (String)"sit-sitbp-business", (Object[])new Object[]{name, fieldMapDyobj.getString("name")})), new Object[0]);
        }
        if (!SITStringUtils.equals((String)fieldMapDyobj.getString("enable"), (String)"1")) {
            isQualified = false;
            throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u5b9e\u4f53 ''{0}''\uff0c\u5b57\u6bb5\u6620\u5c04\u65b9\u6848\uff08{1}\uff09\u5df2\u88ab\u7981\u7528", (String)"CommonBizAppCloudCollaRuleConstructHelper_3", (String)"sit-sitbp-business", (Object[])new Object[]{name, fieldMapDyobj.getString("name")})), new Object[0]);
        }
        return isQualified;
    }

    private List<CollaTriggerEntity> assemblyTriggerData(Map<String, DynamicObject> fieldRuleDataMap, Map<Long, DynamicObject> allTriggerObjectMap, DynamicObject payRollAct, Set<String> executeAppSet) {
        DynamicObjectCollection triggerCollaDyobjs = payRollAct.getDynamicObjectCollection("entryentity");
        long payRollActId = payRollAct.getLong("id");
        ArrayList<CollaTriggerEntity> result = new ArrayList<CollaTriggerEntity>(10);
        for (DynamicObject triggerCollaDyobj : triggerCollaDyobjs) {
            Long triggerCollaId = triggerCollaDyobj.getLong("triggercolla.id");
            DynamicObject triggerObject = allTriggerObjectMap.get(triggerCollaId);
            if (triggerObject == null) continue;
            CollaTriggerEntity triggerEntity = new CollaTriggerEntity();
            result.add(triggerEntity);
            triggerEntity.setTriggerId(triggerCollaId);
            triggerEntity.setFieldMap(triggerObject.getString("ismustfieldmapping"));
            triggerEntity.setObjectName(triggerObject.getString("entityobject.number"));
            DynamicObjectCollection paramEntryEntity = triggerObject.getDynamicObjectCollection("paramentryentity");
            triggerEntity.getFieldRules().putAll(this.getFieldRulePolicyMap(fieldRuleDataMap, payRollActId, triggerCollaId, paramEntryEntity));
            triggerEntity.getFields().addAll(paramEntryEntity.stream().map(item -> item.getString("fieldkey")).collect(Collectors.toList()));
            DynamicObjectCollection pluginEntryEntity = triggerObject.getDynamicObjectCollection("pluginentryentity");
            triggerEntity.getPlugins().addAll(this.getTriggerPlugins(pluginEntryEntity, executeAppSet));
        }
        return result;
    }

    private List<AbstractCloudCollaExecutePlugin> getTriggerPlugins(DynamicObjectCollection pluginEntryEntity, Set<String> executeAppSet) {
        ArrayList<AbstractCloudCollaExecutePlugin> result = new ArrayList<AbstractCloudCollaExecutePlugin>();
        if (CollectionUtils.isEmpty((Collection)pluginEntryEntity)) {
            return result;
        }
        for (DynamicObject pluginEntry : pluginEntryEntity) {
            String pluginPath = pluginEntry.getString("pluginpath");
            String pluginApp = pluginEntry.getString("pluginapp.id");
            if (!executeAppSet.contains(pluginApp)) continue;
            AbstractCloudCollaExecutePlugin triggerPluginClass = this.getTriggerPluginClass(pluginPath);
            result.add(triggerPluginClass);
        }
        return result;
    }

    private Map<String, Long> getFieldRulePolicyMap(Map<String, DynamicObject> fieldRuleDataMap, long payRollActId, Long triggerCollaId, DynamicObjectCollection paramEntryEntity) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        if (CollectionUtils.isEmpty((Collection)paramEntryEntity)) {
            return result;
        }
        for (DynamicObject dynamicObject : paramEntryEntity) {
            long tempPolicyId;
            String fieldKey = dynamicObject.getString("fieldkey");
            String key = payRollActId + "_" + triggerCollaId + "_" + fieldKey;
            DynamicObject policy = fieldRuleDataMap.get(key);
            if (policy == null || (tempPolicyId = policy.getLong("frfieldrule.policy.id")) == 0L) continue;
            result.put(fieldKey, tempPolicyId);
        }
        return result;
    }

    private AbstractCloudCollaExecutePlugin getTriggerPluginClass(String classPath) {
        if (SITStringUtils.isEmpty((String)classPath)) {
            return null;
        }
        try {
            AbstractCloudCollaExecutePlugin cloudCollaExecutePugin = (AbstractCloudCollaExecutePlugin)Class.forName(classPath).newInstance();
            return cloudCollaExecutePugin;
        }
        catch (KDBizException e) {
            log.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u5bfc\u5165\u63d2\u4ef6{0}\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff1a{1}", (String)"CommonBizAppCloudCollaRuleConstructHelper_4", (String)"sit-sitbp-business", (Object[])new Object[]{classPath, e.getMessage()})), new Object[0]);
        }
        catch (Throwable e) {
            log.error(e);
            throw new KDBizException(e, new ErrorCode("", ResManager.loadKDString((String)"\u5bfc\u5165\u63d2\u4ef6{0}\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff1a\u8be6\u60c5\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"CommonBizAppCloudCollaRuleConstructHelper_5", (String)"sit-sitbp-business", (Object[])new Object[]{classPath})), new Object[0]);
        }
    }

    private void publishSyncMsg(String taskCenterClass, Long taskCenterId, Long centerEntId, String errorMsg, String taskExecManner) {
        log.info("[colla]:\u8de8\u4e1a\u52a1\u534f\u4f5c ---> \u5f00\u59cb\u53cd\u5199\u534f\u4f5c\u4efb\u52a1\u7ba1\u7406 <---");
        this.publishSyncMsg(this.assembleMsgData(taskCenterClass, taskCenterId, centerEntId, errorMsg, taskExecManner));
        log.info("[colla]:\u8de8\u4e1a\u52a1\u534f\u4f5c ---> \u7ed3\u675f\u53cd\u5199\u534f\u4f5c\u4efb\u52a1\u7ba1\u7406 <---");
    }

    private Map<String, Object> assembleMsgData(String taskCenterClass, Long taskCenterId, Long centerEntId, String errorMsg, String taskExecManner) {
        HashMap<String, Object> messageData = new HashMap<String, Object>(16);
        messageData.put("tag", "writebacktaskcenter");
        messageData.put("entity", taskCenterClass);
        HashMap<String, Object> collaData = new HashMap<String, Object>(16);
        collaData.put("id", taskCenterId);
        collaData.put("entryentity.id", centerEntId);
        collaData.put("entryentity.taskexecutestatusent", "E");
        collaData.put("entryentity.executefailmsgent", String.join((CharSequence)System.lineSeparator(), errorMsg));
        collaData.put("entryentity.taskexecutetime", new Date());
        collaData.put("entryentity.taskexecuser", RequestContext.get().getCurrUserId());
        collaData.put("entryentity.taskexecmanner", taskExecManner);
        messageData.put("data", collaData);
        return messageData;
    }

    private void publishSyncMsg(Map<String, Object> messageData) {
        try (MessagePublisher publisher = MQFactory.get().createSimplePublisher("swc", "hpdi_opsync_queue");){
            publisher.publish(messageData);
        }
    }

    private Map<String, DynamicObject> getFieldRuleMap(DynamicObject payActGrpDyObj) {
        HashMap<String, DynamicObject> fieldRuleMap = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection payActEntities = payActGrpDyObj.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)payActEntities)) {
            return fieldRuleMap;
        }
        String key = null;
        for (DynamicObject act : payActEntities) {
            act.get("fieldrulesubentryentity");
            DynamicObjectCollection fieldRuleEntits = act.getDynamicObjectCollection("fieldrulesubentryentity");
            if (CollectionUtils.isEmpty((Collection)fieldRuleEntits)) continue;
            for (DynamicObject rule : fieldRuleEntits) {
                key = rule.getLong("frpayrollact.id") + "_" + rule.getLong("frtriggercolla.id") + "_" + rule.getString("frfieldkey");
                fieldRuleMap.put(key, rule);
            }
        }
        return fieldRuleMap;
    }

    private Map<Long, DynamicObject> getPayActDyObjMap(DynamicObject payActGrpDyObj) {
        HashMap<Long, DynamicObject> payActDyObjMap = new HashMap<Long, DynamicObject>(16);
        DynamicObjectCollection payActGrpEntits = payActGrpDyObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject actGrp : payActGrpEntits) {
            payActDyObjMap.put(actGrp.getLong("payrollact.id"), actGrp);
        }
        return payActDyObjMap;
    }

    private Map<String, DynamicObject> getPayRollActFieldMapRel(DynamicObject payActGrpDyobj) {
        HashMap<String, DynamicObject> payRollActFieldMapRel = new HashMap<String, DynamicObject>(16);
        HashMap<String, Long> payRollActFieldMapIdRel = new HashMap<String, Long>(16);
        HashSet<Long> fieldMapIds = new HashSet<Long>(16);
        DynamicObjectCollection entryentities = payActGrpDyobj.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentities)) {
            return payRollActFieldMapRel;
        }
        for (DynamicObject entryentity : entryentities) {
            DynamicObjectCollection subentryentitys = entryentity.getDynamicObjectCollection("subentryentity");
            if (CollectionUtils.isEmpty((Collection)subentryentitys)) continue;
            for (DynamicObject subentryentity : subentryentitys) {
                DynamicObjectCollection fieldMapObjs;
                long fieldMapId2 = subentryentity.getLong("fieldmap.id");
                if (fieldMapId2 == 0L || CollectionUtils.isEmpty((Collection)(fieldMapObjs = subentryentity.getDynamicObjectCollection("actgfieldmapobj")))) continue;
                for (DynamicObject fieldMapObj : fieldMapObjs) {
                    String baseDataId = fieldMapObj.getString("fbasedataid_id");
                    if (StringUtils.isEmpty((String)baseDataId)) continue;
                    payRollActFieldMapIdRel.put(String.join((CharSequence)"|", entryentity.getString("payrollact.id"), baseDataId), fieldMapId2);
                    fieldMapIds.add(fieldMapId2);
                }
            }
        }
        HashMap<Long, DynamicObject> fieldMapRel = new HashMap<Long, DynamicObject>(16);
        if (!fieldMapIds.isEmpty()) {
            DynamicObject[] fieldMapDyobjs;
            for (DynamicObject fieldMapDyobj : fieldMapDyobjs = BusinessDataServiceHelper.load((String)"hsbs_fieldmap", (String)"enable,name,number,status,apideploy.type,entityobject,targetobjectfield,subscibeapifield,subscibeobject", (QFilter[])new QFilter[]{new QFilter("id", "in", fieldMapIds)})) {
                fieldMapRel.put(fieldMapDyobj.getLong("id"), fieldMapDyobj);
            }
        }
        if (!payRollActFieldMapIdRel.isEmpty() && !fieldMapRel.isEmpty()) {
            payRollActFieldMapIdRel.forEach((payRollActId, fieldMapId) -> payRollActFieldMapRel.put((String)payRollActId, (DynamicObject)fieldMapRel.get(fieldMapId)));
        }
        return payRollActFieldMapRel;
    }

    private Map<Long, DynamicObject> getAllTriggerObjectMap(DynamicObject payActGrpDyobj) {
        DynamicObject[] triggers;
        DynamicObjectCollection entryentities = payActGrpDyobj.getDynamicObjectCollection("entryentity");
        ArrayList<Long> triggerCollaIds = new ArrayList<Long>(10);
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject entryentity : entryentities) {
            DynamicObject payRollActDyobj = entryentity.getDynamicObject("payrollact");
            DynamicObjectCollection triggerCollaDyobjs = payRollActDyobj.getDynamicObjectCollection("entryentity");
            for (DynamicObject triggerCollaDyobj : triggerCollaDyobjs) {
                Long triggerCollaId = triggerCollaDyobj.getLong("triggercolla.id");
                triggerCollaIds.add(triggerCollaId);
            }
        }
        if (CollectionUtils.isEmpty(triggerCollaIds)) {
            return result;
        }
        for (DynamicObject trigger : triggers = BusinessDataServiceHelper.load((Object[])triggerCollaIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hsbs_triggercolla"))) {
            result.put(trigger.getLong("id"), trigger);
        }
        return result;
    }

    private DynamicObject getPayRollActGrpDyobj(String payRollActGrpClass, Long payActGrpId) {
        if (SITStringUtils.isEmpty((String)payRollActGrpClass) || payActGrpId == null || payActGrpId == 0L) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)payActGrpId, (String)payRollActGrpClass, (String)SITBaseDataHelper.getSelectProperties(payRollActGrpClass));
    }

    private static class load {
        private static final CommonBizAppCloudCollaRuleConstructHelper INSTANCE = new CommonBizAppCloudCollaRuleConstructHelper();

        private load() {
        }
    }
}

