/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.coderule;

import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.sit.sitbp.common.enums.SInsuranceInfoEnum;

public class CodeRuleHelper {
    private static final Log log = LogFactory.getLog(CodeRuleHelper.class);
    public static final String ERRCODE_CODERULE_VALIDATE_NUMBER = "ERRCODE_CODERULE_VALIDATE_NUMBER";

    private CodeRuleHelper() {
    }

    public static String getNumber(DynamicObject entityDy, String orgId) {
        try {
            String entityId = entityDy.getDynamicObjectType().getName();
            return CodeRuleServiceHelper.getNumber((String)entityId, (DynamicObject)entityDy, (String)orgId);
        }
        catch (Exception exception) {
            log.error("CodeRuleHelper.getNumber: ", (Throwable)exception);
            KDException codeRuleExc = null;
            if (exception instanceof KDException) {
                KDException kdException = (KDException)exception;
                StringJoiner errMsg = new StringJoiner("");
                if ("CodeRule_Specific_PageCacheKey_propertiesMap".equals(kdException.getErrorCode())) {
                    errMsg.add(SInsuranceInfoEnum.COMMON_CODE_RULE_ERR_LENGTH.getErrInfo());
                }
                if (ERRCODE_CODERULE_VALIDATE_NUMBER.equals(kdException.getErrorCode().getCode())) {
                    errMsg.add(kdException.getErrorCode().getMessage());
                }
                if (errMsg.length() > 0) {
                    ErrorCode errorCode = new ErrorCode(ERRCODE_CODERULE_VALIDATE_NUMBER, errMsg.toString());
                    codeRuleExc = new KDException(errorCode, new Object[]{exception});
                    throw codeRuleExc;
                }
            }
            ErrorCode errorCode = new ErrorCode(ERRCODE_CODERULE_VALIDATE_NUMBER, SInsuranceInfoEnum.COMMON_CODE_RULE_SYSTEM_ERR.getErrInfo());
            codeRuleExc = new KDException(errorCode, new Object[]{exception});
            throw codeRuleExc;
        }
    }

    public static String getCodeRuleExceptionInfo(Exception exception) {
        KDException kdException;
        if (exception instanceof KDException && ERRCODE_CODERULE_VALIDATE_NUMBER.equals((kdException = (KDException)exception).getErrorCode().getCode())) {
            return kdException.getErrorCode().getMessage();
        }
        return null;
    }
}

