/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.datachanged;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.sit.sitbp.common.enums.SInsuranceInfoEnum;

public class BizChangedHelper {
    public static void operateBizChangedSet(DynamicObject dataEntity, Collection<String> needOptFields, OperateEnum operateEnum) {
        if (CollectionUtils.isEmpty(needOptFields)) {
            return;
        }
        if (!(needOptFields instanceof Set)) {
            needOptFields = new HashSet<String>(needOptFields);
        }
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        if (OperateEnum.RETAIN == operateEnum) {
            for (IDataEntityProperty bizChangedProperty : dataEntityState.getBizChangedProperties()) {
                String bizChangedPropertyName = bizChangedProperty.getName();
                if (bizChangedPropertyName.endsWith("_id")) {
                    bizChangedPropertyName = bizChangedPropertyName.substring(0, bizChangedPropertyName.lastIndexOf("_id"));
                }
                dataEntityState.setBizChanged(bizChangedProperty.getOrdinal(), needOptFields.contains(bizChangedPropertyName));
            }
        } else {
            Map<String, Integer> changedFieldAndOrdinalMap = null;
            DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
            for (String needOptField : needOptFields) {
                Map<String, Integer> bizOrdinalMap = BizChangedHelper.getBizOrdinalMap(properties, needOptField);
                if (OperateEnum.ADD == operateEnum) {
                    if (changedFieldAndOrdinalMap == null) {
                        changedFieldAndOrdinalMap = BizChangedHelper.getChangedFieldAndOrdinalMap(dataEntityState);
                    }
                    bizOrdinalMap.values().forEach(ordinal -> dataEntityState.setBizChanged(ordinal.intValue(), true));
                    continue;
                }
                if (OperateEnum.DELETE != operateEnum) continue;
                bizOrdinalMap.values().forEach(ordinal -> dataEntityState.setBizChanged(ordinal.intValue(), false));
            }
        }
    }

    private static Map<String, Integer> getBizOrdinalMap(DataEntityPropertyCollection properties, String needOptField) {
        List<String> needOptFields = Arrays.asList(needOptField, needOptField + "_id");
        HashMap<String, Integer> bizOrdinalMap = new HashMap<String, Integer>(2);
        for (String optField : needOptFields) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)optField);
            if (iDataEntityProperty == null) continue;
            bizOrdinalMap.put(needOptField, iDataEntityProperty.getOrdinal());
        }
        return bizOrdinalMap;
    }

    public static Map<String, Integer> getChangedFieldAndOrdinalMap(DataEntityState dataEntityState) {
        HashMap<String, Integer> changedFieldAndOrdinalMap = new HashMap<String, Integer>(16);
        for (IDataEntityProperty dataEntityProperty : dataEntityState.getBizChangedProperties()) {
            changedFieldAndOrdinalMap.put(dataEntityProperty.getName(), dataEntityProperty.getOrdinal());
        }
        return changedFieldAndOrdinalMap;
    }

    public static void showConfirm(AbstractFormPlugin formPlugin, String changeDesc, String callBackId, String customValue) {
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), SInsuranceInfoEnum.COMMON_CONFIRM_RETURN_EDIT.getErrInfo());
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), SInsuranceInfoEnum.COMMON_CONFIRM_RETURN_DIR.getErrInfo());
        String msg = SInsuranceInfoEnum.COMMON_CONFIRM_DES.getErrInfo();
        msg = msg.replaceAll("\\\\r\\\\n", "\r\n");
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackId, formPlugin.getPluginName());
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        customValue = customValue == null ? "" : customValue;
        formPlugin.getView().showConfirm(msg, changeDesc, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, customValue);
    }

    public static enum OperateEnum {
        ADD,
        DELETE,
        RETAIN;

    }
}

