/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.dynamic;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.Features;
import kd.bos.entity.Tips;
import kd.bos.metadata.entity.fielddefvalue.DefValueDesign;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.dynamic.FieldIdGenerationParam;

public class DynamicEntry
implements Serializable {
    private static final long serialVersionUID = -5473216812057752692L;
    public static final String ALL_STATUS_LOCKED = "new,edit,view,submit,audit";
    private String key;
    private FieldIdGenerationParam fieldIdGenerationParam;
    private String name;
    private String foreColor;
    private String backColor;
    private String lock;
    private String width;
    private boolean hidden = false;
    private String textAlign;
    private static final String DEFAULT_WIDTH = "200";
    private boolean isHyperlink;
    private Tips tips;
    private boolean showTitle = true;
    private boolean mustInput = false;
    private Features features;
    private Object defValue;
    private boolean isFixed = false;
    private String visible = "init,new,edit,view,submit,audit";
    private boolean dbIgnore = true;
    private String fieldName;
    private boolean noDisplayScaleZero;
    private boolean isFireUpdEvt = true;
    private boolean quickAddNew = false;
    private String displayFormatString;
    private String mask;
    private String currencyFieldId;
    private String amountPrecisionType;
    private String baseEntityId;
    private boolean viewDetail = true;
    private String displayProp = "name";
    private int displayStyle = 0;
    private int basedataEditStyle = 0;
    private String startDateFieldKey;
    private String startDateFieldName;
    private String endDateFieldKey;
    private String endDateFieldName;
    private LocaleString emptyText;
    private int regionType = 1;
    private String minDate;
    private String maxDate;
    private int timeZoneTransType = 0;
    private String relateOrg;
    private DefValueDesign defValueDesign;
    private boolean useRegion;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int privacyType;
    private int precision = 15;
    private int scale = 2;
    private boolean zeroShow = true;
    private String dataScope;
    private String controlPropName;
    private boolean enableNull;
    private String editingMode = "summary";
    private int maxLength = 50;
    private int editStyle;
    private boolean isGroupContainer = false;
    private FieldTypeEnum fieldType;

    public DynamicEntry() {
    }

    private DynamicEntry(EntryBuilder builder) {
        this.initEntryBuilder(builder);
        this.initFieldBuilder(builder);
        this.initComboBuilder(builder);
        this.initBaseDataBuilder(builder);
        this.initMulBaseDataBuilder(builder);
        this.initDateRangeBuilder(builder);
        this.initDateTimeBuilder(builder);
        this.initDecimalBuilder(builder);
        this.initAmountBuilder(builder);
        this.setWidth();
    }

    private void setWidth() {
        boolean widthEmpty = HRStringUtils.isEmpty((String)this.width);
        boolean nameEmpty = HRStringUtils.isEmpty((String)this.name);
        if (widthEmpty) {
            this.width = nameEmpty ? "120px" : (this.name.length() <= 6 ? "140px" : this.name.length() * 16 + "px");
        }
    }

    private void initEntryBuilder(EntryBuilder builder) {
        this.key = builder.key;
        this.fieldIdGenerationParam = builder.fieldIdGenerationParam;
        this.name = builder.name;
        this.foreColor = builder.foreColor;
        this.backColor = builder.backColor;
        this.lock = builder.lock;
        this.width = builder.width;
        this.hidden = builder.hidden;
        this.textAlign = builder.textAlign;
        this.isGroupContainer = builder.isGroupContainer;
        this.fieldType = builder.fieldType;
    }

    private void initFieldBuilder(EntryBuilder entryBuilder) {
        if (entryBuilder instanceof FieldBuilder) {
            FieldBuilder builder = (FieldBuilder)entryBuilder;
            this.isHyperlink = builder.isHyperlink;
            this.tips = builder.tips;
            this.showTitle = builder.showTitle;
            this.mustInput = builder.mustInput;
            this.features = builder.features;
            this.defValue = builder.defValue;
            this.isFixed = builder.isFixed;
            this.visible = builder.visible;
            this.dbIgnore = builder.dbIgnore;
            this.fieldName = builder.fieldName;
            this.noDisplayScaleZero = builder.noDisplayScaleZero;
            this.isFireUpdEvt = builder.isFireUpdEvt;
            this.quickAddNew = builder.quickAddNew;
            this.displayFormatString = builder.displayFormatString;
            this.mask = builder.mask;
        }
    }

    private void initComboBuilder(EntryBuilder entryBuilder) {
        if (entryBuilder instanceof ComboBuilder) {
            ComboBuilder builder = (ComboBuilder)entryBuilder;
            this.defValue = builder.defValue;
        }
    }

    private void initAmountBuilder(EntryBuilder entryBuilder) {
        if (entryBuilder instanceof AmountBuilder) {
            AmountBuilder builder = (AmountBuilder)entryBuilder;
            this.currencyFieldId = builder.currencyFieldId;
            this.amountPrecisionType = builder.amountPrecisionType;
            this.fieldType = builder.fieldType;
        }
    }

    private void initBaseDataBuilder(EntryBuilder entryBuilder) {
        if (entryBuilder instanceof BaseDataBuilder) {
            BaseDataBuilder builder = (BaseDataBuilder)entryBuilder;
            this.baseEntityId = builder.baseEntityId;
            this.viewDetail = builder.viewDetail;
            this.displayProp = builder.displayProp;
            this.displayStyle = builder.displayStyle;
            this.basedataEditStyle = builder.basedataEditStyle;
            this.fieldType = builder.fieldType;
        }
    }

    private void initMulBaseDataBuilder(EntryBuilder entryBuilder) {
        if (entryBuilder instanceof MulBaseDataBuilder) {
            MulBaseDataBuilder builder = (MulBaseDataBuilder)entryBuilder;
            this.baseEntityId = builder.baseEntityId;
            this.displayProp = builder.displayProp;
            this.fieldType = builder.fieldType;
        }
    }

    private void initDateRangeBuilder(EntryBuilder entryBuilder) {
        if (entryBuilder instanceof DateRangeBuilder) {
            DateRangeBuilder builder = (DateRangeBuilder)entryBuilder;
            this.startDateFieldKey = builder.startDateFieldKey;
            this.startDateFieldName = builder.startDateFieldName;
            this.endDateFieldKey = builder.endDateFieldKey;
            this.endDateFieldName = builder.endDateFieldName;
            this.emptyText = builder.emptyText;
            this.regionType = builder.regionType;
            this.defValue = builder.defValue;
        }
    }

    private void initDateTimeBuilder(EntryBuilder entryBuilder) {
        if (entryBuilder instanceof DateTimeBuilder) {
            DateTimeBuilder builder = (DateTimeBuilder)entryBuilder;
            this.minDate = builder.minDate;
            this.maxDate = builder.maxDate;
            this.timeZoneTransType = builder.timeZoneTransType;
            this.relateOrg = builder.relateOrg;
            this.regionType = builder.regionType;
            this.defValue = builder.defValue;
            this.defValueDesign = builder.defValueDesign;
            this.useRegion = builder.useRegion;
            this.dateFormat = builder.dateFormat;
            this.emptyText = builder.emptyText;
            this.privacyType = builder.privacyType;
            this.fieldType = builder.fieldType;
        }
    }

    private void initDecimalBuilder(EntryBuilder entryBuilder) {
        if (entryBuilder instanceof DecimalBuilder) {
            DecimalBuilder builder = (DecimalBuilder)entryBuilder;
            this.precision = builder.precision;
            this.scale = builder.scale;
            this.zeroShow = builder.zeroShow;
            this.dataScope = builder.dataScope;
            this.controlPropName = builder.controlPropName;
            this.enableNull = builder.enableNull;
            this.editingMode = builder.editingMode;
            this.maxLength = builder.maxLength;
            this.editStyle = builder.editStyle;
            this.fieldType = builder.fieldType;
        }
    }

    private void initTextFieldBuilder(EntryBuilder entryBuilder) {
        if (entryBuilder instanceof TextFieldBuilder) {
            TextFieldBuilder fieldBuilder = (TextFieldBuilder)entryBuilder;
            this.maxLength = fieldBuilder.maxLength;
            this.editStyle = fieldBuilder.editStyle;
        }
    }

    public String getKey() {
        return this.key;
    }

    public FieldIdGenerationParam getFieldIdGenerationParam() {
        return this.fieldIdGenerationParam;
    }

    public String getName() {
        return this.name;
    }

    public String getForeColor() {
        return this.foreColor;
    }

    public String getBackColor() {
        return this.backColor;
    }

    public String getLock() {
        return this.lock;
    }

    public String getWidth() {
        return this.width;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getTextAlign() {
        return this.textAlign;
    }

    public static String getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    public boolean isHyperlink() {
        return this.isHyperlink;
    }

    public Tips getTips() {
        return this.tips;
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public boolean isMustInput() {
        return this.mustInput;
    }

    public Features getFeatures() {
        return this.features;
    }

    public Object getDefValue() {
        return this.defValue;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public String getVisible() {
        return this.visible;
    }

    public boolean isDbIgnore() {
        return this.dbIgnore;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isNoDisplayScaleZero() {
        return this.noDisplayScaleZero;
    }

    public boolean isFireUpdEvt() {
        return this.isFireUpdEvt;
    }

    public boolean isQuickAddNew() {
        return this.quickAddNew;
    }

    public String getDisplayFormatString() {
        return this.displayFormatString;
    }

    public String getMask() {
        return this.mask;
    }

    public String getCurrencyFieldId() {
        return this.currencyFieldId;
    }

    public String getAmountPrecisionType() {
        return this.amountPrecisionType;
    }

    public String getBaseEntityId() {
        return this.baseEntityId;
    }

    public boolean isViewDetail() {
        return this.viewDetail;
    }

    public String getDisplayProp() {
        return this.displayProp;
    }

    public int getDisplayStyle() {
        return this.displayStyle;
    }

    public int getBasedataEditStyle() {
        return this.basedataEditStyle;
    }

    public String getStartDateFieldKey() {
        return this.startDateFieldKey;
    }

    public String getStartDateFieldName() {
        return this.startDateFieldName;
    }

    public String getEndDateFieldKey() {
        return this.endDateFieldKey;
    }

    public String getEndDateFieldName() {
        return this.endDateFieldName;
    }

    public LocaleString getEmptyText() {
        return this.emptyText;
    }

    public int getRegionType() {
        return this.regionType;
    }

    public String getMinDate() {
        return this.minDate;
    }

    public String getMaxDate() {
        return this.maxDate;
    }

    public int getTimeZoneTransType() {
        return this.timeZoneTransType;
    }

    public String getRelateOrg() {
        return this.relateOrg;
    }

    public DefValueDesign getDefValueDesign() {
        return this.defValueDesign;
    }

    public boolean isUseRegion() {
        return this.useRegion;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public int getPrivacyType() {
        return this.privacyType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isZeroShow() {
        return this.zeroShow;
    }

    public String getDataScope() {
        return this.dataScope;
    }

    public String getControlPropName() {
        return this.controlPropName;
    }

    public boolean isEnableNull() {
        return this.enableNull;
    }

    public String getEditingMode() {
        return this.editingMode;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getEditStyle() {
        return this.editStyle;
    }

    public boolean isGroupContainer() {
        return this.isGroupContainer;
    }

    public FieldTypeEnum getFieldType() {
        return this.fieldType;
    }

    public static class TextFieldBuilder
    extends FieldBuilder {
        private int maxLength = 255;
        private int editStyle;

        public static TextFieldBuilder createInstance() {
            return new TextFieldBuilder();
        }

        public TextFieldBuilder setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public TextFieldBuilder setEditStyle(int editStyle) {
            this.editStyle = editStyle;
            return this;
        }

        @Override
        public DynamicEntry build() {
            return new DynamicEntry(this);
        }
    }

    public static class DecimalBuilder
    extends FieldBuilder {
        private int precision = 15;
        private int scale = 2;
        private boolean zeroShow = true;
        private String dataScope = "[0,100]";
        private String controlPropName;
        private boolean enableNull = true;
        private FieldTypeEnum fieldType = FieldTypeEnum.DECIMAL;
        private String editingMode = "summary";
        private int maxLength = 50;
        private int editStyle;

        public static DecimalBuilder createInstance() {
            return new DecimalBuilder();
        }

        public DecimalBuilder setPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        public DecimalBuilder setScale(int scale) {
            this.scale = scale;
            return this;
        }

        public DecimalBuilder setZeroShow(boolean zeroShow) {
            this.zeroShow = zeroShow;
            return this;
        }

        public DecimalBuilder setDataScope(String dataScope) {
            this.dataScope = dataScope;
            return this;
        }

        public DecimalBuilder setControlPropName(String controlPropName) {
            this.controlPropName = controlPropName;
            return this;
        }

        public DecimalBuilder setEnableNull(boolean enableNull) {
            this.enableNull = enableNull;
            return this;
        }

        public DecimalBuilder setEditingMode(String editingMode) {
            this.editingMode = editingMode;
            return this;
        }

        public DecimalBuilder setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public DecimalBuilder setEditStyle(int editStyle) {
            this.editStyle = editStyle;
            return this;
        }

        @Override
        public DynamicEntry build() {
            return new DynamicEntry(this);
        }
    }

    public static class DateTimeBuilder
    extends FieldBuilder {
        private String minDate;
        private String maxDate;
        private int timeZoneTransType = 0;
        private String relateOrg;
        private int regionType = 2;
        private String defValue;
        private DefValueDesign defValueDesign;
        private boolean useRegion;
        private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        private LocaleString emptyText;
        private int privacyType;
        private FieldTypeEnum fieldType = FieldTypeEnum.DATE_TIME;

        public static DateTimeBuilder createInstance() {
            return new DateTimeBuilder();
        }

        public DateTimeBuilder setRegionType(int regionType) {
            this.regionType = regionType;
            return this;
        }

        public DateTimeBuilder setDefValue(String defValue) {
            this.defValue = defValue;
            return this;
        }

        public DateTimeBuilder setEmptyText(LocaleString emptyText) {
            this.emptyText = emptyText;
            return this;
        }

        public DateTimeBuilder setMinDate(String minDate) {
            this.minDate = minDate;
            return this;
        }

        public DateTimeBuilder setMaxDate(String maxDate) {
            this.maxDate = maxDate;
            return this;
        }

        public DateTimeBuilder setTimeZoneTransType(int timeZoneTransType) {
            this.timeZoneTransType = timeZoneTransType;
            return this;
        }

        public DateTimeBuilder setRelateOrg(String relateOrg) {
            this.relateOrg = relateOrg;
            return this;
        }

        public DateTimeBuilder setDefValueDesign(DefValueDesign defValueDesign) {
            this.defValueDesign = defValueDesign;
            return this;
        }

        public DateTimeBuilder setUseRegion(boolean useRegion) {
            this.useRegion = useRegion;
            return this;
        }

        public DateTimeBuilder setDateFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public DateTimeBuilder setPrivacyType(int privacyType) {
            this.privacyType = privacyType;
            return this;
        }

        @Override
        public DynamicEntry build() {
            return new DynamicEntry(this);
        }
    }

    public static class DateRangeBuilder
    extends FieldBuilder {
        private String startDateFieldKey;
        private String startDateFieldName;
        private String endDateFieldKey;
        private String endDateFieldName;
        private LocaleString emptyText;
        private Integer regionType = 1;
        private String defValue;

        public static DateRangeBuilder createInstance() {
            return new DateRangeBuilder();
        }

        public DateRangeBuilder setStartDateFieldKey(String startDateFieldKey) {
            this.startDateFieldKey = startDateFieldKey;
            return this;
        }

        public DateRangeBuilder setStartDateFieldName(String startDateFieldName) {
            this.startDateFieldName = startDateFieldName;
            return this;
        }

        public DateRangeBuilder setEndDateFieldKey(String endDateFieldKey) {
            this.endDateFieldKey = endDateFieldKey;
            return this;
        }

        public DateRangeBuilder setEndDateFieldName(String endDateFieldName) {
            this.endDateFieldName = endDateFieldName;
            return this;
        }

        public DateRangeBuilder setEmptyText(LocaleString emptyText) {
            this.emptyText = emptyText;
            return this;
        }

        public DateRangeBuilder setRegionType(int regionType) {
            this.regionType = regionType;
            return this;
        }

        public DateRangeBuilder setDefValue(String defValue) {
            this.defValue = defValue;
            return this;
        }

        @Override
        public DynamicEntry build() {
            return new DynamicEntry(this);
        }
    }

    public static class MulBaseDataBuilder
    extends FieldBuilder {
        private String displayProp = "name";
        private String baseEntityId;
        private FieldTypeEnum fieldType = FieldTypeEnum.BASE_DATA;

        public static MulBaseDataBuilder createInstance() {
            return new MulBaseDataBuilder();
        }

        public MulBaseDataBuilder setDisplayProp(String displayProp) {
            this.displayProp = displayProp;
            return this;
        }

        public MulBaseDataBuilder setBaseEntityId(String baseEntityId) {
            this.baseEntityId = baseEntityId;
            return this;
        }

        @Override
        public DynamicEntry build() {
            return new DynamicEntry(this);
        }
    }

    public static class BaseDataBuilder
    extends FieldBuilder {
        private String baseEntityId;
        private boolean viewDetail = true;
        private String displayProp = "name";
        private int displayStyle = 0;
        private int basedataEditStyle = 0;
        private FieldTypeEnum fieldType = FieldTypeEnum.BASE_DATA;

        public static BaseDataBuilder createInstance() {
            return new BaseDataBuilder();
        }

        public BaseDataBuilder setBaseEntityId(String baseEntityId) {
            this.baseEntityId = baseEntityId;
            return this;
        }

        public BaseDataBuilder setViewDetail(boolean viewDetail) {
            this.viewDetail = viewDetail;
            return this;
        }

        public BaseDataBuilder setDisplayProp(String displayProp) {
            this.displayProp = displayProp;
            return this;
        }

        public BaseDataBuilder setDisplayStyle(int displayStyle) {
            this.displayStyle = displayStyle;
            return this;
        }

        public BaseDataBuilder setBasedataEditStyle(int basedataEditStyle) {
            this.basedataEditStyle = basedataEditStyle;
            return this;
        }

        @Override
        public DynamicEntry build() {
            return new DynamicEntry(this);
        }
    }

    public static class AmountBuilder
    extends DecimalBuilder {
        private String currencyFieldId;
        private String amountPrecisionType;
        private FieldTypeEnum fieldType = FieldTypeEnum.AMOUNT;

        public static AmountBuilder createInstance() {
            return new AmountBuilder();
        }

        public AmountBuilder setCurrencyFieldId(String currencyFieldId) {
            this.currencyFieldId = currencyFieldId;
            return this;
        }

        public AmountBuilder setAmountPrecisionType(String amountPrecisionType) {
            this.amountPrecisionType = amountPrecisionType;
            return this;
        }

        @Override
        public DynamicEntry build() {
            return new DynamicEntry(this);
        }
    }

    public static class ComboBuilder
    extends FieldBuilder {
        private String defValue;

        public static ComboBuilder createInstance() {
            return new ComboBuilder();
        }

        public ComboBuilder setCurrencyFieldId(String defValue) {
            this.defValue = defValue;
            return this;
        }

        @Override
        public DynamicEntry build() {
            return new DynamicEntry(this);
        }
    }

    public static class FieldBuilder
    extends EntryBuilder {
        private static final String DEFAULT_WIDTH = "200";
        private boolean isHyperlink;
        private Tips tips;
        private boolean showTitle = true;
        private boolean mustInput = false;
        private Features features;
        private Object defValue = null;
        private boolean isFixed = false;
        private String visible = "init,new,edit,view,submit,audit";
        private boolean dbIgnore = true;
        private String fieldName;
        private boolean noDisplayScaleZero;
        private boolean isFireUpdEvt = true;
        private boolean quickAddNew = false;
        private String displayFormatString;
        private String mask;

        public static FieldBuilder createInstance() {
            return new FieldBuilder();
        }

        public FieldBuilder setHyperlink(boolean hyperlink) {
            this.isHyperlink = hyperlink;
            return this;
        }

        public FieldBuilder setTips(Tips tips) {
            this.tips = tips;
            return this;
        }

        public FieldBuilder setShowTitle(boolean showTitle) {
            this.showTitle = showTitle;
            return this;
        }

        public FieldBuilder setMustInput(boolean mustInput) {
            this.mustInput = mustInput;
            return this;
        }

        public FieldBuilder setFeatures(Features features) {
            this.features = features;
            return this;
        }

        public FieldBuilder setDefValue(Object defValue) {
            this.defValue = defValue;
            return this;
        }

        public FieldBuilder setFixed(boolean fixed) {
            this.isFixed = fixed;
            return this;
        }

        public FieldBuilder setVisible(String visible) {
            this.visible = visible;
            return this;
        }

        public FieldBuilder setDbIgnore(boolean dbIgnore) {
            this.dbIgnore = dbIgnore;
            return this;
        }

        public FieldBuilder setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public FieldBuilder setNoDisplayScaleZero(boolean noDisplayScaleZero) {
            this.noDisplayScaleZero = noDisplayScaleZero;
            return this;
        }

        public FieldBuilder setFireUpdEvt(boolean fireUpdEvt) {
            this.isFireUpdEvt = fireUpdEvt;
            return this;
        }

        public FieldBuilder setQuickAddNew(boolean quickAddNew) {
            this.quickAddNew = quickAddNew;
            return this;
        }

        public FieldBuilder setDisplayFormatString(String displayFormatString) {
            this.displayFormatString = displayFormatString;
            return this;
        }

        public FieldBuilder setMask(String mask) {
            this.mask = mask;
            return this;
        }

        @Override
        public DynamicEntry build() {
            return new DynamicEntry(this);
        }
    }

    public static abstract class EntryBuilder {
        private String key;
        private FieldIdGenerationParam fieldIdGenerationParam;
        private String name;
        private String foreColor;
        private String backColor;
        private String lock;
        private String width;
        private boolean hidden = false;
        private String textAlign = "left";
        private boolean isGroupContainer = false;
        private FieldTypeEnum fieldType = FieldTypeEnum.TEXT;

        public EntryBuilder setKey(String key) {
            this.key = key;
            return this;
        }

        public EntryBuilder setFieldIdGenerationParam(FieldIdGenerationParam fieldIdGenerationParam) {
            this.fieldIdGenerationParam = fieldIdGenerationParam;
            return this;
        }

        public EntryBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public EntryBuilder setForeColor(String foreColor) {
            this.foreColor = foreColor;
            return this;
        }

        public EntryBuilder setBackColor(String backColor) {
            this.backColor = backColor;
            return this;
        }

        public EntryBuilder setLock(String lock) {
            this.lock = lock;
            return this;
        }

        public EntryBuilder setWidth(String width) {
            this.width = width;
            return this;
        }

        public EntryBuilder setHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public EntryBuilder setTextAlign(String textAlign) {
            this.textAlign = textAlign;
            return this;
        }

        public EntryBuilder setGroupContainer(boolean groupContainer) {
            this.isGroupContainer = groupContainer;
            return this;
        }

        public EntryBuilder setFieldType(FieldTypeEnum fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public DynamicEntry build() {
            return new DynamicEntry(this);
        }
    }

    public static enum FieldTypeEnum {
        BASE_DATA,
        TEXT,
        AMOUNT,
        DECIMAL,
        DATE_TIME;

    }
}

