/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.dynamic;

import kd.bos.entity.Features;
import kd.bos.metadata.entity.EntityMetadata;
import kd.sit.sitbp.business.dynamic.AbstractContainerFactory;
import kd.sit.sitbp.business.dynamic.DynamicEntry;
import kd.sit.sitbp.business.dynamic.grid.BasedataFieldParamContainer;
import kd.sit.sitbp.business.dynamic.grid.DecimalFieldParamContainer;
import kd.sit.sitbp.business.dynamic.grid.EntryParamContainer;
import kd.sit.sitbp.business.dynamic.grid.FieldParamContainer;
import kd.sit.sitbp.business.dynamic.grid.TextFieldParamContainer;

class FieldContainerFactory
extends AbstractContainerFactory {
    protected FieldContainerFactory(EntityMetadata entityMetadata, Features features, DynamicEntry dynamicEntryDTO) {
        super(entityMetadata, features, dynamicEntryDTO);
    }

    @Override
    public FieldParamContainer createEntryParamContainer() {
        if (this.dynamicEntryDTO.getFieldType() == null) {
            return null;
        }
        FieldParamContainer entryParamContainer = null;
        switch (this.dynamicEntryDTO.getFieldType()) {
            case AMOUNT: 
            case DECIMAL: {
                entryParamContainer = this.createDecimalFieldParamContainer();
                break;
            }
            case TEXT: {
                entryParamContainer = this.createTextFieldParamContainer();
                break;
            }
            case BASE_DATA: {
                entryParamContainer = this.createBasedataFieldParamContainer();
                break;
            }
        }
        return entryParamContainer;
    }

    @Override
    protected void initEntryParamContainer(EntryParamContainer entryParamContainer) {
        super.initEntryParamContainer(entryParamContainer);
        FieldParamContainer fieldParamContainer = (FieldParamContainer)entryParamContainer;
        fieldParamContainer.setFixed(this.dynamicEntryDTO.isFixed());
        fieldParamContainer.setVisible(this.dynamicEntryDTO.getVisible());
        fieldParamContainer.setFeatures(this.features);
        fieldParamContainer.setVisible(this.dynamicEntryDTO.getVisible());
        fieldParamContainer.setHidden(this.dynamicEntryDTO.isHidden());
    }

    private FieldParamContainer createDecimalFieldParamContainer() {
        DecimalFieldParamContainer fieldParamContainer = new DecimalFieldParamContainer();
        this.initEntryParamContainer(fieldParamContainer);
        fieldParamContainer.setZeroShow(this.dynamicEntryDTO.isZeroShow());
        fieldParamContainer.setEnableNull(this.dynamicEntryDTO.isEnableNull());
        fieldParamContainer.setScale(this.dynamicEntryDTO.getScale());
        fieldParamContainer.setPrecision(this.dynamicEntryDTO.getPrecision());
        return fieldParamContainer;
    }

    private FieldParamContainer createTextFieldParamContainer() {
        TextFieldParamContainer fieldParamContainer = new TextFieldParamContainer();
        this.initEntryParamContainer(fieldParamContainer);
        fieldParamContainer.setMaxLength(this.dynamicEntryDTO.getMaxLength());
        return fieldParamContainer;
    }

    private FieldParamContainer createBasedataFieldParamContainer() {
        BasedataFieldParamContainer fieldParamContainer = new BasedataFieldParamContainer();
        this.initEntryParamContainer(fieldParamContainer);
        fieldParamContainer.setDisplayProp(this.dynamicEntryDTO.getDisplayProp());
        fieldParamContainer.setBaseEntityId(this.dynamicEntryDTO.getBaseEntityId());
        return fieldParamContainer;
    }
}

