/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.dynamic.grid;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.xdb.util.Pair;
import kd.sit.sitbp.business.dynamic.grid.FieldParamContainer;

public class ComboFieldParamContainer
extends FieldParamContainer {
    private static final long serialVersionUID = 5115000709108473366L;
    private String defValue;
    private List<Pair<String, String>> items = new ArrayList<Pair<String, String>>();

    @Override
    public String getDefValue() {
        return this.defValue;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    public boolean addItems(Pair<String, String> ... comboItems) {
        for (Pair<String, String> comboItem : comboItems) {
            this.items.add(comboItem);
        }
        return true;
    }

    @Override
    <T extends DynamicProperty> T createProp() {
        return (T)new ComboProp();
    }

    @Override
    <T extends DynamicProperty> void setPropProperty(T prop) {
        ComboProp comboProp = (ComboProp)prop;
        List mapItems = this.items.stream().map(ele -> new ValueMapItem("", (String)ele.getKey(), new LocaleString((String)ele.getValue()))).collect(Collectors.toList());
        comboProp.setComboItems(mapItems);
    }

    @Override
    <T extends DynamicProperty> void doRegisterProp(T prop, EntityType entityType) {
        entityType.registerSimpleProperty((DynamicSimpleProperty)((ComboProp)prop));
    }

    @Override
    <T extends Field> T createField() {
        return (T)new ComboField();
    }

    @Override
    protected <T extends Field> void setFieldProperties(T field) {
        super.setFieldProperties(field);
        ComboField comboField = (ComboField)field;
        for (int i = 0; i < this.items.size(); ++i) {
            Pair<String, String> pair = this.items.get(i);
            ComboItem item = new ComboItem(i, new LocaleString((String)pair.getValue()), (String)pair.getKey());
            comboField.getItems().add(item);
        }
        comboField.setEntityMetadata(this.getEntityMetadata());
        comboField.setDefValue(this.defValue);
    }
}

