/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.dynamic.grid;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.EntityType;
import kd.bos.entity.Features;
import kd.bos.entity.Tips;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldContainerAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.sit.sitbp.business.dynamic.FieldIdGenerationParam;
import kd.sit.sitbp.business.dynamic.grid.EntryParamContainer;
import kd.sit.sitbp.business.dynamic.grid.FieldContainerParamContainer;
import kd.sit.sitbp.business.dynamic.grid.FieldParamContainer;
import kd.sit.sitbp.business.dynamic.grid.GroupParamContainer;
import kd.sit.sitbp.common.util.SITStringUtils;
import org.apache.commons.lang.StringUtils;

public class EntryParamContainerBaseHelper {
    private static final Log LOGGER = LogFactory.getLog(EntryParamContainerBaseHelper.class);

    public static void addChild(List<EntryParamContainer> allContainer, GroupParamContainer topContainer, EntryParamContainer child) {
        if (child == null) {
            LOGGER.error("EntryParamContainerBaseHelper.addChild: child is null.");
            return;
        }
        if (topContainer != null) {
            topContainer.addChild(child);
        } else {
            allContainer.add(child);
        }
    }

    public static void setBaseFieldValue(FieldParamContainer fieldParamContainer, FieldIdGenerationParam idGenParam, String name, String lock, String backColor, String width, boolean hidden, String textAlign, EntityMetadata entityMetadata, Tips tips, Features features) {
        fieldParamContainer.setFieldIdGenerationParam(idGenParam);
        fieldParamContainer.setKey(idGenParam.generateKey());
        fieldParamContainer.setName(name);
        fieldParamContainer.setLock(lock);
        fieldParamContainer.setBackColor(backColor);
        fieldParamContainer.setWidth(width);
        fieldParamContainer.setHidden(hidden);
        fieldParamContainer.setTextAlign(textAlign);
        fieldParamContainer.setEntityMetadata(entityMetadata);
        fieldParamContainer.setTips(tips);
        fieldParamContainer.setFeatures(features);
    }

    public static GroupParamContainer createEntryContainer(String defEntryKey) {
        GroupParamContainer entContainer = new GroupParamContainer();
        entContainer.setKey(SITStringUtils.isEmpty((String)defEntryKey) ? "entryentity" : defEntryKey);
        return entContainer;
    }

    public static GroupParamContainer createGroupParamContainer(String groupKey, String groupHeaderName, boolean hidden) {
        GroupParamContainer group = new GroupParamContainer();
        group.setKey(groupKey);
        group.setName(groupHeaderName);
        group.setHidden(hidden);
        return group;
    }

    public static String getFieldIdFromMeta(EntityMetadata entityMetadata, String fieldKey) {
        if (entityMetadata == null || SITStringUtils.isEmpty((String)fieldKey)) {
            LOGGER.error("EntryParamContainerBaseHelper.getFieldIdFromMeta: entityMetadata is {} fieldKey is {}", (Object)(entityMetadata == null ? 1 : 0), (Object)fieldKey);
            return "";
        }
        for (EntityItem item : entityMetadata.getItems()) {
            if (!SITStringUtils.equals((String)item.getKey(), (String)fieldKey)) continue;
            return item.getId();
        }
        return "";
    }

    public static void registProp(List<EntryParamContainer> params, EntityType entityType) {
        if (params == null || params.isEmpty() || entityType == null) {
            LOGGER.error("EntryParamContainerBaseHelper.registProp: entityMetadata is {} entityType is {}", (Object)(params == null || params.isEmpty() ? 1 : 0), (Object)(entityType == null ? 1 : 0));
            return;
        }
        for (EntryParamContainer param : params) {
            if (param instanceof GroupParamContainer) {
                EntryParamContainerBaseHelper.registProp(((GroupParamContainer)param).getChild(), entityType);
            } else if (param instanceof FieldContainerParamContainer) {
                EntryParamContainerBaseHelper.registProp(((FieldContainerParamContainer)param).getChild(), entityType);
            }
            if (!(param instanceof FieldParamContainer)) continue;
            ((FieldParamContainer)param).registerProp(entityType);
        }
    }

    public static EntryAp createEntryAp(String key) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(key);
        entryAp.setOrderAndFilter(1);
        entryAp.setRowHeight("40px");
        entryAp.setWidth(new LocaleString("50%"));
        entryAp.setGrow(0);
        entryAp.setShrink(0);
        entryAp.setShowSeq(true);
        entryAp.setShowSelChexkbox(true);
        entryAp.setMulti(true);
        entryAp.setShowGridConfig(true);
        entryAp.setTextAlign("left");
        return entryAp;
    }

    public static FieldEdit initFieldEdit(FieldEdit fieldEdit, IFormView view, String key, String entryKey) {
        FieldEdit tmpFieldEdit = fieldEdit == null ? new FieldEdit() : fieldEdit;
        tmpFieldEdit.setFieldKey(key);
        tmpFieldEdit.setEntryKey(entryKey);
        tmpFieldEdit.setEntryControlKey(entryKey);
        tmpFieldEdit.setView(view);
        tmpFieldEdit.setKey(key);
        tmpFieldEdit.setModel(view.getModel());
        if (tmpFieldEdit instanceof BasedataEdit) {
            BasedataEdit baseDataEdit = (BasedataEdit)tmpFieldEdit;
            baseDataEdit.setF7BatchFill(false);
            baseDataEdit.setF7MultipleSelect(false);
        }
        return fieldEdit;
    }

    public static EntryAp createControlAp(List<EntryParamContainer> containers) {
        EntryAp rootAp = EntryParamContainerBaseHelper.createEntryAp("entryentity");
        return EntryParamContainerBaseHelper.createControlAp(rootAp, containers);
    }

    public static EntryAp createControlAp(EntryAp rootAp, List<EntryParamContainer> containers) {
        if (containers == null || rootAp == null) {
            LOGGER.error("EntryParamContainerBaseHelper.createControlAp, containers is {}, rootAp is {}", containers, (Object)rootAp);
            return null;
        }
        for (EntryParamContainer container : containers) {
            if (container instanceof GroupParamContainer) {
                EntryFieldGroupAp groupAp = ((GroupParamContainer)container).createGroupAp();
                rootAp.getItems().add(groupAp);
                EntryParamContainerBaseHelper.createForGroupAp(((GroupParamContainer)container).getChild(), groupAp);
                continue;
            }
            if (container instanceof FieldContainerParamContainer) {
                EntryFieldContainerAp containerAp = ((FieldContainerParamContainer)container).createContainerAp();
                rootAp.getItems().add(containerAp);
                EntryParamContainerBaseHelper.createForFieldContainerAp(((FieldContainerParamContainer)container).getChild(), containerAp);
                continue;
            }
            if (!(container instanceof FieldParamContainer)) continue;
            EntryFieldAp fieldAp = ((FieldParamContainer)container).createEntryFieldAp();
            rootAp.getItems().add(fieldAp);
        }
        return rootAp;
    }

    public static FlexPanelAp createControlAp(FlexPanelAp rootAp, List<EntryParamContainer> containers) {
        if (containers == null || containers.isEmpty() || rootAp == null) {
            LOGGER.error("EntryParamContainerBaseHelper.createControlAp, containers is {}, rootAp is {}", containers, (Object)rootAp);
            return rootAp;
        }
        for (EntryParamContainer container : containers) {
            if (container instanceof GroupParamContainer) {
                EntryFieldGroupAp groupAp = ((GroupParamContainer)container).createGroupAp();
                rootAp.getItems().add(groupAp);
                EntryParamContainerBaseHelper.createForGroupAp(((GroupParamContainer)container).getChild(), groupAp);
                continue;
            }
            if (container instanceof FieldContainerParamContainer) {
                EntryFieldContainerAp containerAp = ((FieldContainerParamContainer)container).createContainerAp();
                rootAp.getItems().add(containerAp);
                EntryParamContainerBaseHelper.createForFieldContainerAp(((FieldContainerParamContainer)container).getChild(), containerAp);
                continue;
            }
            if (!(container instanceof FieldParamContainer)) continue;
            EntryFieldAp fieldAp = ((FieldParamContainer)container).createEntryFieldAp();
            rootAp.getItems().add(fieldAp);
        }
        return rootAp;
    }

    private static void createForGroupAp(List<EntryParamContainer> containers, EntryFieldGroupAp parentGroupAp) {
        for (EntryParamContainer container : containers) {
            if (container instanceof GroupParamContainer) {
                EntryFieldGroupAp groupAp = ((GroupParamContainer)container).createGroupAp();
                parentGroupAp.getItems().add(groupAp);
                EntryParamContainerBaseHelper.createForGroupAp(((GroupParamContainer)container).getChild(), groupAp);
                continue;
            }
            if (!(container instanceof FieldParamContainer)) continue;
            EntryFieldAp fieldAp = ((FieldParamContainer)container).createEntryFieldAp();
            parentGroupAp.getItems().add(fieldAp);
        }
    }

    private static void createForFieldContainerAp(List<EntryParamContainer> containers, EntryFieldContainerAp fieldContainerAp) {
        for (EntryParamContainer container : containers) {
            if (container instanceof FieldContainerParamContainer) {
                EntryFieldContainerAp subFieldContainerAp = ((FieldContainerParamContainer)container).createContainerAp();
                fieldContainerAp.getItems().add(subFieldContainerAp);
                EntryParamContainerBaseHelper.createForFieldContainerAp(((FieldContainerParamContainer)container).getChild(), subFieldContainerAp);
                continue;
            }
            if (!(container instanceof FieldParamContainer)) continue;
            EntryFieldAp fieldAp = ((FieldParamContainer)container).createEntryFieldAp();
            fieldContainerAp.getItems().add(fieldAp);
        }
    }

    public static Features createInitFeature(boolean switchFlag) {
        Features features = new Features();
        features.setCopyable(switchFlag);
        features.setMultiFillable(switchFlag);
        features.setImportable(switchFlag);
        features.setExportable(switchFlag);
        features.setSeriesNewTote(switchFlag);
        features.setBulkEditable(switchFlag);
        features.setConvertTote(switchFlag);
        features.setAllowvoucher(switchFlag);
        features.setF7BatchFill(switchFlag);
        return features;
    }

    public static void updateEntryGrid(IFormView view, EntryGrid grid, String fieldKey) {
        List subItems;
        int index;
        if (view == null || grid == null || StringUtils.isEmpty((String)fieldKey)) {
            LOGGER.error("EntryParamContainerBaseHelper.updateEntryGrid: view is {} grid is {} fieldKey is {}", new Object[]{view == null, grid == null, fieldKey});
            return;
        }
        Container entryParentAp = EntryParamContainerBaseHelper.findControl((Container)view.getRootControl(), fieldKey);
        if (entryParentAp != null && entryParentAp.getItems() != null && (index = EntryParamContainerBaseHelper.findControlIndex(subItems = entryParentAp.getItems(), fieldKey)) >= 0) {
            subItems.set(index, grid);
            view.createControlIndex(grid.getItems());
        }
    }

    private static Container findControl(Container srcControl, String key) {
        Container destControl = null;
        if (srcControl != null && srcControl.getItems() != null) {
            Set subKeys = srcControl.getItems().stream().map(Control::getKey).collect(Collectors.toSet());
            if (subKeys.contains(key)) {
                return srcControl;
            }
            for (Control item : srcControl.getItems()) {
                if (!(item instanceof Container) || (destControl = EntryParamContainerBaseHelper.findControl((Container)item, key)) == null) continue;
                return destControl;
            }
        }
        return destControl;
    }

    private static int findControlIndex(List<Control> controls, String key) {
        int index = -1;
        for (int i = 0; i < controls.size(); ++i) {
            String target = controls.get(i).getKey();
            if (!StringUtils.equals((String)target, (String)key)) continue;
            index = i;
            break;
        }
        return index;
    }
}

