/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.entrygrid;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridSetRowDataEvent;
import kd.bos.form.control.events.EntryGridSetRowDataListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public interface SitEntryGridSetRowDataListener
extends EntryGridSetRowDataListener {
    public static final Log LOGGER = LogFactory.getLog(SitEntryGridSetRowDataListener.class);

    default public void entryGridSetRowData(EntryGridSetRowDataEvent event) {
        Map columnMap = event.getValues();
        if (!CollectionUtils.isEmpty((Map)columnMap) && event.getSource() instanceof EntryGrid) {
            int preRowSize = 0;
            EntryGrid entryGrid = (EntryGrid)event.getSource();
            IFormView formView = entryGrid.getView();
            String preRowSizeStr = formView.getPageCache().get(entryGrid.getEntryKey() + "preRowSize");
            if (HRStringUtils.isNotEmpty((String)preRowSizeStr)) {
                preRowSize = Integer.parseInt(preRowSizeStr);
            }
            String isUpdateView = formView.getPageCache().get("BOS.setRowDataByNumberUpdateView");
            LOGGER.info("SitEntryGridSetRowDataListener.entryGridSetRowData: the preRowSize is {}, rowSize is {}, and isUpdateView is {}", new Object[]{preRowSize, entryGrid.getModel().getEntryEntity(entryGrid.getEntryKey()).size(), isUpdateView});
            preRowSize = preRowSize > 0 ? preRowSize : entryGrid.getModel().getEntryEntity(entryGrid.getEntryKey()).size();
            HashSet<Integer> outIndexes = new HashSet<Integer>(16);
            Iterator columnIterator = columnMap.entrySet().iterator();
            while (columnIterator.hasNext()) {
                Map.Entry entry = columnIterator.next();
                List itemValueList = (List)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)itemValueList)) continue;
                Iterator itemValueIterator = itemValueList.iterator();
                while (itemValueIterator.hasNext()) {
                    Tuple tuple = (Tuple)itemValueIterator.next();
                    Integer seq = (Integer)tuple.item1;
                    if (seq + 1 <= preRowSize) continue;
                    outIndexes.add(seq);
                    itemValueIterator.remove();
                }
                if (!itemValueList.isEmpty()) continue;
                columnIterator.remove();
            }
            int[] outIndexArr = outIndexes.stream().mapToInt(Integer::intValue).toArray();
            if (outIndexArr != null) {
                AbstractFormDataModel model = (AbstractFormDataModel)entryGrid.getModel();
                model.deleteEntryRows(entryGrid.getEntryKey(), outIndexArr);
            }
        }
    }
}

