/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.enums;

import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.common.model.SITI18NParam;

public enum TaxDataBizStatusEnum {
    DO_DEL("03", new SITI18NParam("\u5220\u9664", "TaxDataBizStatus_03", "sit-itc-common")),
    TO_DEL("05", new SITI18NParam("\u9000\u56de", "TaxDataBizStatus_05", "sit-itc-common")),
    NEW("10", new SITI18NParam("\u65b0\u589e", "TaxDataBizStatus_10", "sit-itc-common")),
    BACK("11", new SITI18NParam("\u9000\u56de", "TaxDataBizStatus_11", "sit-itc-common")),
    UPDATE("12", new SITI18NParam("\u65b0\u589e", "TaxDataBizStatus_12", "sit-itc-common")),
    TO_NEW("13", new SITI18NParam("\u65b0\u589e", "TaxDataBizStatus_13", "sit-itc-common")),
    REFER("15", new SITI18NParam("\u5bfc\u5165\u7b97\u85aa\u6570\u636e", "TaxDataBizStatus_15", "sit-itc-common")),
    EXPORT("20", new SITI18NParam("\u5bfc\u51fa\u7533\u62a5\u8868", "TaxDataBizStatus_20", "sit-itc-common")),
    LOCK("25", new SITI18NParam("\u9501\u5b9a", "TaxDataBizStatus_25", "sit-itc-common")),
    EXPORT_LOCK("30", new SITI18NParam("\u5bfc\u51fa\u7533\u62a5\u8868\u5e76\u9501\u5b9a", "TaxDataBizStatus_30", "sit-itc-common")),
    IMPORT("40", new SITI18NParam("\u5bfc\u5165\u7a0e\u5c40\u7ed3\u679c", "TaxDataBizStatus_40", "sit-itc-common")),
    FEEDBACK("50", new SITI18NParam("\u63a8\u56de\u7b97\u85aa", "TaxDataBizStatus_50", "sit-itc-common")),
    DECLARE("60", new SITI18NParam("\u5df2\u7533\u62a5", "TaxDataBizStatus_60", "sit-itc-common")),
    CONFIRM("70", new SITI18NParam("\u5df2\u786e\u8ba4", "TaxDataBizStatus_60", "sit-itc-common")),
    END("90", new SITI18NParam("\u5df2\u7ed3\u675f", "TaxDataBizStatus_90", "sit-itc-common"));

    private final String code;
    private final SITI18NParam i18nParam;

    private TaxDataBizStatusEnum(String code, SITI18NParam i18nParam) {
        this.code = code;
        this.i18nParam = i18nParam;
    }

    public String getCode() {
        return this.code;
    }

    public SITI18NParam getI18nParam() {
        return this.i18nParam;
    }

    public String getI18nParamString() {
        return this.i18nParam.loadKDString();
    }

    public static String getI18nNameByCode(String code) {
        for (TaxDataBizStatusEnum statusEnum : TaxDataBizStatusEnum.values()) {
            if (!statusEnum.code.equals(code)) continue;
            return statusEnum.i18nParam.loadKDString();
        }
        return TaxDataBizStatusEnum.NEW.i18nParam.loadKDString();
    }

    public static TaxDataBizStatusEnum getStatusEnum(DynamicObject taxData) {
        String refOpType = taxData.getString("refoprecord.optype");
        boolean refer = StringUtils.isEmpty((CharSequence)refOpType) ? REFER.isLessEqThan(taxData.getString("bizstatus")) : TaxTaskGuideOpEnum.isYes(refOpType);
        return TaxDataBizStatusEnum.getStatusEnum(refer, TaxTaskGuideOpEnum.isYes(taxData.getString("exportoprecord.optype")), TaxTaskGuideOpEnum.isYes(taxData.getString("lockoprecord.optype")), TaxTaskGuideOpEnum.isYes(taxData.getString("importoprecord.optype")), TaxTaskGuideOpEnum.isYes(taxData.getString("feedbackoprecord.optype")), TaxTaskGuideOpEnum.isYes(taxData.getString("reportoprecord.optype")), TaxTaskGuideOpEnum.isYes(taxData.getString("confirmoprecord.optype")), TaxTaskGuideOpEnum.isYes(taxData.getString("endoprecord.optype")));
    }

    @Deprecated
    public static TaxDataBizStatusEnum getStatusEnum(boolean exportStatus, boolean lockStatus, boolean importStatus, boolean feedbackStatus, boolean reportStatus, boolean confirmStatus, boolean endStatus) {
        return TaxDataBizStatusEnum.getStatusEnum(true, endStatus, lockStatus, importStatus, feedbackStatus, reportStatus, confirmStatus, endStatus);
    }

    public static void rollbackStatusFromRawData(DynamicObject taxData, List<DynamicObject> rawDataList) {
        Iterator<DynamicObject> iterator = rawDataList.iterator();
        DynamicObject rawData = iterator.next();
        taxData.set("refoprecord", rawData.get("refoprecord"));
        taxData.set("exportoprecord", rawData.get("exportoprecord"));
        taxData.set("lockoprecord", rawData.get("lockoprecord"));
        taxData.set("importoprecord", rawData.get("importoprecord"));
        taxData.set("feedbackoprecord", rawData.get("feedbackoprecord"));
        taxData.set("reportoprecord", rawData.get("reportoprecord"));
        taxData.set("confirmoprecord", rawData.get("confirmoprecord"));
        taxData.set("endoprecord", rawData.get("endoprecord"));
        while (iterator.hasNext()) {
            DynamicObject rd = iterator.next();
            if (!TaxTaskGuideOpEnum.isYes(rd.getString("refoprecord.optype"))) {
                taxData.set("refoprecord", rawData.get("refoprecord"));
            }
            if (!TaxTaskGuideOpEnum.isYes(rd.getString("exportoprecord.optype"))) {
                taxData.set("exportoprecord", rawData.get("exportoprecord"));
            }
            if (!TaxTaskGuideOpEnum.isYes(rd.getString("lockoprecord.optype"))) {
                taxData.set("lockoprecord", rawData.get("lockoprecord"));
            }
            if (!TaxTaskGuideOpEnum.isYes(rd.getString("importoprecord.optype"))) {
                taxData.set("importoprecord", rawData.get("importoprecord"));
            }
            if (!TaxTaskGuideOpEnum.isYes(rd.getString("feedbackoprecord.optype"))) {
                taxData.set("feedbackoprecord", rawData.get("feedbackoprecord"));
            }
            if (!TaxTaskGuideOpEnum.isYes(rd.getString("reportoprecord.optype"))) {
                taxData.set("reportoprecord", rawData.get("reportoprecord"));
            }
            if (!TaxTaskGuideOpEnum.isYes(rd.getString("confirmoprecord.optype"))) {
                taxData.set("confirmoprecord", rawData.get("confirmoprecord"));
            }
            if (TaxTaskGuideOpEnum.isYes(rd.getString("endoprecord.optype"))) continue;
            taxData.set("endoprecord", rawData.get("endoprecord"));
        }
        taxData.set("bizstatus", (Object)TaxDataBizStatusEnum.getStatusEnum(taxData).getCode());
    }

    public static TaxDataBizStatusEnum getStatusEnum(boolean refStatus, boolean exportStatus, boolean lockStatus, boolean importStatus, boolean feedbackStatus, boolean reportStatus, boolean confirmStatus, boolean endStatus) {
        if (endStatus) {
            return END;
        }
        if (confirmStatus) {
            return CONFIRM;
        }
        if (reportStatus) {
            return DECLARE;
        }
        if (feedbackStatus && importStatus) {
            return FEEDBACK;
        }
        if (importStatus) {
            return IMPORT;
        }
        if (lockStatus && exportStatus) {
            return EXPORT_LOCK;
        }
        if (lockStatus) {
            return LOCK;
        }
        if (exportStatus) {
            return EXPORT;
        }
        if (refStatus) {
            return REFER;
        }
        return BACK;
    }

    public static TaxDataBizStatusEnum statusAfterLock(String originalStatus) {
        if (EXPORT.getCode().equals(originalStatus)) {
            return EXPORT_LOCK;
        }
        if (StringUtils.isEmpty((CharSequence)originalStatus) || EXPORT.getCode().compareTo(originalStatus) > 0 || LOCK.getCode().equals(originalStatus)) {
            return LOCK;
        }
        return TaxDataBizStatusEnum.fromCode(originalStatus);
    }

    public static TaxDataBizStatusEnum statusAfterUnLock(String originalStatus) {
        if (StringUtils.isNotEmpty((CharSequence)originalStatus) && EXPORT_LOCK.getCode().compareTo(originalStatus) <= 0) {
            return EXPORT;
        }
        if (LOCK.getCode().equals(originalStatus)) {
            return REFER;
        }
        return TaxDataBizStatusEnum.fromCode(originalStatus);
    }

    public static TaxDataBizStatusEnum fromCode(String status) {
        TaxDataBizStatusEnum res = NEW;
        if (StringUtils.isEmpty((CharSequence)status)) {
            return res;
        }
        for (TaxDataBizStatusEnum val : TaxDataBizStatusEnum.values()) {
            if (val.getCode().compareTo(status) == 0) {
                return val;
            }
            if (val.getCode().compareTo(status) > 0) {
                return res;
            }
            res = val;
        }
        return res;
    }

    public static boolean isLocked(String status) {
        return status != null && LOCK.getCode().compareTo(status) <= 0;
    }

    public boolean isLessThan(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return false;
        }
        return this.getCode().compareTo(code) < 0;
    }

    public boolean isLessEqThan(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return false;
        }
        return this.getCode().compareTo(code) <= 0;
    }

    public boolean isGreaterThan(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return true;
        }
        return this.getCode().compareTo(code) > 0;
    }

    public boolean isGreaterEqThan(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return true;
        }
        return this.getCode().compareTo(code) >= 0;
    }
}

