/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.formula.builder;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.formula.cal.vo.AddSumVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalAllParamVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.formula.builder.BaseFormulaNodeItemBuilder;
import kd.sit.sitbp.common.api.BizMessage;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.entity.accumulator.AccumulatorInfo;
import kd.sit.sitbp.common.enums.CalFailTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.TaxCalContext;
import kd.sit.sitbp.common.model.TaxCalUnit;
import kd.sit.sitbp.common.util.SitDateUtil;

public class AccFormulaNodeItemBuilder
extends BaseFormulaNodeItemBuilder {
    private static final Log LOGGER = LogFactory.getLog(AccFormulaNodeItemBuilder.class);
    private static final int SEQ_NO = 90;
    private static final String UC_PREFIX = "AC";

    @Override
    public String uniCodePrefix() {
        return UC_PREFIX;
    }

    @Override
    public int seq(Long country, String appId, Long category, Map<String, Object> cond) {
        return 90;
    }

    @Override
    public boolean match(Long country, String appId, Long category, Map<String, Object> cond) {
        return true;
    }

    @Override
    public List<TreeNodeItem> rootWithAllNode(Long country, String appId, Long category, Map<String, Object> cond) {
        ArrayList<TreeNodeItem> resultList = new ArrayList<TreeNodeItem>(16);
        resultList.add(new TreeNodeItem(UC_PREFIX, UC_PREFIX, "", ResManager.loadKDString((String)"\u7d2f\u52a0\u5668-AC", (String)"TaxCalFormulaEdit_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0])));
        this.assembleAccNode(country, category, resultList);
        return resultList;
    }

    @Override
    public void genCalItemVO(DynamicObject formulaDynamicObj, Set<String> taxItemEntity, Map<String, CalItemVO> uniqueCodeCalItemMap, TaxCalContext taxCalContext) {
        for (String obj : taxItemEntity) {
            CalItemVO fileVO = new CalItemVO();
            String uniCode = this.uniCodeResolver().uniCode(obj);
            fileVO.setDataType(DataTypeEnum.NUM);
            fileVO.setUniqueCode(uniCode);
            fileVO.setId(uniCode);
            uniqueCodeCalItemMap.put(uniCode, fileVO);
        }
    }

    @Override
    public void resolveParams(CalAllParamVO paramVO, Set<String> itemKeys, TaxCalContext taxCalContext, TaxTaskEntity taskEntity, Long catId, String paramId, TaxCalUnit taxCalUnit) {
        Map acMap = (Map)taxCalUnit.getExtraParam(UC_PREFIX);
        if (CollectionUtils.isEmpty((Map)acMap)) {
            LOGGER.info("by cyh: AccFormulaNodeItemBuilder.resolveParams()  acMap is empty");
            return;
        }
        Map addSumVoMap = (Map)acMap.get(catId);
        if (CollectionUtils.isEmpty((Map)addSumVoMap)) {
            LOGGER.info("by cyh: AccFormulaNodeItemBuilder.resolveParams()  addSumVoMap is empty");
            return;
        }
        HashMap<String, Map> accMapMap = paramVO.getParamIdAddSumMap();
        if (accMapMap == null) {
            accMapMap = new HashMap<String, Map>(16);
            paramVO.setParamIdAddSumMap(accMapMap);
        }
        accMapMap.put(paramId, addSumVoMap);
        Map params = (Map)paramVO.getParamIdToParamMap().get(paramId);
        for (String itemKey : itemKeys) {
            String uCode = this.uniCodeResolver().uniCode(itemKey);
            AddSumVO addSumVO = (AddSumVO)addSumVoMap.get(uCode);
            if (addSumVO != null && addSumVO.getOriginalValue() != null) {
                params.put(uCode, addSumVO.getOriginalValue());
                continue;
            }
            params.put(uCode, BigDecimal.ZERO);
        }
    }

    @Override
    public void queryCalElements(TaxCalContext taxCalContext, TaxTaskEntity taskEntity, Map<String, TaxCalUnit> calUnitMap, Set<String> items) {
        if (CollectionUtils.isEmpty(calUnitMap)) {
            return;
        }
        Map accInfoMap = taxCalContext.getAccInfoMap();
        Long currencyId = taxCalContext.getCurrency().getId();
        Long taskId = taskEntity.getId();
        int detailNum = SitDateUtil.toYearMonthDay((Date)taskEntity.getStartDate());
        int taxCategorySize = taskEntity.getTaxCategoryEntityList().size();
        Set accSet = taskEntity.getAccSet();
        if (CollectionUtils.isEmpty((Collection)accSet)) {
            return;
        }
        Set taxFileIdSet = taxCalContext.taxFileIdsOf(calUnitMap.keySet());
        HashMap<Long, Integer> instanceNumMap = new HashMap<Long, Integer>(accSet.size());
        for (Long accId : accSet) {
            AccumulatorInfo accumulatorInfo = (AccumulatorInfo)accInfoMap.get(accId);
            if (accumulatorInfo == null) {
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"ID\u4e3a{0}\u7684\u7d2f\u52a0\u5668\u5df2\u5220\u9664\u6216\u5df2\u7981\u7528,\u65e0\u6cd5\u7ee7\u7eed\u8ba1\u7b97\u3002", (String)"AccFormulaNodeItemBuilder_3", (String)"sit-sitbp-business", (Object[])new Object[0]), accId));
            }
            LOGGER.info("fetchAccData start logAccInfos : {}", (Object)accumulatorInfo);
            if (!accumulatorInfo.isBsed()) continue;
            instanceNumMap.put(accId, accumulatorInfo.getInstanceNum());
        }
        String appId = taxCalContext.getAppId();
        Map<Long, Map<Long, DynamicObject>> fileAndAccResultMap = this.queryAccResultMap(appId, taxFileIdSet, instanceNumMap);
        if (CollectionUtils.isEmpty(fileAndAccResultMap)) {
            fileAndAccResultMap = new HashMap<Long, Map<Long, DynamicObject>>(taxFileIdSet.size());
        }
        HashSet<Long> existAccResultSet = new HashSet<Long>(taxFileIdSet.size());
        HashMap fileIdToSrcDataKeyMap = Maps.newHashMapWithExpectedSize((int)fileAndAccResultMap.size());
        for (Map.Entry<String, TaxCalUnit> entry : calUnitMap.entrySet()) {
            TaxCalUnit taxCalUnit = entry.getValue();
            Long taxFileId = taxCalUnit.getTaxFileId();
            fileIdToSrcDataKeyMap.put(taxFileId, taxCalUnit.getSrcDataKey());
            Map accResultMap = fileAndAccResultMap.computeIfAbsent(taxFileId, ky -> new HashMap(accSet.size()));
            for (Long accId : accSet) {
                AccumulatorInfo accInfo = (AccumulatorInfo)accInfoMap.get(accId);
                if (!accInfo.isBsed()) {
                    accResultMap.put(accId, null);
                    continue;
                }
                DynamicObject accResultObj = (DynamicObject)accResultMap.get(accId);
                if (accResultObj == null) {
                    accResultObj = this.getAccDynamicObject(appId, taxFileId, accInfo, currencyId, BigDecimal.ZERO);
                } else if (accResultObj.getInt("instancenum") != accInfo.getInstanceNum()) {
                    accResultObj = this.getAccDynamicObject(appId, taxFileId, accInfo, currencyId, BigDecimal.ZERO);
                } else {
                    existAccResultSet.add(accResultObj.getLong("id"));
                }
                accResultMap.put(accId, accResultObj);
            }
        }
        Map<Long, DynamicObject> allAccDetailMap = this.queryAccDetailMap(taxCalContext, existAccResultSet, taskEntity);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(appId + "_accdetail");
        for (Map.Entry<Long, Map<Long, DynamicObject>> accResultMapEntry : fileAndAccResultMap.entrySet()) {
            Long taxFileId = accResultMapEntry.getKey();
            Map<Long, DynamicObject> accResultMap = accResultMapEntry.getValue();
            HashMap<Long, Map> cateAddSumVOMap = new HashMap<Long, Map>(taxCategorySize);
            HashMap<String, DynamicObject> accUniqueCodeResultMap = new HashMap<String, DynamicObject>(accResultMap.size());
            HashMap<String, DynamicObject> accUniqueCodeDetailMap = new HashMap<String, DynamicObject>(accResultMap.size());
            for (Map.Entry<Long, DynamicObject> accResultEntry : accResultMap.entrySet()) {
                AddSumVO addSumVO;
                Long accId = accResultEntry.getKey();
                DynamicObject accResult = accResultEntry.getValue();
                AccumulatorInfo accInfo = (AccumulatorInfo)accInfoMap.get(accId);
                String accUniqueCode = accInfo.getUniqueCode();
                long taxCategoriesId = accInfo.getTaxCategoriesId();
                if (accResult == null) {
                    addSumVO = this.accInfoToAddSumVO(accInfo, BigDecimal.ZERO);
                } else {
                    long accResultId = accResult.getLong("id");
                    DynamicObject accDetail = allAccDetailMap.get(accResultId);
                    if (accDetail == null) {
                        accDetail = serviceHelper.generateEmptyDynamicObject();
                        accDetail.set("accresult", (Object)accResultId);
                        accDetail.set("taxtask", (Object)taskId);
                        accDetail.set("detailnum", (Object)detailNum);
                        accDetail.set("currency", (Object)currencyId);
                        accDetail.set("initvalue", (Object)accResult.getBigDecimal("resultvalue"));
                    } else {
                        BigDecimal initValue = accResult.getBigDecimal("resultvalue").subtract(accDetail.getBigDecimal("currentvalue"));
                        accResult.set("resultvalue", (Object)initValue);
                        accDetail.set("initvalue", (Object)initValue);
                        accDetail.set("currentvalue", null);
                    }
                    accUniqueCodeDetailMap.put(accUniqueCode, accDetail);
                    accUniqueCodeResultMap.put(accUniqueCode, accResult);
                    addSumVO = this.accInfoToAddSumVO(accInfo, accResult.getBigDecimal("resultvalue"));
                }
                Map AddSumVOMap = cateAddSumVOMap.computeIfAbsent(taxCategoriesId, ky -> new HashMap(16));
                AddSumVOMap.put(accUniqueCode, addSumVO);
            }
            TaxCalUnit calUnit = calUnitMap.get(fileIdToSrcDataKeyMap.get(taxFileId));
            calUnit.setExtraParam(UC_PREFIX, cateAddSumVOMap);
            calUnit.setExtraParam("AC_RESULT", accUniqueCodeResultMap);
            calUnit.setExtraParam("AC_DETAIL", accUniqueCodeDetailMap);
        }
    }

    protected Map<Long, Map<Long, DynamicObject>> queryAccResultMap(String appId, Set<Long> taxFileIdSet, Map<Long, Integer> instanceNumMap) {
        if (CollectionUtils.isEmpty(instanceNumMap)) {
            return null;
        }
        String entityCode = appId + "_accresult";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityCode);
        String fields = "id,creator,createtime,modifier,modifytime,taxfile,accumulator,instancenum,startdate,enddate,currency,resultvalue";
        QFilter filter = new QFilter("taxfile", "in", taxFileIdSet);
        filter.and("accumulator", "in", instanceNumMap.keySet());
        filter.and("instancenum", "in", instanceNumMap.values());
        DynamicObject[] accResults = serviceHelper.query(fields, new QFilter[]{filter});
        HashMap<Long, Map<Long, DynamicObject>> fileAndAccResultMap = new HashMap<Long, Map<Long, DynamicObject>>(taxFileIdSet.size());
        for (DynamicObject accResult : accResults) {
            long accResultId = accResult.getLong("accumulator.id");
            if (accResult.getInt("instancenum") != instanceNumMap.get(accResultId).intValue()) continue;
            Map accResultMap = fileAndAccResultMap.computeIfAbsent(accResult.getLong("taxfile.id"), ky -> new HashMap(instanceNumMap.size()));
            accResultMap.put(accResultId, accResult);
        }
        return fileAndAccResultMap;
    }

    private Map<Long, DynamicObject> queryAccDetailMap(TaxCalContext taxCalContext, Set<Long> accResultSet, TaxTaskEntity taskEntity) {
        String entityCode = taxCalContext.getAppId() + "_accdetail";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityCode);
        QFilter filter = new QFilter("accresult", "in", accResultSet);
        filter.and("taxdataid", "!=", (Object)0L);
        long taskId = taskEntity.getId();
        int detailNum = SitDateUtil.toYearMonthDay((Date)taskEntity.getStartDate());
        String fields = "id,creator,createtime,modifier,modifytime,accresult,taxtask,taxdataid,currency,initvalue,currentvalue,detailnum";
        DynamicObject[] detailObjs = serviceHelper.query(fields, new QFilter[]{filter}, "detailnum desc");
        HashMap detailMap = Maps.newHashMapWithExpectedSize((int)detailObjs.length);
        HashMap accNameMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap failDataMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet taxDataSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject detailObj : detailObjs) {
            long taxDataId = detailObj.getLong("taxdataid");
            if (taxDataId <= 0L) continue;
            if (detailObj.getInt("detailnum") > detailNum) {
                long taxFileId = detailObj.getLong("accresult.taxfile.id");
                Set accName = accNameMap.computeIfAbsent(taxFileId, ky -> Sets.newLinkedHashSetWithExpectedSize((int)8));
                accName.add(detailObj.getString("accresult.accumulator.number") + detailObj.getString("accresult.accumulator.name"));
                Set failData = failDataMap.computeIfAbsent(taxFileId, ky -> Sets.newLinkedHashSetWithExpectedSize((int)8));
                failData.add(taxDataId);
                taxDataSet.add(taxDataId);
                continue;
            }
            if (taskId != detailObj.getLong("taxtask.id")) continue;
            long resultId = detailObj.getLong("accresult.id");
            detailMap.put(resultId, detailObj);
        }
        Map<Long, Set<String>> rawTaskNameOfFile = this.queryRawTaskNameOfFile(taxCalContext, taxDataSet);
        String split = ResManager.loadKDString((String)"\u3001", (String)"AccFormulaNodeItemBuilder_1", (String)"sit-sitbp-business", (Object[])new Object[0]);
        Joiner joiner = Joiner.on((String)split);
        String msgInst = ResManager.loadKDString((String)"\u672a\u6309\u7167\u987a\u5e8f\u8ba1\u7b97\n\uff08\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\uff1a{0}\u5df2\u7ecf\u6709\u5bf9\u5e94\u7684\u4e2a\u7a0e\u8ba1\u7b97\u7ed3\u679c\uff1b\n\u6d89\u53ca\u5230\u7d2f\u52a0\u5668\uff1a{1})", (String)"AccFormulaNodeItemBuilder_0", (String)"sit-sitbp-business", (Object[])new Object[0]);
        for (Map.Entry entry : accNameMap.entrySet()) {
            Long taxFileId = (Long)entry.getKey();
            Set<String> taskNames = rawTaskNameOfFile.get(taxFileId);
            taxCalContext.calUnitFailByFileId((BizMessage)CalFailTypeEnum.ACCUMULATOR_ORDER_FAIL.of(MessageFormat.format(msgInst, CollectionUtils.isEmpty(taskNames) ? "" : joiner.join(taskNames), joiner.join((Iterable)entry.getValue()))), taxFileId);
        }
        return detailMap;
    }

    private Map<Long, Set<String>> queryRawTaskNameOfFile(TaxCalContext taxCalContext, Set<Long> taxDataSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(taxCalContext.getAppId() + "_taxrawdata");
        QFilter dataFilter = new QFilter("taxdata", "in", taxDataSet);
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        DynamicObject[] taxData = serviceHelper.queryOriginalArray("taxfile.boid,taxdatabasic.rawcaltask.number,taxdatabasic.rawcaltask.name", new QFilter[]{dataFilter, statusFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)taxData.length);
        for (DynamicObject datum : taxData) {
            long taxFileBoId = datum.getLong("taxfile.boid");
            String calTaskNumber = datum.getString("taxdatabasic.rawcaltask.number");
            Set set = result.computeIfAbsent(taxFileBoId, ky -> Sets.newHashSetWithExpectedSize((int)4));
            set.add(calTaskNumber + datum.getString("taxdatabasic.rawcaltask.name"));
        }
        return result;
    }

    private DynamicObject getAccDynamicObject(String appId, Long taxFileId, AccumulatorInfo accInfo, Long currencyId, BigDecimal value) {
        String codeName = appId + "_accresult";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(codeName);
        DynamicObject accObject = serviceHelper.generateEmptyDynamicObject();
        accObject.set("taxfile", (Object)taxFileId);
        accObject.set("accumulator", (Object)accInfo.getId());
        accObject.set("instancenum", (Object)accInfo.getInstanceNum());
        accObject.set("startdate", (Object)accInfo.getCycleStartDate());
        accObject.set("enddate", (Object)accInfo.getCycleEndDate());
        accObject.set("currency", (Object)currencyId);
        accObject.set("resultvalue", (Object)value);
        accObject.set("ischanged", (Object)YesOrNoEnum.NO.getCode());
        accObject.set("datasource", (Object)YesOrNoEnum.NO.getCode());
        return accObject;
    }

    private AddSumVO accInfoToAddSumVO(AccumulatorInfo accInfo, BigDecimal value) {
        if (accInfo == null) {
            return null;
        }
        AddSumVO addSumVO = new AddSumVO();
        addSumVO.setAddSumId(Long.toString(accInfo.getId()));
        addSumVO.setUniqueCode(accInfo.getUniqueCode());
        addSumVO.setAddSumType(accInfo.getAddSumTypeEnum());
        addSumVO.setOriginalValue((Object)value);
        addSumVO.setAddSumItemUniqueCodeSet(accInfo.getMemberUniqueCodeSet());
        addSumVO.setScale(Integer.valueOf(accInfo.getScale()));
        addSumVO.setRoundingMode(accInfo.getRoundingMode());
        addSumVO.setItemIsAddMap(accInfo.getItemIsAddMap());
        addSumVO.setItemProportionMap(accInfo.getItemProportionMap());
        return addSumVO;
    }

    private void assembleAccNode(Long country, Long category, List<TreeNodeItem> resultList) {
        DynamicObject[] objs;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_accumulator");
        QFilter filter = new QFilter("country.id", "=", (Object)country);
        filter.and("taxcategories.id", "=", (Object)category);
        for (DynamicObject obj : objs = serviceHelper.query("id,number,name,status,enable", new QFilter[]{filter}, "")) {
            String uniCode = this.uniCodeResolver().uniCode(obj.getString("id"));
            String name = obj.getString("name");
            TreeNodeItem item = this.build(UC_PREFIX, uniCode, UC_PREFIX, name, uniCode, DataTypeEnum.getDataType((String)DataTypeEnum.NUM.name()));
            if (!"C".equals(obj.getString("status")) || !"1".equals(obj.getString("enable"))) {
                item.setShow(false);
            }
            resultList.add(item);
        }
    }
}

