/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.formula.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.sit.sitbp.business.api.FormulaNodeItemBuilder;
import kd.sit.sitbp.business.formula.builder.DefaultFormulaNodeItemBuilder;
import kd.sit.sitbp.common.entity.TaxCalItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.model.TaxCalContext;
import kd.sit.sitbp.common.model.TaxCalUnit;

public abstract class BaseFormulaNodeItemBuilder
implements FormulaNodeItemBuilder {
    private static final Map<String, FormulaNodeItemBuilder> NODE_ITEM_BUILDERS = new HashMap<String, FormulaNodeItemBuilder>(16);

    public static Map<String, FormulaNodeItemBuilder> getInstances() {
        return NODE_ITEM_BUILDERS;
    }

    public static BaseFormulaNodeItemBuilder getInstance(String prefix) {
        return (BaseFormulaNodeItemBuilder)NODE_ITEM_BUILDERS.get(prefix);
    }

    @Override
    public void queryCalElements(TaxCalContext taxCalContext, TaxTaskEntity taskEntity, Map<String, TaxCalUnit> calUnitMap, Set<String> items) {
    }

    public TreeNodeItem build(String itemCategory, String id, String parentId, String name) {
        return new TreeNodeItem(itemCategory, id, parentId, name);
    }

    public TreeNodeItem build(String itemCategory, String id, String parentId, String name, String uniqueCode, DataTypeEnum dataType) {
        return new CalItem(itemCategory, id, parentId, name, uniqueCode, dataType);
    }

    public TreeNodeItem build(String itemCategory, String id, String parentId, String name, String uniqueCode, TaxCalItemEntity taxCalItemEntity) {
        CalItem calItem = new CalItem(itemCategory, id, parentId, name, uniqueCode, taxCalItemEntity.getCalItemVO().getDataType());
        if (taxCalItemEntity.getItemType() != null) {
            calItem.setItemType(taxCalItemEntity.getItemType());
            calItem.setEntityNumber(taxCalItemEntity.getEntityNumber());
            calItem.setPropertyField(taxCalItemEntity.getPropertyField());
            calItem.setOrders("number asc");
            if (taxCalItemEntity.getqFilters() != null) {
                calItem.setqFilters(taxCalItemEntity.getqFilters());
            }
        }
        return calItem;
    }

    static {
        ServiceLoader<FormulaNodeItemBuilder> serviceLoader = ServiceLoader.load(FormulaNodeItemBuilder.class);
        for (FormulaNodeItemBuilder next : serviceLoader) {
            NODE_ITEM_BUILDERS.put(next.uniCodePrefix(), next);
        }
        NODE_ITEM_BUILDERS.put("$", DefaultFormulaNodeItemBuilder.DEFAULT);
    }
}

