/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.formula.builder;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.service.formula.cal.vo.CalAllParamVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.sit.sitbp.business.formula.builder.EntityFieldFormulaNodeItemBuilder;
import kd.sit.sitbp.common.api.TaxCalItemUniCodeResolver;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.model.TaxCalContext;
import kd.sit.sitbp.common.model.TaxCalUnit;
import kd.sit.sitbp.common.util.FormulaCalUtils;
import kd.sit.sitbp.common.util.SITMServiceUtils;

public class TaxFileFormulaNodeItemBuilder
extends EntityFieldFormulaNodeItemBuilder {
    private static final Log LOGGER = LogFactory.getLog(TaxFileFormulaNodeItemBuilder.class);
    private static final int SEQ_NO = 30;
    private static final String UC_PREFIX = "TF";
    private static final Map<String, String> IIT_PERSON_TO_FILE_PROPS;

    @Override
    public String uniCodePrefix() {
        return UC_PREFIX;
    }

    @Override
    public int seq(Long country, String appId, Long category, Map<String, Object> cond) {
        return 30;
    }

    @Override
    public boolean match(Long country, String appId, Long category, Map<String, Object> cond) {
        return true;
    }

    @Override
    public List<TreeNodeItem> rootWithAllNode(Long country, String appId, Long category, Map<String, Object> cond) {
        ArrayList<TreeNodeItem> resultList = new ArrayList<TreeNodeItem>(16);
        resultList.add(this.build(UC_PREFIX, UC_PREFIX, "TFBS", ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848-TF", (String)"TaxCalFormulaEdit_4", (String)"sit-sitcs-business", (Object[])new Object[0])));
        this.assembleTaxFileNode(appId, resultList, country);
        return resultList;
    }

    @Override
    public void genCalItemVO(DynamicObject formulaDynamicObj, Set<String> querySelectField, Map<String, CalItemVO> uniqueCodeCalItemMap, TaxCalContext taxCalContext) {
        HashMap typeMap = new HashMap(16);
        String appId = taxCalContext.getAppId();
        for (String obj : querySelectField) {
            String fields;
            String metaTag;
            int index = obj.indexOf(46);
            if (index < 0) {
                metaTag = appId + "_taxfile";
                fields = obj;
            } else {
                metaTag = obj.substring(0, index);
                fields = obj.substring(index + 1);
            }
            CalItemVO fileVO = FormulaCalUtils.getCalItemVO((String)metaTag, (String)fields, typeMap);
            String uniCode = this.uniCodeResolver().uniCode(obj);
            fileVO.setUniqueCode(uniCode);
            uniqueCodeCalItemMap.put(uniCode, fileVO);
        }
    }

    @Override
    public void resolveParams(CalAllParamVO paramVO, Set<String> itemKeys, TaxCalContext taxCalContext, TaxTaskEntity taskEntity, Long catId, String paramId, TaxCalUnit taxCalUnit) {
        Map taxFileMap = (Map)taxCalUnit.getExtraParam(UC_PREFIX);
        Map params = (Map)paramVO.getParamIdToParamMap().get(paramId);
        for (String fileKey : itemKeys) {
            String uniCode = this.uniCodeResolver().uniCode(fileKey);
            Object value = taxFileMap.get(fileKey);
            LOGGER.info("Trace by Quinn: {} - {} - {}", new Object[]{"resolveParams", uniCode, value});
            params.put(uniCode, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void queryCalElements(TaxCalContext taxCalContext, TaxTaskEntity taskEntity, Map<String, TaxCalUnit> calUnitMap, Set<String> items) {
        HashMap propGroups = Maps.newHashMapWithExpectedSize((int)8);
        TaxCalItemUniCodeResolver resolver = this.uniCodeResolver();
        String appId = taxCalContext.getAppId();
        String mainEntity = appId + "_taxfile";
        HashMap calItemFilePropOfUnicode = Maps.newHashMapWithExpectedSize((int)16);
        for (String item : items) {
            void var13_14;
            String prop;
            int index = (item = resolver.encode(item)).indexOf(36);
            if (index < 0 || !item.contains("_")) {
                String string = mainEntity;
                prop = item;
            } else {
                String string = item.substring(0, index);
                prop = item.substring(index + 1);
            }
            prop = resolver.decode(prop);
            if (taxCalContext.calItemUnicodeNeedBaseDataConvert(prop)) {
                String originalProp = prop;
                prop = prop.substring(0, prop.lastIndexOf(46));
                Map map = calItemFilePropOfUnicode.computeIfAbsent(var13_14, ky -> Maps.newHashMapWithExpectedSize((int)16));
                map.put(originalProp, prop);
            }
            Set props = propGroups.computeIfAbsent(var13_14, ky -> Sets.newHashSetWithExpectedSize((int)16));
            props.add(prop);
        }
        Set mainProps = propGroups.computeIfAbsent(mainEntity, ky -> Sets.newHashSetWithExpectedSize((int)8));
        mainProps.add("id");
        mainProps.add("boid");
        HashMap idGroups = Maps.newHashMapWithExpectedSize((int)8);
        for (Map.Entry entry : propGroups.entrySet()) {
            HashSet ids = Sets.newHashSetWithExpectedSize((int)calUnitMap.size());
            String key = (String)entry.getKey();
            idGroups.put(key, ids);
            for (Map.Entry entry2 : calUnitMap.entrySet()) {
                ids.add(((TaxCalUnit)entry2.getValue()).getIdFromBasic(key));
            }
        }
        Set iitPersonProp = (Set)propGroups.get("iit_person");
        if (!CollectionUtils.isEmpty((Collection)iitPersonProp)) {
            for (String perProp : iitPersonProp) {
                String fileProp = IIT_PERSON_TO_FILE_PROPS.get(perProp);
                if (StringUtils.isEmpty((Object)fileProp)) continue;
                mainProps.add(fileProp);
            }
        }
        Map map = (Map)SITMServiceUtils.invokeSITService((String)appId, (String)(appId + "TaxFileApiService"), (String)"findPropOfTaxFile", (Object[])new Object[]{idGroups, propGroups});
        for (Map.Entry<String, TaxCalUnit> entry : calUnitMap.entrySet()) {
            String fileProp;
            long fileId;
            Map remove;
            Map fileMap;
            TaxCalUnit calUnit = entry.getValue();
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)16);
            calUnit.setExtraParam(UC_PREFIX, (Object)hashMap);
            for (Map.Entry mapEntry : map.entrySet()) {
                long id = calUnit.getIdFromBasic((String)mapEntry.getKey());
                Map map2 = (Map)((Map)mapEntry.getValue()).get(id);
                if (map2 == null) continue;
                for (Map.Entry entry3 : map2.entrySet()) {
                    DynamicObject value;
                    DataEntityPropertyCollection properties;
                    if (!(entry3.getValue() instanceof DynamicObject) || !(properties = (value = (DynamicObject)entry3.getValue()).getDataEntityType().getProperties()).containsKey((Object)"id") || !properties.containsKey((Object)"boid")) continue;
                    value.set("id", value.get("boid"));
                }
                Map calItem = (Map)calItemFilePropOfUnicode.get(mapEntry.getKey());
                if (calItem != null) {
                    for (Map.Entry stringEntry : calItem.entrySet()) {
                        hashMap.put((String)mapEntry.getKey() + "." + (String)stringEntry.getKey(), map2.get(stringEntry.getValue()));
                    }
                }
                for (Map.Entry objectEntry3 : map2.entrySet()) {
                    hashMap.put((String)mapEntry.getKey() + "." + (String)objectEntry3.getKey(), objectEntry3.getValue());
                }
            }
            if (CollectionUtils.isEmpty((Collection)iitPersonProp) || (fileMap = (Map)(remove = (Map)map.get(mainEntity)).get(fileId = calUnit.getIdFromBasic(mainEntity))) == null) continue;
            Map calItem = (Map)calItemFilePropOfUnicode.get("iit_person");
            if (calItem != null) {
                for (Map.Entry entry4 : calItem.entrySet()) {
                    fileProp = IIT_PERSON_TO_FILE_PROPS.get(entry4.getValue());
                    if (StringUtils.isEmpty((Object)fileProp)) continue;
                    hashMap.put("iit_person." + (String)entry4.getKey(), fileMap.get(fileProp));
                }
            }
            for (String string : iitPersonProp) {
                Object value;
                fileProp = IIT_PERSON_TO_FILE_PROPS.get(string);
                if (StringUtils.isEmpty((Object)fileProp) || (value = fileMap.get(fileProp)) == null) continue;
                hashMap.put("iit_person." + string, value);
            }
        }
    }

    private void assembleTaxFileNode(String appId, List<TreeNodeItem> treeNodeItems, Long country) {
        treeNodeItems.add(this.build(UC_PREFIX, "BND", UC_PREFIX, ResManager.loadKDString((String)"\u4e2a\u7a0e\u6863\u6848\u57fa\u7840\u4fe1\u606f", (String)"TaxCalFormulaEdit_6", (String)"sit-sitbp-business", (Object[])new Object[0])));
        QueryEntityType taxFileQuery = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)(appId + "_taxcalformulaquery"));
        Map<String, MainEntityType> allJoinEntityType = taxFileQuery.getAllJoinEntityType().stream().collect(Collectors.toMap(DynamicObjectType::getName, ele -> ele));
        HashSet types = Sets.newHashSetWithExpectedSize((int)allJoinEntityType.size());
        MainEntityType mainEntityType = taxFileQuery.getMainEntityType();
        String mainEntityTypeName = mainEntityType.getName();
        List selectFields = taxFileQuery.getSelectFields();
        for (QuerySelectField selectField : selectFields) {
            String uniCode;
            String name = selectField.getDisplayName();
            String alias = selectField.getAlias();
            MainEntityType entityType = null;
            int index = alias.indexOf(46);
            if (index > 0) {
                String aliasType = alias.substring(0, index);
                if (aliasType.equals(mainEntityTypeName)) {
                    alias = alias.substring(index + 1);
                } else {
                    entityType = allJoinEntityType.get(aliasType);
                }
            }
            if (entityType == null) {
                uniCode = this.uniCodeResolver().uniCode(mainEntityTypeName + "." + alias);
                treeNodeItems.add(this.build(UC_PREFIX, uniCode, "BND", name, uniCode, FormulaCalUtils.getCalDataType((String)mainEntityTypeName, (String)alias, (Long)country, (String)appId)));
                continue;
            }
            uniCode = this.uniCodeResolver().uniCode(alias);
            String parentCode = this.uniCodeResolver().uniCode(entityType.getName());
            if (types.add(parentCode)) {
                treeNodeItems.add(this.build(UC_PREFIX, parentCode, UC_PREFIX, entityType.getDisplayName().getLocaleValue()));
            }
            alias = alias.substring(index + 1);
            treeNodeItems.add(this.build(UC_PREFIX, uniCode, parentCode, name, uniCode, FormulaCalUtils.getCalDataType((String)entityType.getName(), (String)alias, (Long)country, (String)appId)));
        }
    }

    static {
        HashMap temp = Maps.newHashMapWithExpectedSize((int)10);
        temp.put("id", "person.id");
        temp.put("number", "personversion.number");
        temp.put("name", "personversion.name");
        temp.put("taxcrdltype", "taxcrdltype");
        temp.put("credentialsnum", "percre.number");
        temp.put("nationality", "pernontsprop.nationality");
        temp.put("birthday", "pernontsprop.birthday");
        temp.put("gender", "pernontsprop.gender");
        temp.put("education", "pereduexp.education");
        temp.put("marriagestatus", "pertsprop.marriagestatus");
        temp.put("credentialstype", "percre.credentialstype");
        IIT_PERSON_TO_FILE_PROPS = Collections.unmodifiableMap(temp);
    }
}

